--author: igor29381

UnloadingSpec = {};

UnloadingSpec.PARENTTYPE_VEHICLE = 1;
UnloadingSpec.PARENTTYPE_FILLABLEPALLET = 2;
UnloadingSpec.PARENTTYPE_OBJECT = 3;

function UnloadingSpec.prerequisitesPresent(specializations)
	return true;
end;

function UnloadingSpec:load(savegame)
	self.getValidFillTrigger = UnloadingSpec.getValidFillTrigger;
	self.getFillableAllowFillTypes = UnloadingSpec.getFillableAllowFillTypes;
	self.getParentFreeCapacity = UnloadingSpec.getParentFreeCapacity;
	self.enableDump = false;
	self.dumpInputButton = InputBinding.IMPLEMENT_EXTRA3;
	if SpecializationUtil.hasSpecialization(SowingMachine, self.specializations) then
		self.dumpInputButton = self.changeSeedInputButton;
	end;
end;

function UnloadingSpec:delete()
end;

function UnloadingSpec:readStream(streamId, connection)
end;

function UnloadingSpec:writeStream(streamId, connection)
end;

function UnloadingSpec:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UnloadingSpec:keyEvent(unicode, sym, modifier, isDown)
end;

function UnloadingSpec:update(dt)
	if self.sowingMachine then
		if self.fillUnits[self.sowingMachine.fillUnitIndex].fillLevel > 0 then
			if self.allowsSeedChanging then
				self.allowsSeedChanging = false;
			end;
		elseif not self.allowsSeedChanging then
			self.allowsSeedChanging = true;
		end;
	end;
	if self.fillTriggers then
		local trigger, fillType, parentType = self:getValidFillTrigger();
		if trigger then
			local parent = trigger.parent;
			local parentFreeCapacity = self:getParentFreeCapacity(parent, parentType, fillType);
			if self:getIsActive() and self:getIsActiveForInput() then
				if not self.isFilling and not self.enableDump and self:getFillLevel(fillType) > 0 and parentFreeCapacity > 0 then
					g_currentMission:addHelpButtonText(g_i18n:getText("action_tip"), self.dumpInputButton, nil, GS_PRIO_HIGH);
					if InputBinding.hasEvent(self.dumpInputButton) then
						if g_server ~= nil then
							self.enableDump = true;
							g_currentMission:removeActivatableObject(self.fillActivatable);
							g_server:broadcastEvent(Perestroyka.UnloadingSpecEvent:new(true, self));
						else
							g_client:getServerConnection():sendEvent(Perestroyka.UnloadingSpecEvent:new(true, self));
						end;
					end;
				end;
			end;
			if g_server and self.enableDump then
				if self:getFillLevel(fillType) > 0 then
					local selfFillLevel = self:getFillLevel(fillType);
					local delta = math.min(dt*0.15, parentFreeCapacity, selfFillLevel);
					if delta > 0 then
						self:setFillLevel(selfFillLevel - delta, fillType, true);
						if parentType == UnloadingSpec.PARENTTYPE_VEHICLE or parentType == UnloadingSpec.PARENTTYPE_FILLABLEPALLET then
							parent:setFillLevel(parent:getFillLevel(fillType) + delta, fillType, true);
						elseif parentType == UnloadingSpec.PARENTTYPE_OBJECT then
							local parentFillType = parent.fillType[fillType];
							parentFillType.level = parentFillType.level + delta;
							parent:heapsMoving();
							parent.enableUpdateClients = true;
							if not parent.isOwned then
								parent:fillTypePayment(fillType, "other", delta, true);
							end;
						end;
					else
						self.enableDump = false;
						g_server:broadcastEvent(Perestroyka.UnloadingSpecEvent:new(false, self));
					end;
				else
					self.enableDump = false;
					g_server:broadcastEvent(Perestroyka.UnloadingSpecEvent:new(false, self));
				end;
			end;
		elseif self.enableDump then
			self.enableDump = false;
			if g_server then
				g_server:broadcastEvent(Perestroyka.UnloadingSpecEvent:new(false, self));
			end;
		end;
	end;
end;

function UnloadingSpec:updateTick(dt)
end;

function UnloadingSpec:draw()
end;

function UnloadingSpec:getValidFillTrigger()
	local fillTypes = self:getCurrentFillTypes();
	for i=1, #self.fillTriggers do
		local trigger = self.fillTriggers[i];
		local parent = trigger.parent;
		if parent then
			if parent:isa(Vehicle) then
				local fillType = self:getFillableAllowFillTypes(parent, fillTypes);
				if fillType > 0 then
					return trigger, fillType, UnloadingSpec.PARENTTYPE_VEHICLE;
				end;
			elseif parent:isa(FillablePallet) then
				for i=1, #fillTypes do
					local fillType = fillTypes[i];
					if trigger.fillType == fillType then
						return trigger, fillType, UnloadingSpec.PARENTTYPE_FILLABLEPALLET;
					end;
				end;
			elseif parent:isa(Object) then
				for i=1, #fillTypes do
					local fillType = fillTypes[i];
					if trigger.fillType == fillType then
						return trigger, fillType, UnloadingSpec.PARENTTYPE_OBJECT;
					end;
				end;
			end;
		end;
	end;
	return nil, 0, 0;
end;

function UnloadingSpec:getFillableAllowFillTypes(fillable, fillTypes)
	for i=1, #fillTypes do
		local fillType = fillTypes[i];
		for ii=1, #fillable.fillUnits do
			local unit = fillable.fillUnits[ii];
			if unit.currentFillType ~= FillUtil.FILLTYPE_UNKNOWN then
				if unit.currentFillType == fillType then
					return fillType;
				end;
			else
				for k,_ in pairs (unit.fillTypes) do
					if k==fillType then
						return fillType;
					end;
				end;
			end;
		end;
	end;
	return 0;
end;

function UnloadingSpec:getParentFreeCapacity(parent, parentType, fillType)
	if parentType == UnloadingSpec.PARENTTYPE_VEHICLE then
		return parent:getFreeCapacity(fillType);
	end;
	if parentType == UnloadingSpec.PARENTTYPE_FILLABLEPALLET then
		return parent:getCapacity() - parent:getFillLevel();
	end;
	if parentType == UnloadingSpec.PARENTTYPE_OBJECT then
		return parent:getFreeSpace(fillType);
	end;
	return 0;
end;
