--authors: igor29381, Giants

function UniversalFactory:registerFillType(fillType, capacity, priceMultiplier, put, pallet, bale)
	if fillType then
		put = Utils.getNoNil(put, 0);
		local desc = {};
		if self.fillType[fillType] then
			local oldDesc = self.fillType[fillType];
			desc = oldDesc;
			if not oldDesc.pallet then
				desc.pallet = Utils.getNoNil(pallet, false);
			end;
			if not oldDesc.bale then
				desc.bale = Utils.getNoNil(bale, false);
			end;
			if not oldDesc.inputFillType then
				desc.inputFillType = put == 1;
			end;
			if not oldDesc.outputFillType then
				desc.outputFillType = put == 2;
			end;
		else
			desc.index = fillType;
			desc.level = 0;
			desc.capacity = capacity;
			desc.priceMultiplier = Utils.getNoNil(priceMultiplier, 1);
			desc.pallet = Utils.getNoNil(pallet, false);
			desc.bale = Utils.getNoNil(bale, false);
			desc.inputFillType = put == 1;
			desc.outputFillType = put == 2;
			desc.rent = false;
			desc.rentLevel = 0;
			if self.isWarehouse then
				desc.inputFillType = true;
				desc.outputFillType = true;
			else
				desc.priceDelta = 1;
				desc.extraMission = false;
				desc.extraMissionLevel = 0;
				desc.contract = false;
				desc.contractLevel = 0;
			end;
			table.insert(self.fillTypesToPut[put], desc);
		end;
		self.fillType[fillType] = desc;
	end;
end;

function UniversalFactory:loadTipTrigger(id)
	local fillTypes = getUserAttribute(id, "fillTypes");
	local priceMultipliers = getUserAttribute(id, "priceMultipliers");
	if priceMultipliers then priceMultipliers = Utils.splitString(" ", priceMultipliers); end;
	local capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 50000);
	local allToFirst = Utils.getNoNil(getUserAttribute(id, "allToFirst"), false);
	local acceptedFillTypes = {};
	local fillTypePrices = {};
	local fillTypePriceInfo = {};
	local firstFillType = nil;
	if fillTypes then
		fillTypes = Utils.splitString(" ", fillTypes);
		for k,v in pairs(fillTypes) do
			local fillType = FillUtil.fillTypeNameToInt[v];
			if fillType then
				acceptedFillTypes[fillType] = true;
				fillTypePrices[fillType] = 0;
				fillTypePriceInfo[fillType] = 0;
				if allToFirst then
					if firstFillType == nil then
						firstFillType = fillType;
						self:registerFillType(fillType, capacity, priceMultipliers[1], 1, false);
					end;
				else
					local priceMultiplier = 1;
					if priceMultipliers and priceMultipliers[k] and tonumber(priceMultipliers[k]) then priceMultiplier = tonumber(priceMultipliers[k]); end;
					self:registerFillType(fillType, capacity, priceMultiplier, 1, false);
				end;
			else
				print("UniversalFactory: "..self.factoryName.." - fillType for tipTrigger - "..v.." is not registered and can't be assigned");
			end;
		end;
	end;
	local tipTrigger = TipTrigger:new(g_server ~= nil, g_client ~= nil);
	tipTrigger.addAcceptedFillType = function(tipTrigger, fillType, priceUnscaled, supportsGreatDemand, disablePriceDrop, allowedToolTypes)
		if fillType ~= nil and tipTrigger.acceptedFillTypes[fillType] == nil then
			tipTrigger.acceptedFillTypes[fillType] = true;
			tipTrigger.priceMultipliers[fillType] = 1.0;
			if not tipTrigger.allowedToolTypes then
				tipTrigger.allowedToolTypes = {};
			end;
			for _,toolType in pairs(allowedToolTypes) do
				if not tipTrigger.allowedToolTypes[fillType] then
					tipTrigger.allowedToolTypes[fillType] = {};
				end;
				tipTrigger.allowedToolTypes[fillType][toolType] = true;
			end;
		end;
	end;
	tipTrigger.initPricingDynamics = function() end;
	tipTrigger.className = "TipTrigger";
	tipTrigger.allToFirst = allToFirst;
	if firstFillType then tipTrigger.firstFillType = firstFillType; end;
	tipTrigger:load(id, self);
	tipTrigger:register(true);
	g_currentMission:addOnCreateLoadedObject(tipTrigger);
	tipTrigger.fillTypePrices = fillTypePrices;
	tipTrigger.fillTypePriceInfo = fillTypePriceInfo;
	if tipTrigger.mapHotspot then
		g_currentMission.ingameMap:deleteMapHotspot(tipTrigger.mapHotspot);
	end;
	local unloadingPipeI3d = getUserAttribute(id, "unloadingPipeI3d");
	tipTrigger.shlang = getChild(id, "shlang");
	if unloadingPipeI3d then
		unloadingPipeI3d = TrafficManager.curModDir..unloadingPipeI3d;
		if fileExists(unloadingPipeI3d) then
			local pipeAttacher = getChild(id, "pipeAttacher");
			tipTrigger.minHeight = Utils.getNoNil(getUserAttribute(pipeAttacher, "minHeight"), 0);
			local pipeRoot = Utils.loadSharedI3DFile(unloadingPipeI3d);
			tipTrigger.pipeSkin = getChildAt(pipeRoot, 1);
			link(getRootNode(), tipTrigger.pipeSkin);
			setVisibility(tipTrigger.pipeSkin, false);
			tipTrigger.skeleton = getChildAt(pipeRoot, 0);
			link(getRootNode(), tipTrigger.skeleton);
			delete(pipeRoot);
			tipTrigger.middlePipe = getChildAt(tipTrigger.skeleton, 0);
			tipTrigger.flangePipe = getChildAt(tipTrigger.middlePipe, 0);
			local x,y,z = getWorldTranslation(pipeAttacher);
			local rx,ry,rz = getWorldRotation(pipeAttacher);
			setTranslation(tipTrigger.skeleton, x,y,z);
			setRotation(tipTrigger.skeleton, rx,ry,rz);
			tipTrigger.pipeRY = ry;
			tipTrigger.unloadingPipeAttacher = 0;
		end;
	end;
	tipTrigger.addFillLevelFromTool = function(trigger, object, fillDelta, fillType, toolType)
		if fillDelta > 0 then
			if trigger.acceptedFillTypes[fillType] then
				if trigger.allToFirst then fillType = trigger.firstFillType; end;
				local parentFillType = self.fillType[fillType];
				if parentFillType.rent then
					local delta = math.min(fillDelta, parentFillType.capacity - parentFillType.level, parentFillType.capacity - parentFillType.rentLevel);
					self:setFillLevel(fillType, 0, delta);
					fillDelta = delta;
				else
					local delta = math.min(fillDelta, parentFillType.capacity - parentFillType.level);
					self:setFillLevel(fillType, delta, 0);
					if parentFillType.extraMission then
						parentFillType.extraMissionLevel = parentFillType.extraMissionLevel + delta;
					end;
					if parentFillType.contract then
						parentFillType.contractLevel = parentFillType.contractLevel + delta;
					end;
					if not self.isOwned and not parentFillType.extraMission then
						self:fillTypePayment(fillType, "harvestIncome", delta, true, g_i18n:getText("finance_harvestIncome"));
					end;
					fillDelta = delta;
				end;
				self.updateTipping = true;
				self:heapsMoving();
				self.enableUpdateClients = true;
			end;
			return fillDelta;
		end;
	end;
	tipTrigger.getNotAllowedText = function(trigger, fillable, toolType)
		if not trigger.suppressWarnings then
			if not self.isEnabled then
				return g_i18n:getText("no_input");
			end;
			local fillTypes = fillable:getCurrentFillTypes();
			if fillTypes ~= nil and next(fillTypes) ~= nil then
				local hasGenerallyAcceptedFillType = false;
				local acceptedFillType;
				local notAcceptedFillTypes = "";
				local notAcceptedToolFillTypes = "";
				for _,fillType in pairs(fillTypes) do
					if trigger.acceptedFillTypes[fillType] then
						hasGenerallyAcceptedFillType = true;
						if trigger.allowedToolTypes[fillType][toolType] then
							if acceptedFillType == nil then
								acceptedFillType = fillType;
							end;
						else
							if notAcceptedToolFillTypes ~= "" then
								notAcceptedToolFillTypes = notAcceptedToolFillTypes .. ", "
							end;
							notAcceptedToolFillTypes = notAcceptedToolFillTypes .. FillUtil.fillTypeIndexToDesc[fillType].nameI18N
						end;
					else
						if notAcceptedFillTypes ~= "" then
							notAcceptedFillTypes = notAcceptedFillTypes .. ", "
						end;
						notAcceptedFillTypes = notAcceptedFillTypes .. FillUtil.fillTypeIndexToDesc[fillType].nameI18N
					end;
				end;
				if acceptedFillType == nil then
					if hasGenerallyAcceptedFillType then
						return string.format(g_i18n:getText("warning_notAcceptedTool"), notAcceptedToolFillTypes)
					else
						return string.format(g_i18n:getText("warning_notAcceptedHere"), notAcceptedFillTypes)
					end;
				else
					if not trigger:getAllowFillTypeFromTool(acceptedFillType, toolType) then
						return string.format(g_i18n:getText("warning_noMoreFreeCapacity"), FillUtil.fillTypeIndexToDesc[acceptedFillType].nameI18N)
					end;
				end;
			end;
		end;
	end;
	tipTrigger.getAllowFillTypeFromTool = function(trigger, fillType, toolType)
		if self.isEnabled and trigger.isEnabled and trigger.acceptedFillTypes[fillType] and trigger.allowedToolTypes[fillType][toolType] then
			return true;
		end;
		return false;
	end;
	tipTrigger.getTipInfoForTrailer = function(trigger, trailer, tipReferencePointIndex)
		local minDistance, bestPoint = trigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex);
		local isAllowed = false;
		local fillTypes = trailer:getCurrentFillTypes();
		if fillTypes then
			for _,fillType in pairs(fillTypes) do
				if trigger:getAllowFillTypeFromTool(fillType, TipTrigger.TOOL_TYPE_TRAILER) and self:getFreeSpace(fillType) > 0 then
					isAllowed = true;
					break;
				end;
			end;
		end;
		if isAllowed and not trigger.onCourse and trigger.unloadingPipeAttacher and trigger.unloadingPipeAttacher == 0 then
			isAllowed = false;
		end;
		return isAllowed, minDistance, bestPoint;
	end;
	if tipTrigger.flangePipe then
		tipTrigger.attacherInRange = function(trigger, attacherId)
			local attacherInRange = false;
			local x,y,z = getWorldTranslation(attacherId);
			local x1,y1,z1 = getWorldTranslation(trigger.shlang);
			local lx,_,lz = worldToLocal(trigger.shlang, x,y,z);
			local distance = Utils.vector3Length(x1-x, y1-y, z1-z);
			if distance < 6 and math.abs(lz) < 1 and math.abs(lx) > 4 then
				attacherInRange = true;
			end;
			return attacherInRange, distance;
		end;
		tipTrigger.update = function(trigger, dt)
			if trigger.trailer and trigger.trailer:getFillLevel() > 0 then
				if trigger.unloadingPipeAttacher > 0 then
					local x,y,z = getWorldTranslation(trigger.unloadingPipeAttacher);
					local rx,ry,rz = getWorldRotation(trigger.unloadingPipeAttacher);
					local attacherInRange, dis = trigger:attacherInRange(trigger.unloadingPipeAttacher);
					if attacherInRange then
						local middleZ = -dis/2.5;
						local middleX = (5-dis)/4;
						setTranslation(trigger.middlePipe, middleX,trigger.minHeight,middleZ);
						Utils.setWorldTranslation(trigger.flangePipe, x,y,z);
						setRotation(trigger.flangePipe, rx,ry,rz);
						setVisibility(trigger.shlang, false);
						setVisibility(trigger.pipeSkin, true);
					else
						setVisibility(trigger.shlang, true);
						setVisibility(trigger.pipeSkin, false);
						trigger.unloadingPipeAttacher = 0;
					end;
				else
					local distance = 100;
					local unloadingPipeAttacher = 0;
					for i=1, #trigger.trailer.attacherJoints do
						local attacher = trigger.trailer.attacherJoints[i];
						if attacher.jointType == AttacherJoints.JOINTTYPE_UNLOADINGPIPE then
							local x,y,z = getWorldTranslation(attacher.jointTransform);
							local x1,y1,z1 = getWorldTranslation(trigger.shlang);
							local dis = Utils.vector3Length(x1-x, y1-y, z1-z);
							if dis < 6 and dis < distance then
								unloadingPipeAttacher = attacher.jointTransform;
								distance = dis;
							end;
						end;
					end;
					if unloadingPipeAttacher > 0 and trigger:attacherInRange(unloadingPipeAttacher) then
						trigger.unloadingPipeAttacher = unloadingPipeAttacher;
					end;
				end;
			elseif trigger.unloadingPipeAttacher > 0 then
				setVisibility(trigger.shlang, true);
				setVisibility(trigger.pipeSkin, false);
				trigger.unloadingPipeAttacher = 0;
			end;
		end;
		tipTrigger.triggerCallback = function(trigger, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
			if self.isEnabled then
				if onEnter then
					local trailer = g_currentMission.objectToTrailer[otherShapeId];
					if trailer ~= nil and trailer.allowTipDischarge then
						if g_currentMission.trailerTipTriggers[trailer] == nil then
							g_currentMission.trailerTipTriggers[trailer] = {};
						end;
						table.insert(g_currentMission.trailerTipTriggers[trailer], trigger);
						trigger.trailer = trailer;
						if trailer.cp then
							local rootAttacherVehicle = trailer:getRootAttacherVehicle();
							if rootAttacherVehicle and rootAttacherVehicle.cp.isDriving then
								trigger.onCourse = true;
							end;
						end;
					end;
				elseif onLeave then
					local trailer = g_currentMission.objectToTrailer[otherShapeId];
					if trailer ~= nil and trailer.allowTipDischarge then
						local triggers = g_currentMission.trailerTipTriggers[trailer];
						if triggers ~= nil then
							for i=1, table.getn(triggers) do
								if triggers[i] == trigger then
									table.remove(triggers, i);
									trigger.trailer = nil;
									trigger.onCourse = nil;
									if table.getn(triggers) == 0 then
										g_currentMission.trailerTipTriggers[trailer] = nil;
									end;
									break;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	table.insert(self.TipTriggers, tipTrigger);
end;

function UniversalFactory:loadSiloTrigger(id)
	local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:removeSiloTrigger(trigger);
	trigger.parent = self;
	trigger.isSiloTrigger = Utils.getNoNil(getUserAttribute(id, "isSiloTrigger"), false);
	trigger.fillTypes = {};
	local fillTypes = getUserAttribute(id, "fillTypes");
	if fillTypes then fillTypes = Utils.splitString(" ", fillTypes); end;
	local capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 50000);
	local priceMultipliers = getUserAttribute(id, "priceMultipliers");
	if priceMultipliers then priceMultipliers = Utils.splitString(" ", priceMultipliers); end;
	for k,fillType in pairs(fillTypes) do
		if fillType then
			fillType = FillUtil.fillTypeNameToInt[fillType];
			if fillType then
				local priceMultiplier = 1;
				if priceMultipliers and priceMultipliers[k] and tonumber(priceMultipliers[k]) then priceMultiplier = tonumber(priceMultipliers[k]); end;
				self:registerFillType(fillType, capacity, priceMultiplier, 2, false);
				if trigger.isSiloTrigger then
					trigger.siloFillType = fillType;
					trigger.fillTypes = {};
				end;
				trigger.fillTypes[fillType] = fillType;
			end;
		end;
	end;
	g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:load(id);
	trigger:register(true);
	if self.isWarehouse then trigger.isEnabled = self.isOwned; end;
	trigger.getFillLevel = function(trigger, fillType)
		local parentFillType = self.fillType[fillType];
		if not parentFillType then
			return nil;
		end;
		return parentFillType.level + Utils.getNoNil(parentFillType.rentLevel, 0);
	end;
	trigger.getIsActivatable = function(trigger)
		if not self.isEnabled or not trigger.isEnabled then
			return false;
		end;
		if trigger.isFilling then
			if trigger.siloTrailer:getRootAttacherVehicle() == g_currentMission.controlledVehicle then
				return true;
			end;
		else
			if trigger.siloTrailer ~= nil and trigger.activeTriggers >= 4 then
				local trailer = trigger.siloTrailer;
				if trailer:getRootAttacherVehicle() ~= g_currentMission.controlledVehicle then
					return false;
				end;
				local currentFillType = trailer.fillUnits[1].currentFillType;
				local fillLevel = trailer:getFillLevel(currentFillType);
				if trigger.isSiloTrigger then
					if (self.fillType[trigger.siloFillType].level > 0 or self.fillType[trigger.siloFillType].rentLevel > 0) and (trigger.siloFillType==currentFillType or currentFillType==FillUtil.FILLTYPE_UNKNOWN) and fillLevel < trailer:getCapacity() then
						return true;
					end;
				else
					if fillLevel == 0 then
						return true;
					elseif fillLevel > 0 and trigger.fillTypes[currentFillType] ~= nil and fillLevel < trailer:getCapacity()
					and (self.fillType[currentFillType].level > 0 or self.fillType[currentFillType].rentLevel > 0) then
						return true;
					end;
				end;
			end;
		end;
		return false;
	end;
	trigger.onActivateObject = function(trigger)
		if not trigger.isFilling then
			if trigger.siloTrailer and trigger.siloTrailer:getFillLevel() > 0 then
				local fillTypes = trigger.siloTrailer:getCurrentFillTypes();
				for _,fillType in pairs(fillTypes) do
					if trigger.fillTypes[fillType] and trigger.siloTrailer:getFillLevel(fillType) < trigger.siloTrailer:getCapacity(fillType) then
						trigger:setIsFilling(true, fillType);
					end;
				end;
			elseif trigger.isSiloTrigger then
				trigger:setIsFilling(true, trigger.siloFillType);
			elseif not UniversalFactoryHUD.siloTriggerMenu then
				UniversalFactoryHUD.currentSiloTrigger = trigger;
				UniversalFactoryHUD.siloTriggerMenu = true;
				UniversalFactoryHUD.showCursor = true;
			end;
		else
			trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
		end;
		g_currentMission:addActivatableObject(trigger);
	end;
	trigger.drawActivate = function(trigger)
		g_currentMission:enableHudIcon("load", 4);
	end;
	trigger.delete = function(trigger)
		if trigger.isClient then
			if trigger.siloFillSound ~= nil then
				delete(trigger.siloFillSound);
			end;
			if trigger.dropEffects then
				EffectManager:deleteEffects(trigger.dropEffects);
			end;
			if trigger.dropParticleSystems then
				ParticleUtil.deleteParticleSystems(trigger.dropParticleSystems);
			end;
			if trigger.lyingParticleSystems then
				ParticleUtil.deleteParticleSystems(trigger.lyingParticleSystems);
			end;
		end;
		for i=1, table.getn(trigger.triggerIds) do
			removeTrigger(trigger.triggerIds[i]);
		end
		delete(trigger.rootNode);
		SiloTrigger:superClass().delete(trigger);
	end;
	trigger.update = function(trigger, dt)
		if trigger.isServer then
			if trigger.siloTrailer == nil then
				trigger.isEnabled = self.isEnabled;
			end;
			local trailer = trigger.siloTrailer;
			local inputLock = false;
			if not self.isOwned and not self.isWarehouse and g_currentMission.missionStats.money <= 0 then
				inputLock = true;
			end;
			if trigger.activeTriggers >= 4 and trailer ~= nil and not inputLock then
				if trigger.isFilling then
					trailer:resetFillLevelIfNeeded(trigger.selectedFillType);
					local fillLevel = trailer:getFillLevel(trigger.selectedFillType);
					if trailer:allowFillType(trigger.selectedFillType, false) then
						local parentFillType = self.fillType[trigger.selectedFillType];
						local level = parentFillType.level;
						if parentFillType.rentLevel > 0 then
							level = parentFillType.rentLevel;
						end;
						local deltaFillLevel = math.min(trigger.fillLitersPerSecond*0.001*dt, level, trailer:getFreeCapacity(trigger.selectedFillType));
						if deltaFillLevel > 0 then
							trailer:setFillLevel(fillLevel+deltaFillLevel, trigger.selectedFillType, false, trigger.fillVolumeDischargeInfos);
							if parentFillType.rentLevel > 0 then
								parentFillType.rentLevel = math.max(parentFillType.rentLevel-deltaFillLevel, 0);
								if parentFillType.rentLevel <= 0 then
									trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
								end;
							else
								parentFillType.level = math.max(parentFillType.level-deltaFillLevel, 0);
								if not self.isOwned and not self.isWarehouse then
									self:fillTypePayment(trigger.selectedFillType, "other", -deltaFillLevel, true, g_i18n:getText("resourceCosts"));
								end;
							end;
						else
							trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
						end;
						self:heapsMoving();
						self.enableUpdateClients = true;
					else
						trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
					end;
				end;
			elseif trigger.isFilling then
				trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
			end;
			if trigger.siloTrailerSend ~= trigger.siloTrailer then
				trigger.siloTrailerSend = trigger.siloTrailer;
				trigger:raiseDirtyFlags(trigger.siloTriggerDirtyFlag);
			end;
		end;
	end;
	table.insert(self.siloTriggers, trigger);
	return trigger;
end;

function UniversalFactory:loadFillTrigger(id)
	local fillType = getUserAttribute(id, "fillType");
	local priceMultiplier = Utils.getNoNil(getUserAttribute(id, "priceMultiplier"), 1);
	local capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 50000);
	if fillType then
		local FT = FillUtil.fillTypeNameToInt[fillType];
		if FT then
			if not self.fillType[FT] then
				self:registerFillType(FT, capacity, priceMultiplier, 2, false);
			end;
			local trigger = FillTrigger:new();
			trigger:load(id, nil, self);
			g_currentMission:addNonUpdateable(trigger);
			trigger.fill = function(trigger, tool, delta)
				if not tool:allowFillType(trigger.fillType, false) then
					return 0.0;
				end
				local oldFillLevel = tool:getFillLevel(trigger.fillType);
				local level = self.fillType[trigger.fillType].level;
				delta = math.min(delta, level);
				if delta > 0 then
					tool:setFillLevel(oldFillLevel + delta, trigger.fillType, true);
					delta = tool:getFillLevel(trigger.fillType) - oldFillLevel;
					self.fillType[trigger.fillType].level = math.max(level - delta, 0);
					self:heapsMoving();
					self.enableUpdateClients = true;
					if not self.isOwned then
						self:fillTypePayment(trigger.fillType, "other", -delta, true, g_i18n:getText("resourceCosts"));
					end;
				end;
				return delta;
			end;
			trigger.getIsActivatable = function(trigger, fillable)
				if not self.isEnabled or not fillable:allowFillType(trigger.fillType, false) or self.fillType[trigger.fillType].level <= 0 then
					return false;
				end;
				return true;
			end;
			table.insert(self.fillTriggers, trigger);
		else
			print("UniversalFactory: "..self.factoryName.." - fillType for FillTrigger "..tostring(i).." - "..fillType.." is not registered");
		end;
	end;
end;

function UniversalFactory:loadLiquidManureFillTrigger(id)
	self:registerFillType(FillUtil.FILLTYPE_LIQUIDMANURE, 800000, 1, 2);
	local trigger = LiquidManureFillTrigger:new();
	trigger.update = function(trigger, dt)
		if trigger:getShowInfo() then
			local fillType = self.fillType[FillUtil.FILLTYPE_LIQUIDMANURE];
			local fillTypeName = FillUtil.fillTypeIndexToDesc[FillUtil.FILLTYPE_LIQUIDMANURE].nameI18N;
			g_currentMission:addExtraPrintText(fillTypeName .. " " ..g_i18n:getText("info_fillLevel").." "..math.floor(fillType.level).." ("..math.floor(100*fillType.level/fillType.capacity).."%)");
		end;
	end;
	trigger.fill = function(trigger, tool, delta)
		if not tool:allowFillType(FillUtil.FILLTYPE_LIQUIDMANURE, false) then
			return 0.0;
		end;
		local level = self.fillType[FillUtil.FILLTYPE_LIQUIDMANURE].level;
		delta = math.max(math.min(delta, level), 0);
		if delta > 0 then
			local oldFillLevel = tool:getFillLevel(FillUtil.FILLTYPE_LIQUIDMANURE);
			tool:setFillLevel(oldFillLevel + delta, FillUtil.FILLTYPE_LIQUIDMANURE, true);
			delta = tool:getFillLevel(FillUtil.FILLTYPE_LIQUIDMANURE) - oldFillLevel;
			if delta > 0 then
				trigger:setFillLevel(level - delta);
			end;
		end;
		return delta;
	end;
	trigger.setFillLevel = function(trigger, fillLevel, noEventSend)
		local fillType = self.fillType[FillUtil.FILLTYPE_LIQUIDMANURE];
		fillLevel = Utils.clamp(fillLevel, 0, fillType.capacity);
		if fillType.level ~= fillLevel then
			fillType.level = fillLevel;
			if g_server then
				self.enableUpdateClients = true;
			end;
			if trigger.movingId ~= nil then
				local x,_,z = getTranslation(trigger.movingId);
				local y = trigger.moveMinY + (trigger.moveMaxY - trigger.moveMinY)*fillType.level/fillType.capacity;
				setTranslation(trigger.movingId, x,y,z);
			end;
		end
	end;
	trigger.getIsActivatable = function(trigger, fillable)
		if self.fillType[FillUtil.FILLTYPE_LIQUIDMANURE].level <= 0 then
			return false;
		end;
		return LiquidManureFillTrigger:superClass().getIsActivatable(trigger, fillable);
	end;
	if trigger:load(id) then
		g_currentMission:addLiquidManureFillTrigger("$l10n_ui_"..self.husbandry.typeName.."LiquidManureSilo", trigger);
		return trigger;
	else
		trigger:delete();
	end;
end;

function UniversalFactory:loadObjectInputTrigger(id)
	local acceptedFillTypes = {};
	local fillTypes = getUserAttribute(id, "fillTypes");
	local priceMultipliers = getUserAttribute(id, "priceMultipliers");
	if priceMultipliers then priceMultipliers = Utils.splitString(" ", priceMultipliers); end;
	local capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 50000);
	if fillTypes ~= nil then
		local types = Utils.splitString(" ", fillTypes);
		for k,ft in pairs(types) do
			local fillType = FillUtil.fillTypeNameToInt[ft];
			if fillType then
				acceptedFillTypes[fillType] = true;
				local priceMultiplier = 1;
				if priceMultipliers and priceMultipliers[k] and tonumber(priceMultipliers[k]) then priceMultiplier = tonumber(priceMultipliers[k]); end;
				self:registerFillType(fillType, capacity, priceMultiplier, 1, false);
			else
				print("UniversalFactory: "..self.factoryName.." - fillType for objectInputTrigger - "..ft.." is not registered and can't be assigned");
			end;
		end;
	end;
	local trigger = ObjectInputTrigger:new(g_server ~= nil, g_client ~= nil);
	trigger.acceptedFillTypes = acceptedFillTypes;
	trigger.parent = self;
	g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:load(id);
	trigger:register(true);
	table.insert(self.objectInputTriggers, trigger);
end;

function UniversalFactory:loadWoodTrigger(id)
	local priceMultiplier = Utils.getNoNil(getUserAttribute(id, "priceMultipliers"), 1);
	local capacity = Utils.getNoNil(getUserAttribute(id, "capacity"), 50000);
	if FillUtil.FILLTYPE_WOOD then
		self:registerFillType(FillUtil.FILLTYPE_WOOD, capacity, priceMultiplier, 1);
	else
		print("UniversalFactory: "..self.factoryName.." - fillType wood for woodTriggers is not registered");
		return;
	end;
	local trigger = WoodSellTrigger:new(id);
	g_currentMission:addNonUpdateable(trigger);
	trigger.triggerCallback = function(trigger, triggerId, otherActorId, onEnter, onLeave, onStay)
		if self.isServer and self.isEnabled and onEnter and otherActorId ~= 0 then
			local splitType = SplitUtil.splitTypes[getSplitType(otherActorId)];
			if splitType and splitType.pricePerLiter > 0 then
				local volume = getVolume(otherActorId);
				local woodLevel = volume*1000;
				if self:getFreeSpace(FillUtil.FILLTYPE_WOOD) >= woodLevel then
					local wood = self.fillType[FillUtil.FILLTYPE_WOOD];
					if wood.rent then
						wood.rentLevel = wood.rentLevel + woodLevel;
					else
						wood.level = wood.level + woodLevel;
						if not self.isOwned then
							local qualityScale = 1;
							local lengthScale = 1;
							local defoliageScale = 1;
							local sizeX, sizeY, sizeZ, numConvexes, numAttachments = getSplitShapeStats(otherActorId);
							if sizeX ~= nil and volume > 0 then
								local bvVolume = sizeX*sizeY*sizeZ;
								local volumeRatio = bvVolume / volume;
								local volumeQuality = 1-math.sqrt(Utils.clamp((volumeRatio-3)/7, 0,1)) * 0.95;
								local convexityQuality = 1-Utils.clamp((numConvexes-2)/(6-2), 0,1) * 0.95;
								local maxSize = math.max(sizeX, math.max(sizeY, sizeZ));
								if maxSize < 11 then
									lengthScale = 0.6 + math.min(math.max((maxSize-1)/5, 0), 1)*0.6;
								else
									lengthScale = 1.2 - math.min(math.max((maxSize-11)/8, 0), 1)*0.6;
								end;
								local minQuality = math.min(convexityQuality,volumeQuality);
								local maxQuality = math.max(convexityQuality,volumeQuality);
								qualityScale = minQuality + (maxQuality-minQuality) * 0.3;
								defoliageScale = 1-math.min(numAttachments/15, 1) * 0.8;
							end;
							qualityScale = Utils.lerp(1, qualityScale, g_currentMission.missionInfo.difficulty/3);
							defoliageScale = Utils.lerp(1, defoliageScale, g_currentMission.missionInfo.difficulty/3);
							local baseValue = volume*1000*splitType.pricePerLiter*qualityScale*defoliageScale * lengthScale;
							local difficultyMultiplier = g_currentMission.missionInfo.sellPriceMultiplier;
							local money = baseValue * difficultyMultiplier * self.fillType[FillUtil.FILLTYPE_WOOD].priceMultiplier;
							g_currentMission:addSharedMoney(money, "soldWood");
							g_currentMission:addMoneyChange(money, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_soldWood"));
						end;
					end;
					self:heapsMoving();
					self.enableUpdateClients = true;
					delete(otherActorId);
				end;
			end;
		end;
	end;
	table.insert(self.woodTriggers, trigger);
end;

function UniversalFactory:loadGasStation(id)
	local station = GasStation:new(id, nil, customMt);
	g_currentMission:addNonUpdateable(station);
	station.fillFuel = function(station, vehicle, delta)
		if self.fillType[FillUtil.FILLTYPE_FUEL].level > 0 then
			if vehicle.setFuelFillLevel ~= nil then
				local oldFillLevel = vehicle.fuelFillLevel;
				vehicle:setFuelFillLevel(vehicle.fuelFillLevel + delta);
				delta = vehicle.fuelFillLevel - oldFillLevel;
			else
				if not vehicle:allowFillType(FillUtil.FILLTYPE_FUEL, false) then
					return 0;
				end;
				local oldFillLevel = vehicle:getFillLevel(FillUtil.FILLTYPE_FUEL);
				vehicle:setFillLevel(oldFillLevel + delta, FillUtil.FILLTYPE_FUEL);
				delta = vehicle:getFillLevel(FillUtil.FILLTYPE_FUEL) - oldFillLevel;
			end;
			if delta > 0 then
				self.fillType[FillUtil.FILLTYPE_FUEL].level = math.max(self.fillType[FillUtil.FILLTYPE_FUEL].level - delta, 0);
				self:heapsMoving();
				self.enableUpdateClients = true;
			end;
		elseif station.vehiclesTriggerCount[vehicle] then
			station.vehiclesTriggerCount[vehicle] = nil;
			vehicle:removeFuelFillTrigger(station);
		end;
		return delta;
	end;
	station.triggerCallback = function(station, triggerId, otherId, onEnter, onLeave, onStay)
		if station.isEnabled and (onEnter or onLeave) then
			local vehicle = g_currentMission.nodeToVehicle[otherId];
			if vehicle ~= nil and vehicle.addFuelFillTrigger ~= nil and vehicle.removeFuelFillTrigger ~= nil and vehicle ~= station then
				local count = Utils.getNoNil(station.vehiclesTriggerCount[vehicle], 0);
				if onEnter and self.fillType[FillUtil.FILLTYPE_FUEL].level > 0 then
					station.vehiclesTriggerCount[vehicle] = count+1;
					if count == 0 then
						vehicle:addFuelFillTrigger(station);
					end
				elseif station.vehiclesTriggerCount[vehicle] then
					station.vehiclesTriggerCount[vehicle] = count-1;
					if count == 1 then
						station.vehiclesTriggerCount[vehicle] = nil;
						vehicle:removeFuelFillTrigger(station);
					end
				end;
			end;
		end;
	end;
	table.insert(self.gasStations, station);
end;

function UniversalFactory:loadSlideGates(id)
	local gate = SlideGateTrigger:new(id);
	g_currentMission:addUpdateable(gate);
	gate.parent = self;
	table.insert(self.slideGates, gate);
end;

---------------------------------------------------------------------------------------EVENT

UniFactoryEvent = {};
UniFactoryEvent_mt = Class(UniFactoryEvent, Event);

InitEventClass(UniFactoryEvent, "UniFactoryEvent");

function UniFactoryEvent:emptyNew()
	local self = Event:new(UniFactoryEvent_mt);
    return self;
end;

function UniFactoryEvent:new(isFactoryEnabled, isOwned, repairTimer, factory)
	local self = UniFactoryEvent:emptyNew();
	self.isFactoryEnabled = isFactoryEnabled;
	self.isOwned = isOwned;
	self.repairTimer = repairTimer;
	self.factory = factory;
	return self;
end;

function UniFactoryEvent:readStream(streamId, connection)
	local isFactoryEnabled = streamReadBool(streamId);
	local isOwned = streamReadBool(streamId);
	local repairTimer = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local factory = networkGetObject(id);
	if factory ~= nil then
		factory.isEnabled = isFactoryEnabled;
		factory.isOwned = isOwned;
		factory:setRentTriggerVisibility(not isOwned);
		factory.repairTimer = repairTimer;
	end;
	Economica:updateShops();
end;

function UniFactoryEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isFactoryEnabled);
	streamWriteBool(streamId, self.isOwned);
	streamWriteInt8(streamId, self.repairTimer);
	streamWriteInt32(streamId, networkGetObjectId(self.factory));
end;

FactoryRentEvent = {};
FactoryRentEvent_mt = Class(FactoryRentEvent, Event);
InitEventClass(FactoryRentEvent, "FactoryRentEvent");

function FactoryRentEvent:emptyNew()
	local self = Event:new(FactoryRentEvent_mt);
    return self;
end;

function FactoryRentEvent:new(numJobStream, hours, price, object)
	local self = FactoryRentEvent:emptyNew();
	self.numJobStream = numJobStream;
	self.hours = hours;
	self.price = price;
	self.object = object;
	return self;
end;

function FactoryRentEvent:readStream(streamId, connection)
	local numJobStream = streamReadInt8(streamId);
	local hours = streamReadInt32(streamId);
	local price = streamReadInt32(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if g_server then
		object:rentPayment(numJobStream, hours, price);
		g_server:broadcastEvent(FactoryRentEvent:new(numJobStream, hours, 0, object));
	else
		object.jobStreams[numJobStream].rentTimer = hours*60;
		object:setRentState(numJobStream, true);
	end;
end;

function FactoryRentEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numJobStream);
	streamWriteInt32(streamId, self.hours);
	streamWriteInt32(streamId, self.price);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
