--author: igor29381

UniversalFactory = {};
UniversalFactory.Factories = {};
UniversalFactory.Shops = {};
UniversalFactory.Warehouses = {};
UniversalFactory.category_animals = {};
UniversalFactory.all = {};

source(g_currentModDirectory.."maps/scripts/FillingStation.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/ObjectInputTrigger.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Sawmill.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/UniversalFactoryLoads.lua", "Perestroyka");

UniversalFactory_mt = Class(UniversalFactory, Object);

function UniversalFactory.onCreate(id)
	local instance = UniversalFactory:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:addOnCreateLoadedObject(instance);
	instance:load(id);
	instance:register(true);
end;

function UniversalFactory:new(isServer, isClient)
	local self = Object:new(isServer, isClient, UniversalFactory_mt);
	self.UniversalFactoryDirtyFlag = self:getNextDirtyFlag();
	self.siloTriggers = {};
	self.fillTriggers = {};
	self.TipTriggers = {};
	self.objectInputTriggers = {};
	self.woodTriggers = {};
	self.gasStations = {};
	self.shovelFillTriggers = {};
	self.shovelTargets = {};
	self.slideGates = {};
	self.weighStations = {};
	self.jobStreams = {};
	self.jobStreamObjects = {};
	self.fillType = {};
	self.heightFillTypeArea = {};
	self.fillTypesToPut = {{}, {}};
	return self;
end;

function UniversalFactory:load(id)

	self.tipTriggersRootNode = getChild(id, "tipTriggers");
	self.objectInputTriggersRootNode = getChild(id, "objectInputTriggers");
	self.woodTriggersRootNode = getChild(id, "woodTriggers");
	self.siloTriggersRootNode = getChild(id, "siloTriggers");
	self.fillTriggersRootNode = getChild(id, "fillTriggers");
	self.gasStationsRootNode = getChild(id, "gasStations");
	self.jobStreamsRootNode = getChild(id, "jobStreams");
	self.heapsRootNode = getChild(id, "heaps");
	self.blocksRootNode = getChild(id, "blocks");
	self.palletsRootNode = getChild(id, "pallets");
	self.balesRootNode = getChild(id, "bales");
	self.fillingStationsRootNode = getChild(id, "fillingStations");
	self.visibleEffectsNode = getChild(id, "visibleEffects");
	self.slideGatesNode = getChild(id, "slideGates");
	self.weighStationsNode = getChild(id, "weighStations");
	self.factoryName = Utils.getNoNil(getUserAttribute(id, "factoryName"), "MegaPlant");
	local locationName = self.factoryName;
	if string.find(g_i18n:getText(locationName), "Missing") == nil then
		locationName = g_i18n:getText(locationName);
	end;
	self.locationName = locationName;
	local description = getUserAttribute(id, "description");
	if description then
		description = g_i18n:getText(description);
		self.descLenght = 1;
		for w in string.gmatch(description, "@") do
			self.descLenght = self.descLenght + 1;
		end;
		self.description = string.gsub(description, "@", "\n");
	end;
	self.isFactory = Utils.getNoNil(getUserAttribute(id, "isFactory"), false);
	self.isWarehouse = Utils.getNoNil(getUserAttribute(id, "isWarehouse"), false);
	self.isShop = Utils.getNoNil(getUserAttribute(id, "isShop"), false);
	self.enableIfOwned = Utils.getNoNil(getUserAttribute(id, "enableIfOwned"), false);
	self.foodFactory = Utils.getNoNil(getUserAttribute(id, "foodFactory"), false);
	self.isOwned = Utils.getNoNil(getUserAttribute(id, "isOwned"), true);
	local animalHusbandry = getUserAttribute(id, "animalHusbandry");
	if animalHusbandry and AnimalUtil.animals[animalHusbandry] then
		self.husbandry = g_currentMission.husbandries[animalHusbandry];
		self.husbandry.parent = self;
		if self.husbandry.manureArea then
			self.heightFillTypeArea[FillUtil.FILLTYPE_MANURE] = self.husbandry.manureArea;
			self:registerFillType(FillUtil.FILLTYPE_MANURE, 500000, 1, 1, false);
		end;
		table.insert(UniversalFactory.category_animals, self);
		local liquidManureTriggerId = Utils.indexToObject(self.husbandry.nodeId, getUserAttribute(self.husbandry.nodeId, "liquidManureTriggerIndex"));
		if liquidManureTriggerId ~= nil then
			local trigger = self:loadLiquidManureFillTrigger(liquidManureTriggerId);
			if trigger then
				self.husbandry.liquidManureTrigger = trigger;
			end;
		end;
	end;
	local hotspotFileName = TrafficManager.curModDir.."maps/scripts/huds/HUD_Tech.png";
	if self.isFactory then table.insert(UniversalFactory.Factories, self); end;
	if self.isWarehouse then table.insert(UniversalFactory.Warehouses, self); end;
	if self.isShop then
		hotspotFileName = TrafficManager.curModDir.."maps/scripts/huds/hud_pda_spot_tipPlaceGreen.png";
		self.transportStation = Utils.getNoNil(getUserAttribute(id, "transportStation"), false);
		table.insert(UniversalFactory.Shops, self);
		self.isOwned = false;
	end;
	UniversalFactory[self.factoryName] = self;
	table.insert(UniversalFactory.all, self);
	self.index = #UniversalFactory.all;
	local appearsOnPDA = Utils.getNoNil(getUserAttribute(id, "appearsOnPDA"), true);
	if appearsOnPDA then
		local x, _, z = getWorldTranslation(id);
		local visitPoint = getChild(id, "visitPoint");
		if visitPoint > 0 then
			x, _, z = getWorldTranslation(visitPoint);
		end;
		local width, height = getNormalizedScreenValues(10, 10);
		self.mapHotspot = g_currentMission.ingameMap:createMapHotspot("", self.locationName, hotspotFileName, nil, nil, x, z, width, height, false, false, true, nil, true);
	end;
	if self.tipTriggersRootNode > 0 then
		for i=1, getNumOfChildren(self.tipTriggersRootNode) do
			self:loadTipTrigger(getChildAt(self.tipTriggersRootNode, i-1));
		end;
	end;
	if self.objectInputTriggersRootNode > 0 then
		for i=1, getNumOfChildren(self.objectInputTriggersRootNode) do
			local childId = getChildAt(self.objectInputTriggersRootNode, i-1);
			self:loadObjectInputTrigger(childId);
		end;
	end;
	if self.woodTriggersRootNode > 0 then
		for i=1, getNumOfChildren(self.woodTriggersRootNode) do
			local childId = getChildAt(self.woodTriggersRootNode, i-1);
			self:loadWoodTrigger(childId);
		end;
	end;
	if self.siloTriggersRootNode > 0 then
		for i=1, getNumOfChildren(self.siloTriggersRootNode) do
			local childId = getChildAt(self.siloTriggersRootNode, i-1);
			self:loadSiloTrigger(childId);
		end;
	end;
	if self.fillTriggersRootNode > 0 then
		for i=1, getNumOfChildren(self.fillTriggersRootNode) do
			local childId = getChildAt(self.fillTriggersRootNode, i-1);
			self:loadFillTrigger(childId);
		end;
	end;
	if self.gasStationsRootNode > 0 then
		if self.fillType[FillUtil.FILLTYPE_FUEL] then
			for i=1, getNumOfChildren(self.gasStationsRootNode) do
				local childId = getChildAt(self.gasStationsRootNode, i-1);
				self:loadGasStation(childId);
			end;
		else
			print("UniversalFactory: "..self.factoryName.." - no fuel in objectInputTriggers. GasStation can't be loaded");
		end;
	end;
	if self.slideGatesNode > 0 then
		for i=1, getNumOfChildren(self.slideGatesNode) do
			self:loadSlideGates(getChildAt(self.slideGatesNode, i-1));
		end;
	end;
	if self.weighStationsNode > 0 then
		for i=1, getNumOfChildren(self.weighStationsNode) do
			local childId = getChildAt(self.weighStationsNode, i-1);
			local station = WeighStation:new(childId);
			g_currentMission:addNonUpdateable(station);
			table.insert(self.weighStations, station);
		end;
	end;
	if self.palletsRootNode > 0 then
		self.palletSpawns = {};
		for i=1, getNumOfChildren(self.palletsRootNode) do
			local childId = getChildAt(self.palletsRootNode, i-1);
			local fillType = getUserAttribute(childId, "fillType");
			local ValueScale = math.min(Utils.getNoNil(getUserAttribute(childId, "valueScale"), 1), 1);
			local capacity = Utils.getNoNil(getUserAttribute(childId, "capacity"), 50000);
			local priceMultiplier = Utils.getNoNil(getUserAttribute(childId, "priceMultiplier"), 1);
			if fillType then
				local fillTypeIndex = FillUtil.fillTypeNameToInt[fillType];
				if fillTypeIndex then
					local i3dFilename = PalletBase[fillTypeIndex];
					i3dFilename = Utils.getFilename(i3dFilename);
					if i3dFilename and fileExists(i3dFilename) then
						self:registerFillType(fillTypeIndex, capacity, priceMultiplier, 2, true);
						local spawns = {};
						for k=1, getNumOfChildren(childId) do
							spawns[k] = getChildAt(childId, k-1);
						end;
						self.palletSpawns[fillTypeIndex] = {ValueScale = ValueScale, spawns=spawns};
					else
						print("UniversalFactory: "..self.factoryName.." - can't find pallet i3d file for fillType "..fillType);
					end;
				else
					print("UniversalFactory: "..self.factoryName.." - pallet fillType "..fillType.." is not registered and can't be assigned");
				end;
			end;
		end;
	end;
	if self.balesRootNode > 0 then
		self.baleSpawns = {};
		local numChildren = getNumOfChildren(self.balesRootNode);
		for i=1, numChildren do
			local childId = getChildAt(self.balesRootNode, i-1);
			local fillType = getUserAttribute(childId, "fillType");
			local i3dFilename = getUserAttribute(childId, "i3dFilename");
			if i3dFilename then
				i3dFilename = Utils.getFilename(i3dFilename, g_currentMission.baseDirectory);
			end;
			local capacity = Utils.getNoNil(getUserAttribute(childId, "capacity"), 50000);
			local priceMultiplier = Utils.getNoNil(getUserAttribute(childId, "priceMultiplier"), 1);
			if fillType then
				local fillTypeIndex = FillUtil.fillTypeNameToInt[fillType];
				if fillTypeIndex ~= nil then
					self:registerFillType(fillTypeIndex, capacity, priceMultiplier, 2, false, true);
					local spawns = {};
					for k=1, getNumOfChildren(childId) do spawns[k] = getChildAt(childId, k-1); end;
					self.baleSpawns[fillTypeIndex] = {["spawns"]=spawns, ["i3dFilename"]=i3dFilename};
				else
					print("UniversalFactory: "..self.factoryName.." - fillType for bales "..tostring(i).." - "..fillType.." is not registered and can't be assigned");
				end;
			end;
		end;
	end;
	if self.fillingStationsRootNode > 0 then
		local numChildren = getNumOfChildren(self.fillingStationsRootNode);
		if numChildren > 0 then
			self.fillingStations = {};
			for i=1, numChildren do
				local child = getChildAt(self.fillingStationsRootNode, i-1);
				local fillingStation = FillingStation:new(g_server ~= nil, g_client ~= nil);
				fillingStation.parent = self;
				g_currentMission:addOnCreateLoadedObject(fillingStation);
				fillingStation:load(child);
				fillingStation:register(true);
				table.insert(self.fillingStations, fillingStation);
			end;
		end;
	end;
	if self.blocksRootNode > 0 then
		local numChildren = getNumOfChildren(self.blocksRootNode);
		if numChildren > 0 then
			self.blocks = {};
			for i=1, numChildren do
				local child = getChildAt(self.blocksRootNode, i-1);
				local fillType = getUserAttribute(child, "fillType");
				if fillType ~= nil then
					local desc = FillUtil.fillTypeNameToDesc[fillType];
					if desc ~= nil and self.fillType[desc.index] then
						self.blocks[desc.index] = {};
						local numChildren = getNumOfChildren(child);
						if numChildren > 0 then
							for i=1, numChildren do
								local childBlock = getChildAt(child, i-1);
								setVisibility(childBlock, false);
								table.insert(self.blocks[desc.index], childBlock);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	local sawmillRootNode = getChild(id, "sawmillRootNode");
	if sawmillRootNode > 0 then
		local sawmill = Sawmill:new(g_server ~= nil, g_client ~= nil);
		sawmill.parent = self;
		g_currentMission:addOnCreateLoadedObject(sawmill);
		sawmill:load(sawmillRootNode, true);
		sawmill:register(true);
		table.insert(self.jobStreamObjects, sawmill);
	end;
	local woodCrusherRootNode = getChild(id, "woodCrusherRootNode");
	if woodCrusherRootNode > 0 then
		local woodCrusher = Sawmill:new(g_server ~= nil, g_client ~= nil);
		woodCrusher.parent = self;
		g_currentMission:addOnCreateLoadedObject(woodCrusher);
		woodCrusher:load(woodCrusherRootNode);
		woodCrusher:register(true);
		table.insert(self.jobStreamObjects, woodCrusher);
	end;
	if self.jobStreamsRootNode > 0 then
		local numChildren = math.min(getNumOfChildren(self.jobStreamsRootNode), 3);
		for i=1, numChildren do
			local childId = getChildAt(self.jobStreamsRootNode, i-1);
			local jobStream = {};
			jobStream.isActivated = false;
			jobStream.isWorking = false;
			jobStream.rentTimer = 0;
			local inputFillTypes = getUserAttribute(childId, "inputFillTypes");
			local inputPercents = getUserAttribute(childId, "inputPercents");
			if inputFillTypes ~= nil and inputPercents ~= nil then
				local types = Utils.splitString(" ", inputFillTypes);
				local percents = Utils.splitString(" ", inputPercents);
				jobStream.inputFillTypes = {};
				jobStream.inputPercents = {};
				for k,v in pairs(types) do
					local desc = FillUtil.fillTypeNameToDesc[v];
					local percent = tonumber(percents[k]);
					if desc ~= nil then
						if percent then
							if self.fillType[desc.index] then
								table.insert(jobStream.inputFillTypes, desc.index);
								table.insert(jobStream.inputPercents, percent/100);
							else
								print("UniversalFactory: "..self.factoryName.." fillType in jobStream "..tostring(i).." - "..v.." is not specified in tipTriggers");
							end;
						else
							print("UniversalFactory: "..self.factoryName.."invalid input percent in jobStream "..tostring(i).." - "..percents[k]);
						end;
					else
						print("UniversalFactory: "..self.factoryName.." fillType in jobStream "..tostring(i).." - "..v.." is not registered");
					end;
				end;
			end;
			local outputFillTypes = getUserAttribute(childId, "outputFillTypes");
			local outputPercents = getUserAttribute(childId, "outputPercents");
			if outputFillTypes ~= nil and outputPercents ~= nil then
				local types = Utils.splitString(" ", outputFillTypes);
				local percents = Utils.splitString(" ", outputPercents);
				jobStream.outputFillTypes = {};
				jobStream.outputPercents = {};
				for k,v in pairs(types) do
					local desc = FillUtil.fillTypeNameToDesc[v];
					local percent = tonumber(percents[k]);
					if desc ~= nil and self.fillType[desc.index] then
						if percent then
							table.insert(jobStream.outputFillTypes, desc.index);
							table.insert(jobStream.outputPercents, percent/100);
						else
							print("UniversalFactory: "..self.factoryName.."invalid output percent in jobStream "..tostring(i).." - "..percents[k]);
						end;
					else
						print("UniversalFactory: "..self.factoryName.." fillType in jobStream "..tostring(i).." - "..v.." is not registered or not specified in siloTriggers or fillablePallets");
					end;
				end;
			end;
			table.insert(self.jobStreams, jobStream);
		end;
	end;
	if self.heapsRootNode > 0 then
		local numChildren = getNumOfChildren(self.heapsRootNode);
		if numChildren > 0 then
			self.heaps = {};
			for i=1, numChildren do
				local child = getChildAt(self.heapsRootNode, i-1);
				local fillType = getUserAttribute(child, "fillType");
				local minY, maxY = Utils.getVectorFromString(getUserAttribute(child, "moveMinMaxY"));
				if fillType ~= nil then
					local int = FillUtil.fillTypeNameToInt[fillType];
					if int and minY and maxY and self.fillType[int] then
						self.heaps[int] = {["movingId"] = child, ["minY"] = minY, ["maxY"] = maxY};
						local shovelFillTriggerIndex = getUserAttribute(child, "shovelFillTriggerIndex");
						if shovelFillTriggerIndex then shovelFillTriggerIndex = Utils.indexToObject(child, shovelFillTriggerIndex); end;
						if shovelFillTriggerIndex then
							local trigger = ShovelFillTrigger:new();
							if trigger:load(shovelFillTriggerIndex, int) then
								g_currentMission:addUpdateable(trigger);
							else
								trigger:delete();
							end;
							trigger.fillShovel = function(trigger, shovel, dt)
								local fillType = self.fillType[trigger.fillType];
								local level = fillType.level;
								if fillType.rentLevel > 0 then
									level = fillType.rentLevel;
								end;
								if level > 0 then
									local delta = shovel:fillShovelFromTrigger(trigger, level, trigger.fillType, dt);
									if delta > 0 then
										if fillType.rentLevel > 0 then
											fillType.rentLevel = fillType.rentLevel - delta;
										else
											fillType.level = fillType.level - delta;
											if not self.isOwned then
												self:fillTypePayment(trigger.fillType, "other", -delta, true, g_i18n:getText("resourceCosts"));
											end;
										end;
										self:heapsMoving();
										self.enableUpdateClients = true;
									end;
								end;
							end;
							table.insert(self.shovelFillTriggers, trigger);
						end;
						local shovelTargetIndex = getUserAttribute(child, "shovelTargetIndex");
						if shovelTargetIndex then shovelTargetIndex = Utils.indexToObject(child, shovelTargetIndex); end;
						if shovelTargetIndex then
							if self.isServer then
								local object = ShovelTarget:new();
								if object:load(shovelTargetIndex) then
									object.fillTypes[int] = true;
									g_currentMission:addNonUpdateable(object);
								else
									object:delete();
								end;
								object.addShovelFillLevel = function(object, shovel, fillLevelDelta, fillType)
									if object.fillTypes[fillType] then
										local parentFillType = self.fillType[fillType];
										if parentFillType.rent then
											parentFillType.rentLevel = parentFillType.rentLevel + fillLevelDelta;
										else
											parentFillType.level = parentFillType.level + fillLevelDelta;
											if not self.isOwned and fillLevelDelta > 0 then
												self:fillTypePayment(fillType, "other", fillLevelDelta, true, g_i18n:getText("finance_harvestIncome"));
											end;
										end;
										self:heapsMoving();
										self.enableUpdateClients = true;
										return fillLevelDelta;
									end;
									return 0;
								end;
								table.insert(self.shovelTargets, object);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	if self.visibleEffectsNode > 0 then
		local shaderObjects = getUserAttribute(self.visibleEffectsNode, "shaderObjects");
		if shaderObjects then
			self.shaderObjects = {};
			shaderObjects = Utils.splitString(" ", shaderObjects);
			for i=1, #shaderObjects do
				local objectId = Utils.indexToObject(id, shaderObjects[i]);
				if objectId > 0 then
					local object = {};
					object.node = objectId;
					object.parameterName = getUserAttribute(objectId, "parameterName");
					local shaderWorkParams = getUserAttribute(objectId, "shaderWorkParams");
					object.shaderWorkParams = {Utils.getVectorFromString(shaderWorkParams)};
					local shaderUpdateParams = getUserAttribute(objectId, "shaderUpdateParams");
					if shaderUpdateParams then
						object.shaderUpdateParams = {Utils.getVectorFromString(shaderUpdateParams)};
					end;
					local shaderStopParams = getUserAttribute(objectId, "shaderStopParams");
					object.shaderStopParams = {Utils.getVectorFromString(shaderStopParams)};
					object.activated = false;
					table.insert(self.shaderObjects, object);
				end;
			end;
		end;
		local particles = getUserAttribute(self.visibleEffectsNode, "particles");
		if particles then
			self.particles = {};
			particles = Utils.splitString(" ", particles);
			for i=1, #particles do
				local particleId = Utils.indexToObject(id, particles[i]);
				local particle = {};
				ParticleUtil.loadParticleSystemFromNode(particleId, particle, false, false);
				table.insert(self.particles, particle);
			end;
		end;
	end;
	self.isEnabled = true;
	self.nodeId = id;
	g_currentMission.environment:addHourChangeListener(self);
	g_currentMission.environment:addMinuteChangeListener(self);
	self.updateTipping = false;
	self.updateTippingTimer = 0;
	self.repairTimer = 0;
	if self.visibleEffectsNode > 0 then
		setVisibility(self.visibleEffectsNode, false);
	end;
	local hour1, hour2 = Utils.getVectorFromString(getUserAttribute(id, "workingHours"));
	if hour1 and hour2 then
		self.workingHours = {hour1, hour2};
		self.workingDuration = hour2 - hour1;
	end;
	self.jobLitersPerSecond = Utils.clamp(Utils.getNoNil(getUserAttribute(id, "jobLitersPerSecond"), 50), 1, 1000);
	self.dayCosts = Utils.getNoNil(getUserAttribute(id, "dayCosts"), 500);
	self.costsPerSecond = Utils.getNoNil(getUserAttribute(id, "costsPerSecond"), 0);
	self.nightCosts = Utils.getNoNil(getUserAttribute(id, "nightCosts"), 2);
	self.rentCosts = 0;
	self.moneyChangeId = getMoneyTypeId();
	self.lastMoneyChange = -1;
	self:setRentFillTypes(not self.isOwned);
	if self.isServer then
		self.enableUpdateClients = false;
		self.updateTimer = 1000;
		local xmlPath = "UniFactorySaves.xml";
		if g_currentMission.missionInfo.savegameDirectory then
			xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/UniFactorySaves.xml";
		end;
		if fileExists(xmlPath) then
			local xmlFile = loadXMLFile("UniFactorySaves", xmlPath);
			local i = 0;
			while true do
				local factoryIndex = string.format("factories.factory(%d)", i);
				if not hasXMLProperty(xmlFile, factoryIndex) then break; end;
				local name = getXMLString(xmlFile, factoryIndex .. "#name");
				if name == self.factoryName then
					self.jobLitersPerSecond = Utils.clamp(Utils.getNoNil(getXMLFloat(xmlFile, factoryIndex .. "#jobLitersPerSecond"), 50), 1, 1000);
					for c=1, #self.jobStreams do
						local jobStream = self.jobStreams[c];
						jobStream.isActivated = Utils.getNoNil(getXMLBool(xmlFile, string.format("%s#jobStream%d", factoryIndex, c)), false);
						jobStream.rentTimer = Utils.getNoNil(getXMLInt(xmlFile, string.format("%s#rentTimerJobStream%d", factoryIndex, c)), 0);
					end;
					self.repairTimer = Utils.getNoNil(getXMLInt(xmlFile, factoryIndex .. "#repairTimer"), 0);
					self.rentCosts = Utils.getNoNil(getXMLFloat(xmlFile, factoryIndex .. "#rentCosts"), 0);
					local repairTimer = getXMLInt(xmlFile, factoryIndex .. "#updateFactoryTimer");
					if repairTimer then
						self.repairTimer = repairTimer;
					end;
					self.isEnabled = self.repairTimer == 0;
					local ii = 0;
					while true do
						local resourceIndex = string.format(factoryIndex .. ".resource(%d)", ii);
						if not hasXMLProperty(xmlFile, resourceIndex) then break; end;
						local fillType = Utils.getNoNil(getXMLString(xmlFile, resourceIndex.."#fillType"), "unknown");
						fillType = FillUtil.fillTypeNameToInt[fillType];
						if fillType and self.fillType[fillType] then
							local factoryFillType = self.fillType[fillType];
							factoryFillType.level = Utils.getNoNil(getXMLFloat(xmlFile, resourceIndex.."#fillLevel"), 0);
							factoryFillType.rentLevel = Utils.getNoNil(getXMLFloat(xmlFile, resourceIndex.."#rentLevel"), 0);
							factoryFillType.extraMission = Utils.getNoNil(getXMLBool(xmlFile, resourceIndex.."#extraMission"), false);
							if factoryFillType.extraMission then
								factoryFillType.extraMissionLevel = Utils.getNoNil(getXMLFloat(xmlFile, resourceIndex.."#extraMissionLevel"), 0);
							end;
							factoryFillType.contract = Utils.getNoNil(getXMLBool(xmlFile, resourceIndex.."#contract"), false);
							if factoryFillType.contract then
								factoryFillType.contractLevel = Utils.getNoNil(getXMLFloat(xmlFile, resourceIndex.."#contractLevel"), 0);
							end;
							factoryFillType.rent = Utils.getNoNil(getXMLBool(xmlFile, resourceIndex.."#rent"), false);
							local autoOutput = getXMLString(xmlFile, resourceIndex.."#autoOutput");
							if autoOutput then
								factoryFillType.autoOutput = autoOutput;
							end;
							local autoInput = getXMLBool(xmlFile, resourceIndex.."#autoInput");
							if autoInput then
								factoryFillType.autoInput = true;
							end;
						end;
						ii = ii + 1;
					end;
					break;
				end;
				i = i + 1;
			end;
			delete(xmlFile);
		end;
		self:heapsMoving();
	end;
	print("UniFactory ".. self.factoryName .." loaded");
	return true;
end;

function UniversalFactory:readStream(streamId, connection)
	UniversalFactory:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		for i=1, #self.jobStreams do
			local jobStream = self.jobStreams[i];
			jobStream.isActivated = streamReadBool(streamId);
			jobStream.isWorking = streamReadBool(streamId);
			jobStream.rentTimer = streamReadInt32(streamId);
			if jobStream.rentTimer > 0 then
				self:setRentState(i, true);
			end;
		end;
		for n,fillType in pairs(self.fillType) do
			fillType.level = streamReadInt32(streamId);
			local extraMission = streamReadBool(streamId);
			if extraMission then
				fillType.extraMission = true;
				fillType.extraMissionLevel = streamReadInt32(streamId);
			end;
			local contract = streamReadBool(streamId);
			if contract then
				fillType.contract = true;
				fillType.contractLevel = streamReadInt32(streamId);
			end;
			fillType.rentLevel = streamReadInt32(streamId);
			local autoOutput = streamReadString(streamId);
			if autoOutput ~= " " then
				fillType.autoOutput = autoOutput;
			end;
			local autoInput = streamReadBool(streamId);
			if autoInput then
				fillType.autoInput = true;
			end;
		end;
		self:heapsMoving();
		self.repairTimer = streamReadInt8(streamId);
		self.rentCosts = streamReadInt32(streamId);
		self.isEnabled = streamReadBool(streamId);
		self.isOwned = streamReadBool(streamId);
		if self.isOwned then
			self:setRentTriggerVisibility(false);
		end;
		self.jobLitersPerSecond = streamReadFloat32(streamId);
	end;
end;

function UniversalFactory:writeStream(streamId, connection)
	UniversalFactory:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		for i=1, #self.jobStreams do
			local jobStream = self.jobStreams[i];
			streamWriteBool(streamId, jobStream.isActivated);
			streamWriteBool(streamId, jobStream.isWorking);
			streamWriteInt32(streamId, jobStream.rentTimer);
		end;
		for n,fillType in pairs(self.fillType) do
			streamWriteInt32(streamId, math.floor(fillType.level));
			streamWriteBool(streamId, Utils.getNoNil(fillType.extraMission, false));
			if fillType.extraMission then
				streamWriteInt32(streamId, math.floor(fillType.extraMissionLevel));
			end;
			streamWriteBool(streamId, Utils.getNoNil(fillType.contract, false));
			if fillType.contract then
				streamWriteInt32(streamId, math.floor(fillType.contractLevel));
			end;
			streamWriteInt32(streamId, math.floor(fillType.rentLevel));
			streamWriteString(streamId, Utils.getNoNil(fillType.autoOutput, " "));
			streamWriteBool(streamId, Utils.getNoNil(fillType.autoInput, false));
		end;
		streamWriteInt8(streamId, self.repairTimer);
		streamWriteInt32(streamId, math.floor(self.rentCosts));
		streamWriteBool(streamId, self.isEnabled);
		streamWriteBool(streamId, self.isOwned);
		streamWriteFloat32(streamId, self.jobLitersPerSecond);
	end;
end;

function UniversalFactory:readUpdateStream(streamId, timestamp, connection)
	UniversalFactory:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		for _,fillType in pairs(self.fillType) do
			fillType.level = streamReadInt32(streamId);
			local extraMission = streamReadBool(streamId);
			if extraMission then
				fillType.extraMission = true;
				fillType.extraMissionLevel = streamReadInt32(streamId);
			end;
			local contract = streamReadBool(streamId);
			if contract then
				fillType.contract = true;
				fillType.contractLevel = streamReadInt32(streamId);
			end;
			fillType.rent = streamReadBool(streamId);
			fillType.rentLevel = streamReadInt32(streamId);
		end;
		self.rentCosts = streamReadInt32(streamId);
		self:heapsMoving();
	end;
end;

function UniversalFactory:writeUpdateStream(streamId, connection, dirtyMask)
	UniversalFactory:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		self.enableUpdateClients = false;
		self.updateTimer = 1000;
		for _,fillType in pairs(self.fillType) do
			streamWriteInt32(streamId, math.floor(fillType.level));
			streamWriteBool(streamId, Utils.getNoNil(fillType.extraMission, false));
			if fillType.extraMission then
				streamWriteInt32(streamId, math.floor(fillType.extraMissionLevel));
			end;
			streamWriteBool(streamId, Utils.getNoNil(fillType.contract, false));
			if fillType.contract then
				streamWriteInt32(streamId, math.floor(fillType.contractLevel));
			end;
			streamWriteBool(streamId, fillType.rent);
			streamWriteInt32(streamId, math.floor(fillType.rentLevel));
		end;
		streamWriteInt32(streamId, math.floor(self.rentCosts));
	end;
end;

function UniversalFactory:changeJobStreamState(number)
	local jobStream = self.jobStreams[number];
	if jobStream then
		jobStream.isActivated = not jobStream.isActivated;
		if not jobStream.isActivated then
			jobStream.isWorking = false;
		end;
		g_server:broadcastEvent(UniFactoryHUDEvent:new(number, jobStream.isActivated, jobStream.isWorking, 0, 0, self));
	end;
end;

function UniversalFactory:delete()
	if self.mapHotspot ~= nil then
		g_currentMission.ingameMap:deleteMapHotspot(self.mapHotspot);
	end;
	for i=1, #self.TipTriggers do
		local trigger = self.TipTriggers[i];
		if trigger.skeleton and trigger.pipeSkin then
			delete(trigger.skeleton);
			delete(trigger.pipeSkin);
		end;
	end;
	if self.loadedGates then
		for i=1, #self.loadedGates do
			self.loadedGates[i]:delete();
		end;
	end;
	if self.updateRootNode then
		delete(self.updateRootNode);
	end;
	if self.nodeId then g_currentMission:removeNodeObject(self.nodeId); end;
	g_currentMission.environment:removeHourChangeListener(self);
	UniversalFactory:superClass().delete(self);
end;

function UniversalFactory:update(dt)
	if self.isServer then
		if self.isEnabled then
			local timeScale = g_currentMission.missionInfo.timeScale;
			if self.isFactory then
				if self.isOwned then
					for i=1, #self.jobStreams do
						local jobStream = self.jobStreams[i];
						if not jobStream.specialJobStream and jobStream.isActivated then
							local delta = self.jobLitersPerSecond*0.001*dt*timeScale;
							local isWorking = not self.updateTipping;
							if isWorking then
								if #jobStream.inputFillTypes == 1 then
									delta = math.min(delta, self.fillType[jobStream.inputFillTypes[1]].level);
									if delta <= 0 then isWorking = false; end;
								else
									for k=1, #jobStream.inputFillTypes do
										local fillType = self.fillType[jobStream.inputFillTypes[k]];
										local inputDelta = delta*jobStream.inputPercents[k];
										if fillType.level - inputDelta < 0 then
											isWorking = false;
											break;
										end;
									end;
								end;
							end;
							if isWorking then
								for k=1, #jobStream.outputFillTypes do
									local fillType = self.fillType[jobStream.outputFillTypes[k]];
									local outputDelta = delta*jobStream.outputPercents[k];
									if fillType.level + outputDelta > fillType.capacity then
										isWorking = false;
										break;
									end;
								end;
							end;
							if isWorking then
								for k=1, #jobStream.inputFillTypes do
									local fillType = self.fillType[jobStream.inputFillTypes[k]];
									local inputDelta = delta*jobStream.inputPercents[k];
									fillType.level = fillType.level - inputDelta;
								end;
								for k=1, #jobStream.outputFillTypes do
									local fillType = self.fillType[jobStream.outputFillTypes[k]];
									local outputDelta = delta*jobStream.outputPercents[k];
									fillType.level = fillType.level + outputDelta;
								end;
								if self.costsPerSecond > 0 then
									local nightCosts = 1;
									if not g_currentMission.environment.isSunOn then nightCosts = self.nightCosts; end;
									local costs = (self.costsPerSecond*nightCosts*0.001*dt*timeScale) / #self.jobStreams;
									g_currentMission:addSharedMoney(-costs, "other");
								end;
								self:heapsMoving();
								self.enableUpdateClients = true;
							end;
							if jobStream.isWorking ~= isWorking then
								g_server:broadcastEvent(UniFactoryHUDEvent:new(i, true, isWorking, 0, 0, self));
							end;
							jobStream.isWorking = isWorking;
						end;
					end;
				end;
				if self.updateTipping then
					self.updateTippingTimer = self.updateTippingTimer + dt;
					if self.updateTippingTimer > 3000 then
						self.updateTipping = false;
						self.updateTippingTimer = 0;
					end;
				end;
			end;
			if self.isShop or (self.isFactory and not self.isOwned and not self.enableIfOwned) then
				if self.transportStation and self.cargoFillTypes then
					for n,ft in pairs(self.fillType) do
						if self.cargoFillTypes[n] then
							local delta = 0.25*dt*timeScale;
							if ft.inputFillType then
								ft.level = math.max(ft.level - delta, 0);
							elseif ft.outputFillType then
								ft.level = math.min(ft.level + delta, ft.capacity);
							end;
						end;
					end;
					self:heapsMoving();
					self.enableUpdateClients = true;
				end;
			end;
		end;
	end;
	local enableEffects = false;
	if self.isEnabled then
		if self.isFactory and self.isOwned then
			for i=1, #self.jobStreams do
				if not self.jobStreams[i].specialJobStream and self.jobStreams[i].isWorking then enableEffects = true; end;
			end;
		else
			enableEffects = true;
		end;
	end;
	if self.visibleEffectsNode > 0 then
		if enableEffects then
			if not getVisibility(self.visibleEffectsNode) then
				setVisibility(self.visibleEffectsNode, true);
				if self.particles then
					for i=1, #self.particles do
						local particle = self.particles[i];
						Utils.setEmittingState(particle, true);
					end;
				end;
			end;
		else
			if getVisibility(self.visibleEffectsNode) then
				setVisibility(self.visibleEffectsNode, false);
				if self.particles then
					for i=1, #self.particles do
						local particle = self.particles[i];
						Utils.setEmittingState(particle, false);
					end;
				end;
			end;
		end;
	end;
	if self.shaderObjects then
		for i=1, #self.shaderObjects do
			local shaderObject = self.shaderObjects[i];
			if enableEffects and not shaderObject.activated then
				shaderObject.activated = true;
				local params = shaderObject.shaderWorkParams;
				if shaderObject.shaderUpdateParams then
					local updateable = Economica.updateables[self.factoryName][1];
					if updateable and updateable.currentValue > 1 then
						params = shaderObject.shaderUpdateParams;
					end;
				end;
				setShaderParameter(shaderObject.node, shaderObject.parameterName, params[1], params[2], params[3], params[4], false);
			end;
			if not enableEffects and shaderObject.activated then
				shaderObject.activated = false;
				local params = shaderObject.shaderStopParams;
				setShaderParameter(shaderObject.node, shaderObject.parameterName, params[1], params[2], params[3], params[4], false);
			end;
		end;
	end;
	if self.weighStationsNode > 0 then
		for _,station in pairs(self.weighStations) do
			for vehicle, _ in pairs(station.triggerVehicles) do
				station:updateWeight();
			end;
		end;
	end;
	if self.lastMoneyChange > 0 then
		self.lastMoneyChange = self.lastMoneyChange - 1;
		if self.lastMoneyChange == 0 then
			g_currentMission:showMoneyChange(self.moneyChangeId, self.lastMoneyChangeText);
		end;
	end;
	if self.isServer and self.enableUpdateClients then
		self.updateTimer = math.max(self.updateTimer - dt, 0);
		if self.updateTimer == 0 then
			self:raiseDirtyFlags(self.UniversalFactoryDirtyFlag);
		end;
	end;
end;

function UniversalFactory:getHeightFillTypeLevel(fillType)
    local area = self.heightFillTypeArea[fillType];
	if area == nil then
        return;
    end;
    local xs,_,zs = getWorldTranslation(area.start);
    local xw,_,zw = getWorldTranslation(area.width);
    local xh,_,zh = getWorldTranslation(area.height);
    local fillLevel = TipUtil.getFillLevelAtArea(fillType, xs,zs, xw,zw, xh,zh);
    return fillLevel;
end

function UniversalFactory:heapsMoving()
	if self.heaps then
		for k,heap in pairs(self.heaps) do
			local fillType = self.fillType[k];
			if fillType.level and fillType.capacity then
				local x,y,z = getTranslation(heap.movingId);
				local newY = (heap.maxY - heap.minY)*((fillType.level + Utils.getNoNil(fillType.rentLevel, 0))/fillType.capacity);
				setTranslation(heap.movingId, x, newY, z);
			end;
		end;
	end;
	if self.blocks then
		for k,block in pairs(self.blocks) do
			local fillType = self.fillType[k];
			if fillType.level and fillType.capacity then
				local percentDecimal = (fillType.level + Utils.getNoNil(fillType.rentLevel, 0))/fillType.capacity;
				local numBlocksToShow = math.ceil(#block*math.min(percentDecimal, 1));
				for i=1, #block do
					setVisibility(block[i], i <= numBlocksToShow);
				end;
				if fillType.level + Utils.getNoNil(fillType.rentLevel, 0) < 0.1 then
					for i=1, #block do
						setVisibility(block[i], false);
					end;
				end;
			end;
		end;
	end;
	for k,_ in pairs(self.heightFillTypeArea) do
		local fillType = self.fillType[k];
		local fillLevel = self:getHeightFillTypeLevel(k);
		if fillLevel then
			fillType.level = fillLevel;
		end;
	end;
end;

function UniversalFactory:loadPallet(palletFillType)
	local i3dFilename = PalletBase[palletFillType];
	if not i3dFilename or not (self.palletSpawns and self.palletSpawns[palletFillType]) then
		return;
	end;
	local fillType = self.fillType[palletFillType];
	if fillType.level + fillType.rentLevel >= 2000 then
		local palletSpawns = self.palletSpawns[palletFillType];
		local spawnId = self:findFreeSpawn(palletFillType, palletSpawns.spawns);
		if spawnId then
			local delta = 2000 - math.min(fillType.rentLevel, 2000);
			if not fillType.rent and not self.isOwned and delta > 0 then
				local priceMultiplier = Utils.getNoNil(fillType.priceMultiplier, 1);
				local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
				local money = FillUtil.fillTypeIndexToDesc[palletFillType].pricePerLiter * priceMultiplier * fillType.priceDelta * difficultyMultiplier * delta;
				if g_currentMission.missionStats.money < money then
					g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
					return;
				else
					g_currentMission:addSharedMoney(-money, "other");
					g_currentMission:addMoneyChange(-money, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("resourceCosts"));
				end;
			end;
			fillType.rentLevel = fillType.rentLevel - (2000 - delta);
			fillType.level = fillType.level - delta;
			self:heapsMoving();
			self.enableUpdateClients = true;
			local x,y,z = getWorldTranslation(spawnId);
			local _,ry,_ = getWorldRotation(spawnId);
			local pallet = FillablePallet:new(self.isServer, self.isClient);
			pallet.fillablePalletValueScale = palletSpawns.ValueScale;
			pallet:load(i3dFilename, x,y,z, 0,ry,0);
			pallet:register();
			pallet.fillType = palletFillType;
			pallet:setFillLevel(2000, true);
			pallet.sendI3dFilename = true;
		end;
	end;
end;

function UniversalFactory:loadBale(baleFillType)
	if self.baleSpawns and self.baleSpawns[baleFillType] then
		if self.isServer then
			local fillType = self.fillType[baleFillType];
			if fillType.level + fillType.rentLevel >= 4000 then
				local baleSpawns = self.baleSpawns[baleFillType];
				local spawnId = self:findFreeSpawn(baleFillType, baleSpawns.spawns);
				if spawnId then
					local delta = 4000 - math.min(fillType.rentLevel, 4000);
					fillType.rentLevel = fillType.rentLevel - (4000 - delta);
					fillType.level = fillType.level - delta;
					self:heapsMoving();
					self.enableUpdateClients = true;
					local bale = Bale:new(self.isServer, self.isClient);
					local x,y,z = getWorldTranslation(spawnId);
					bale:load(baleSpawns.i3dFilename, x,y,z, 0,0,0, 4000);
					bale:register();
					if baleFillType == FillUtil.FILLTYPE_SILAGE then
						bale:setWrappingState(1);
					end;
					bale.fillType = baleFillType;
				end;
			end;
		end;
	end;
end;

function UniversalFactory:findFreeSpawn(fillType, spawnsGroup)
	local spawnId = nil;
	for i=1, #spawnsGroup do
		local spawn = spawnsGroup[i];
		local x,y,z = getWorldTranslation(spawn);
		local distance = 1.65;
		if g_currentMission.itemsToSave then
			for index,item in pairs(g_currentMission.itemsToSave) do
				if item.item.fillType == fillType then
					local fpx, fpy, fpz = getWorldTranslation(item.item.nodeId);
					local newDistance = Utils.vector3Length(fpx-x, fpy-y, fpz-z);
					if newDistance < 1.65 then distance = newDistance; end;
				end;
			end;
		end;
		if distance >= 1.65 then spawnId = spawn; break; end;
	end;
	return spawnId;
end;

function UniversalFactory:testWorkingHours()
	if self.repairTimer == 0 then
		local currentHour = g_currentMission.environment.currentHour;
		if self.workingHours and self.workingHours[1] and self.workingHours[2] then
			if currentHour >= self.workingHours[1] and currentHour < self.workingHours[2] then
				if not self.isEnabled then
					self.isEnabled = true;
					g_server:broadcastEvent(UniFactoryEvent:new(self.isEnabled, self.isOwned, 0, self));
				end;
			elseif self.isEnabled then
				self.isEnabled = false;
				g_server:broadcastEvent(UniFactoryEvent:new(self.isEnabled, self.isOwned, 0, self));
			end;
		elseif not self.isEnabled then
			if not self.isOwned and (self.isWarehouse or self.enableIfOwned) then
				return;
			end;
			self.isEnabled = true;
			g_server:broadcastEvent(UniFactoryEvent:new(self.isEnabled, self.isOwned, 0, self));
		end;
	end;
end;

function UniversalFactory:setOutputFillTypes()
	if self.isOwned then
		for n,fillType in pairs(self.fillType) do
			if fillType.outputFillType and n ~= FillUtil.FILLTYPE_MANURE then
				fillType.outputNames = {};
				for i=1, #UniversalFactory.all do
					local factory = UniversalFactory.all[i];
					if factory ~= self then
						local targetFillType = factory.fillType[n];
						if targetFillType and targetFillType.inputFillType then
							if factory.isOwned then
								if not fillType.outputNames.storage then
									fillType.outputNames.storage = {};
								end;
								table.insert(fillType.outputNames.storage, factory.factoryName);
							elseif not factory.isWarehouse and not factory.enableIfOwned then
								if not fillType.outputNames.buying then
									fillType.outputNames.buying = {};
								end;
								table.insert(fillType.outputNames.buying, factory.factoryName);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function UniversalFactory:hourChanged()
	if self.repairTimer > 0 then
		self.repairTimer = math.max(self.repairTimer - 1, 0);
	end;
	if self.isServer then
		self:testWorkingHours();
		if self.isOwned then
			local totalPrice = 0;
			local transportPrice = 0;
			for n,ft in pairs(self.fillType) do
				if ft.autoOutput then
					local target = UniversalFactory[ft.autoOutput];
					if target.isEnabled then
						local targetFreeSpace = target:getFreeSpace(n);
						if targetFreeSpace > 0 and ft.level > 1000 then
							local price = 0;
							if not target.isOwned then
								local targetFillType = target.fillType[n];
								local priceMultiplier = Utils.getNoNil(targetFillType.priceMultiplier, 1);
								local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
								local priceDelta = Utils.getNoNil(targetFillType.priceDelta, 1);
								price = FillUtil.fillTypeIndexToDesc[n].pricePerLiter * priceMultiplier * priceDelta * difficultyMultiplier;
							end;
							local delta = math.min(math.random(1, ft.capacity/10000)*1000, ft.level, targetFreeSpace);
							self:setFillLevel(n, -delta, 0);
							target:setFillLevel(n, delta, 0);
							totalPrice = totalPrice + price*delta;
							transportPrice = transportPrice + Economica.autoOutputPricePerCube*delta;
						end;
					end;
				end;
			end;
			if totalPrice > 0 then
				g_currentMission:addSharedMoney(totalPrice, "harvestIncome");
				g_currentMission:addMoneyChange(totalPrice, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_harvestIncome"));
			end;
			if transportPrice > 0 then
				g_currentMission:addSharedMoney(-transportPrice, "wagePayment");
				g_currentMission:addMoneyChange(-transportPrice, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_wagePayment"));
			end;
		elseif not self.enableIfOwned then
			if self.transportStation then
				if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMCARGODELTA] and self.cargoFillTypes == nil then
					for _,ft in pairs(self.fillType) do
						if ft.priceDelta == 1 and not ft.extraMission then
							local delta = math.random(0, ft.capacity/20);
							if ft.outputFillType then
								ft.level = math.max(ft.level - delta, 0);
							elseif ft.inputFillType then
								ft.level = math.min(ft.level + delta, ft.capacity);
							end;
						end;
					end;
				end;
			elseif not UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMCARGODELTA] then
				for _,ft in pairs(self.fillType) do
					if ft.priceDelta == 1 and not ft.extraMission then
						local delta = math.random(1, ft.capacity/10000)*1000;
						if ft.inputFillType then
							ft.level = math.max(ft.level - delta, 0);
						elseif ft.outputFillType then
							local capacity = ft.capacity;
							if ft.rent then
								capacity = capacity/2;
							end;
							ft.level = math.min(ft.level + delta, capacity);
						end;
					end;
				end;
			else
				for _,ft in pairs(self.fillType) do
					if ft.curve then
						ft.minuteToChange = math.random(1, 20);
					end;
				end;
			end;
		end;
		self:heapsMoving();
		self:raiseDirtyFlags(self.UniversalFactoryDirtyFlag);
	end;
end;

function UniversalFactory:minuteChanged()
	if not self.isOwned then
		local recheckJobStreams = false;
		for i=1, #self.jobStreams do
			local jobStream = self.jobStreams[i];
			if jobStream.rentTimer > 0 then
				jobStream.rentTimer = jobStream.rentTimer - 1;
				if jobStream.rentTimer == 0 then
					self:setRentState(i, false);
					recheckJobStreams = true;
				end;
			end;
		end;
		if recheckJobStreams then
			for i=1, #self.jobStreams do
				local jobStream = self.jobStreams[i];
				if jobStream.rentTimer > 0 then
					self:setRentState(i, true);
				end;
			end;
		end;
		if self.isServer then
			if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMCARGODELTA] then
				if self.isEnabled and not self.isWarehouse and not self.transportStation and not self.enableIfOwned then
					for _,ft in pairs(self.fillType) do
						if ft.curve and ft.minuteToChange and ft.minuteToChange == g_currentMission.environment.currentMinute then
							if ft.priceDelta == 1 and not ft.extraMission then
								local realPercent = ft.level/ft.capacity;
								local rentPercent = Utils.getNoNil(ft.rentLevel, 0)/ft.capacity;
								local percent = Economica.fillLevelCurves[ft.curve][g_currentMission.environment.currentHour];
								if percent then
									percent = Utils.clamp(realPercent - math.random(10, 20)*0.01, percent, 1-rentPercent);
									if ft.rent then
										percent = math.min(percent, 0.5);
									end;
									ft.level = ft.capacity*percent;
									self:heapsMoving();
									self.enableUpdateClients = true;
								end;
							end;
						end;
					end;
				end;
			end;
			for n,fillType in pairs(self.fillType) do
				if fillType.rentLevel > 0 then
					self.rentCosts = self.rentCosts + fillType.rentLevel*Economica.rentPrice*Utils.getNoNil(Economica.rentCoeffs[n], 1);
				end;
			end;
		end;
	end;
end;

function UniversalFactory:setFillLevel(index, delta, rentDelta)
	local fillType = self.fillType[index];
	if fillType then
		fillType.level = fillType.level + delta;
		fillType.rentLevel = fillType.rentLevel + rentDelta;
	end;
end;

function UniversalFactory:fillTypePayment(index, statName, delta, moneyChange, text)
	if not self.isWarehouse then
		local fillType = self.fillType[index];
		local priceMultiplier = Utils.getNoNil(fillType.priceMultiplier, 1);
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
		local money = FillUtil.fillTypeIndexToDesc[index].pricePerLiter*priceMultiplier*fillType.priceDelta*difficultyMultiplier*delta;
		g_currentMission:addSharedMoney(money, statName);
		if moneyChange then
			g_currentMission:addMoneyChange(money, self.moneyChangeId);
			self.lastMoneyChange = 30;
			self.lastMoneyChangeText = text;
		else
			g_currentMission:addMoneyChange(money, FSBaseMission.MONEY_TYPE_SINGLE, true, text);
		end;
	end;
end;

function UniversalFactory:setRentState(numJobStream, state)
	local jobStream = self.jobStreams[numJobStream];
	if jobStream.rentObject then
		setVisibility(jobStream.rentObject.trigger, not state);
	end;
	for i=1, #jobStream.inputFillTypes do
		local index = jobStream.inputFillTypes[i];
		if FillUtil.fillTypeIndexToDesc[index] and self.fillType[index] then
			self.fillType[index].rent = state;
		end;
	end;
	for i=1, #jobStream.outputFillTypes do
		local index = jobStream.outputFillTypes[i];
		if FillUtil.fillTypeIndexToDesc[index] and self.fillType[index] then
			self.fillType[index].rent = state;
		end;
	end;
end;

function UniversalFactory:rentPayment(numJobStream, hours, price)
	g_currentMission:addSharedMoney(-price, "other");
	g_currentMission:addMoneyChange(-price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("rent"));
	self.jobStreams[numJobStream].rentTimer = hours*60;
	self:setRentState(numJobStream, true);
end;

function UniversalFactory:getFreeSpace(index)
	local fillType = self.fillType[index];
	if fillType.rent then
		return fillType.capacity - fillType.level - fillType.rentLevel;
	end;
	return fillType.capacity - fillType.level;
end;

function UniversalFactory:getFillTypeWithMinLevel()
	local zeroFillTypes = {};
	local percent = 1;
	local fillTypeIndex = 0;
	for index, fillType in pairs(self.fillType) do
		if (FillUtil.fillTypeIndexToDesc[index].showOnPriceTable or num == FillUtil.FILLTYPE_MILK) and Economica.acceptedFillTypes[index]
		and fillType.inputFillType and fillType.priceDelta == 1 and not fillType.extraMission and not fillType.contract
		and not fillType.autoInput and not fillType.rent then
			if self:getFreeSpace(index) == fillType.capacity then
				table.insert(zeroFillTypes, index);
			else
				local fillTypePercent = (fillType.level + Utils.getNoNil(fillType.rentLevel, 0))/fillType.capacity;
				if fillTypePercent < percent then
					percent = fillTypePercent;
					fillTypeIndex = index;
				end;
			end;
		end;
	end;
	if #zeroFillTypes > 0 then
		fillTypeIndex = zeroFillTypes[math.random(1, #zeroFillTypes)];
	end;
	return fillTypeIndex;
end;

function UniversalFactory:setRentTriggerVisibility(state)
	if #self.jobStreamObjects > 0 then
		for i=1, #self.jobStreamObjects do
			setVisibility(self.jobStreamObjects[i].trigger, state);
		end;
	end;
end;

function UniversalFactory:setRentFillTypes(state)
	if self.isWarehouse then
		for _, fillType in pairs(self.fillType) do
			fillType.rent = state;
		end;
	end;
end;

function UniversalFactory:updateTick(dt)
end;

g_onCreateUtil.addOnCreateFunction("UniversalFactory", UniversalFactory.onCreate);
