--author: igor29381

HelpStrings = {};
function HelpStrings.onCreate(id)
	UniversalFactoryHUD.helpStringsRootNode = id;
	UniversalFactoryHUD.helpStrings = {};
	for i=1, getNumOfChildren(id) do
		local child = getChildAt(id, i-1);
		table.insert(UniversalFactoryHUD.helpStrings, child);
	end;
end;
g_onCreateUtil.addOnCreateFunction("HelpStrings", HelpStrings.onCreate);

function FieldDefinition:onCreate(id)
	local fieldDefinition = FieldDefinition:new(id);
	g_currentMission:addNonUpdateable(fieldDefinition);
	g_currentMission.fieldDefinitionBase = fieldDefinition;
	g_currentMission.defaultFieldOwnershipMapWidth = 4096;
	g_currentMission.defaultFieldOwnershipMapHeight = 4096;
end;

UniversalFactoryHUD = {};
UniversalFactoryHUD.SET_RANDOMCARGODELTA = 1;
UniversalFactoryHUD.SET_RANDOMEVENTS = 2;
UniversalFactoryHUD.SET_RANDOMEXTRAMISSION = 3;
UniversalFactoryHUD.SET_SHOWEXTRAMISSIONHUD = 4;
UniversalFactoryHUD.SET_CONTRACTS = 5;
UniversalFactoryHUD.SET_SHOWCONTRACTSHUD = 6;
UniversalFactoryHUD.SET_DIRTCONTROL = 7;
UniversalFactoryHUD.SET_HELPSTRINGS = 8;
UniversalFactoryHUD.SET_BIGFILLTYPEOVERLAY = 9;
UniversalFactoryHUD.SET_CUTFRUITSBYWHEELS = 10;
UniversalFactoryHUD.SET_SHOWPALLETINFO = 11;
UniversalFactoryHUD.SET_GARBAGEDELETEMODE = 12;
UniversalFactoryHUD.SET_COINSEARCHMODE = 13;
UniversalFactoryHUD.SET_TARGETHOLE = 14;
UniversalFactoryHUD.SET_EGGAUTOPICKUP = 15;
UniversalFactoryHUD.SET_FLIGHTDIALOG = 16;
UniversalFactoryHUD.SET_FIELDJOBREWARD = 17;
UniversalFactoryHUD.SET_FONTSIZE = 18;

function UniversalFactoryHUD:dayChanged()
	if g_server then
		local totalCosts = 0;
		local rentCosts = 0;
		Economica:setRandomCurve();
		for i=1, #UniversalFactory.all do
			local factory = UniversalFactory.all[i];
			if factory.isOwned then
				totalCosts = totalCosts + factory.dayCosts;
			elseif factory.rentCosts > 0 then
				rentCosts = rentCosts + factory.rentCosts;
				factory.rentCosts = 0;
			end;
		end;
		if totalCosts > 0 then
			g_currentMission:addSharedMoney(-totalCosts, "propertyMaintenance");
			g_currentMission:addMoneyChange(-totalCosts, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_propertyMaintenance"));
		end;
		if rentCosts > 0 then
			g_currentMission:addSharedMoney(-rentCosts, "other");
			g_currentMission:addMoneyChange(-rentCosts, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("rent"));
		end;
		totalCosts = 0;
		for i=1, #Garage.main.garages do
			local garage = Garage.main.garages[i];
			if garage.isOwned then
				for num=1, #garage.garageTriggers do
					local trigger = garage.garageTriggers[num];
					if trigger.storeNums and #trigger.storeNums > 0 then
						for ii=1, #trigger.storeNums do
							local num = trigger.storeNums[ii]
							local storeItem = StoreItemsUtil.storeItems[num];
							if storeItem then
								totalCosts = totalCosts + storeItem.dailyUpkeep;
							end;
						end;
					end;
				end;
			end;
		end;
		g_currentMission:addSharedMoney(-totalCosts, "vehicleRunningCost");
		g_currentMission:addMoneyChange(-totalCosts, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_vehicleRunningCost"));
		for _,carWashId in pairs(DirtyTrigger.carWash) do
			local carWash = g_currentMission.onCreateLoadedObjects[carWashId];
			if carWash then
				if carWash.price > 0 and carWash.isOwned then
					local money = math.random(100, 1000);
					g_currentMission:addSharedMoney(money, "other");
				end;
			end;
		end;
		if #g_currentMission.fieldDefinitionBase.unownedFields > 0 then
			Economica.airSprayerHour = math.random(5, 20);
		end;
		Economica:setRains();
	end;
	if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_CONTRACTS] then
		for i=1, #Economica.contracts do
			local contract = Economica.contracts[i];
			if contract then
				local shop = UniversalFactory.all[contract.numShop];
				if contract.active then
					local currentHour = (g_currentMission.environment.currentDay-1)*24 + g_currentMission.environment.currentHour;
					contract.duration = math.max(contract.endHour - currentHour, 0);
				end;
			end;
		end;
	end;
end;

function UniversalFactoryHUD:loadMap(name)
	self.factoryNames = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/factoryNames.dds");
	self.stringHUD = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/string.dds");
	setOverlayColor(self.stringHUD, 0.5, 0.5, 0.5, 0.5);
	self.buttonM = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/buttonM.dds");
	self.buttonX = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/buttonX.dds");
	self.buttonD = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/buttonD.dds");
	self.buttonP = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/buttonP.dds");
	self.buttonW = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/buttonW.dds");
	self.greyButton = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/greyButton.dds");
	self.types = {"Factories", "Shops", "Warehouses", "category_animals"};
	self.labelText = {g_i18n:getText("buying"), g_i18n:getText("selling"), g_i18n:getText("rent")};
	self.startPoint = {};
	self.startPoint.x = 0.05;
	self.startPoint.y = 0.75;
	self.active = false;
	self.showCursor = false;
	self.allFactories = false;
	self.moveable = false;
	self.percentMode = false;
	self.settingsMode = false;
	self.fillTypeMode = 0;
	self.autoOutputSelection = 0;
	self.settingsNames = {	"randomCargoDelta", "randomEvents", "extraMission",
							"showExtraMissionHUD", "contracts", "showContractsHUD",
							"dirtControl", 	"helpStrings", "bigFillTypeOverlay",
							"cutFruitsByWheels", "showPalletInfo", "garbageDeleteMode",
							"coinSearchMode", "targetHole", "eggAutoPickUp", "flightDialog", "fieldJobReward", "fontSize"};
	self.settings = {true, true, true, true, true, true, true, true, true, true, false, false, false, true, false, true, true, 0.015};
	self.clientSettings = {false, false, false, true, false, true, false, true, true, false, true, true, true, true, false, true, false, true};
	self:setFontSize();
	self.showType = 1;
	self.incPos = {["x"]=0, ["y"]=0};
	self.factoryIndex = {1, 1, 1, 1};
	self.garageStartPos = 1;
	self.searchSound = createSample("searchSound");
	loadSample(self.searchSound, "data/sounds/reverseDrivingBeep.wav", false);
	self.searchSoundTimer = 0;
	self.foundAllGoldCoins = false;
	self.mPos={0,0,0,0};
	self.wPos={0,0,0,0};
	local function onStartMission()
		Economica:updateShops();
		if g_server then
			Economica:updateRating();
			Economica.enableAgency = g_currentMission.environment.currentHour >= 8 and g_currentMission.environment.currentHour < 18;
			for i=1, #UniversalFactory.all do
				UniversalFactory.all[i]:testWorkingHours();
			end;
			Economica:setRandomCurve();
			Economica:setRains();
		end;
		if g_currentMission.missionInfo.isNewSPCareer then
			for i=1, #UniversalFactory.all do
				local factory = UniversalFactory.all[i];
				if not factory.isOwned then
					if not factory.isWarehouse and not factory.enableIfOwned then
						for _,ft in pairs(factory.fillType) do
							if ft.curve then
								local percent = Economica.fillLevelCurves[ft.curve][g_currentMission.environment.currentHour];
								if percent then
									ft.level = ft.capacity*percent;
									factory:heapsMoving();
									factory.enableUpdateClients = true;
								end;
							end;
						end;
					end;
				elseif factory.isWarehouse then
					local fillTypeTable = {
					[FillUtil.FILLTYPE_WHEAT]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_BARLEY]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_RAPE]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_SUNFLOWER]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_SOYBEAN]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_MAIZE]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_RYE]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_POTATO]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_SUGARBEET]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_ONION]=math.random(5000, 7000),
					[FillUtil.FILLTYPE_CARROT]=math.random(5000, 7000)};
					for index,ft in pairs(factory.fillType) do
						ft.level = Utils.getNoNil(fillTypeTable[index], 0);
					end;
				end;
				factory:heapsMoving();
				factory.enableUpdateClients = true;
			end;
			for _,fieldDef in pairs(g_currentMission.fieldDefinitionBase.fieldDefs) do
				fieldDef.npcIndex = math.random(NPCUtil.startPosition, NPCUtil.NUM_NPCS);
			end;
			g_currentMission.missionInfo.isNewSPCareer = false;
		end;
		for i=1, #UniversalFactoryHUD.settings do
			UniversalFactoryHUD:onChangeSettings(i, UniversalFactoryHUD.settings[i]);
		end;
		local lowWoodPrice = 10;
		local highWoodPrice = 0;
		for i=1, #SplitUtil.splitTypes do
			local splitType = SplitUtil.splitTypes[i];
			if splitType.pricePerLiter < lowWoodPrice then
				lowWoodPrice = splitType.pricePerLiter;
			end;
			if splitType.pricePerLiter > highWoodPrice then
				highWoodPrice = splitType.pricePerLiter;
			end;
		end;
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1)*1000;
		SplitUtil.lowWoodPrice = lowWoodPrice*difficultyMultiplier;
		SplitUtil.highWoodPrice = highWoodPrice*difficultyMultiplier;
	end;
	FSBaseMission.onStartMission = Utils.appendedFunction(FSBaseMission.onStartMission, onStartMission);
	local xmlPath = "UniFactorySaves.xml";
	if g_currentMission.missionInfo.savegameDirectory then
		xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/UniFactorySaves.xml";
	end;
	if fileExists(xmlPath) then
		local xmlFile = loadXMLFile("UniFactorySaves", xmlPath);
		self.settings[self.SET_RANDOMCARGODELTA] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#randomCargoDelta"), true);
		self.settings[self.SET_RANDOMEVENTS] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#randomEvents"), true);
		self.settings[self.SET_RANDOMEXTRAMISSION] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#randomExtraMission"), true);
		self.settings[self.SET_SHOWEXTRAMISSIONHUD] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#showExtraMissionHUD"), true);
		self.settings[self.SET_CONTRACTS] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#contracts"), true);
		self.settings[self.SET_SHOWCONTRACTSHUD] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#showContractsHUD"), true);
		self.settings[self.SET_DIRTCONTROL] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#dirtControl"), true);
		self.settings[self.SET_HELPSTRINGS] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#helpStrings"), true);
		self.settings[self.SET_BIGFILLTYPEOVERLAY] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#bigFillTypeOverlay"), true);
		self.settings[self.SET_CUTFRUITSBYWHEELS] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#cutFruitsByWheels"), true);
		self.settings[self.SET_SHOWPALLETINFO] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#showPalletInfo"), false);
		self.settings[self.SET_GARBAGEDELETEMODE] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#garbageDeleteMode"), false);
		self.settings[self.SET_COINSEARCHMODE] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#coinSearchMode"), false);
		self.settings[self.SET_TARGETHOLE] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#targetHole"), true);
		self.settings[self.SET_EGGAUTOPICKUP] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#eggAutoPickUp"), false);
		self.settings[self.SET_FLIGHTDIALOG] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#flightDialog"), true);
		self.settings[self.SET_FIELDJOBREWARD] = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#fieldJobReward"), true);
		self.settings[self.SET_FONTSIZE] = Utils.clamp(Utils.getNoNil(getXMLFloat(xmlFile, "factories.settings#fontSize"), 0.015), 0.015, 0.02);
		self:setFontSize();
		self.percentMode = Utils.getNoNil(getXMLBool(xmlFile, "factories.settings#percentMode"), false);
		local posX = Utils.getNoNil(getXMLFloat(xmlFile, "factories.hudPosition#x"), 0.05);
		local posY = Utils.getNoNil(getXMLFloat(xmlFile, "factories.hudPosition#y"), 0.75);
		if posX > 0 then self.startPoint.x = posX; end;
		if posY > 0 then self.startPoint.y = posY; end;
		self.factoryIndex = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "factories.hudSelections#indexes"), "1 1 1 1"))};
		self.showType = Utils.getNoNil(getXMLInt(xmlFile, "factories.hudSelections#showType"), 1);
		delete(xmlFile);
	end;
	g_currentMission.environment:addDayChangeListener(self);
	print("UniversalFactoryHUD loaded");
end;

function UniversalFactoryHUD:deleteMap()
	UniversalFactory.Factories = {};
	UniversalFactory.Shops = {};
	UniversalFactory.Warehouses = {};
	UniversalFactory.all = {};
	UniversalFactory.category_animals = {};
	UniversalFactory.noDropMultiSiloTriggers = {};
	self.garageOverlays = nil;
	self.garageTexts = nil;
	if g_currentMission.environment then
		g_currentMission.environment:removeDayChangeListener(self);
	end;
end;

function UniversalFactoryHUD:mouseEvent(posX, posY, isDown, isUp, button)
	if self.active or self.siloTriggerMenu then
		if isDown and button == 1 then
			self.mPos[3] = posX;
			self.mPos[4] = posY;
		end;
		self.mPos[1] = posX;
		self.mPos[2] = posY;
		if self.moveable then
			self.startPoint.x = posX - self.incPos.x;
			self.startPoint.y = posY - self.incPos.y;
			if isDown and button == 1 then
				self.moveable = false;
				self.mPos[3] = 0;
				self.mPos[4] = 0;
			end;
		end;
		if button == Input.MOUSE_BUTTON_WHEEL_UP then
			self.wPos[1] = posX;
			self.wPos[2] = posY;
		elseif button == Input.MOUSE_BUTTON_WHEEL_DOWN then
			self.wPos[3] = posX;
			self.wPos[4] = posY;
		end;
	end;
	local airSprayer = TrafficManager.AirSprayer;
	if airSprayer and airSprayer.camera and airSprayer.camera.isActivated then
		airSprayer.camera:mouseEvent(posX, posY, isDown, isUp, button);
	end;
	if self.garageOverlays and #self.garageOverlays > 7 then
		if button == Input.MOUSE_BUTTON_WHEEL_UP then
			self.garageStartPos = math.max(self.garageStartPos - 0.5, 1);
		elseif button == Input.MOUSE_BUTTON_WHEEL_DOWN then
			self.garageStartPos = math.min(self.garageStartPos + 0.5, #self.garageOverlays - 6);
		end;
	end;
end;

function UniversalFactoryHUD:keyEvent(unicode, sym, modifier, isDown)
	if bitAND(modifier, Input.MOD_RSHIFT) > 0 then
		if isDown and sym == Input.KEY_slash then
			if Economica.active then
				Economica.activated = false;
				Economica:onCloseMap();
			else
				Economica.activate = true;
				Economica.action = "realtor";
				if g_server then
					Economica:updateRating();
				else
					g_client:getServerConnection():sendEvent(EconomicaRatingEvent:new(0, 0));
				end;
				Economica.callMode = true;
			end;
		end;
	elseif bitAND(modifier, Input.MOD_RCTRL) > 0 then
		if isDown and sym == Input.KEY_slash then
			if not Economica.showMessage then
				local msgNum = #Economica.messageHistory;
				if msgNum == 0 then
					g_currentMission:showBlinkingWarning(g_i18n:getText("NoMessagesFromHistory"), 3000);
				else
					Economica:showMessageFromHistory(msgNum);
				end;
			end;
		end;
	elseif isDown and sym == Input.KEY_period then
		if Economica.rating > 10 and TrafficManager.AirSprayer:getIsActivatable() then
			self.currentAirSprayer = TrafficManager.AirSprayer;
			if #self.currentAirSprayer.chemicals == 1 then
				UniversalFactoryHUD.currentChemical = 1;
			end;
			self.siloTriggerMenu = true;
			self.showCursor = true;
		end;
	elseif isDown and sym == Input.KEY_slash then
		self.showCursor = not self.showCursor;
		if self.showCursor then
			if not self.active then self.active = true; end;
		else
			unlockCameras();
		end;
	end;
end;

function inRange(X, Y, startX, incX, startY, incY)
if X > startX and X < startX+incX and Y > startY and Y < startY+incY then return true; else return false; end;
end;

function fillTypeName(fillType)
	local text = "";
	local desc = FillUtil.fillTypeIndexToDesc[fillType];
	if desc ~= nil then
		text = desc.name;
		if string.find(desc.nameI18N, "Missing") == nil then
			text = desc.nameI18N;
		end;
	end;
	return text;
end;

function timeToString(timer)
	local timeString = "00:00";
	if timer then
		local hours = math.floor(timer/60/60);
		local minutes = math.floor((timer/60)-(hours*60));
		local seconds = math.floor(timer-(hours*60*60)-(minutes*60));
		local hrs = tostring(hours)..':';
		local mins = tostring(minutes)..':';
		local sec = tostring(seconds);
		if minutes < 10 then mins = '0'..mins; end;
		if seconds < 10 then sec = '0'..sec; end;
		timeString = mins..sec;
		if hours > 0 then timeString = hrs..timeString; end;
	end;
	return timeString;
end;

function unlockCameras()
	if not (OriginalFunctions.courseplay and g_currentMission.controlledVehicle and g_currentMission.controlledVehicle.cp.mouseCursorActive) then
		InputBinding.setShowMouseCursor(false);
	end;
	if g_currentMission.player then
		g_currentMission.player.lockedInput = false;
	end;
end;

function tableToString(TABLE)
	local tableString = "";
	if TABLE and #TABLE > 0 then
		tableString = tostring(TABLE[1]);
		for i=2, #TABLE do
			tableString = string.format("%s %s", tableString, tostring(TABLE[i]));
		end;
	end;
	return tableString;
end;

function UniversalFactoryHUD:onCloseHUD()
	self.mPos={0,0,0,0};
	unlockCameras();
	self.showCursor = false;
end;

function UniversalFactoryHUD:update(dt)
	if g_gui.currentGuiName == "" then
		if (self.active and self.showCursor) or self.siloTriggerMenu or Economica.showMessage or Economica.active then
			if not g_currentMission.player.lockedInput then
				InputBinding.setShowMouseCursor(true);
				g_currentMission.player.lockedInput = true;
			end;
			terrainControl.lockCameras = true;
		else
			if g_currentMission.player.lockedInput then
				unlockCameras();
			end;
			terrainControl.lockCameras = false;
		end;
	end;
	if self.settings[self.SET_HELPSTRINGS] and not g_gui:getIsGuiVisible() and not Economica.active and not Economica.showMessage and self.helpStringsRootNode then
        local x1,y1,z1 = getWorldTranslation(getCamera());
		for i=1, #self.helpStrings do
			local point = self.helpStrings[i];
			if point then
				local x,y,z = getWorldTranslation(point);
				local dist = Utils.vector3Length(x-x1,y-y1,z-z1);
				if dist < 20 then
					local sx,sy,sz = project(x,y+0.5,z);
					if sz <= 1 and sx < 0.75 and sx > 0.25 then
						setTextAlignment(RenderText.ALIGN_CENTER);
						setTextBold(false);
						local text = getUserAttribute(point, "text");
						text = g_i18n:getText(text);
						text = Utils.splitString("@", text);
						setTextColor(1, 1, 1, 0.5);
						for i=1, #text do
							renderText(sx, sy+i*0.02, getCorrectTextSize(0.02), text[#text-i+1]);
						end;
						setTextColor(1, 1, 1, 1);
						setTextAlignment(RenderText.ALIGN_LEFT);
					end;
				end;
			end;
		end;
	end;
	if self.settings[self.SET_COINSEARCHMODE] and Economica.base and g_currentMission.player.isControlled then
		local x,y,z = getWorldTranslation(g_currentMission.player.rootNode);
		local base = Economica.base;
		if #base.goldCoins > 0 then
			for i=1, #base.goldCoins do
				if base.goldCoinStates[i] > 0 then
					local gx, gy, gz = getWorldTranslation(base.goldCoins[i].parentId);
					local distance = Utils.vector3Length(gx-x, gy-y, gz-z);
					if distance < 15 then
						self.searchSoundTimer = self.searchSoundTimer + dt;
						if self.searchSoundTimer > distance*100 then
							self.searchSoundTimer = 0;
							playSample(self.searchSound, 1, 1, 0);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function UniversalFactoryHUD:draw()
	if self.active then
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
		local fontScale = 1-(self.fontSize-0.015)*40;
		if g_screenWidth/g_screenHeight < 1.5 then
			fontScale = fontScale - 0.15;--0.86;
		end;
		renderOverlay(self.factoryNames, self.startPoint.x, self.startPoint.y-0.03, 0.25, 0.03);
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x, 0.03, self.startPoint.y-0.03, 0.03) then
			setOverlayColor(self.buttonM, 0.6, 0.6, 0.6, 1);
		end;
		renderOverlay(self.buttonM, self.startPoint.x, self.startPoint.y-0.03, 0.03, 0.03);
		setOverlayColor(self.buttonM, 0.4, 0.4, 0.4, 1);
		if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.03, self.startPoint.y-0.03, 0.03) then
			self.moveable = true;
			self.incPos.x = self.mPos[1] - self.startPoint.x;
			self.incPos.y = self.mPos[2] - self.startPoint.y;
			self.mPos={0,0,0,0};
		end;
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.03, 0.03) then
			setOverlayColor(self.buttonX, 0.6, 0.6, 0.6, 1);
			end;
		renderOverlay(self.buttonX, self.startPoint.x+0.22, self.startPoint.y-0.03, 0.03, 0.03);
		setOverlayColor(self.buttonX, 0.4, 0.4, 0.4, 1);
		if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.03, 0.03) then
			self.active = false;
			self:onCloseHUD();
			self.settingsMode = false;
		end;
		renderOverlay(self.factoryNames, self.startPoint.x, self.startPoint.y-0.06, 0.25, 0.03);
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x, 0.03, self.startPoint.y-0.06, 0.03) then
			setOverlayColor(self.buttonW, 0.6, 0.6, 0.6, 1);
		else
			setOverlayColor(self.buttonW, 0.4, 0.4, 0.4, 1);
		end;
		renderOverlay(self.buttonW, self.startPoint.x, self.startPoint.y-0.06, 0.03, 0.03);
		if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.03, self.startPoint.y-0.06, 0.03) then
			self.settingsMode = not self.settingsMode;
			self.mPos={0,0,0,0};
		end;
		local infoMode = false;
		if not self.settingsMode then
			if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.05, 0.15, self.startPoint.y-0.03, 0.03) then
				infoMode = self.showType < 4;
			end;
			if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.03, 0.05, self.startPoint.y-0.06, 0.03) then
				setTextColor(1, 1, 0, 1);
			end;
			if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.03, 0.05, self.startPoint.y-0.06, 0.03) then
				self.factoryIndex[self.showType] = self.factoryIndex[self.showType] - 1;
				if self.factoryIndex[self.showType] == 0 then
					self.factoryIndex[self.showType] = #UniversalFactory[self.types[self.showType]];
				end;
				self.fillTypeMode = 0;
				self.mPos={0,0,0,0};
			end;
			renderText(self.startPoint.x+0.04, self.startPoint.y-0.052, 0.0175, "<<");
			setTextColor(1, 1, 1, 1);
			if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.08, 0.09, self.startPoint.y-0.06, 0.03) then
				setTextColor(1, 1, 0, 1);
			end;
			if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.08, 0.09, self.startPoint.y-0.06, 0.03) then
				self.allFactories = not self.allFactories;
				self.mPos={0,0,0,0};
			end;
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(self.startPoint.x+0.125, self.startPoint.y-0.05, self.fontSize, g_i18n:getText("allFactories"));
			setTextColor(1, 1, 1, 1);
			if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.17, 0.05, self.startPoint.y-0.06, 0.03) then
				setTextColor(1, 1, 0, 1);
			end;
			if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.17, 0.05, self.startPoint.y-0.06, 0.03) then
				self.factoryIndex[self.showType] = self.factoryIndex[self.showType] + 1;
				if self.factoryIndex[self.showType] > #UniversalFactory[self.types[self.showType]] then
					self.factoryIndex[self.showType] = 1;
				end;
				self.fillTypeMode = 0;
				self.mPos={0,0,0,0};
			end;
			setTextAlignment(RenderText.ALIGN_RIGHT);
			renderText(self.startPoint.x+0.21, self.startPoint.y-0.052, 0.0175, ">>");
			setTextColor(1, 1, 1, 1);
			setTextAlignment(RenderText.ALIGN_LEFT);
			if self.percentMode then
				if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.06, 0.03) then
					setOverlayColor(self.buttonD, 0.6, 0.6, 0.6, 1);
				else
					setOverlayColor(self.buttonD, 0.4, 0.4, 0.4, 1);
				end;
				renderOverlay(self.buttonD, self.startPoint.x+0.22, self.startPoint.y-0.06, 0.03, 0.03);
				if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.06, 0.03) then
					self.percentMode = false;
					self.mPos={0,0,0,0};
				end;
			else
				if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.06, 0.03) then
					setOverlayColor(self.buttonP, 0.6, 0.6, 0.6, 1);
				else
					setOverlayColor(self.buttonP, 0.4, 0.4, 0.4, 1);
				end;
				renderOverlay(self.buttonP, self.startPoint.x+0.22, self.startPoint.y-0.06, 0.03, 0.03);
				if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.22, 0.03, self.startPoint.y-0.06, 0.03) then
					self.percentMode = true;
					self.mPos={0,0,0,0};
				end;
			end;
			setTextAlignment(RenderText.ALIGN_CENTER);
			for i=1, 4 do
				if i==self.showType then
					setOverlayColor(self.greyButton, 0.3, 0.7, 0.3, 0.5);
				else
					setOverlayColor(self.greyButton, 0.7, 0.7, 0.7, 0.5);
				end;
				renderOverlay(self.greyButton, self.startPoint.x+(i-1)*0.0625, self.startPoint.y-0.08, 0.0625, 0.02);
				setTextWidthScale(fontScale);
				renderText(self.startPoint.x+0.031+(i-1)*0.0625, self.startPoint.y-0.075, self.fontSize, g_i18n:getText(self.types[i]));
				setTextWidthScale(1);
				if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+(i-1)*0.0625, 0.0625, self.startPoint.y-0.08, 0.02) then
					self.showType = i;
					self.fillTypeMode = 0;
					self.mPos={0,0,0,0};
				end;
			end;
		end;
		setTextAlignment(RenderText.ALIGN_CENTER);
		local factory = UniversalFactory[self.types[self.showType]][self.factoryIndex[self.showType]];
		local text = "";
		if factory then
			text = factory.locationName;
		end;
		if self.fillTypeMode > 0 then text = fillTypeName(self.fillTypeMode); end;
		if self.settingsMode then text = g_i18n:getText("button_settings"); end;
		renderText(self.startPoint.x+0.125, self.startPoint.y-0.02, self.fontSize, text);
		setTextAlignment(RenderText.ALIGN_LEFT);
		local posY = 0.1;
		if self.settingsMode then
			posY = 0.08;
			for i=1, #self.settings do
				renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
				setTextWidthScale(fontScale);
				renderText(self.startPoint.x+0.01, self.startPoint.y-posY+0.005, self.fontSize, g_i18n:getText(self.settingsNames[i]));
				setTextWidthScale(1);
				local setText = g_i18n:getText("ui_off");
				if self.settings[i] then setText = g_i18n:getText("ui_on"); end;
				if i == self.SET_FONTSIZE then setText = tostring(math.ceil(self.settings[self.SET_FONTSIZE]*1000)); end;
				setTextAlignment(RenderText.ALIGN_RIGHT);
				local enableChangeSetting = true;
				if (i == self.SET_RANDOMEXTRAMISSION and #Economica.extraMissions > 0) or (i == self.SET_CONTRACTS and #Economica.contracts > 0)
				or (not g_server and not self.clientSettings[i] and not g_currentMission.isMasterUser) then
					enableChangeSetting = false;
				end;
				if enableChangeSetting then
					if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.21, 0.04, self.startPoint.y-posY, 0.02) then
						setTextColor(1, 1, 0, 1);
					end;
					if i == self.SET_FONTSIZE then
						if inRange(self.wPos[1], self.wPos[2], self.startPoint.x+0.21, 0.04, self.startPoint.y-posY, 0.02) then
							self.settings[self.SET_FONTSIZE] = math.min(self.settings[self.SET_FONTSIZE] + 0.001, 0.02);
							self:setFontSize();
							self.wPos={0,0,0,0};
						end;
						if inRange(self.wPos[3], self.wPos[4], self.startPoint.x+0.21, 0.04, self.startPoint.y-posY, 0.02) then
							self.settings[self.SET_FONTSIZE] = math.max(self.settings[self.SET_FONTSIZE] - 0.001, 0.015);
							self:setFontSize();
							self.wPos={0,0,0,0};
						end;
					else
						if inRange(self.mPos[3], self.mPos[4], self.startPoint.x+0.21, 0.04, self.startPoint.y-posY, 0.02) then
							if g_server then
								self.settings[i] = not self.settings[i];
								self:onChangeSettings(i, self.settings[i]);
								if not self.clientSettings[i] then
									g_server:broadcastEvent(UFHUDsettingsEvent:new(i, self.settings[i]));
								end;
							else
								if self.clientSettings[i] then
									self.settings[i] = not self.settings[i];
									self:onChangeSettings(i, self.settings[i]);
								else
									g_client:getServerConnection():sendEvent(UFHUDsettingsEvent:new(i, self.settings[i]));
								end;
							end;
							self.mPos={0,0,0,0};
						end;
					end;
				end;
				renderText(self.startPoint.x+0.245, self.startPoint.y-posY+0.005, self.fontSize, setText);
				setTextColor(1, 1, 1, 1);
				setTextAlignment(RenderText.ALIGN_LEFT);
				posY = posY + 0.02;
			end;
		else
			if self.allFactories then
				for i=1, #UniversalFactory[self.types[self.showType]] do
					renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
					if inRange(self.mPos[1], self.mPos[2], self.startPoint.x, 0.25, self.startPoint.y-posY, 0.02) then
						setTextColor(1, 1, 0, 1);
					end;
					local text = UniversalFactory[self.types[self.showType]][i].locationName;
					renderText(self.startPoint.x+0.01, self.startPoint.y-posY+0.005, self.fontSize, text);
					setTextColor(1, 1, 1, 1);
					if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.25, self.startPoint.y-posY, 0.02) then
						self.factoryIndex[self.showType] = i;
						self.allFactories = false;
						self.fillTypeMode = 0;
						self.mPos={0,0,0,0};
					end;
					posY = posY + 0.02;
				end;
			elseif self.fillTypeMode > 0 then
				local enableBuying = false;
				local enableSelling = false;
				for i=1, #Economica.shops do
					local shop = Economica.shops[i];
					if shop.fillType[self.fillTypeMode] then
						if shop.fillType[self.fillTypeMode].inputFillType then
							enableBuying = true;
						end;
						if shop.fillType[self.fillTypeMode].outputFillType then
							enableSelling = true;
						end;
					end;
				end;
				local startNum = 1;
				if not enableBuying then startNum = 2; end;
				local num = 2;
				if not enableSelling then num = 1; end;
				for i=startNum, num do
					renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
					setTextAlignment(RenderText.ALIGN_CENTER);
					renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, self.labelText[i]);
					setTextAlignment(RenderText.ALIGN_LEFT);
					posY = posY + 0.02;
					for ii=1, #Economica.shops do
						local shop = Economica.shops[ii];
						local fillType = shop.fillType[self.fillTypeMode];
						if fillType then
							if (fillType.inputFillType and i==1) or (fillType.outputFillType and i==2) then
								self:showValues(self.fillTypeMode, shop.factoryName, self:getFillTypePrice(self.fillTypeMode, shop.factoryName), posY);
								posY = posY + 0.02;
							end;
						end;
					end;
				end;
			elseif factory then
				setTextColor(1, 1, 1, 1);
				if infoMode then
					if self.showType == 1 then
						for i=1, 6 do
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
							posY = posY + 0.02;
						end;
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.095, self.fontSize, g_i18n:getText("productivity"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.115, self.fontSize, g_i18n:getText("maintainingCosts"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.135, self.fontSize, g_i18n:getText("dayCosts"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.155, self.fontSize, g_i18n:getText("nightCosts"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.175, self.fontSize, g_i18n:getText("workingHours"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.195, self.fontSize, g_i18n:getText("state"));
						setTextAlignment(RenderText.ALIGN_RIGHT);
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.095, self.fontSize, tostring(math.ceil(factory.jobLitersPerSecond*60*60)));
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.115, self.fontSize, tostring(math.ceil(factory.dayCosts)));
						local costs = "-";
						local nightCosts = "-";
						if factory.costsPerSecond then
							local costsPerSecond = factory.costsPerSecond*60*60;
							costs = tostring(math.ceil(costsPerSecond));
							nightCosts = tostring(math.ceil(costsPerSecond*factory.nightCosts));
						end;
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.135, self.fontSize, costs);
						local hours = g_i18n:getText("daylong");
						if factory.workingHours and factory.workingHours[1] and factory.workingHours[2] then
							hours = string.format("%s-%s", factory.workingHours[1], factory.workingHours[2]);
							if factory.workingHours[1] > 6 and factory.workingHours[2] < 20 then
								nightCosts = "-";
							end;
						end;
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.155, self.fontSize, nightCosts);
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.175, self.fontSize, hours);
						local state = g_i18n:getText("working");
						if not factory.isEnabled then state = g_i18n:getText("shuted"); end;
						if factory.repairTimer > 0 then
							state = string.format("%s, %s", g_i18n:getText("repair"), string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), factory.repairTimer));
						end;
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.195, self.fontSize, state);
						setTextAlignment(RenderText.ALIGN_LEFT);
					elseif self.showType == 2 then
						for i=1, 2 do
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
							posY = posY + 0.02;
						end;
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.095, self.fontSize, g_i18n:getText("workingHours"));
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.115, self.fontSize, g_i18n:getText("state"));
						setTextAlignment(RenderText.ALIGN_RIGHT);
						local hours = g_i18n:getText("daylong");
						if factory.workingHours and factory.workingHours[1] and factory.workingHours[2] then
							hours = string.format("%s-%s", factory.workingHours[1], factory.workingHours[2]);
						end;
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.095, self.fontSize, hours);
						local state = g_i18n:getText("working");
						if not factory.isEnabled then state = g_i18n:getText("shuted"); end;
						if factory.repairTimer > 0 then
							state = string.format("%s, %s", g_i18n:getText("repair"), string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), factory.repairTimer));
						end;
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.115, self.fontSize, state);
						setTextAlignment(RenderText.ALIGN_LEFT);
					elseif self.showType == 3 and factory.repairTimer > 0 then
						renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
						renderText(self.startPoint.x+0.005, self.startPoint.y-0.095, self.fontSize, g_i18n:getText("state"));
						setTextAlignment(RenderText.ALIGN_RIGHT);
						local state = string.format("%s, %s", g_i18n:getText("repair"), string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), factory.repairTimer));
						renderText(self.startPoint.x+0.245, self.startPoint.y-0.095, self.fontSize, state);
						setTextAlignment(RenderText.ALIGN_LEFT);
					end;
					for i=1, #factory.jobStreams do
						jobStream = factory.jobStreams[i];
						if jobStream.rentTimer > 0 and jobStream.rentText then
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
							local text = string.format("%s %d %s", jobStream.rentText, math.ceil(jobStream.rentTimer/60), g_i18n:getText("shortHour"));
							renderText(self.startPoint.x+0.005, self.startPoint.y-posY+0.005, self.fontSize, text);
							posY = posY + 0.02;
						end;
					end;
					if factory.rentCosts > 0 then
						renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
						renderText(self.startPoint.x+0.005, self.startPoint.y-posY+0.005, self.fontSize, g_i18n:getText("rentCosts"));
						setTextAlignment(RenderText.ALIGN_RIGHT);
						renderText(self.startPoint.x+0.245, self.startPoint.y-posY+0.005, self.fontSize, string.format("%d%s", factory.rentCosts, Economica.currencySymbol));
						setTextAlignment(RenderText.ALIGN_LEFT);
						posY = posY + 0.02;
					end;
					if factory.description then
						if self.RailRoad and factory.factoryName == "railRoadStation" then
							if self.RailRoad.trainOnTrack then
								setOverlayColor(self.stringHUD, 0.7, 0.3, 0.3, 0.5);
							else
								setOverlayColor(self.stringHUD, 0.3, 0.7, 0.3, 0.5);
							end;
						end;
						renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY+0.02-0.015*factory.descLenght, 0.25, 0.015*factory.descLenght);
						renderText(self.startPoint.x+0.005, self.startPoint.y-posY+0.005, self.fontSize, factory.description);
						setOverlayColor(self.stringHUD, 0.5, 0.5, 0.5, 0.5);
					end;
				else
					if self.showType == 1 then
						if factory.isOwned or factory.enableIfOwned then
							for i=1, #factory.jobStreams do
								local FillTypes = factory.jobStreams[i].inputFillTypes;
								local lineText = string.format("%s%d: %s", g_i18n:getText("line"), i, g_i18n:getText("inputFillTypes"));
								for c=1, 2 do
									renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
									setTextAlignment(RenderText.ALIGN_CENTER);
									renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, lineText);
									setTextAlignment(RenderText.ALIGN_LEFT);
									posY = posY + 0.02;
									for a=1, #FillTypes do
										local fillType = factory.fillType[FillTypes[a]];
										self:showValues(FillTypes[a], factory.factoryName, 0, posY);
										posY = posY + 0.02;
									end;
									FillTypes = factory.jobStreams[i].outputFillTypes;
									lineText = string.format("%s%d: %s", g_i18n:getText("line"), i, g_i18n:getText("outputFillTypes"));
								end;
								if factory.isOwned then
									local text = g_i18n:getText("startJob");
									if factory.jobStreams[i].isActivated then
										setOverlayColor(self.greyButton, 0.7, 0.7, 0.3, 0.5);
										text = g_i18n:getText("stopJob");
										if factory.jobStreams[i].isWorking then
											setOverlayColor(self.greyButton, 0.3, 0.7, 0.3, 0.5);
										end;
									else
										setOverlayColor(self.greyButton, 0.7, 0.3, 0.3, 0.5);
									end;
									if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.25, self.startPoint.y-posY, 0.02) then
										if g_server ~= nil then
											factory:changeJobStreamState(i);
										else
											g_client:getServerConnection():sendEvent(UniFactoryHUDEvent:new(i, false, false, 0, 0, factory));
										end;
										self.mPos={0,0,0,0};
									end;
									renderOverlay(self.greyButton, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
									setTextAlignment(RenderText.ALIGN_CENTER);
									renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, text);
									setTextAlignment(RenderText.ALIGN_LEFT);
									posY = posY + 0.02;
								end;
							end;
						end;
					end;
					if self.showType == 2 or (self.showType == 1 and not factory.isOwned and not factory.enableIfOwned) then
						for i=1, 2 do
							if #factory.fillTypesToPut[i] > 0 then
								renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
								setTextAlignment(RenderText.ALIGN_CENTER);
								renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, self.labelText[i]);
								setTextAlignment(RenderText.ALIGN_LEFT);
								posY = posY + 0.02;
								for n=1, #factory.fillTypesToPut[i] do
									local fillType = factory.fillTypesToPut[i][n];
									self:showValues(fillType.index, factory.factoryName, self:getFillTypePrice(fillType.index, factory.factoryName), posY);
									posY = posY + 0.02;
								end;
							end;
						end;
						local rentFillTypes = false;
						for _,ft in pairs(factory.fillType) do
							if ft.rentLevel > 0 or ft.rent then
								rentFillTypes = true;
								break;
							end;
						end;
						if rentFillTypes then
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
							setTextAlignment(RenderText.ALIGN_CENTER);
							renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, self.labelText[3]);
							setTextAlignment(RenderText.ALIGN_LEFT);
							posY = posY + 0.02;
							for n,ft in pairs(factory.fillType) do
								if ft.rentLevel > 0 or ft.rent then
									self:showValues(n, factory.factoryName, 0, posY, true);
									posY = posY + 0.02;
								end;
							end;
						end;
					end;
					if self.showType == 3 then
						if not factory.isOwned then
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
							setTextAlignment(RenderText.ALIGN_CENTER);
							renderText(self.startPoint.x+0.125, self.startPoint.y-posY+0.005, self.fontSize, self.labelText[3]);
							setTextAlignment(RenderText.ALIGN_LEFT);
							posY = posY + 0.02;
						end;
						for n,_ in pairs(factory.fillType) do
							self:showValues(n, factory.factoryName, 0, posY, not factory.isOwned);
							posY = posY + 0.02;
						end;
					end;
					if self.showType == 4 then
						local husbandry = factory.husbandry;
						local husbandryText = string.format("%s: %d", g_i18n:getText("statistic_"..husbandry.typeName.."Owned"), husbandry.totalNumAnimals);
						self:showHusbandryInfo(husbandryText, nil, nil, posY);
						posY = posY + 0.02;
						husbandryText = string.format("%s: %d%%", g_i18n:getText("statistic_productivity"), husbandry.productivity*100);
						self:showHusbandryInfo(husbandryText, nil, nil, posY);
						posY = posY + 0.02;
						if husbandry.animalDesc.birthRatePerDay > 0 then
							local reprText1, reprText2 = string.format("--:--h"), string.format("--:--h");
							if husbandry.reproductionRatePerDay ~= 0 then
								local reproMins = (1.0 / husbandry.reproductionRatePerDay) * 24 * 60;
								local hours = math.floor(reproMins / 60);
								local mins = reproMins - (hours*60);
								reprText1 = string.format("%02d:%02dh", hours, mins);
								local timeMissing = math.max(0, 1.0 - husbandry.newAnimalPercentage) * reproMins;
								hours = math.floor(timeMissing / 60);
								mins = timeMissing - (hours*60);
								reprText2 = string.format("%02d:%02dh", hours, mins);
							end;
							husbandryText = string.format("%s: %s", g_i18n:getText("statistic_reproductionRate"), reprText1);
							self:showHusbandryInfo(husbandryText, nil, nil, posY);
							posY = posY + 0.02;
							husbandryText = string.format("%s: %s", g_i18n:getText("statistic_timeTillNextAnimal"), reprText2);
							self:showHusbandryInfo(husbandryText, nil, nil, posY);
							posY = posY + 0.02;
						end;
						if husbandry.animalDesc.dirtFillLevelPerDay > 0 then
							local text = "-";
							if husbandry.totalNumAnimals > 0 then
								text=string.format("%d", math.floor(husbandry.cleanlinessFactor*100));
							end;
							self:showHusbandryInfo(g_i18n:getText("statistic_cleanliness").." [%] "..text, nil, nil, posY);
							posY = posY + 0.02;
						end;
						for _,fillType in pairs({FillUtil.FILLTYPE_LIQUIDMANURE, FillUtil.FILLTYPE_MANURE, FillUtil.FILLTYPE_MILK, FillUtil.FILLTYPE_WOOL}) do
							if factory.fillType[fillType] then
								self:showValues(fillType, factory.factoryName, 0, posY);
								posY = posY + 0.02;
							end;
						end;
						if husbandry.numActivePickupObjects then
							husbandryText = string.format("%s: %d", g_i18n:getText("fillType_egg"), husbandry.numActivePickupObjects);
							self:showHusbandryInfo(husbandryText, nil, nil, posY);
							posY = posY + 0.02;
							husbandryText = string.format("%s: %d", g_i18n:getText("statistic_eggsCarrying"), g_currentMission:getNumPickupObjects(FillUtil.FILLTYPE_EGG));
							self:showHusbandryInfo(husbandryText, nil, nil, posY);
							posY = posY + 0.02;
						end;
						if husbandry.tipTriggersFillLevels[FillUtil.FILLTYPE_WATER] ~= nil then
							self:showHusbandryInfo(g_i18n:getText("statistic_water"), husbandry:getFillLevel(FillUtil.FILLTYPE_WATER), husbandry:getCapacity(FillUtil.FILLTYPE_WATER), posY);
							posY = posY + 0.02;
						end;
						if husbandry.tipTriggersFillLevels[FillUtil.FILLTYPE_STRAW] ~= nil then
							self:showHusbandryInfo(g_i18n:getText("statistic_strawStorage"), husbandry:getFillLevel(FillUtil.FILLTYPE_STRAW), husbandry:getCapacity(FillUtil.FILLTYPE_STRAW), posY);
							posY = posY + 0.02;
						end;
						if husbandry.animalDesc.foodPerDay > 0 and FillUtil.foodGroups[husbandry.animalDesc.index] then
							for _,foodGroup in pairs(FillUtil.foodGroups[husbandry.animalDesc.index]) do
								self:showHusbandryInfo(AnimalHusbandry:getFillTypesString(foodGroup.fillTypes), husbandry:getAvailableAmountOfFillTypes(foodGroup.fillTypes), husbandry:getCapacity(nil, foodGroup), posY);
								posY = posY + 0.02;
							end;
						end;
					end;
					posY = posY - 0.02;
					setTextAlignment(RenderText.ALIGN_CENTER);
					if self.settings[self.SET_SHOWEXTRAMISSIONHUD] then
						if #Economica.extraMissions > 0 and Economica.extraMissions[1].active then
							local mission = Economica.extraMissions[1];
							renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY-0.048, 0.25, 0.048);
							renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.015, self.fontSize, g_i18n:getText("extraMission"));
							local level = UniversalFactory[mission.shopName].fillType[mission.fillType].extraMissionLevel;
							local text = g_i18n:getText(mission.shopName)..": "..fillTypeName(mission.fillType).." "..
							tostring(math.ceil(level)).."/"..tostring(math.ceil(mission.volume));
							renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.03, self.fontSize, text);
							if mission.duration < 60 then
								setTextColor(1, 0, 0, 1);
							end;
							renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.045, self.fontSize, timeToString(mission.duration));
							setTextColor(1, 1, 1, 1);
							posY = posY + 0.048;
						end;
					end;
					if self.settings[self.SET_SHOWCONTRACTSHUD] then
						for i=1, #Economica.contracts do
							local contract = Economica.contracts[i];
							if contract.active or contract.postponed then
								local level = UniversalFactory.all[contract.numShop].fillType[contract.fillType].contractLevel;
								local text = string.format("%d/%d", level, contract.volume);
								local label = g_i18n:getText("contract");
								local duration = contract.duration;
								if contract.postponed then
									setOverlayColor(self.stringHUD, 0.9, 0.9, 0.1, 1);
									text = "";
									label = g_i18n:getText("contract_putOff");
									duration = contract.waitInterval;
									if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.25, self.startPoint.y-posY-0.048, 0.048) then
										if g_server then
											Economica:showContractMessage(i, false, 0, true);
											g_server:broadcastEvent(EconomicaContractEvent:new(Economica.emptyContractData, i, false, 0, 0, true));
										else
											g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, 0, false, i));
										end;
										self.mPos={0,0,0,0};
									end;
								end;
								renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY-0.048, 0.25, 0.048);
								setOverlayColor(self.stringHUD, 0.5, 0.5, 0.5, 0.5);
								renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.015, self.fontSize, label);
								renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.03, self.fontSize, string.format("%s %s", contract.hudText, text));
								if duration == 1 then
									setTextColor(1, 0, 0, 1);
								end;
								renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.045, self.fontSize, string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), duration));
								setTextColor(1, 1, 1, 1);
								posY = posY + 0.048;
							end;
						end;
					end;
					if Economica.woodLicense then
						local license = Economica.woodLicense;
						renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY-0.035, 0.25, 0.035);
						renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.015, self.fontSize, g_i18n:getText("woodlicensingAgency"));
						setTextAlignment(RenderText.ALIGN_LEFT);
						if license.timer <= 2 then
							setTextColor(1, 0, 0, 1);
						end;
						renderText(self.startPoint.x+0.01, self.startPoint.y-posY-0.03, self.fontSize, string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), license.timer));
						setTextColor(1, 1, 1, 1);
						renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.03, self.fontSize, string.format("%s %d", g_i18n:getText("numTrees"), license.numTrees));
						posY = posY + 0.035;
					end;
					if self.settings[self.SET_COINSEARCHMODE] and Economica.base and g_currentMission.player.isControlled then
						renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY-0.02, 0.25, 0.02);
						setTextAlignment(RenderText.ALIGN_CENTER);
						renderText(self.startPoint.x+0.125, self.startPoint.y-posY-0.015, self.fontSize, string.format("%s %d", g_i18n:getText("numGoldCoins"), Economica.base.notFoundGoldCoins));
					end;
					setTextAlignment(RenderText.ALIGN_LEFT);
				end;
			end;
		end;
	end;
	if self.siloTriggerMenu then
		if (not self.currentSiloTrigger and not self.currentAirSprayer and self.autoOutputSelection == 0 and not self.rentObject)
		or (self.currentSiloTrigger and not self.currentSiloTrigger.siloTrailer) or Economica.showMessage then
			self.siloTriggerMenu = false;
			if not self.active or not Economica.showMessage then
				self:onCloseHUD();
			end;
		end;
	end;
	if self.siloTriggerMenu then
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
		local posY = 0.56;
		if self.currentAirSprayer then
			posY = 0.7;
		end;
		renderOverlay(self.factoryNames, 0.375, posY, 0.25, 0.03);
		if inRange(self.mPos[1], self.mPos[2], 0.595, 0.03, posY, 0.03) then
			setOverlayColor(self.buttonX, 0.6, 0.6, 0.6, 1);
		end;
		renderOverlay(self.buttonX, 0.595, posY, 0.03, 0.03);
		setOverlayColor(self.buttonX, 0.4, 0.4, 0.4, 1);
		if inRange(self.mPos[3], self.mPos[4], 0.595, 0.03, posY, 0.03) then
			self.siloTriggerMenu = false;
			self.autoOutputSelection = 0;
			self.currentAirSprayer = nil;
			self.rentObject = nil;
			self.currentChemical = nil;
			self.currentSiloTrigger = nil;
			self.baggerSiloTrigger = false;
			self:onCloseHUD();
		end;
		setTextAlignment(RenderText.ALIGN_CENTER);
		posY = posY - 0.02;
		if self.rentObject then
			renderText(0.5, posY+0.03, self.fontSize + 0.001, self.rentObject.activateText);
			setTextAlignment(RenderText.ALIGN_LEFT);
			renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
			local hours = self.rentObject.hoursAmount;
			local price = hours*self.rentObject.hourPrice;
			if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
				setTextColor(1, 1, 0, 1);
			end;
			local delta = 1;
			if self.rentObject.hoursAmount > 24 then delta = 4; end;
			if self.rentObject.hoursAmount > 72 then delta = 24; end;
			if inRange(self.wPos[1], self.wPos[2], 0.375, 0.25, posY, 0.02) then
				self.rentObject.hoursAmount = math.max(self.rentObject.hoursAmount - delta, 1);
				self.wPos={0,0,0,0};
			end;
			if inRange(self.wPos[3], self.wPos[4], 0.375, 0.25, posY, 0.02) then
				self.rentObject.hoursAmount = self.rentObject.hoursAmount + delta;
				self.wPos={0,0,0,0};
			end;
			if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
				if g_currentMission.missionStats.money < price then
					g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
				else
					if g_server then
						self.rentObject.parent:rentPayment(self.rentObject.numJobStream, self.rentObject.hoursAmount, price);
						g_server:broadcastEvent(FactoryRentEvent:new(self.rentObject.numJobStream, self.rentObject.hoursAmount, 0, self.rentObject.parent));
					elseif g_currentMission.isMasterUser then
						g_client:getServerConnection():sendEvent(FactoryRentEvent:new(self.rentObject.numJobStream, self.rentObject.hoursAmount, price, self.rentObject.parent));
					end;
				end;
				self.siloTriggerMenu = false;
				self.rentObject = nil;
				self:onCloseHUD();
			end;
			renderText(0.38, posY+0.005, self.fontSize, string.format(g_i18n:getText("rentPeriod"), hours, price, g_i18n.globalI18N:getCurrencySymbol(true)));
			setTextColor(1, 1, 1, 1);
		end;
		if self.autoOutputSelection > 0 then
			renderText(0.5, posY+0.03, self.fontSize + 0.001, g_i18n:getText("shopSelection"));
			local sourceFillType = UniversalFactory[self.sourceName].fillType[self.autoOutputSelection];
			if sourceFillType.outputNames and sourceFillType.outputNames.buying then
				renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
				renderText(0.5, posY+0.005, self.fontSize + 0.001, g_i18n:getText("buying"));
				setTextAlignment(RenderText.ALIGN_LEFT);
				posY = posY - 0.02;
				local shopNames = sourceFillType.outputNames.buying;
				for i=1, #shopNames do
					renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
					if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
						setTextColor(1, 1, 0, 1);
					end;
					local shopName = shopNames[i];
					renderText(0.48, posY+0.005, self.fontSize, string.format("%d", self:getFillTypePrice(self.autoOutputSelection, shopName)));
					local text = UniversalFactory[shopName].locationName;
					renderText(0.38, posY+0.005, self.fontSize, text);
					setTextColor(1, 1, 1, 1);
					if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
						self.siloTriggerMenu = false;
						self.mPos={0,0,0,0};
						local shopFillType = UniversalFactory[shopName].fillType[self.autoOutputSelection];
						if not shopFillType.extraMission and not shopFillType.contract then
							if g_server then
								sourceFillType.autoOutput = shopName;
								shopFillType.autoInput = true;
								g_server:broadcastEvent(AutoOutputEvent:new(self.sourceName, shopName, self.autoOutputSelection, false));
							elseif g_currentMission.isMasterUser then
								g_client:getServerConnection():sendEvent(AutoOutputEvent:new(self.sourceName, shopName, self.autoOutputSelection, false));
							end;
						end;
						self.autoOutputSelection = 0;
					end;
					posY = posY - 0.02;
				end;
			end;
			if self.autoOutputSelection > 0 and sourceFillType.outputNames and sourceFillType.outputNames.storage then
				renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(0.5, posY+0.005, self.fontSize + 0.001, g_i18n:getText("Warehouses"));
				setTextAlignment(RenderText.ALIGN_LEFT);
				posY = posY - 0.02;
				local storageNames = sourceFillType.outputNames.storage;
				for i=1, #storageNames do
					local storageName = storageNames[i];
					renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
					if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
						setTextColor(1, 1, 0, 1);
					end;
					local text = UniversalFactory[storageName].locationName;
					renderText(0.38, posY+0.005, self.fontSize, text);
					setTextColor(1, 1, 1, 1);
					if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
						self.siloTriggerMenu = false;
						self.mPos={0,0,0,0};
						local storageFillType = UniversalFactory[storageName].fillType[self.autoOutputSelection];
						if g_server then
							sourceFillType.autoOutput = storageName;
							storageFillType.autoInput = true;
							g_server:broadcastEvent(AutoOutputEvent:new(self.sourceName, storageName, self.autoOutputSelection, false));
						elseif g_currentMission.isMasterUser then
							g_client:getServerConnection():sendEvent(AutoOutputEvent:new(self.sourceName, storageName, self.autoOutputSelection, false));
						end;
						self.autoOutputSelection = 0;
					end;
					posY = posY - 0.02;
				end;
			end;
		elseif self.currentAirSprayer and self.currentChemical then
			renderText(0.5, posY+0.03, self.fontSize + 0.001, g_i18n:getText("fieldSelection"));
			setTextAlignment(RenderText.ALIGN_LEFT);
			local sprayer = self.currentAirSprayer;
			for i=1, #sprayer.splines do
				renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
				if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
					setTextColor(1, 1, 0, 1);
				end;
				local chemical = sprayer.splines[i].chemicals[self.currentChemical];
				if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
					local price = chemical.price;
					if g_currentMission.missionStats.money < price then
						g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
					else
						if g_server then
							sprayer.currentSpline = i;
							sprayer.currentChemical = self.currentChemical;
							g_server:broadcastEvent(AirSprayerEvent:new(i, self.currentChemical, sprayer));
						elseif g_currentMission.isMasterUser then
							g_client:getServerConnection():sendEvent(AirSprayerEvent:new(i, self.currentChemical, sprayer));
						end;
						if g_currentMission.missionStats.money > price + 1000 then
							Economica:showAirSprayerMessage(price, true);
						else
							Economica.airSprayerNoFlight(price);
						end;
					end;
					self.siloTriggerMenu = false;
					self.currentAirSprayer = nil;
					self.currentChemical = nil;
					self:onCloseHUD();
				end;
				if chemical then
					renderText(0.38, posY+0.005, self.fontSize, chemical.text);
				end;
				setTextColor(1, 1, 1, 1);
				posY = posY - 0.02;
			end;
		elseif self.currentAirSprayer and not self.currentChemical then
			renderText(0.5, posY+0.03, self.fontSize + 0.001, g_i18n:getText("chemicalSelection"));
			setTextAlignment(RenderText.ALIGN_LEFT);
			local sprayer = self.currentAirSprayer;
			for i=1, #sprayer.chemicals do
				local chemical = sprayer.chemicals[i];
				renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
				if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
					setTextColor(1, 1, 0, 1);
				end;
				if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
					self.currentChemical = i;
					self.mPos={0,0,0,0};
				end;
				renderText(0.38, posY+0.005, self.fontSize, chemical.label);
				setTextColor(1, 1, 1, 1);
				posY = posY - 0.02;
			end;
		elseif self.baggerSiloTrigger then
			renderText(0.5, posY+0.03, self.fontSize + 0.001, g_i18n:getText("selectBaggerFillType"));
			setTextAlignment(RenderText.ALIGN_LEFT);
			local bagger = self.currentSiloTrigger.parent;
			local trailer = self.currentSiloTrigger.siloTrailer;
			for n,_ in pairs(self.currentSiloTrigger.fillTypes) do
				renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
				if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
					setTextColor(1, 1, 0, 1);
				end;
				if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
					self.siloTriggerMenu = false;
					self.baggerSiloTrigger = false;
					self:onCloseHUD();
					if g_server then
						bagger:setCurrentFillType(n);
					else
						g_client:getServerConnection():sendEvent(BaggerEvent:new(n, bagger));
					end;
					self.currentSiloTrigger = nil;
				end;
				renderText(0.38, posY+0.005, self.fontSize, FillUtil.fillTypeIndexToDesc[n].nameI18N);
				setTextColor(1, 1, 1, 1);
				posY = posY - 0.02;
			end;
		elseif self.currentSiloTrigger then
			local factory = self.currentSiloTrigger.parent;
			local trailer = self.currentSiloTrigger.siloTrailer;
			local text = "";
			if factory then
				text = factory.locationName;
			end;
			renderText(0.5, posY+0.03, self.fontSize + 0.001, text);
			setTextAlignment(RenderText.ALIGN_LEFT);
			for n,_ in pairs(self.currentSiloTrigger.fillTypes) do
				if self:trailerAllowFillType(trailer, n) then
					renderOverlay(self.stringHUD, 0.375, posY, 0.25, 0.02);
					local fillType = factory.fillType[n];
					local level = fillType.level + Utils.getNoNil(fillType.rentLevel, 0);
					if level > 0 then
						if inRange(self.mPos[1], self.mPos[2], 0.375, 0.25, posY, 0.02) then
							setTextColor(1, 1, 0, 1);
						end;
						if inRange(self.mPos[3], self.mPos[4], 0.375, 0.25, posY, 0.02) then
							self.currentSiloTrigger:onFillTypeSelection(n);
							self.siloTriggerMenu = false;
							self:onCloseHUD();
							self.currentSiloTrigger = nil;
						end;
					end;
					renderText(0.38, posY+0.005, self.fontSize, string.format("%s %d %s", FillUtil.fillTypeIndexToDesc[n].nameI18N, level, string.format("%s.", g_i18n:getText("unit_liter"))));
					setTextColor(1, 1, 1, 1);
					posY = posY - 0.02;
				end;
			end;
		end;
	end;
	if g_currentMission.player.isControlled then
		if self.settings[self.SET_SHOWPALLETINFO] then
			local x,_,z = getWorldTranslation(g_currentMission.player.rootNode);
			if g_currentMission.itemsToSave then
				for index,item in pairs(g_currentMission.itemsToSave) do
					local pallet = item.item;
					if pallet:isa(FillablePallet) then
						local fpx, _, fpz = getWorldTranslation(pallet.nodeId);
						local Distance = Utils.vector2Length(fpx-x, fpz-z);
						if Distance < 3 then
							setTextColor(1, 1, 1, 1);
							setTextAlignment(RenderText.ALIGN_CENTER);
							renderText(0.5,0.15,self.fontSize, FillUtil.fillTypeIndexToDesc[item.item.fillType].nameI18N);
							renderText(0.5,0.13,self.fontSize, string.format("%s: %d l, %s: %d kg", g_i18n:getText("level"), item.item.fillLevel, g_i18n:getText("mass"), getMass(pallet.nodeId)*1000));
							renderText(0.5,0.09,self.fontSize, string.format("%sX - %s", g_i18n:getText("ui_key"), g_i18n:getText("button_delete")));
							setTextAlignment(RenderText.ALIGN_LEFT);
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then pallet:delete(); end;
						end;
					end;
				end;
			end;
		end;
		if self.settings[self.SET_GARBAGEDELETEMODE] and Economica.base then
			local x,_,z = getWorldTranslation(g_currentMission.player.rootNode);
			local base = Economica.base;
			if #base.garbage > 0 then
				for i=1, #base.garbage do
					if base.garbageStates[i] > 0 then
						local garbage = base.garbage[i];
						local gx, _, gz = getWorldTranslation(garbage.id);
						local distance = Utils.vector2Length(gx-x, gz-z);
						if distance < 12 then
							setTextColor(1, 1, 1, 0.5);
							setTextAlignment(RenderText.ALIGN_CENTER);
							if garbage.text then
								for i=1, #garbage.text do
									renderText(0.5, 0.09+i*0.015, self.fontSize, string.format(garbage.text[#garbage.text-i+1], garbage.price, g_i18n.globalI18N:getCurrencySymbol(true)));
								end;
							end;
							renderText(0.5, 0.09, self.fontSize, string.format("%sX - %s", g_i18n:getText("ui_key"), g_i18n:getText("button_delete")));
							setTextColor(1, 1, 1, 1);
							setTextAlignment(RenderText.ALIGN_LEFT);
							if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
								if g_currentMission.missionStats.money < garbage.price then
									g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
								else
									if g_server then
										base:removeGarbage(i);
									else
										g_client:getServerConnection():sendEvent(EconomicaGarbageEvent:new(i));
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	if self.garageOverlays then
		for i=1, math.min(7, #self.garageOverlays) do
			local position = math.floor(self.garageStartPos-1)+i;
			if self.garageOverlays[position] and self.garageTexts[position] then
				renderOverlay(self.garageOverlays[position], 0.46, 0.2 + 0.1*i, 0.08, 0.08);
				setTextColor(1, 1, 1, 1);
				setTextAlignment(RenderText.ALIGN_CENTER);
				renderText(0.5, 0.2 + 0.1*i, 0.02, self.garageTexts[position]);
				setTextAlignment(RenderText.ALIGN_LEFT);
			end;
		end;
	end;
end;

function UniversalFactoryHUD:getFillTypePrice(fillTypeInt, factoryName)
	local price = 1;
	local fillType = UniversalFactory[factoryName].fillType[fillTypeInt];
	if fillType and fillTypeInt ~= FillUtil.FILLTYPE_WOOD then
		local priceMultiplier = Utils.getNoNil(fillType.priceMultiplier, 1);
		local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
		local priceDelta = Utils.getNoNil(fillType.priceDelta, 1);
		local cube = 1000;
		if FillUtil.fillTypeIndexToDesc[fillTypeInt] then
			price = FillUtil.fillTypeIndexToDesc[fillTypeInt].pricePerLiter * priceMultiplier * priceDelta * difficultyMultiplier * cube;
		end;
	end;
	return price;
end;

function UniversalFactoryHUD:showValues(fillTypeInt, factoryName, price, posY, rent)
	local transparentText = 1;
	local factory = UniversalFactory[factoryName];
	if not factory.isEnabled then
		transparentText = 0.4;
	end;
	setTextColor(1, 1, 1, transparentText);
	if fillTypeInt > 0 and factory.fillType[fillTypeInt] then
		local fillType = factory.fillType[fillTypeInt];
		if fillType.autoOutput or fillType.autoInput then
			setOverlayColor(self.stringHUD, 0.7, 0.3, 0.3, 1);
		end;
		if fillType.priceDelta ~= 1 or fillType.extraMission then
			if not factory.isWarehouse then
				setOverlayColor(self.stringHUD, 0.9, 0.9, 0.1, 1);
			end;
		end;
		renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
		setOverlayColor(self.stringHUD, 0.5, 0.5, 0.5, 0.5);
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x, 0.1, self.startPoint.y-posY, 0.02) then
			local text = "";
			if Input.isKeyPressed(Input.KEY_lshift) and self.fillTypeMode == 0 then
				text = g_i18n:getText("samplePrices");
			elseif Input.isKeyPressed(Input.KEY_lalt) then
				if fillType.autoOutput then
					text = g_i18n:getText("autoOutputOff");
				elseif fillType.outputNames and (fillType.outputNames.buying or fillType.outputNames.storage) then
					text = g_i18n:getText("autoOutputOn");
				end;
			elseif factory.isEnabled and (fillType.pallet or fillType.bale) then
				text = g_i18n:getText("toPallet");
				if fillType.bale then
					text = g_i18n:getText("loadBale");
				end;
			end;
			if text ~= "" then
				setTextColor(1, 1, 0, 1);
				setTextAlignment(RenderText.ALIGN_LEFT);
				renderText(self.startPoint.x+0.01, self.startPoint.y-posY+0.005, self.fontSize, text);
				transparentText = 0.3;
				setTextColor(1, 1, 1, transparentText);
			end;
		end;
		if inRange(self.mPos[3], self.mPos[4], self.startPoint.x, 0.1, self.startPoint.y-posY, 0.02) then
			if Input.isKeyPressed(Input.KEY_lshift) and self.fillTypeMode == 0 then
				self.fillTypeMode = fillTypeInt;
				self.mPos={0,0,0,0};
			elseif Input.isKeyPressed(Input.KEY_lalt) then
				if fillType.autoOutput then
					if g_server then
						g_server:broadcastEvent(AutoOutputEvent:new(factoryName, fillType.autoOutput, fillTypeInt, true));
						UniversalFactory[fillType.autoOutput].fillType[fillTypeInt].autoInput = nil;
						fillType.autoOutput = nil;
					elseif g_currentMission.isMasterUser then
						g_client:getServerConnection():sendEvent(AutoOutputEvent:new(factoryName, fillType.autoOutput, fillTypeInt, true));
					end;
				elseif fillType.outputNames and (fillType.outputNames.buying or fillType.outputNames.storage) then
					self.siloTriggerMenu = true;
					self.autoOutputSelection = fillTypeInt;
					self.sourceName = factoryName;
				end;
				self.mPos={0,0,0,0};
			elseif factory.isEnabled and (fillType.pallet or fillType.bale) then
				if g_server then
					if fillType.pallet then
						factory:loadPallet(fillTypeInt);
					end;
					if fillType.bale then
						factory:loadBale(fillTypeInt);
					end;
				else
					if fillType.pallet then
						g_client:getServerConnection():sendEvent(UniFactoryHUDEvent:new(0, false, false, fillTypeInt, 0, factory));
					end;
					if fillType.bale then
						g_client:getServerConnection():sendEvent(UniFactoryHUDEvent:new(0, false, false, 0, fillTypeInt, factory));
					end;
				end;
				self.mPos={0,0,0,0};
			end;
		end;
		local name = fillTypeName(fillTypeInt);
		if self.fillTypeMode > 0 then
			name = factory.locationName;
		end;
		renderText(self.startPoint.x+0.01, self.startPoint.y-posY+0.005, self.fontSize, name);
		if price > 0 then
			if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.09, 0.04, self.startPoint.y-posY, 0.02) then
				setTextColor(1, 1, 0, 1);
				local text = g_i18n:getText("price1000l");
				if fillType.animal then
					text = g_i18n:getText("priceAnimal");
				end;
				if fillType.greatDemandDuration then
					text = string.format(g_i18n:getText("ui_greatDemandTimeRemaining"), fillType.greatDemandDuration);
				end;
				renderText(self.startPoint.x+0.11, self.startPoint.y-posY+0.005, self.fontSize, text);
				transparentText = 0.3;
				setTextColor(1, 1, 1, transparentText);
			end;
			local priceString = tostring(math.ceil(price));
			if fillTypeInt == FillUtil.FILLTYPE_WOOD then
				priceString = string.format("%d-%d", SplitUtil.lowWoodPrice*fillType.priceMultiplier, SplitUtil.highWoodPrice*fillType.priceMultiplier);
			end;
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(self.startPoint.x+0.11, self.startPoint.y-posY+0.005, self.fontSize, priceString);
			setTextAlignment(RenderText.ALIGN_LEFT);
		end;
		local level = fillType.level;
		local capacity = fillType.capacity;
		if rent then
			level = fillType.rentLevel;
			capacity = fillType.capacity - fillType.level;
		end;
		if capacity > -1 then
			self:showLevels(level, capacity, transparentText, posY);
		end;
	end;
	setTextColor(1, 1, 1, 1);
end;

function UniversalFactoryHUD:showHusbandryInfo(text, level, capacity, posY)
	renderOverlay(self.stringHUD, self.startPoint.x, self.startPoint.y-posY, 0.25, 0.02);
	renderText(self.startPoint.x+0.01, self.startPoint.y-posY+0.005, self.fontSize, text);
	if level and capacity then
		self:showLevels(level, capacity, 1, posY);
	end;
	setTextColor(1, 1, 1, 1);
end;

function UniversalFactoryHUD:showLevels(level, capacity, transparentText, posY)
	local percent = Utils.clamp(level/capacity, 0, 1);
	if self.percentMode then
		setOverlayColor(self.greyButton, 0.5, 0.5, 0.5, 0.5);
		renderOverlay(self.greyButton, self.startPoint.x+0.15, self.startPoint.y-posY, 0.1, 0.02);
		if percent <= 0.5 then
			setOverlayColor(self.greyButton, 0.6, 1-percent, 0.2, 0.5);
		else
			setOverlayColor(self.greyButton, 0+percent, 0.6, 0.2, 0.5);
		end;
		renderOverlay(self.greyButton, self.startPoint.x+0.15, self.startPoint.y-posY, percent/10, 0.02);
		setTextAlignment(RenderText.ALIGN_CENTER);
		renderText(self.startPoint.x+0.2, self.startPoint.y-posY+0.005, self.fontSize, tostring(math.ceil(percent*100)).."%");
		setTextAlignment(RenderText.ALIGN_LEFT);
	else
		if percent > 0.9 then setTextColor(1, 0, 0, transparentText); end;
		local unit = string.format("%s.", g_i18n:getText("unit_liter"));
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.15, 0.05, self.startPoint.y-posY, 0.02) then
			setTextColor(1, 1, 0, 1);
			renderText(self.startPoint.x+0.15, self.startPoint.y-posY+0.005, self.fontSize, string.format("%s, %s", g_i18n:getText("level"), unit));
			setTextColor(1, 1, 1, 0.3);
		end;
		if inRange(self.mPos[1], self.mPos[2], self.startPoint.x+0.2, 0.05, self.startPoint.y-posY, 0.02) then
			setTextColor(1, 1, 0, 1);
			renderText(self.startPoint.x+0.15, self.startPoint.y-posY+0.005, self.fontSize, string.format("%s, %s", g_i18n:getText("capacity"), unit));
			setTextColor(1, 1, 1, 0.3);
		end;
		renderText(self.startPoint.x+0.15, self.startPoint.y-posY+0.005, self.fontSize, string.format("%d", level));
		renderText(self.startPoint.x+0.2, self.startPoint.y-posY+0.005, self.fontSize, string.format("%d", capacity));
	end;
end;

function UniversalFactoryHUD:onChangeSettings(numSet, stateSet)
	if numSet == self.SET_SHOWEXTRAMISSIONHUD then
		self.showExtraMission = stateSet;
	end;
	if numSet == self.SET_HELPSTRINGS then
		if self.helpStringsRootNode then setVisibility(self.helpStringsRootNode, stateSet); end;
	end;
	if numSet == self.SET_CUTFRUITSBYWHEELS and terrainControl then
		terrainControl.cutFruitsByWheels = stateSet;
	end;
	if numSet == self.SET_TARGETHOLE then
		if stateSet then
			g_currentMission.player.pickedUpObjectAimingUVs = getNormalizedUVs({800, 360, 69, 60});
		else
			g_currentMission.player.pickedUpObjectAimingUVs = getNormalizedUVs({870, 280, 69, 60});
		end;
	end;
end;

function UniversalFactoryHUD:setFontSize()
	local fontSize = self.settings[self.SET_FONTSIZE];
	if g_screenWidth/g_screenHeight < 1.5 then
		fontSize = self.settings[self.SET_FONTSIZE]-0.003;
	end;
	self.fontSize = fontSize;
end;

function UniversalFactoryHUD:trailerAllowFillType(trailer, fillType)
	for i=1, #trailer.fillUnits do
        local fillUnit = trailer.fillUnits[i];
		if fillUnit.fillTypes[fillType] then
			return true;
		end;
	end;
	return false;
end;

function UniversalFactoryHUD:save()
	local key = "factories";
	local path = ('%ssavegame%d/'):format(tostring(getUserProfileAppPath()), g_currentMission.missionInfo.savegameIndex);
	local xmlFile = createXMLFile("UniFactorySaves", path .. "/UniFactorySaves.xml", key);
	local i = 0;
	for f=1, #UniversalFactory.all do
		local factory = UniversalFactory.all[f];
		local factoryKey = string.format(key .. ".factory(%d)", i);
		local name = factory.factoryName;
		setXMLString(xmlFile, factoryKey.."#name", name);
		if factory.jobLitersPerSecond ~= 50 then
			setXMLFloat(xmlFile, factoryKey.."#jobLitersPerSecond", factory.jobLitersPerSecond);
		end;
		if factory.repairTimer > 0 then
			setXMLInt(xmlFile, factoryKey.."#repairTimer", factory.repairTimer);
		end;
		if factory.rentCosts > 0 then
			setXMLFloat(xmlFile, factoryKey.."#rentCosts", factory.rentCosts);
		end;
		for c=1, #factory.jobStreams do
			local jobStream = factory.jobStreams[c];
			setXMLBool(xmlFile, string.format("%s#jobStream%d", factoryKey, c), jobStream.isActivated);
			if jobStream.rentTimer > 0 then
				setXMLInt(xmlFile, string.format("%s#rentTimerJobStream%d", factoryKey, c), jobStream.rentTimer);
			end;
		end;
		local ii=0;
		for k,v in pairs(factory.fillType) do
			local fillTypeKey = string.format(factoryKey .. ".resource(%d)", ii);
			setXMLString(xmlFile, fillTypeKey.."#fillType", FillUtil.fillTypeIntToName[k]);
			setXMLFloat(xmlFile, fillTypeKey.."#fillLevel", v.level);
			if v.extraMission then
				local mission = Economica.extraMissions[1];
				if mission and mission.active then
					if mission.shopName == name and mission.fillType == k then
						setXMLBool(xmlFile, fillTypeKey.."#extraMission", v.extraMission);
						setXMLFloat(xmlFile, fillTypeKey.."#extraMissionLevel", v.extraMissionLevel);
					end;
				end;
			end;
			if v.contract then
				for _,contract in pairs(Economica.contracts) do
					if contract.active and contract.numShop == factory.index and contract.fillType == k then
						setXMLBool(xmlFile, fillTypeKey.."#contract", v.contract);
						setXMLFloat(xmlFile, fillTypeKey.."#contractLevel", v.contractLevel);
					end;
				end;
			end;
			if v.rent then
				setXMLBool(xmlFile, fillTypeKey.."#rent", true);
			end;
			if v.rentLevel and v.rentLevel > 0 then
				setXMLFloat(xmlFile, fillTypeKey.."#rentLevel", v.rentLevel);
			end;
			if v.autoOutput then
				setXMLString(xmlFile, fillTypeKey.."#autoOutput", v.autoOutput);
			end;
			if v.autoInput then
				setXMLBool(xmlFile, fillTypeKey.."#autoInput", v.autoInput);
			end;
			ii = ii + 1;
		end;
		i = i + 1;
	end;
	setXMLBool(xmlFile, key..".settings#randomCargoDelta", self.settings[self.SET_RANDOMCARGODELTA]);
	setXMLBool(xmlFile, key..".settings#randomEvents", self.settings[self.SET_RANDOMEVENTS]);
	setXMLBool(xmlFile, key..".settings#randomExtraMission", self.settings[self.SET_RANDOMEXTRAMISSION]);
	setXMLBool(xmlFile, key..".settings#showExtraMissionHUD", self.settings[self.SET_SHOWEXTRAMISSIONHUD]);
	setXMLBool(xmlFile, key..".settings#contracts", self.settings[self.SET_CONTRACTS]);
	setXMLBool(xmlFile, key..".settings#showContractsHUD", self.settings[self.SET_SHOWCONTRACTSHUD]);
	setXMLBool(xmlFile, key..".settings#dirtControl", self.settings[self.SET_DIRTCONTROL]);
	setXMLBool(xmlFile, key..".settings#helpStrings", self.settings[self.SET_HELPSTRINGS]);
	setXMLBool(xmlFile, key..".settings#bigFillTypeOverlay", self.settings[self.SET_BIGFILLTYPEOVERLAY]);
	setXMLBool(xmlFile, key..".settings#cutFruitsByWheels", self.settings[self.SET_CUTFRUITSBYWHEELS]);
	setXMLBool(xmlFile, key..".settings#showPalletInfo", self.settings[self.SET_SHOWPALLETINFO]);
	setXMLBool(xmlFile, key..".settings#garbageDeleteMode", self.settings[self.SET_GARBAGEDELETEMODE]);
	setXMLBool(xmlFile, key..".settings#coinSearchMode", self.settings[self.SET_COINSEARCHMODE]);
	setXMLBool(xmlFile, key..".settings#targetHole", self.settings[self.SET_TARGETHOLE]);
	setXMLBool(xmlFile, key..".settings#eggAutoPickUp", self.settings[self.SET_EGGAUTOPICKUP]);
	setXMLBool(xmlFile, key..".settings#flightDialog", self.settings[self.SET_FLIGHTDIALOG]);
	setXMLBool(xmlFile, key..".settings#fieldJobReward", self.settings[self.SET_FIELDJOBREWARD]);
	setXMLFloat(xmlFile, key..".settings#fontSize", self.settings[self.SET_FONTSIZE]);
	setXMLBool(xmlFile, key..".settings#percentMode", self.percentMode);
	setXMLFloat(xmlFile, key .. ".hudPosition#x", self.startPoint.x);
	setXMLFloat(xmlFile, key .. ".hudPosition#y", self.startPoint.y);
	setXMLString(xmlFile, key .. ".hudSelections#indexes", tableToString(self.factoryIndex));
	setXMLInt(xmlFile, key .. ".hudSelections#showType", self.showType);
	saveXMLFile(xmlFile);
	delete(xmlFile);
end;

-------------------------------------------------------------------------------------------------

UniFactoryHUDEvent = {};
UniFactoryHUDEvent_mt = Class(UniFactoryHUDEvent, Event);

InitEventClass(UniFactoryHUDEvent, "UniFactoryHUDEvent");

function UniFactoryHUDEvent:emptyNew()
	local self = Event:new(UniFactoryHUDEvent_mt);
    return self;
end;

function UniFactoryHUDEvent:new(numJobStream, state, working, pallet, bale, factory)
	local self = UniFactoryHUDEvent:emptyNew();
	self.numJobStream = numJobStream;
	self.state = state;
	self.working = working;
	self.pallet = pallet;
	self.bale = bale;
	self.factory = factory;
	return self;
end;

function UniFactoryHUDEvent:readStream(streamId, connection)
	local numJobStream = streamReadInt8(streamId);
	local state = streamReadBool(streamId);
	local working = streamReadBool(streamId);
	local pallet = streamReadInt8(streamId);
	local bale = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local factory = networkGetObject(id);
	if factory then
		if g_server then
			if numJobStream > 0 then
				factory:changeJobStreamState(numJobStream);
			end;
			if pallet > 0 then
				factory:loadPallet(pallet);
			end;
			if bale > 0 then
				factory:loadBale(bale);
			end;
		else
			if numJobStream > 0 then
				factory.jobStreams[numJobStream].isActivated = state;
				factory.jobStreams[numJobStream].isWorking = working;
			end;
		end;
	end;
end;

function UniFactoryHUDEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numJobStream);
	streamWriteBool(streamId, self.state);
	streamWriteBool(streamId, self.working);
	streamWriteInt8(streamId, self.pallet);
	streamWriteInt8(streamId, self.bale);
	streamWriteInt32(streamId, networkGetObjectId(self.factory));
end;

-----------------------------------------------------------------------

UFHUDsettingsEvent = {};
UFHUDsettingsEvent_mt = Class(UFHUDsettingsEvent, Event);
InitEventClass(UFHUDsettingsEvent, "UFHUDsettingsEvent");

function UFHUDsettingsEvent:emptyNew()
	local self = Event:new(UFHUDsettingsEvent_mt);
    return self;
end;

function UFHUDsettingsEvent:new(numSet, stateSet)
	local self = UFHUDsettingsEvent:emptyNew();
	self.numSet = numSet;
	self.stateSet = stateSet;
	return self;
end;

function UFHUDsettingsEvent:readStream(streamId, connection)
	local numSet = streamReadInt8(streamId);
	local stateSet = streamReadBool(streamId);
	if g_server then
		UniversalFactoryHUD.settings[numSet] = not UniversalFactoryHUD.settings[numSet];
		UniversalFactoryHUD:onChangeSettings(numSet, UniversalFactoryHUD.settings[numSet]);
		g_server:broadcastEvent(UFHUDsettingsEvent:new(numSet, UniversalFactoryHUD.settings[numSet]));
	else
		UniversalFactoryHUD.settings[numSet] = stateSet;
		UniversalFactoryHUD:onChangeSettings(numSet, stateSet);
	end;
end;

function UFHUDsettingsEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numSet);
	streamWriteBool(streamId, self.stateSet);
end;

----------------------------------------------------------------------------------------------------------------

AutoOutputEvent = {};
AutoOutputEvent_mt = Class(AutoOutputEvent, Event);
InitEventClass(AutoOutputEvent, "AutoOutputEvent");

function AutoOutputEvent:emptyNew()
	local self = Event:new(AutoOutputEvent_mt);
    return self;
end;

function AutoOutputEvent:new(sourceName, shopName, fillType, stop)
	local self = AutoOutputEvent:emptyNew();
	self.sourceName = sourceName;
	self.shopName = shopName;
	self.fillType = fillType;
	self.stop = Utils.getNoNil(stop, false);
	return self;
end;

function AutoOutputEvent:readStream(streamId, connection)
	local sourceName = streamReadString(streamId);
	local shopName = streamReadString(streamId);
	local fillType = streamReadInt8(streamId);
	local stop = streamReadBool(streamId);
	if UniversalFactory[sourceName] and UniversalFactory[shopName] and FillUtil.fillTypeIndexToDesc[fillType] then
		if stop then
			if g_server then
				g_server:broadcastEvent(AutoOutputEvent:new(sourceName, shopName, fillType, true));
			end;
			UniversalFactory[sourceName].fillType[fillType].autoOutput = nil;
			UniversalFactory[shopName].fillType[fillType].autoInput = nil;
		else
			UniversalFactory[sourceName].fillType[fillType].autoOutput = shopName;
			UniversalFactory[shopName].fillType[fillType].autoInput = true;
			if g_server then
				g_server:broadcastEvent(AutoOutputEvent:new(sourceName, shopName, fillType));
			end;
		end;
	end;
end;

function AutoOutputEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.sourceName);
	streamWriteString(streamId, self.shopName);
	streamWriteInt8(streamId, self.fillType);
	streamWriteBool(streamId, self.stop);
end;
