--author: igor29381

SlideGateTrigger = {}

local SlideGateTrigger_mt = Class(SlideGateTrigger);

function SlideGateTrigger.onCreate(id)
	g_currentMission:addUpdateable(SlideGateTrigger:new(id));
end;

function SlideGateTrigger:new(triggerId)
	local self = {};
	setmetatable(self, SlideGateTrigger_mt);
	self.triggerId = triggerId;
	addTrigger(self.triggerId, "triggerCallback", self);
	local num = getNumOfChildren(triggerId);
	self.slideGates = {};
	for i = 1, num do
		local slideGate = {};
		slideGate.node = getChildAt(triggerId, i - 1);
		slideGate.startX, slideGate.startY, slideGate.startZ = getTranslation(slideGate.node);
		slideGate.endX = slideGate.startX + tonumber(Utils.getNoNil(getUserAttribute(slideGate.node, "translateX"), "0"));
		slideGate.endY = slideGate.startY + tonumber(Utils.getNoNil(getUserAttribute(slideGate.node, "translateY"), "0"));
		slideGate.endZ = slideGate.startZ + tonumber(Utils.getNoNil(getUserAttribute(slideGate.node, "translateZ"), "0"));
		slideGate.startRotX, slideGate.startRotY, slideGate.startRotZ = getRotation(slideGate.node);
		slideGate.endRotX = slideGate.startRotX + math.rad(Utils.getNoNil(getUserAttribute(slideGate.node, "rotX"), 0));
		slideGate.endRotY = slideGate.startRotY + math.rad(Utils.getNoNil(getUserAttribute(slideGate.node, "rotY"), 0));
		slideGate.endRotZ = slideGate.startRotZ + math.rad(Utils.getNoNil(getUserAttribute(slideGate.node, "rotZ"), 0));
		local sound = getChild(slideGate.node, "audio");
		if sound > 0 then
			slideGate.sound = sound;
			setVisibility(slideGate.sound, false);
		end;
		table.insert(self.slideGates, slideGate);
		if OriginalFunctions.courseplay and g_currentMission.nodeToVehicle then
			local pathVehicle = {};
			local rootNode = slideGate.node;
			if getNumOfChildren(slideGate.node) > 0 then
				rootNode = getChildAt(slideGate.node, 0);
			end;
			pathVehicle.rootNode = rootNode;
			pathVehicle.name = "gate";
			pathVehicle.sizeLength = 3;
			pathVehicle.sizeWidth = 5;
			g_currentMission.nodeToVehicle[pathVehicle.rootNode] = pathVehicle;
		end;
	end;
	self.opening = false;
	self.closing = false;
	self.pausing = false;
	self.playerLeft = false;
	self.speed = Utils.getNoNil(getUserAttribute(triggerId, "speed"), 0.0006);
	self.pauseDuration = Utils.getNoNil(getUserAttribute(triggerId, "pauseDuration"), 2000);
	self.isParentEnabled = Utils.getNoNil(getUserAttribute(triggerId, "isParentEnabled"), false);
	self.dirtControl = Utils.getNoNil(getUserAttribute(triggerId, "dirtControl"), false);
	self.pauseTime = self.pauseDuration;
	self.gatePos = 0;
	self.count = 0;
	self.isEnabled = true;
	return self;
end;

function SlideGateTrigger:delete()
	if self.triggerId then
		removeTrigger(self.triggerId);
	end;
end;

function SlideGateTrigger:update(dt)
	if self.isEnabled then
		local moving = false;
		if self.pausing then
			self.pauseTime = self.pauseTime - dt;
			if self.pauseTime <= 0 then
				self.pausing = false;
				self.closing = true;
			end;
		end;
		if self.opening then
			moving = true;
			self.gatePos = math.min(self.gatePos + self.speed * dt, 1);
			if self.gatePos == 1 then
				self.opening = false;
				for _, slideGate in pairs(self.slideGates) do
					if slideGate.sound then setVisibility(slideGate.sound, false); end;
				end;
				if self.playerLeft then
					self.pausing = true;
					self.pauseTime = self.pauseDuration;
				end;
			end;
		end;
		if self.closing then
			moving = true;
			self.gatePos = math.max(self.gatePos - self.speed * dt, 0);
			if self.gatePos == 0 then
				self.closing = false;
				for _, slideGate in pairs(self.slideGates) do
					if slideGate.sound then setVisibility(slideGate.sound, false); end;
				end;
			end;
		end;
		if moving then
			for _, slideGate in pairs(self.slideGates) do
				local x = (1 - self.gatePos) * slideGate.startX + self.gatePos * slideGate.endX;
				local y = (1 - self.gatePos) * slideGate.startY + self.gatePos * slideGate.endY;
				local z = (1 - self.gatePos) * slideGate.startZ + self.gatePos * slideGate.endZ;
				setTranslation(slideGate.node, x, y, z);
				local rx = (1 - self.gatePos) * slideGate.startRotX + self.gatePos * slideGate.endRotX;
				local ry = (1 - self.gatePos) * slideGate.startRotY + self.gatePos * slideGate.endRotY;
				local rz = (1 - self.gatePos) * slideGate.startRotZ + self.gatePos * slideGate.endRotZ;
				setRotation(slideGate.node, rx, ry, rz);
			end;
		end;
		for _, slideGate in pairs(self.slideGates) do
			if slideGate.sound then
				if moving then
					if not getVisibility(slideGate.sound) then
						setVisibility(slideGate.sound, true);
					end;
				else
					if getVisibility(slideGate.sound) then
						setVisibility(slideGate.sound, false);
					end;
				end;
			end;
		end;
	end;
end;

function SlideGateTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.parent and self.isParentEnabled then self.isEnabled = self.parent.isEnabled; end;
	if self.isEnabled then
		if onEnter then
			self.count = self.count + 1;
			if self.count == 1 then
				if self.dirtControl and UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_DIRTCONTROL] then
					local vehicle = g_currentMission.nodeToVehicle[otherId];
					local dirtControl = false;
					if vehicle then
						if vehicle.attachedImplements ~= nil then
							for i=1, #vehicle.attachedImplements do
								local object = vehicle.attachedImplements[i].object;
								if object.dirtAmount and object.dirtAmount > 0.7 then dirtControl = true; end;
								if object.attachedImplements ~= nil then
									for i=1, #object.attachedImplements do
										local object2 = object.attachedImplements[i].object;
										if object2.dirtAmount > 0.7 then dirtControl = true; end;
									end;
								end;
							end;
						end;
						if vehicle.dirtAmount > 0.7 then dirtControl = true; end;
					end;
					if dirtControl then
						g_currentMission:showBlinkingWarning(g_i18n:getText("dirtControlMessage"), 2000);
						return;
					end;
				end;
				self.playerLeft = false;
				if self.pausing then self.pausing = false; end;
				self.opening = true;
				self.closing = false;
			end;
		elseif onLeave then
			self.count = math.max(self.count - 1, 0);
			if self.count == 0 then
				self.playerLeft = true;
				if not self.opening then
					self.pausing = true;
					self.pauseTime = self.pauseDuration;
				end;
			end;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("SlideGateTrigger", SlideGateTrigger.onCreate);
