--author: igor29381

ShipTraffic = {};
ShipTraffic_mt = Class(ShipTraffic, Object);

function ShipTraffic.onCreate(id)
    local traffic = ShipTraffic:new(g_server ~= nil, g_client ~= nil);
    g_currentMission:addOnCreateLoadedObject(traffic);
	traffic:load(id);
	traffic:register(true);
end;

function ShipTraffic:new(isServer, isClient, customMt)
    if customMt == nil then customMt = ShipTraffic_mt; end;
    local self = Object:new(isServer, isClient, customMt);
	self.shipDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function ShipTraffic:load(id)
	self.splines = {};
	self.splinesRootNode = id;
	local actions = "horn lowSpeed cruiseSpeed stop";
	actions = Utils.splitString(" ", actions);
	local numChildren = getNumOfChildren(self.splinesRootNode);
	if numChildren > 0 and #TrafficManager.ships > 0 then
		self.isEnabled = true;
		for i=1, numChildren do
			local splineId = getChildAt(self.splinesRootNode, i-1);
			local spline = {};
			spline.nodeId = splineId;
			spline.length = getSplineLength(splineId);
			local numMarkers = getNumOfChildren(splineId);
			if numMarkers > 0 then
				spline.markers = {};
				for m=1, numMarkers do
					local markerId = getChildAt(splineId, m-1);
					if markerId ~= nil then
						local action = getUserAttribute(markerId, "action");
						if action then
							for a=1, #actions do
								if action == actions[a] then
									local x, _, z = getWorldTranslation(markerId);
									local marker = {["x"]=x, ["z"]=z, ["action"]=action};
									if marker.action == "stop" then
										marker.minutes = Utils.getNoNil(getUserAttribute(markerId, "minutes"), 45)*60*1000;
										marker.stationName = Utils.getNoNil(getUserAttribute(markerId, "stationName"), "Port");
									end;
									table.insert(spline.markers, marker);
									break;
								end;
							end;
						end;
					end;
				end;
			end;
			table.insert(self.splines, spline);
		end;
	end;
	self.shipOnSpline = false;
	self.shipIsStopped = false;
	self.enableHorn = false;
	self.curShip = 1;
	self.curSpline = 1;
	self.curMark = 1;
	self.hornTimer = 0;
	self.stopTimer = 0;
	self.splinePosition = 0.01;
	self.lowSpeed = 8;
	self.speed = 0;
	self.draught = 0;
	self.level = 0;
	self.limitedSpeed = 0;
	self.cruiseSpeed = 0;
	self.numBlocksToShow = 0;
	TrafficManager.shipTraffic = self;
	g_currentMission.environment:addHourChangeListener(self);
	local xmlPath = "trafficSaves.xml";
	if g_currentMission.missionInfo.savegameDirectory then
		xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/trafficSaves.xml";
	end;
	if fileExists(xmlPath) then
		local xmlFile = loadXMLFile("trafficSaves", xmlPath);
		self.shipOnSpline = getXMLBool(xmlFile, "traffic.shipTraffic#shipOnSpline");
		self.shipIsStopped = getXMLBool(xmlFile, "traffic.shipTraffic#shipIsStopped");
		self.splinePosition = getXMLFloat(xmlFile, "traffic.shipTraffic#splinePosition");
		self.draught = getXMLFloat(xmlFile, "traffic.shipTraffic#draught");
		self.level = getXMLFloat(xmlFile, "traffic.shipTraffic#level");
		self.limitedSpeed = getXMLFloat(xmlFile, "traffic.shipTraffic#limitedSpeed");
		self.stopTimer = getXMLFloat(xmlFile, "traffic.shipTraffic#stopTimer");
		self.curShip = getXMLInt(xmlFile, "traffic.shipTraffic#curShip");
		self.curSpline = getXMLInt(xmlFile, "traffic.shipTraffic#curSpline");
		self.curMark = getXMLInt(xmlFile, "traffic.shipTraffic#curMark");
		self.cruiseSpeed = getXMLInt(xmlFile, "traffic.shipTraffic#cruiseSpeed");
		self.speed = self.limitedSpeed;
		if self.shipOnSpline and self.curShip > 0 and self.curSpline > 0 and self.curMark > 0 then
			local ship = TrafficManager.ships[self.curShip];
			setVisibility(ship.Id, true);
			if not self.shipIsStopped then
				self:changeParticleSystemState(true);
			else
				local marker = self.splines[self.curSpline].markers[self.curMark];
				if marker.stationName then
					local station = UniversalFactory[marker.stationName];
					if station then
						station.cargoFillTypes = ship.cargoFillTypes;
						local numBlocksToShow = math.ceil(ship.numCargoBlocks*(self.level/ship.capacity));
						self:changeBlocksVisibility(numBlocksToShow);
					end;
				end;
			end;
		end;
		delete(xmlFile);
	end;
    return true;
end;

function ShipTraffic:delete()
	if g_currentMission.environment ~= nil then
		g_currentMission.environment:removeHourChangeListener(self);
	end;
	ShipTraffic:superClass().delete(self);
end;

function ShipTraffic:readStream(streamId, connection)
	ShipTraffic:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		local shipOnSpline = streamReadBool(streamId);
		if shipOnSpline then
			self.curShip = streamReadInt8(streamId);
			self.curSpline = streamReadInt8(streamId);
			self.cruiseSpeed = streamReadInt8(streamId);
			self.curMark = streamReadInt8(streamId);
			setVisibility(TrafficManager.ships[self.curShip].Id, true);
			self.splinePosition = streamReadInt32(streamId)/1000;
			self.limitedSpeed = streamReadInt8(streamId);
			self.speed = self.limitedSpeed;
			self.draught = streamReadInt32(streamId)/1000;
			self.shipIsStopped = streamReadBool(streamId);
			if not self.shipIsStopped then
				self:changeParticleSystemState(true);
			end;
			local numBlocksToShow = streamReadInt16(streamId);
			self:changeBlocksVisibility(numBlocksToShow);
			self.shipOnSpline = true;
		end;
	end;
end;

function ShipTraffic:writeStream(streamId, connection)
	ShipTraffic:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		streamWriteBool(streamId, Utils.getNoNil(self.shipOnSpline, false));
		if self.shipOnSpline then
			streamWriteInt8(streamId, self.curShip);
			streamWriteInt8(streamId, self.curSpline);
			streamWriteInt8(streamId, self.cruiseSpeed);
			streamWriteInt8(streamId, self.curMark);
			streamWriteInt32(streamId, math.floor(self.splinePosition*1000));
			streamWriteInt8(streamId, math.floor(self.limitedSpeed));
			streamWriteInt32(streamId, math.floor(self.draught*1000));
			streamWriteBool(streamId, Utils.getNoNil(self.shipIsStopped, false));
			streamWriteInt16(streamId, self.numBlocksToShow);
		end;
	end;
end;

function ShipTraffic:readUpdateStream(streamId, timestamp, connection)
	ShipTraffic:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		self.draught = streamReadInt32(streamId)/1000;
		local numBlocksToShow = streamReadInt16(streamId);
		self:changeBlocksVisibility(numBlocksToShow);
	end;
end;

function ShipTraffic:writeUpdateStream(streamId, connection, dirtyMask)
	ShipTraffic:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		streamWriteInt32(streamId, math.floor(self.draught*1000));
		streamWriteInt16(streamId, self.numBlocksToShow);
	end;
end;

function ShipTraffic:onStartShip()
	local ship = TrafficManager.ships[self.curShip];
	setVisibility(ship.Id, true);
	self.splinePosition = 0.1;
	self.curMark = 1;
	self.speed = self.cruiseSpeed;
	self.limitedSpeed = self.cruiseSpeed;
	self:changeParticleSystemState(true);
	self.shipOnSpline = true;
end;

function ShipTraffic:update(dt)
	if self.isEnabled then
		if self.shipOnSpline then
			if self.splinePosition < 1 and self.splinePosition > 0 then
				local ship = TrafficManager.ships[self.curShip];
				local spline = self.splines[self.curSpline];
				if self.speed < self.limitedSpeed then
					self.speed = math.min(self.speed + dt*0.0005, self.limitedSpeed);
				else
					self.speed = math.max(self.speed - dt*0.0005, self.limitedSpeed);
				end;
				local scale = (self.speed/3.6) / spline.length;
				self.splinePosition = self.splinePosition + 0.001*dt*scale;
				local x,y,z = getSplinePosition(spline.nodeId, self.splinePosition);
				local rx,ry,rz = getSplineOrientation(spline.nodeId, self.splinePosition, 0, -1, 0);
				setTranslation(ship.Id, x, y+self.draught, z);
				setRotation(ship.Id, rx,ry,rz);
				if spline.markers then
					local marker = spline.markers[self.curMark];
					local markerDistance = Utils.vector2Length(x-marker.x, z-marker.z);
					if marker.action == "stop" then
						if not self.shipIsStopped and markerDistance < 2 then
							self.shipIsStopped = true;
							self.limitedSpeed = 0;
							self:changeParticleSystemState();
						end;
						if self.shipIsStopped then
							local timeScale = g_currentMission.missionInfo.timeScale;
							if self.isServer then
								if marker.stationName then
									local station = UniversalFactory[marker.stationName];
									if station then
										if self.speed == 0 and not station.cargoFillTypes then
											station.cargoFillTypes = ship.cargoFillTypes;
										end;
										if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] then
											if self.stopTimer == 0 then
												if Economica.missionInterval < 3 then
													local enableMission = math.random(1, 2) > 1;
													if enableMission then
														self.missionTime = math.random(6, 10)*60;
													end;
												end;
											end;
											if self.missionTime and self.missionTime < self.stopTimer then
												local fillType = station:getFillTypeWithMinLevel();
												if fillType > 0 then
													Economica:newExtraMission(marker.stationName, fillType, self.missionTime - 60);
												end;
												self.missionTime = nil;
											end;
										end;
										if self.speed == 0 and ship.capacity > 0 then
											if self.level < ship.capacity then
												for n,ft in pairs(station.fillType) do
													if ship.cargoFillTypes[n] and ft.inputFillType and ft.level > 0 then
														self.level = math.min(self.level + 0.25*dt*timeScale, ship.capacity);
														self.draught = ship.draught*(1-self.level/ship.capacity);
													end;
												end;
												if ship.cargoBlocks then
													local numBlocksToShow = math.ceil(ship.numCargoBlocks*(self.level/ship.capacity));
													if numBlocksToShow ~= self.numBlocksToShow then
														self.numBlocksToShow = numBlocksToShow;
														self:changeBlocksVisibility(numBlocksToShow);
														self:raiseDirtyFlags(self.shipDirtyFlag);
													end;
												end;
											elseif station.cargoFillTypes then
												station.cargoFillTypes = nil;
											end;
										end;
									end;
								end;
							end;
							self.stopTimer = self.stopTimer + dt*timeScale;
						else
							if self.speed <= self.lowSpeed then
								self.limitedSpeed = math.max(math.min(markerDistance/3, self.speed), 4);
							end;
						end;
						if self.stopTimer > marker.minutes then
							if self.isServer and marker.stationName then
								local station = UniversalFactory[marker.stationName];
								if station then
									station.cargoFillTypes = nil;
								end;
								self.level = 0;
							end;
							self.stopTimer = 0;
							self.curMark = math.min(self.curMark + 1, #spline.markers);
							self.enableHorn = true;
							self.limitedSpeed = self.lowSpeed;
							self:changeParticleSystemState(true);
							self.shipIsStopped = false;
						end;
					elseif not self.shipIsStopped and markerDistance < 1 then
						if marker.action == "horn" then self.enableHorn = true; end;
						if marker.action == "lowSpeed" then
							self.limitedSpeed = self.lowSpeed;
						end;
						if marker.action == "cruiseSpeed" then
							self.limitedSpeed = self.cruiseSpeed;
						end;
						self.curMark = math.min(self.curMark + 1, #spline.markers);
					end;
				end;
				if self.enableHorn and self.hornTimer == 0 then
					self.enableHorn = false;
					setTranslation(ship.hornSound, x, y, z);
					setVisibility(ship.hornSound, true);
					self.hornTimer = 4500;
				end;
				if self.hornTimer > 0 then
					self.hornTimer = math.max(self.hornTimer - dt, 0);
				end;
				if self.hornTimer == 0 then
					setVisibility(ship.hornSound, false);
				end;
			else
				local ship = TrafficManager.ships[self.curShip];
				setVisibility(ship.Id, false);
				setTranslation(ship.Id, 0, 4900, 0);
				self.shipOnSpline = false;
				self.draught = 0;
				if ship.cargoBlocks then
					for cb=1, ship.numCargoBlocks do
						setVisibility(getChildAt(ship.cargoBlocks, cb-1), false);
					end;
				end;
				self.numBlocksToShow = 0;
				self:changeParticleSystemState();
			end;
		end;
	end;
end;

function ShipTraffic:hourChanged()
	if self.isServer and not self.shipOnSpline then
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and Economica.randomEventsByNames.shipDamage.active then
			return;
		end;
		for i=1, #TrafficManager.ships do
			local ship = TrafficManager.ships[i];
			for ii=1, #ship.times do
				if ship.times[ii].hour == g_currentMission.environment.currentHour then
					self.curShip = i;
					self.curSpline = ship.times[ii].splineIndex;
					self.cruiseSpeed = ship.speed;
					self.draught = ship.draught*(1-self.level/ship.capacity);
					self:onStartShip();
					g_server:broadcastEvent(ShipTrafficEvent:new(self.curShip, self.curSpline, self.cruiseSpeed, self));
					break;
				end;
			end;
			if self.shipOnSpline then break; end;
		end;
	end;
end;

function ShipTraffic:changeParticleSystemState(state)
	state = Utils.getNoNil(state, false);
	local waterParticles = TrafficManager.ships[self.curShip].waterParticles;
	if waterParticles then
		for i=1, #waterParticles do
			Utils.setEmittingState(waterParticles[i], state);
		end;
	end;
end;

function ShipTraffic:changeBlocksVisibility(numBlocksToShow)
	local ship = TrafficManager.ships[self.curShip];
	for i=1, ship.numCargoBlocks do
		local block = getChildAt(ship.cargoBlocks, i-1);
		setVisibility(block, i <= numBlocksToShow);
	end;
end;

g_onCreateUtil.addOnCreateFunction("ShipTraffic", ShipTraffic.onCreate);

-----------------------------------------------------------------------



ShipTrafficEvent = {};
ShipTrafficEvent_mt = Class(ShipTrafficEvent, Event);
InitEventClass(ShipTrafficEvent, "ShipTrafficEvent");

function ShipTrafficEvent:emptyNew()
	local self = Event:new(ShipTrafficEvent_mt);
    return self;
end;

function ShipTrafficEvent:new(curShip, curSpline, cruiseSpeed, traffic)
	local self = ShipTrafficEvent:emptyNew();
	self.curShip = curShip;
	self.curSpline = curSpline;
	self.cruiseSpeed = cruiseSpeed;
	self.traffic = traffic;
	return self;
end;

function ShipTrafficEvent:readStream(streamId, connection)
	local curShip = streamReadInt8(streamId);
	local curSpline = streamReadInt8(streamId);
	local cruiseSpeed = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local traffic = networkGetObject(id);
	if traffic then
		traffic.curShip = curShip;
		traffic.curSpline = curSpline;
		traffic.cruiseSpeed = cruiseSpeed;
		traffic:onStartShip();
	end;
end;

function ShipTrafficEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.curShip);
	streamWriteInt8(streamId, self.curSpline);
	streamWriteInt8(streamId, self.cruiseSpeed);
	streamWriteInt32(streamId, networkGetObjectId(self.traffic));
end;

