--author: igor29381
--plug-in script for UniversalFactory

Sawmill = {};
Sawmill_mt = Class(Sawmill, Object);

function Sawmill:new(isServer, isClient, customMt)
    if customMt == nil then
        customMt = Sawmill_mt;
    end
    local self = Object:new(isServer, isClient, customMt);
	self.sawmillDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function Sawmill:load(id, woodWork)
	local animationNode = getUserAttribute(id, "animationNode");
	if animationNode then
		animationNode = Utils.indexToObject(id, animationNode);
		if animationNode > 0 then
			self.animCharSet = getAnimCharacterSet(animationNode);
			if self.animCharSet ~= 0 then
				local clip = getAnimClipIndex(self.animCharSet, "animation");
				if clip > -1 then
					assignAnimTrackClip(self.animCharSet, 1, clip);
					setAnimTrackLoopState(self.animCharSet, 1, false);
					setAnimTrackSpeedScale(self.animCharSet, 1, 1);
					self.animClipDuration = getAnimClipDuration(self.animCharSet, clip);
				end;
			end;
		end;
	end;
	local particleNode = getUserAttribute(id, "particleNode");
	if particleNode then
		particleNode = Utils.indexToObject(id, particleNode);
		if particleNode > 0 then
			self.woodChipsParticle = {};
			for i=1, getNumOfChildren(particleNode) do
				local particleId = getChildAt(particleNode, i-1);
				local ps = {};
				ParticleUtil.loadParticleSystemFromNode(particleId, ps, false, false);
				table.insert(self.woodChipsParticle, ps);
			end;
		end;
	end;
	local scrollNode = getUserAttribute(id, "scrollNode");
	if scrollNode then
		scrollNode = Utils.indexToObject(id, scrollNode);
		if scrollNode > 0 then
			self.scrollParticleSystem = {};
			ParticleUtil.loadParticleSystemFromNode(scrollNode, self.scrollParticleSystem, false, false);
		end;
	end;
	self.parameterName = Utils.getNoNil(getUserAttribute(id, "parameterName"), "uvScrollSpeed");
	local scrollShaderNode = getUserAttribute(id, "scrollShaderNode");
	if scrollShaderNode then
		scrollShaderNode = Utils.splitString(" ", scrollShaderNode);
		self.scrollShaderObjects = {};
		for i=1, #scrollShaderNode do
			local node = Utils.indexToObject(id, scrollShaderNode[i]);
			if node > 0 then
				local object = {};
				object.node = node;
				local shaderWorkParams = Utils.getNoNil(getUserAttribute(node, "shaderWorkParams"), "0 1 0 0");
				object.shaderWorkParams = {Utils.getVectorFromString(shaderWorkParams)};
				table.insert(self.scrollShaderObjects, object);
			end;
		end;
	end;
	local trigger = getUserAttribute(id, "trigger");
	if trigger then
		trigger = Utils.indexToObject(id, trigger);
		if trigger > 0 then
			self.trigger = trigger;
			addTrigger(self.trigger, "triggerCallback", self);
		end;
	end;
	local soundTable = {"startSound", "readySound", "workSound", "stopSound"};
	local loopTable = {100000, 0, 0, 100000};
	for i=1, #soundTable do
		local soundName = soundTable[i];
		local loop = loopTable[i];
		local sound = getUserAttribute(id, soundName);
		if sound then
			sound = Utils.getFilename(sound, g_currentMission.baseDirectory);
			sound = createAudioSource(soundName, sound, 70, 30, 1, loop);
			link(id, sound);
			setVisibility(sound, false);
			if loop > 0 then
				self[soundName.."Duration"] = getSampleDuration(getAudioSourceSample(sound));
				self[soundName.."Timer"] = 0;
			end;
			self[soundName] = sound;
		end;
	end;
	self.startWorkTime = Utils.getNoNil(getUserAttribute(id, "startWorkTime"), 8280);
	self.stopWorkTime = Utils.getNoNil(getUserAttribute(id, "stopWorkTime"), 13650);
	self.jobLitersPerSecond = 50*self.animClipDuration/(self.stopWorkTime-self.startWorkTime);
	self.activateText = g_i18n:getText("hireWoodCrusher");
	if woodWork then
		self.activateText = g_i18n:getText("hireSawmill");
	end;
	self.objectActivated = false;
	self.hoursAmount = 1;
	self.hourPrice = Utils.getNoNil(getUserAttribute(id, "hourPrice"), 0);
	if self.parent then
		if FillUtil.FILLTYPE_WOOD and FillUtil.FILLTYPE_WOODCHIPS then
			local jobStream = {};
			jobStream.isActivated = false;
			jobStream.isWorking = false;
			jobStream.rentTimer = 0;
			jobStream.specialJobStream = true;
			jobStream.inputFillTypes = {FillUtil.FILLTYPE_WOOD};
			jobStream.inputPercents = {1};
			jobStream.outputFillTypes = {FillUtil.FILLTYPE_WOODCHIPS};
			jobStream.outputPercents = {0.97};
			if woodWork and FillUtil.FILLTYPE_PLANK then
				jobStream.outputFillTypes = {FillUtil.FILLTYPE_PLANK, FillUtil.FILLTYPE_WOODCHIPS};
				jobStream.outputPercents = {0.75, 0.25};
			end;
			jobStream.rentText = self.activateText;
			jobStream.rentObject = self;
			table.insert(self.parent.jobStreams, jobStream);
			self.numJobStream = #self.parent.jobStreams;
		end;
	end;
	self.isWorking = false;
	self.readyToStop = false;
	self.woodCrush = false;
	self.clipTimer = 0;
	self.posX, _, self.posZ = getWorldTranslation(id);
	return true;
end;

function Sawmill:delete()
	if self.trigger then
		removeTrigger(self.trigger);
	end;
	Sawmill:superClass().delete(self);
end;

function Sawmill:readStream(streamId, connection)
	Sawmill:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		local isWorking = streamReadBool(streamId);
		if isWorking then
			self:startWork();
		end;
		self.readyToStop = streamReadBool(streamId);
		local woodCrush = streamReadBool(streamId);
		if woodCrush then
			self:setWoodCrush(true);
		end;
		self.clipTimer = streamReadInt32(streamId);
		if self.clipTimer > 0 then
			setAnimTrackTime(self.animCharSet, 1, self.clipTimer);
		end;
	end;
end;

function Sawmill:writeStream(streamId, connection)
	Sawmill:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.isWorking);
		streamWriteBool(streamId, self.readyToStop);
		streamWriteBool(streamId, self.woodCrush);
		streamWriteInt32(streamId, math.floor(self.clipTimer));
	end;
end;

function Sawmill:startWork()
	self:restartWork();
	enableAnimTrack(self.animCharSet, 1);
	setVisibility(self.startSound, true);
	self.startSoundTimer = self.startSoundDuration;
	self.isWorking = true;
	for i=1, #self.scrollShaderObjects do
		local params = self.scrollShaderObjects[i].shaderWorkParams;
		setShaderParameter(self.scrollShaderObjects[i].node, self.parameterName, params[1], params[2], params[3], params[4], false);
	end;
end;

function Sawmill:restartWork()
	setAnimTrackTime(self.animCharSet, 1, 0);
	self.clipTimer = 0;
end;

function Sawmill:stopWork()
	disableAnimTrack(self.animCharSet, 1);
	self:restartWork();
	setVisibility(self.readySound, false);
	setVisibility(self.stopSound, true);
	self.stopSoundTimer = self.stopSoundDuration;
	self.isWorking = false;
	self.readyToStop = false;
	for i=1, #self.scrollShaderObjects do
		local params = self.scrollShaderObjects[i].shaderWorkParams;
		setShaderParameter(self.scrollShaderObjects[i].node, self.parameterName, 0, 0, 0, 0, false);
	end;
end;

function Sawmill:setWoodCrush(state)
	for i=1, #self.woodChipsParticle do
		ParticleUtil.setEmittingState(self.woodChipsParticle[i], state);
	end;
	if self.scrollParticleSystem then
		ParticleUtil.setEmittingState(self.scrollParticleSystem, state);
	end;
	setVisibility(self.workSound, state);
	self.woodCrush = state;
end;

function Sawmill:getIsActivatable()
    if (not self.isServer and not g_currentMission.isMasterUser) or self.parent.isOwned or self.parent.jobStreams[self.numJobStream].rentTimer > 0
	or UniversalFactoryHUD.siloTriggerMenu or Economica.showMessage then
        return false;
    end;
    return true;
end;

function Sawmill:drawActivate()
    return;
end;

function Sawmill:onActivateObject()
	UniversalFactoryHUD.rentObject = self;
	UniversalFactoryHUD.siloTriggerMenu = true;
	UniversalFactoryHUD.showCursor = true;
end;

function Sawmill:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if not self.parent.isOwned then
		if onEnter then
			g_currentMission:addActivatableObject(self);
		elseif onLeave then
			g_currentMission:removeActivatableObject(self);
		end;
	end;
end;

function Sawmill:update(dt)
	if self.isServer and self.parent then
		if self.parent.isEnabled then
			local jobStream = self.parent.jobStreams[self.numJobStream];
			if jobStream.isActivated and not self.parent.isOwned then
				jobStream.isActivated = false;
			end;
			if jobStream.isActivated or jobStream.rentTimer > 0 then
				local timeScale = g_currentMission.missionInfo.timeScale;
				local fillTypes = self.parent.fillType;
				local level = fillTypes[FillUtil.FILLTYPE_WOOD].level;
				if jobStream.rentTimer > 0 then
					level = fillTypes[FillUtil.FILLTYPE_WOOD].rentLevel;
				end;
				local delta = math.min(self.jobLitersPerSecond*0.001*dt*timeScale, level);
				local isWorking = not self.parent.updateTipping and delta > 0;
				if isWorking then
					for k=1, #jobStream.outputFillTypes do
						local fillType = fillTypes[jobStream.outputFillTypes[k]];
						local level = fillType.level;
						local capacity = fillType.capacity;
						if jobStream.rentTimer > 0 then
							level = fillType.rentLevel;
							capacity = fillType.capacity - fillType.level;
						end;
						local outputDelta = delta*jobStream.outputPercents[k];
						if level + outputDelta > capacity then
							isWorking = false;
							break;
						end;
					end;
				end;
				if isWorking and self.clipTimer > self.startWorkTime and self.clipTimer < self.stopWorkTime then
					local wood = fillTypes[FillUtil.FILLTYPE_WOOD];
					if jobStream.rentTimer > 0 then
						wood.rentLevel = wood.rentLevel - delta;
					else
						wood.level = wood.level - delta;
					end;
					local woodChipsCoeff = 2.7;
					for k=1, #jobStream.outputFillTypes do
						local fillType = fillTypes[jobStream.outputFillTypes[k]];
						if fillType.index ~= FillUtil.FILLTYPE_WOODCHIPS then
							woodChipsCoeff = 1;
						end;
						if jobStream.rentTimer > 0 then
							local outputDelta = math.min(delta*woodChipsCoeff*jobStream.outputPercents[k], fillType.capacity - fillType.level - fillType.rentLevel);
							fillType.rentLevel = fillType.rentLevel + outputDelta;
						else
							local outputDelta = math.min(delta*woodChipsCoeff*jobStream.outputPercents[k], fillType.capacity - fillType.level);
							fillType.level = fillType.level + outputDelta;
						end;
					end;
					if jobStream.isActivated and self.parent.costsPerSecond > 0 then
						local nightCosts = 1;
						if not g_currentMission.environment.isSunOn then nightCosts = self.parent.nightCosts; end;
						local costs = (self.parent.costsPerSecond*nightCosts*0.001*dt*timeScale) / #self.parent.jobStreams;
						g_currentMission:addSharedMoney(-costs, "other");
					end;
					self.parent:heapsMoving();
					self.parent.enableUpdateClients = true;
				end;
				if not self.isWorking and isWorking then
					self:startWork();
					g_server:broadcastEvent(SawmillEvent:new(true, false, self));
				end;
				if self.isWorking and not isWorking and not self.readyToStop then
					self.readyToStop = true;
					g_server:broadcastEvent(SawmillEvent:new(false, true, self));
				end;
				if jobStream.isActivated then
					if jobStream.isWorking ~= isWorking then
						g_server:broadcastEvent(UniFactoryHUDEvent:new(self.numJobStream, true, isWorking, 0, 0, self.parent));
					end;
					jobStream.isWorking = isWorking;
				end;
			elseif self.isWorking and not self.readyToStop then
				self.readyToStop = true;
				g_server:broadcastEvent(SawmillEvent:new(false, true, self));
			end;
		elseif self.isWorking and not self.readyToStop then
			self.readyToStop = true;
			g_server:broadcastEvent(SawmillEvent:new(false, true, self));
		end;
	end;
	if self.isWorking then
		self.clipTimer = math.min(self.clipTimer + dt, self.animClipDuration);
		local cam = getCamera();
		local cx, _, cz = getWorldTranslation(cam);
		local distance = Utils.vector2Length(self.posX-cx, self.posZ-cz);
		if distance > 100 and isAnimTrackEnabled(self.animCharSet, 1) then
			disableAnimTrack(self.animCharSet, 1);
		end;
		if distance < 100 and not isAnimTrackEnabled(self.animCharSet, 1) then
			setAnimTrackTime(self.animCharSet, 1, self.clipTimer);
			enableAnimTrack(self.animCharSet, 1);
		end;
		if self.clipTimer >= self.startWorkTime and distance < 100 and not self.woodCrush then
			self:setWoodCrush(true);
		end;
		if (self.clipTimer >= self.stopWorkTime or distance > 100) and self.woodCrush then
			self:setWoodCrush(false);
		end;
		if self.clipTimer == self.animClipDuration then
			if self.readyToStop then
				self:stopWork();
			else
				self:restartWork();
			end;
		end;
	end;
	if self.startSoundTimer > 0 then
		self.startSoundTimer = math.max(self.startSoundTimer - dt, 0);
		if self.startSoundTimer == 0 then
			setVisibility(self.startSound, false);
			setVisibility(self.readySound, true);
		end;
	end;
	if self.stopSoundTimer > 0 then
		self.stopSoundTimer = math.max(self.stopSoundTimer - dt, 0);
		if self.stopSoundTimer == 0 then
			setVisibility(self.stopSound, false);
		end;
	end;
end;

SawmillEvent = {};
SawmillEvent_mt = Class(SawmillEvent, Event);
InitEventClass(SawmillEvent, "SawmillEvent");

function SawmillEvent:emptyNew()
	local self = Event:new(SawmillEvent_mt);
    return self;
end;

function SawmillEvent:new(startWork, readyToStop, object)
	local self = SawmillEvent:emptyNew();
	self.startWork = startWork;
	self.readyToStop = readyToStop;
	self.object = object;
	return self;
end;

function SawmillEvent:readStream(streamId, connection)
	local startWork = streamReadBool(streamId);
	local readyToStop = streamReadBool(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if startWork then
		object:startWork();
	end;
	object.readyToStop = readyToStop;
end;

function SawmillEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.startWork);
	streamWriteBool(streamId, self.readyToStop);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
