--author: igor29381

RandomEvents = {};

RandomEvents_mt = Class(RandomEvents, Object);

function RandomEvents.onCreate(id)
    local object = RandomEvents:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:addOnCreateLoadedObject(object);
    object:load(id);
	object:register(true);
end

function RandomEvents:new(isServer, isClient, customMt)
    if customMt == nil then
        customMt = RandomEvents_mt;
    end
    local self = Object:new(isServer, isClient, customMt);
    return self;
end;

function RandomEvents:load(id)
	local protectedAreas = getChild(id, "protectedAreas");
	if protectedAreas > 0 then
		self.protectedAreas = {};
		for i=1, getNumOfChildren(protectedAreas) do
			local corner1 = getChildAt(protectedAreas, i-1);
			local x,_,z = getWorldTranslation(corner1);
			local corner2 = getChildAt(corner1, 0);
			local x1,_,z1 = getWorldTranslation(corner2);
			table.insert(self.protectedAreas, {["x1"] = x, ["z1"] = z, ["x2"] = x1, ["z2"] = z1});
		end;
	end;
	local repairWorks = getChild(id, "repairWorks");
	if repairWorks > 0 then
		self.repairWorks = {};
		for i=1, getNumOfChildren(repairWorks) do
			local workRootNode = getChildAt(repairWorks, i-1);
			setVisibility(workRootNode, false);
			local x,y,z = getTranslation(workRootNode);
			setTranslation(workRootNode, x,y-100,z);
			local text = getUserAttribute(workRootNode, "text");
			text = string.gsub(g_i18n:getText(text), "@", "\n");
			local stopText = getUserAttribute(workRootNode, "stopText");
			stopText = string.gsub(g_i18n:getText(stopText), "@", "\n");
			table.insert(self.repairWorks, {rootNode=workRootNode, text=text, stopText=stopText, active=false, activated=1});
		end;
	end;
	self.enableBigHail = false;
	self.startFruitCrush = false;
	self.bigHailTimer = 0;
	self.fruitTypes = {
	FruitUtil.FRUITTYPE_WHEAT,
	FruitUtil.FRUITTYPE_BARLEY,
	FruitUtil.FRUITTYPE_RAPE,
	FruitUtil.FRUITTYPE_SUNFLOWER,
	FruitUtil.FRUITTYPE_SOYBEAN,
	FruitUtil.FRUITTYPE_MAIZE,
	FruitUtil.FRUITTYPE_RYE,
	FruitUtil.FRUITTYPE_POTATO,
	FruitUtil.FRUITTYPE_SUGARBEET,
	FruitUtil.FRUITTYPE_OILSEEDRADISH,
	FruitUtil.FRUITTYPE_POPLAR,
	FruitUtil.FRUITTYPE_ONION,
	FruitUtil.FRUITTYPE_CARROT};
	Economica.RandomEventsBase = self;
	g_currentMission.environment:addWeatherChangeListener(self);
	print("RandomEvents loaded");

	return true;
end;

function RandomEvents:getProtectedAreas(x, z)
	if self.protectedAreas then
		for i=1, #self.protectedAreas do
			local area = self.protectedAreas[i];
			if x > area.x1 and z > area.z1 and x < area.x2 and z < area.z2 then
				return true;
			end;
		end;
	end;
	return false;
end;

function RandomEvents:startBigHail()
	self.enableBigHail = true;
	self.bigHailTimer = 180000;
	self.SPX = -2000;
	self.SPZ = -2000;
	self.startFruitCrush = false;
end;

function RandomEvents:weatherChanged()
	if g_currentMission and g_currentMission.environment then
		UniversalFactoryHUD.goodWeather = false;
		local currentRain = g_currentMission.environment.currentRain;
		if currentRain then
			if self.isServer then
				if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and Economica.randomEventsByNames.bigHail then
					if currentRain.rainTypeId == "hail" then
						self:startBigHail();
						g_server:broadcastEvent(WeatherEvent:new(true, false));
					end;
				end;
			end;
		else
			self.enableBigHail = false;
			if g_currentMission.environment.isSunOn then
				UniversalFactoryHUD.goodWeather = true;
			end;
		end;
	end;
end;

function RandomEvents:getLostVehicle()
	local keepers = {};
	local targets = {};
	local dangerTargets = {};
	for rootNode,_ in pairs(g_currentMission.players) do
		table.insert(keepers, rootNode);
	end;
	for i=1, #g_currentMission.vehicles do
		local vehicle = g_currentMission.vehicles[i];
		if vehicle.isControlled or vehicle.isHired or
		(vehicle.cp and vehicle.cp.isDriving) or (vehicle.modFM and (vehicle.modFM.FollowState == 2 or vehicle.modFM.FollowState == 3)) then
			table.insert(keepers, vehicle.rootNode);
		elseif SpecializationUtil.hasSpecialization(Motorized, vehicle.specializations) and vehicle.fuelFillLevel > 0.5 then
			table.insert(targets, vehicle.rootNode);
		end;
	end;
	if #targets > 0 then
		for i=1, #targets do
			local tx, _, tz = getWorldTranslation(targets[i]);
			if not self:getProtectedAreas(tx, tz) then
				local distance1 = 300;
				for ii=1, #keepers do
					local kx, _, kz = getWorldTranslation(keepers[ii]);
					local distance2 = Utils.vector2Length(kx-tx, kz-tz);
					if distance2 < distance1 then
						distance1 = distance2;
						break;
					end;
				end;
				if distance1 == 300 then
					table.insert(dangerTargets, targets[i]);
				end;
			end;
		end;
	end;
	if #dangerTargets > 0 then
		return dangerTargets[math.random(1, #dangerTargets)];
	end;
	return 0;
end;

function RandomEvents:setRepairWorkState(num, state)
	local work = self.repairWorks[num];
	local text = "";
	local x,y,z = getTranslation(work.rootNode);
	if state then
		if work.text then
			text = work.text;
		end;
		text = work.text;
		y = y + 100;
	else
		if work.stopText then
			text = work.stopText;
		end;
		y = y - 100;
	end;
	setVisibility(work.rootNode, state);
	setTranslation(work.rootNode, x,y,z);
	work.active = state;
	work.activated = 0;
	return text;
end;

function RandomEvents:getActiveRepairWork()
	for i=1, #self.repairWorks do
		if self.repairWorks[i].active then
			return i;
		end;
	end;
	return 0;
end;

function RandomEvents:getRepairWorkString()
	local str = tostring(self.repairWorks[1].activated);
	for i=2, #self.repairWorks do
		str = string.format("%s %d", str, self.repairWorks[i].activated);
	end;
	return str;
end;

function RandomEvents:setRepairWorkActivatedStates(states)
	states = Utils.splitString(" ", states);
	for i=1, #states do
		self.repairWorks[i].activated = tonumber(states[i]);
	end;
end;

function RandomEvents:getNewRepairWorks()
	local newRepairWorks = {};
	for i=1, #self.repairWorks do
		if self.repairWorks[i].activated == 1 then
			table.insert(newRepairWorks, i);
		end;
	end;
	return newRepairWorks;
end;

function RandomEvents:delete()
	if g_currentMission.environment ~= nil then
		g_currentMission.environment:removeWeatherChangeListener(self);
		g_currentMission.environment:removeMinuteChangeListener(self);
	end;
	RandomEvents:superClass().delete(self);
end;

function RandomEvents:readStream(streamId, connection)
	RandomEvents:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		local activeRepairWork = streamReadUIntN(streamId, 4);
		if activeRepairWork > 0 then
			self:setRepairWorkState(activeRepairWork, true);
		end;
		local enableBigHail = streamReadBool(streamId);
		if enableBigHail then
			self:startBigHail();
		end;
		self.startFruitCrush = streamReadBool(streamId);
	end;
end;

function RandomEvents:writeStream(streamId, connection)
	RandomEvents:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		local activeRepairWork = self:getActiveRepairWork();
		streamWriteUIntN(streamId, activeRepairWork, 4);
		streamWriteBool(streamId, self.enableBigHail);
		streamWriteBool(streamId, self.startFruitCrush);
	end;
end;

function RandomEvents:update(dt)
	if self.enableBigHail and g_currentMission.environment.lastRainScale == 1 then
		if self.isServer then
			self.bigHailTimer = math.max(self.bigHailTimer - dt*g_currentMission.missionInfo.timeScale, 0);
			if not self.startFruitCrush and self.bigHailTimer == 0 then
				self.startFruitCrush = true;
				local randomEvent = Economica.randomEventsByNames.bigHail;
				randomEvent.interval = math.random(randomEvent.intervals[1], randomEvent.intervals[2]);
				g_server:broadcastEvent(WeatherEvent:new(false, true));
			end;
		end;
	end;
	if self.startFruitCrush then
		if self.SPX < 2000 and self.SPZ < 2000 then
			local growing = false;
			Utils.cutFruitArea(FruitUtil.FRUITTYPE_GRASS, self.SPX, self.SPZ, self.SPX+100, self.SPZ, self.SPX, self.SPZ+100, true, true);
			for i=1, #self.fruitTypes do
				local fruitType = self.fruitTypes[i];
				growing = Utils.getFruitStates(self.fruitTypes[i], self.SPX, self.SPZ, self.SPX+100, self.SPZ, self.SPX, self.SPZ+100);
				if growing then break; end;
			end;
			if growing then
				local x, z = self.SPX, self.SPZ;
				while x < self.SPX+100 and z < self.SPZ+100 do
					for i=1, #self.fruitTypes do
						local fruitType = self.fruitTypes[i];
						local growing, allowPreparing = Utils.getFruitStates(fruitType, x, z, x+5, z, x, z+5);
						if growing then
							if allowPreparing then
								Utils.updateFruitPreparerArea(fruitType, x, z, x+5, z, x, z+5, x, z, x+5, z, x, z+5);
							else
								Utils.updateDestroyCommonArea(x, z, x+5, z, x, z+5);
								Utils.updateHaulmArea(terrainControl.fruitTypesToStraw[fruitType], x, z, x+5, z, x, z+5);
							end;
							break;
						end;
					end;
					x = x + 5;
					if x >= self.SPX+100 then
						z = z + 5;
						x = self.SPX;
					end;
				end;
			end;
			self.SPX = self.SPX + 100;
			if self.SPX >= 2000 then
				self.SPX = -2000;
				self.SPZ = self.SPZ + 100;
			end;
		else
			self.startFruitCrush = false;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("RandomEvents", RandomEvents.onCreate);

RandomEvEvent = {};
RandomEvEvent_mt = Class(RandomEvEvent, Event);
InitEventClass(RandomEvEvent, "RandomEvEvent");

function RandomEvEvent:emptyNew()
	local self = Event:new(RandomEvEvent_mt);
    return self;
end;

function RandomEvEvent:new(numRE, int1, int2, int3)
	local self = RandomEvEvent:emptyNew();
	self.numRE = numRE;
	self.int1 = int1;
	self.int2 = int2;
	self.int3 = int3;
	return self;
end;

function RandomEvEvent:readStream(streamId, connection)
	local numRE = streamReadInt8(streamId);
	local int1 = streamReadInt8(streamId);
	local int2 = streamReadInt8(streamId);
	local int3 = streamReadInt32(streamId);
	local randomEvent = Economica.randomEvents[numRE];
	if randomEvent and not Economica.showMessage then
		local text = "";
		if randomEvent.name == "railRoadDamage" or randomEvent.name == "shipDamage" then
			if int1 > 0 then
				text = string.format(randomEvent.msgText, int1);
			else
				text = randomEvent.stopText;
			end;
		end;
		if randomEvent.name == "factoryDamage" then
			text = string.format(randomEvent.msgText, UniversalFactory.all[int1].locationName, int2);
		end;
		if randomEvent.name == "technologyViolation" then
			text = string.format(randomEvent.msgText, UniversalFactory.all[int1].locationName, fillTypeName(int2), int3, g_i18n:getText("unit_liter"));
		end;
		if randomEvent.name == "sanitaryPenalty" then
			text = string.format(randomEvent.msgText, UniversalFactory.all[int1].locationName, int3, g_i18n.globalI18N:getCurrencySymbol(true));
		end;
		if randomEvent.name == "fuelTheft" or randomEvent.name == "vehicleTheft" then
			local storeItem = StoreItemsUtil.storeItems[int3];
			local storeText = string.format("%s %s", storeItem.brand, storeItem.name);
			text = string.format(randomEvent.msgText, storeText);
		end;
		if randomEvent.name == "moneyTheft" or randomEvent.name == "trafficViolation" then
			text = string.format(randomEvent.msgText, int3, g_i18n.globalI18N:getCurrencySymbol(true));
		end;
		if randomEvent.name == "repairWorks" then
			local base = Economica.RandomEventsBase;
			local start = int1 ~= base:getActiveRepairWork();
			if start then
				text = string.format(base:setRepairWorkState(int1, true), int2);
			else
				text = base:setRepairWorkState(int1, false);
			end;
		end;
		if randomEvent.name == "contractPrize" then
			text = randomEvent.msgText;
		end;
		if text ~= "" then
			Economica:showRandomEventMessage(text);
		end;
	end;
end;

function RandomEvEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.numRE);
	streamWriteInt8(streamId, self.int1);
	streamWriteInt8(streamId, self.int2);
	streamWriteInt32(streamId, self.int3);
end;

WeatherEvent = {};
WeatherEvent_mt = Class(WeatherEvent, Event);
InitEventClass(WeatherEvent, "WeatherEvent");

function WeatherEvent:emptyNew()
	local self = Event:new(WeatherEvent_mt);
    return self;
end;

function WeatherEvent:new(startBigHail, startFruitCrush)
	local self = WeatherEvent:emptyNew();
	self.startBigHail = startBigHail;
	self.startFruitCrush = startFruitCrush;
	return self;
end;

function WeatherEvent:readStream(streamId, connection)
	local startBigHail = streamReadBool(streamId);
	local startFruitCrush = streamReadBool(streamId);
	if startBigHail then
		Economica.RandomEventsBase:startBigHail();
	end;
	if startFruitCrush then
		Economica.RandomEventsBase.startFruitCrush = true;
	end;
end;

function WeatherEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.startBigHail);
	streamWriteBool(streamId, self.startFruitCrush);
end;
