--author: igor29381

ObjectInputTrigger = {}

local ObjectInputTrigger_mt = Class(ObjectInputTrigger, Object);

function ObjectInputTrigger.onCreate(id)
	local trigger = ObjectInputTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:load(id);
	trigger:register(true);
end;

function ObjectInputTrigger:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = ObjectInputTrigger_mt;
	end;
	local self = Object:new(isServer, isClient, customMt);
	self.triggerId = 0;
	self.rootNode = 0;
	return self;
end;

function ObjectInputTrigger:load(id)
	self.rootNode = id;
	self.triggerId = id;
	self.roundbales = getUserAttribute(id, "roundbales");
	addTrigger(self.triggerId, "triggerCallback", self);
	if not self.parent then
		self.acceptedFillTypes = {};
		local fillTypes = getUserAttribute(id, "fillTypes");
		if fillTypes then
			local types = Utils.splitString(" ", fillTypes);
			for k,ft in pairs(types) do
				local fillType = FillUtil.fillTypeNameToInt[ft];
				if fillType then
					self.acceptedFillTypes[fillType] = true;
				end;
			end;
		end;
	end;
	self.startFillText = g_i18n:getText("startTipping");
	self.stopFillText = g_i18n:getText("stopTipping");
	self.isTrashcan = Utils.getNoNil(getUserAttribute(id, "isTrashcan"), false);
	self.activateText = self.startFillText;
	self.objectActivated = false;
	self.isFilling = false;
	self.moneyChangeId = getMoneyTypeId();
	self.lastMoneyChange = -1;
	self.isEnabled = true;
	return true;
end;

function ObjectInputTrigger:delete()
	removeTrigger(self.triggerId);
	ObjectInputTrigger:superClass().delete(self);
end;

function ObjectInputTrigger:update(dt)
	if self.trailer then
		if self.isServer then
			if self.isFilling then
				local currentFillType = self.trailer.fillUnits[1].currentFillType;
				local oldFillLevel = self.trailer:getFillLevel(currentFillType);
				if self.parent then
					local parentLevel = 0;
					if currentFillType > 0 then
						local fillType = self.parent.fillType[currentFillType];
						parentLevel = fillType.capacity - fillType.level;
					end;
					local delta = math.min(0.5*dt, oldFillLevel, parentLevel);
					if delta <= 0 then
						self.isFilling = false;
						self:onActivateObjectClient();
						g_server:broadcastEvent(ObjectInputEvent:new(false, self));
					else
						local fillType = self.parent.fillType[currentFillType];
						fillType.level = math.min(fillType.level + delta, fillType.capacity);
						self.trailer:setFillLevel(math.max(oldFillLevel - delta, 0), currentFillType);
						self.trailer:resetFillLevelIfNeeded(currentFillType);
						self.parent:heapsMoving();
						self.parent.enableUpdateClients = true;
					end;
				else
					local delta = math.min(0.5*dt, oldFillLevel);
					if delta <= 0 then
						self.isFilling = false;
						self:onActivateObjectClient();
						g_server:broadcastEvent(ObjectInputEvent:new(false, self));
					else
						self.trailer:setFillLevel(math.max(oldFillLevel - delta, 0), currentFillType);
						self.trailer:resetFillLevelIfNeeded(currentFillType);
						if self.isTrashcan and currentFillType ~= FillUtil.FILLTYPE_WATER and currentFillType ~= 0 then
							local money = delta*0.01;
							g_currentMission:addSharedMoney(-money, "other");
							g_currentMission:addMoneyChange(-money, self.moneyChangeId);
							self.lastMoneyChange = 30;
						end;
					end;
				end;
			end;
			if self.isTrashcan then
				if self.lastMoneyChange > 0 then
					self.lastMoneyChange = self.lastMoneyChange - 1;
					if self.lastMoneyChange == 0 then
						g_currentMission:showMoneyChange(self.moneyChangeId);
					end;
				end;
			end;
		end;
	end;
end;

function ObjectInputTrigger:getIsActivatable()
    if not self.isEnabled then
        return false;
    end;
    if self.isFilling then
        if self.trailer:getRootAttacherVehicle() == g_currentMission.controlledVehicle then
            return true;
        end;
    else
        if self.trailer ~= nil then
            local trailer = self.trailer;
            if trailer:getRootAttacherVehicle() ~= g_currentMission.controlledVehicle then
                return false;
            end;
			local currentFillType = trailer.fillUnits[1].currentFillType;
			if trailer:getFillLevel(currentFillType) > 0 and self.acceptedFillTypes[currentFillType] ~= nil then
				if self.parent and self.parent.fillType[trailer.currentFillType] then
					if self.parent.fillType[currentFillType].level < self.parent.fillType[currentFillType].capacity then
						return true;
					else
						return false;
					end;
				end;
                return true;
            end;
        end;
    end;
    return false;
end;

function ObjectInputTrigger:drawActivate()
    return;
end;

function ObjectInputTrigger:onActivateObject()
	if self.isServer then
		self.isFilling = not self.isFilling;
		self:onActivateObjectClient();
		g_server:broadcastEvent(ObjectInputEvent:new(self.isFilling, self));
	else
		g_client:getServerConnection():sendEvent(ObjectInputEvent:new(self.isFilling, self));
	end;
    g_currentMission:addActivatableObject(self);
end;

function ObjectInputTrigger:onActivateObjectClient()
	if self.trailer then
		if self.isFilling then
			self.activateText = self.stopFillText;
			if self.trailer.sampleRefuel then
				SoundUtil.play3DSample(self.trailer.sampleRefuel);
			end;
		else
			self.activateText = self.startFillText;
			if self.trailer.sampleRefuel then
				SoundUtil.stop3DSample(self.trailer.sampleRefuel);
			end;
		end;
	end;
end;

function ObjectInputTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled and otherShapeId ~= 0 then
		if onEnter then
			if self.parent and not self.parent.isEnabled then
				return;
			end;
			if self.isServer and not self.isTrashcan then
				local object = g_currentMission:getNodeObject(otherShapeId);
				if object ~= nil then
					local enable = true;
					if self.roundbales ~= nil then
						local roundbale = Utils.getNoNil(getUserAttribute(otherShapeId, "isRoundbale"), false);
						if self.roundbales and not roundbale then enable = false; end;
						if not self.roundbales and roundbale then enable = false; end;
					end;
					if enable and (object:isa(FillablePallet) or object:isa(Bale)) then
						if self.acceptedFillTypes[object.fillType] and self.parent:getFreeSpace(object.fillType) >= object.fillLevel then
							local parentFillType = self.parent.fillType[object.fillType];
							if parentFillType.rent then
								parentFillType.rentLevel = parentFillType.rentLevel + object.fillLevel;
							else
								parentFillType.level = parentFillType.level + object.fillLevel;
								if parentFillType.extraMission then
									parentFillType.extraMissionLevel = parentFillType.extraMissionLevel + object.fillLevel;
								end;
								if parentFillType.contract then
									parentFillType.contractLevel = parentFillType.contractLevel + object.fillLevel;
								end;
								if not self.parent.isOwned then
									self.parent:fillTypePayment(object.fillType, "harvestIncome", object.fillLevel, true, g_i18n:getText("finance_harvestIncome"));
								end;
							end;
							self.parent:heapsMoving();
							self.parent.enableUpdateClients = true;
							object:delete();
						end;
					end;
				end;
			end;
			local trailer = g_currentMission.objectToTrailer[otherShapeId];
			if trailer ~= nil then
				local currentFillType = trailer.fillUnits[1].currentFillType;
				if self.acceptedFillTypes[currentFillType] then
					self.trailer = trailer;
					g_currentMission:addActivatableObject(self);
				end;
			end;
		elseif onLeave then
			self.trailer = nil;
			g_currentMission:removeActivatableObject(self);
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("ObjectInputTrigger", ObjectInputTrigger.onCreate);

---------------------------------------------------------------------------------------------------------

ObjectInputEvent = {};
ObjectInputEvent_mt = Class(ObjectInputEvent, Event);

InitEventClass(ObjectInputEvent, "ObjectInputEvent");

function ObjectInputEvent:emptyNew()
	local self = Event:new(ObjectInputEvent_mt);
    return self;
end;

function ObjectInputEvent:new(isFilling, trigger)
	local self = ObjectInputEvent:emptyNew();
	self.isFilling = Utils.getNoNil(isFilling, false);
	self.trigger = trigger;
	return self;
end;

function ObjectInputEvent:readStream(streamId, connection)
	local isFilling = streamReadBool(streamId);
	local id = streamReadInt32(streamId);
    local trigger = networkGetObject(id);
	if trigger ~= nil then
		if g_server then
			isFilling = not isFilling;
			g_server:broadcastEvent(ObjectInputEvent:new(isFilling, trigger));
		end;
		trigger.isFilling = isFilling;
		trigger:onActivateObjectClient();
	end;
end;

function ObjectInputEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isFilling);
	streamWriteInt32(streamId, networkGetObjectId(self.trigger));
end;
