--author: igor29381

Garage = {};
Garage_mt = Class(Garage, Object);

function Garage.onCreate(id)
    local object = Garage:new(g_server ~= nil, g_client ~= nil);
	object:load(id);
	g_currentMission:addOnCreateLoadedObject(object);
	g_currentMission:addOnCreateLoadedObjectToSave(object);
	object:register(true);
end

function Garage:new(isServer, isClient, customMt)
    if customMt == nil then
        customMt = Garage_mt;
    end
    local self = Object:new(isServer, isClient, Garage_mt);
    return self;
end;

function Garage:load(id)
	self.nodeId = id;
	self.hiddenTriggers = {};
	self.hiddenVehicles = {};
	self.unknownVehicleImage = createImageOverlay(Utils.getFilename("maps/scripts/huds/hud_pda_spot_helper.dds", TrafficManager.curModDir));
	self.garages = {};
	self.garageTriggers = {};
	local garagesRootNode = getChild(id, "garages");
	if garagesRootNode > 0 then
		for i=1, getNumOfChildren(garagesRootNode) do
			local child = getChildAt(garagesRootNode, i-1);
			local garage = {};
			garage.name = getUserAttribute(child, "name");
			garage.isOwned = true;
			garage.nodeId = child;
			for b=1, getNumOfChildren(child) do
				local triggerId = getChildAt(child, b-1);
				if triggerId > 0 then
					local trigger = GaragePlayerTrigger:new(g_server ~= nil, g_client ~= nil);
					g_currentMission:addOnCreateLoadedObject(trigger);
					trigger:load(triggerId);
					trigger:register(true);
					trigger.garage = garage;
					table.insert(self.garageTriggers, trigger);
				end;
			end;
			self.garages[garage.name] = garage;
		end;
	end;
	local hiddenTriggersRootNode = getChild(id, "hiddenTriggers");
	if hiddenTriggersRootNode > 0 then
		hiddenTriggersRootNode = hiddenTriggersRootNode;
		for i=1, getNumOfChildren(hiddenTriggersRootNode) do
			local child = getChildAt(hiddenTriggersRootNode, i-1);
			if child > 0 then
				local trigger = HiddenVehicleTrigger:new(child);
				g_currentMission:addNonUpdateable(trigger);
				trigger.parent = self;
				trigger.state = 0;
				table.insert(self.hiddenTriggers, trigger);
				trigger.number = #self.hiddenTriggers;
				table.insert(self.hiddenVehicles, 1);
			end;
		end;
	end;
	if g_currentMission.missionInfo.isNewSPCareer then
		self:loadHiddenVehicles();
	end;
	g_currentMission.environment:addDayChangeListener(self);
	g_currentMission:addNodeObject(id, self);
	self.saveId = "Garage";
	Garage.main = self;
	print("Garage loaded");
end;

function Garage:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local fileName = string.format("%s/GarageSaves.xml", g_currentMission.missionInfo.savegameDirectory);
	if fileExists(fileName) then
		local xmlFile = loadXMLFile("GarageSaves", fileName);
		local i = 0;
		while true do
			local key = string.format("vehicles.vehicle(%d)", i);
			if not hasXMLProperty(xmlFile, key) then break; end;
			local vehicleXML = Utils.convertFromNetworkFilename(getXMLString(xmlFile, key.."#filename"));
			if vehicleXML then
				g_currentMission:loadVehicle(vehicleXML, 0, 0, 0, 0, true, 0, Vehicle.PROPERTY_STATE_OWNED, nil, {xmlFile=xmlFile, key=key, resetVehicles=false});
			end;
			i = i + 1;
		end;
		delete(xmlFile);
	end;
	local gateStates = getXMLString(xmlFile, key.."#gateStates");
	if gateStates then
		gateStates = {Utils.getVectorFromString(gateStates)};
		for i=1, #self.garageTriggers do
			local garage = self.garageTriggers[i];
			if gateStates[i] == GaragePlayerTrigger.STATE_OPENED then
				garage.gatePos = 1;
				garage.state = GaragePlayerTrigger.STATE_OPENED;
				for _, gate in pairs(garage.gates) do
					setRotation(gate.node, gate.endX, gate.endY, gate.endZ);
				end;
			elseif gateStates[i] == GaragePlayerTrigger.STATE_CLOSED then
				garage:onEndClosing(false);
			end;
		end;
	end;
	local hiddenVehicles = getXMLString(xmlFile, key.."#hiddenVehicles");
	if hiddenVehicles then
		self.hiddenVehicles = {Utils.getVectorFromString(hiddenVehicles)};
		self:loadHiddenVehicles();
	end;
	return true;
end;

function Garage:getSaveAttributesAndNodes(nodeIdent)
	local garagesString = "";
	local gateStates = {};
	for i=1, #self.garageTriggers do
		local garage = self.garageTriggers[i];
		if garage.vehiclesString ~= "" then
			if garagesString == "" then
				garagesString = garage.vehiclesString;
			else
				garagesString = string.format("%s\n%s", garagesString, garage.vehiclesString);
			end;
		end;
		table.insert(gateStates, garage.state);
	end;
	if garagesString ~= "" then
		local file = io.open(string.format("%s/GarageSaves.xml", g_currentMission.missionInfo.savegameDirectory), "w");
		file:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n<vehicles>\n', garagesString, '\n</vehicles>');
		file:close();
	end;
	UniversalFactoryHUD:save();
	Economica:save();
	TrafficManager:save();
	for i=1, #terrainControl.saveDensities do
		local densityId = terrainControl.saveDensities[i];
		if densityId > 0 then
			local filename = getDensityMapFilename(densityId);
			saveDensityMapToFile(densityId, string.format("%s/%s", g_currentMission.missionInfo.savegameDirectory, filename));
		end;
	end;
	attributes = 'hiddenVehicles="'..tableToString(self.hiddenVehicles)..'" gateStates="'..tableToString(gateStates)..'"';
	return attributes, nodes;
end;

function Garage:delete()
	g_currentMission:removeOnCreateLoadedObjectToSave(self);
    if self.nodeId ~= 0 then
        g_currentMission:removeNodeObject(self.nodeId);
    end;
	Garage:superClass().delete(self);
end;

function Garage:changeStates()
	for i=1, #self.hiddenTriggers do
		self.hiddenVehicles[i] = self.hiddenTriggers[i].state;
	end;
end;

function Garage:loadHiddenVehicles()
	for i=1, #self.hiddenTriggers do
		local trigger = self.hiddenTriggers[i];
		trigger.state = self.hiddenVehicles[i];
		if trigger.isEnabled and trigger.state == 1 then
			trigger:i3dLoad();
		end;
	end;
end;

function Garage:readStream(streamId, connection)
	Garage:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		for i=1, #self.hiddenTriggers do
			local state = streamReadUIntN(streamId, 4);
			self.hiddenVehicles[i] = state;
			local trigger = self.hiddenTriggers[i];
			if trigger.isEnabled then
				trigger.state = state;
				if state == 1 then
					trigger:i3dLoad();
				end;
			end;
		end;
	end;
end;

function Garage:writeStream(streamId, connection)
	Garage:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		for i=1, #self.hiddenTriggers do
			streamWriteUIntN(streamId, Utils.getNoNil(self.hiddenVehicles[i], 0), 4);
		end;
	end;
end;

function Garage:update(dt)
end;

function Garage:dayChanged()
	if g_server then
		local totalCosts = 0;
		for _,garage in pairs(self.garageTriggers) do
			if garage.storeNums and #garage.storeNums > 0 then
				for i=1, #garage.storeNums do
					local num = garage.storeNums[i];
					local storeItem = StoreItemsUtil.storeItems[num];
					if storeItem then
						totalCosts = totalCosts + storeItem.dailyUpkeep;
					end;
				end;
			end;
		end;
		g_currentMission:addSharedMoney(-totalCosts, "vehicleRunningCost");
		g_currentMission:addMoneyChange(-totalCosts, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_vehicleRunningCost"));
	end;
end;

g_onCreateUtil.addOnCreateFunction("Garage", Garage.onCreate);

----------------------------------------

HiddenVehicleTrigger = {};
local HiddenVehicleTrigger_mt = Class(HiddenVehicleTrigger);

function HiddenVehicleTrigger:new(nodeId)
	local self = {};
	setmetatable(self, HiddenVehicleTrigger_mt);
	local vehicleXML = getUserAttribute(nodeId, "vehicleXML");
	if vehicleXML then
		vehicleXML = Utils.convertFromNetworkFilename(vehicleXML);
		if fileExists(vehicleXML) then
			local i3dFilename = getUserAttribute(nodeId, "i3dFilename");
			if i3dFilename then
				i3dFilename = Utils.convertFromNetworkFilename(i3dFilename);
				if fileExists(i3dFilename) then
					self.triggerId = nodeId;
					addTrigger(self.triggerId, "triggerCallback", self);
					self.vehicleXML = vehicleXML;
					self.i3dFilename = i3dFilename;
					self.isEnabled = true;
				end;
			end;
		end;
	end;
    return self;
end;

function HiddenVehicleTrigger:delete()
    if self.triggerId then
		removeTrigger(self.triggerId);
	end;
	if self.i3dnode then
		delete(self.i3dnode);
	end;
end;

function HiddenVehicleTrigger:i3dLoad()
	if self.i3dFilename then
		local i3dRoot = Utils.loadSharedI3DFile(self.i3dFilename);
		if i3dRoot > 0 then
			self.i3dnode = getChildAt(i3dRoot, 0);
			link(getRootNode(), self.i3dnode);
			local x,y,z = getWorldTranslation(self.triggerId);
			local _,ry,_ = getWorldRotation(self.triggerId);
			setTranslation(self.i3dnode, x,y+2,z);
			setRotation(self.i3dnode, 0,ry,0);
			setCollisionMask(self.i3dnode, 255);
			delete(i3dRoot);
		end;
	end;
end;

function HiddenVehicleTrigger:onFindVehicle(showMessage)
	delete(self.i3dnode);
	self.i3dnode = nil;
	self.isEnabled = false;
	if showMessage then
		g_currentMission:showBlinkingWarning(g_i18n:getText("vehicleFound"), 3000);
	end;
end;

function HiddenVehicleTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server and self.isEnabled and self.state == 1 and onEnter then
		if g_currentMission.players[otherShapeId] then
			self:onFindVehicle(true);
			self.state = 0;
			self.parent:changeStates();
			local x,_,z = getWorldTranslation(self.triggerId);
			local _,y,_ = getWorldRotation(self.triggerId);
			g_currentMission:loadVehicle(self.vehicleXML, x, 0.1, z, y, true, 0, Vehicle.PROPERTY_STATE_OWNED);
			local vehicle = g_currentMission.vehicles[#g_currentMission.vehicles];
			if vehicle.dirtAmount then
				vehicle:setDirtAmount(1);
			end;
			g_server:broadcastEvent(HiddenVehicleEvent:new(true, self.number));
		end;
	end;
end;

---------------------------------

HiddenVehicleEvent = {};
HiddenVehicleEvent_mt = Class(HiddenVehicleEvent, Event);

InitEventClass(HiddenVehicleEvent, "HiddenVehicleEvent");

function HiddenVehicleEvent:emptyNew()
	local self = Event:new(HiddenVehicleEvent_mt);
    return self;
end;

function HiddenVehicleEvent:new(showMessage, number)
	local self = HiddenVehicleEvent:emptyNew();
	self.showMessage = showMessage;
	self.number = number;
	return self;
end;

function HiddenVehicleEvent:readStream(streamId, connection)
	local showMessage = streamReadBool(streamId);
	local number = streamReadInt8(streamId);
    local object = Garage.main.hiddenTriggers[number];
	if object ~= nil then
		object:onFindVehicle(showMessage);
	end;
end;

function HiddenVehicleEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.showMessage);
	streamWriteInt8(streamId, self.number);
end;
