--author: igor29381

FillingStation = {};
FillingStation_mt = Class(FillingStation, Object);

function FillingStation:onCreate(id)
	local station = FillingStation:new(g_server ~= nil, g_client ~= nil);
    g_currentMission:addOnCreateLoadedObject(station);
    station:load(id);
    station:register(true);
end;

function FillingStation:new(isServer, isClient, customMt)
	if customMt == nil then
		customMt = FillingStation_mt;
	end;
	local self = Object:new(isServer, isClient, customMt);
	self.FillingStationDirtyFlag = self:getNextDirtyFlag();
	return self;
end;

function FillingStation:load(id)
	local manipulator = getUserAttribute(id, "manipulator");
	if manipulator ~= nil then
		self.man01 = Utils.indexToObject(id, manipulator);
		self.man02 = getChildAt(self.man01, 0);
		self.man03 = {};
		self.man03.node = getChildAt(self.man02, 0);
		self.man03.maxRot = {math.rad(10),0,0};
		self.man03.minRot = {math.rad(-50),0,0};
		self.man03.rotTime = 3000;
		self.man04 = {};
		self.man04.node = getChildAt(self.man03.node, 0);
		self.man04.maxRot = {math.rad(-10),0,0};
		self.man04.minRot = {math.rad(50),0,0};
		self.man04.rotTime = 3000;
		self.manPoint = getChild(self.man04.node, "manPoint");
		setRotation(self.man01, 0, math.rad(-170), 0);
		setRotation(self.man02, 0, math.rad(170), 0);
		setRotation(self.man03.node, math.rad(-50), 0, 0);
		setRotation(self.man04.node, math.rad(50), 0, 0);
	end;
	local ladder = getUserAttribute(id, "ladder");
	if ladder ~= nil then
		self.ladder = {};
		self.ladder.node = Utils.indexToObject(id, ladder);
		self.ladder.maxRot = {0,0,math.rad(90)};
		self.ladder.minRot = {0,0,0};
		self.ladder.rotTime = 3000;
	end;
	local siloTrigger = getUserAttribute(id, "siloTrigger");
	if siloTrigger then
		siloTrigger = Utils.indexToObject(id, siloTrigger);
		if siloTrigger then
			local trigger = self.parent:loadSiloTrigger(siloTrigger);
			trigger.getIsActivatable = function(trigger)
				if not self.parent.isEnabled or not trigger.isEnabled then
					return false;
				end;
				if trigger.isFilling then
					if trigger.siloTrailer:getRootAttacherVehicle() == g_currentMission.controlledVehicle then
						return true;
					end;
				else
					if trigger.siloTrailer ~= nil and trigger.activeTriggers >= 4 then
						local trailer = trigger.siloTrailer;
						if self:getNearestAttacher(trailer)==0 and not self:getIsTrailerOnCourse(trailer) then
							return false;
						end;
						local fillTypes = trailer:getCurrentFillTypes();
						local disable = #fillTypes > 0;
						if disable then
							for _,fillType in pairs(fillTypes) do
								if fillType==trigger.siloFillType then
									disable = false;
									break;
								end;
							end;
						end;
						if disable then return false; end;
						if trailer:getRootAttacherVehicle() ~= g_currentMission.controlledVehicle then
							return false;
						end;
						local parentFillType = self.parent.fillType[trigger.siloFillType];
						if (parentFillType.level > 0 or parentFillType.rentLevel > 0) and trailer:getFillLevel() < trailer:getCapacity() then
							return true;
						end;
					end;
				end;
				return false;
			end;
			trigger.onActivateObject = function(trigger)
				if not trigger.isFilling then
					if g_server then
						self:onStartFilling();
						g_server:broadcastEvent(FillingStationEvent:new(true, false, self));
					else
						g_client:getServerConnection():sendEvent(FillingStationEvent:new(true, false, self));
					end;
				else
					self.siloTrigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
					if g_server then
						self:onEndFilling();
						g_server:broadcastEvent(FillingStationEvent:new(false, true, self));
					else
						g_client:getServerConnection():sendEvent(FillingStationEvent:new(false, true, self));
					end;
				end;
				g_currentMission:addActivatableObject(trigger);
			end;
			trigger.drawActivate = function(trigger)
				g_currentMission:enableHudIcon("load", 4);
			end;
			trigger.setIsFilling = function(trigger, isFilling, fillType, noEventSend)
				SiloTriggerSetIsFillingEvent.sendEvent(trigger, isFilling, fillType, noEventSend);
				if isFilling then
					trigger:startFill(fillType);
				else
					trigger:stopFill();
					self:onEndFilling();
				end;
			end;
			self.siloTrigger = trigger;
		end;
	end;
	self.nodeId = id;
	self.moveToAttacher = false;
	self.foldMan = false;
    return true;
end;

function FillingStation:delete()
	FillingStation:superClass().delete(self);
end;

function FillingStation:update(dt)
	if self.siloTrigger.siloTrailer then
		local trailer = self.siloTrigger.siloTrailer;
		if self.moveToAttacher then
			local attacher = self:getNearestAttacher(trailer);
			if attacher == 0 then
				self:onEndFilling();
				self.siloTrigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
				return;
			end;
			local px, py, pz = getWorldTranslation(attacher);
			local _, ry, _ = getRotation(self.man02);
			local dx, _, dz = worldToLocal(self.man02, px, _, pz);
			local angleRad = math.atan(dx/math.abs(dz));
			if angleRad > 0 then
				setRotation(self.man02, 0, math.min(ry+0.1*math.abs(dx), math.rad(170)), 0);
			elseif angleRad < 0 then
				setRotation(self.man02, 0, ry-0.1*math.abs(dx), 0);
			end;
			if math.abs(angleRad) < math.rad(5) then
				local mPx, _, mPz = worldToLocal(self.manPoint, px, _, pz);
				local _, m1y, _ = getRotation(self.man01);
				local m1x, _, m1z = worldToLocal(self.man01, px, _, pz);
				if mPz > 0 and m1x > 0 then
					setRotation(self.man01, 0, math.min(m1y+0.01*mPz, math.rad(-70)), 0);
				else
					setRotation(self.man01, 0, math.max(m1y-0.01*math.abs(mPz), math.rad(-170)), 0);
				end;
				if mPz < 0.3 then
					local _,y,_ = getWorldTranslation(self.manPoint);
					y = math.abs(math.abs(y)-math.abs(py));
					if y > 0.1 then
						local rot = {getRotation(self.man03.node)};
						local newRot = Utils.getMovedLimitedValues(rot, self.man03.maxRot, self.man03.minRot, 3, self.man03.rotTime, dt, false);
						setRotation(self.man03.node, unpack(newRot));
						rot = {getRotation(self.man04.node)};
						newRot = Utils.getMovedLimitedValues(rot, self.man04.maxRot, self.man04.minRot, 3, self.man04.rotTime, dt, false);
						setRotation(self.man04.node, unpack(newRot));
						if rot[1] < 0 and not self.siloTrigger.isFilling then
							self.siloTrigger:onFillTypeSelection(self.siloTrigger.siloFillType);
						end;
					end;
				end;
			end;
		end;
	end;
	if self.foldMan then
		local rot = {getRotation(self.man03.node)};
		local newRot = Utils.getMovedLimitedValues(rot, self.man03.maxRot, self.man03.minRot, 3, self.man03.rotTime, dt, true);
		setRotation(self.man03.node, unpack(newRot));
		rot = {getRotation(self.man04.node)};
		newRot = Utils.getMovedLimitedValues(rot, self.man04.maxRot, self.man04.minRot, 3, self.man04.rotTime, dt, true);
		setRotation(self.man04.node, unpack(newRot));
		local xr, _, _ = getRotation(self.man03.node);
		if xr <= math.rad(-50) then
			local _,yr2,_ = getRotation(self.man02);
			setRotation(self.man02, 0, math.min(yr2+0.03, math.rad(170)), 0);
			local _,yr1,_ = getRotation(self.man01);
			setRotation(self.man01, 0, math.max(yr1-0.03, math.rad(-170)), 0);
			if yr1 <= math.rad(-169) and yr2 >= math.rad(169) then self.foldMan = false; end;
		end;
	end;
end;

function FillingStation:updateTick()
end;

function FillingStation:onStartFilling()
	self.moveToAttacher = true;
end;

function FillingStation:onEndFilling()
	self.moveToAttacher = false;
	self.foldMan = true;
end;

function FillingStation:getNearestAttacher(trailer)
	local distance = 3.6;
	local attacher = 0;
	if trailer.foldAnimTime == 1 then
		for i=1, #trailer.attacherJoints do
			if trailer.attacherJoints[i].jointType == AttacherJoints.JOINTTYPE_FILLINGSTATION then
				local id = trailer.attacherJoints[i].jointTransform;
				local x,_,z = getWorldTranslation(id);
				local x1,_,z1 = getWorldTranslation(self.man01);
				local dis = Utils.vector2Length(x1-x, z1-z);
				if dis < distance then
					distance = dis;
					attacher = id;
				end;
			end;
		end;
	end;
	return attacher;
end;

function FillingStation:getIsTrailerOnCourse(trailer)
	if trailer.cp then
		local rootAttacherVehicle = trailer:getRootAttacherVehicle();
		if rootAttacherVehicle and rootAttacherVehicle.cp.isDriving then
			return true;
		end;
	end;
	return false;
end;

---------------------------------------------------------------------------------------------------------

FillingStationEvent = {};
FillingStationEvent_mt = Class(FillingStationEvent, Event);

InitEventClass(FillingStationEvent, "FillingStationEvent");

function FillingStationEvent:emptyNew()
	local self = Event:new(FillingStationEvent_mt);
    return self;
end;

function FillingStationEvent:new(moveToAttacher, foldMan, station)
	local self = FillingStationEvent:emptyNew();
	self.moveToAttacher = moveToAttacher;
	self.foldMan = foldMan;
	self.station = station;
	return self;
end;

function FillingStationEvent:readStream(streamId, connection)
	local moveToAttacher = streamReadBool(streamId);
	local foldMan = streamReadBool(streamId);
	local id = streamReadInt32(streamId);
    local station = networkGetObject(id);
	if station ~= nil then
		station.moveToAttacher = moveToAttacher;
		station.foldMan = foldMan;
		if g_server then
			g_server:broadcastEvent(FillingStationEvent:new(moveToAttacher, foldMan, station));
		end;
	end;
end;

function FillingStationEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.moveToAttacher);
	streamWriteBool(streamId, self.foldMan);
	streamWriteInt32(streamId, networkGetObjectId(self.station));
end;
