--author: Giants, edit:igor29381

function ChangedFunctions:FPgetSaveAttributesAndNodes(nodeIdent)
	local x,y,z = getWorldTranslation(self.nodeId);
	local xRot,yRot,zRot = getWorldRotation(self.nodeId);
    local filename;
    if self.xmlFilename then
        filename = 'filename="'.. Utils.encodeToHTML(Utils.convertToNetworkFilename(self.xmlFilename))..'"'
    else
        filename = 'i3dFilename="'.. Utils.encodeToHTML(Utils.convertToNetworkFilename(self.i3dFilename))..'"'
    end;
    local attributes = filename..' position="'..x..' '..y..' '..z..'" rotation="'..xRot..' '..yRot..' '..zRot..'" fillLevel="'..self.fillLevel..'"';
	attributes = attributes..' fillType="'..FillUtil.fillTypeIntToName[self.fillType]..'" ValueScale ="'..self.fillablePalletValueScale..'"';
	local nodes = "";
	return attributes, nodes;
end;

function ChangedFunctions:FPloadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#position"));
	local xRot,yRot,zRot = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rotation"));
	if x == nil or y == nil or z == nil or xRot == nil or yRot == nil or zRot == nil then
		return false;
	end;
    local filename;
    local objectXMLFile;
    self.xmlFilename = getXMLString(xmlFile, key.."#filename");
    if self.xmlFilename ~= nil then
        objectXMLFile = loadXMLFile("tempObjectXML", self.xmlFilename);
        filename = getXMLString(objectXMLFile, "object.filename");
    else
        filename = getXMLString(xmlFile, key.."#i3dFilename");
    end;
	if filename == nil then
		return false;
	end;
	filename = Utils.convertFromNetworkFilename(filename);
	local rootNode = Utils.loadSharedI3DFile(filename);
	if rootNode == 0 then
		return false;
	end;

	local ret = false;
	local node = getChildAt(rootNode, 0);
	if node ~= nil and node ~= 0 then
		setTranslation(node, x,y,z);
		setRotation(node, xRot,yRot,zRot);
		link(getRootNode(), node);
		ret = true;
	end;
	delete(rootNode);
	if not ret then
		return false;
	end;
	self:loadFromMemory(node, filename);
	local fillType = Utils.getNoNil(getXMLString(xmlFile, key.."#fillType"), "wool");
	fillType = FillUtil.fillTypeNameToInt[fillType];
	if fillType then self.fillType = fillType; end;
	self.fillablePalletValueScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#ValueScale"), 1);
	local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
	if fillLevel ~= nil then
		self.fillLevel = -1;
		self:setFillLevel(fillLevel, true);
	end;
    if objectXMLFile ~= nil then
        FillablePallet.loadObjectXML(self, objectXMLFile)
    end;
	return true;
end;

function ChangedFunctions:FPreadStream(streamId, connection)
	local i3dFilename = Utils.convertFromNetworkFilename(streamReadString(streamId));
    local xmlFilename;
    if streamReadBool(streamId) then
        xmlFilename = Utils.convertFromNetworkFilename(streamReadString(streamId));
    end
	if self.nodeId == 0 then
		self:createNode(i3dFilename, xmlFilename);
	end;
	local fillLevel = nil;
	if self.synchronizeFillLevel then
		fillLevel = streamReadUIntN(streamId, 15)/32767*self.capacity;
		self.fillType = streamReadInt8(streamId);
	end;
	FillablePallet:superClass().readStream(self, streamId, connection);
	g_currentMission:addItemToSave(self);
	if self.synchronizeFillLevel then
		self:setFillLevel(fillLevel, false);
	end;
end;

function ChangedFunctions:FPwriteStream(streamId, connection)
	streamWriteString(streamId, Utils.convertToNetworkFilename(self.i3dFilename));
    if streamWriteBool(streamId, self.xmlFilename ~= nil) then
        streamWriteString(streamId, Utils.convertToNetworkFilename(self.xmlFilename));
    end;

	if self.synchronizeFillLevel then
		local percent = 0;
		if self.capacity ~= 0 then
			percent = Utils.clamp(self.fillLevel / self.capacity, 0, 1);
		end
		streamWriteUIntN(streamId, math.floor(percent*32767), 15);
		streamWriteInt8(streamId, self.fillType);
	end;
	FillablePallet:superClass().writeStream(self, streamId, connection);
end;

function ChangedFunctions:FPreadUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if self.nodeId == 0 then
			local i3dFilename = Utils.convertFromNetworkFilename(streamReadString(streamId));
			self:createNode(i3dFilename);
		end;
		if self.synchronizeFillLevel then
			if streamReadBool(streamId) then
				local fillLevel = streamReadUIntN(streamId, 15)/32767*self.capacity;
				self:setFillLevel(fillLevel, false);
				self.fillType = streamReadInt8(streamId);
			end
		end;
        if streamReadBool(streamId) then
            local raycastDistance = streamReadUIntN(streamId, 11);
            self.currentRaycastDistance = raycastDistance/100;
        else
            self.currentRaycastDistance = 0;
        end;
	end;
	FillablePallet:superClass().readUpdateStream(self, streamId, timestamp, connection);
end;

function ChangedFunctions:FPwriteUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if self.sendI3dFilename then
			streamWriteString(streamId, Utils.convertToNetworkFilename(self.i3dFilename));
			self.sendI3dFilename = false;
		end;
		if self.synchronizeFillLevel then
			if streamWriteBool(streamId, bitAND(dirtyMask, self.fillablePalletDirtyFlag) ~= 0) then
				local percent = 0;
				if self.capacity ~= 0 then
					percent = Utils.clamp(self.fillLevel / self.capacity, 0, 1);
				end;
				streamWriteUIntN(streamId, math.floor(percent*32767), 15);
				streamWriteInt8(streamId, self.fillType);
			end;
		end;
        if streamWriteBool(streamId, bitAND(dirtyMask, self.syncEffectDirtyFlag) ~= 0) then
            streamWriteUIntN(streamId, math.floor(math.min(self.currentRaycastDistance*100, 2048)), 11);
        end;
	end
	FillablePallet:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
end;
