--author: igor29381

function Economica:loadWoodLicenseDefaultData(xmlFile)
	self.woodLicensePrice = Utils.getNoNil(getXMLFloat(xmlFile, "economica.woodLicense#price"), 1200);
	self.woodLicenseNumTrees = Utils.getNoNil(getXMLInt(xmlFile, "economica.woodLicense#numTrees"), 100);
end;

function Economica:loadWoodLicenseSaveData(xmlFile)
	local woodLicenseTimer = getXMLInt(xmlFile, "economica.woodLicense#timer");
	local woodLicenseNumTrees = getXMLInt(xmlFile, "economica.woodLicense#numTrees");
	if woodLicenseTimer and woodLicenseNumTrees then
		if woodLicenseTimer > 25 then
			woodLicenseTimer = math.min(woodLicenseTimer/3600, 25);
		end;
		self.woodLicense = {["timer"]=woodLicenseTimer, ["numTrees"]=math.min(woodLicenseNumTrees, self.woodLicenseNumTrees)};
	end;
end;

function Economica:woodLicenseHourChanged()
	self.woodLicense.timer = self.woodLicense.timer - 1;
	if self.woodLicense.timer == 0 then
		self.woodLicense = nil;
	end;
end;

function Economica:showWoodLicensingMessage()
	self.message = {
	["timer"] = self.buyMessageDuration,
	["title"] = self.TITLE_WOODLICENSING_AGENCY,
	["buttons"] = self.BUTTONS_OK_CANCEL,
	["text"] = string.format(self.msgText[self.MSG_WOODLICENSE], self.woodLicenseNumTrees, self.woodLicensePrice, self.currencySymbol),
	["callbackOK"] = self.buyWoodLicense,
	["callbackCancel"] = self.callbackCloseMessage};
	self:onStartMessage(true);
end;

function Economica.buyWoodLicense()
	if g_currentMission.missionStats.money < Economica.woodLicensePrice then
		g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
	else
		if g_server then
			Economica:buyServerWoodLicense();
		else
			g_client:getServerConnection():sendEvent(EconomicaWoodEvent:new(true, 0, 0));
		end;
	end;
	Economica:onCloseMessage();
end;

function Economica:buyServerWoodLicense()
	Economica.statistics.purchasedLicenses = Economica.statistics.purchasedLicenses + 1;
	g_currentMission:addSharedMoney(-Economica.woodLicensePrice, "other");
	g_currentMission:addMoneyChange(-Economica.woodLicensePrice, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("licenseCosts"));
	Economica.woodLicense = {["timer"]=25, ["numTrees"]=Economica.woodLicenseNumTrees};
	g_server:broadcastEvent(EconomicaWoodEvent:new(true, 0, Economica.woodLicenseNumTrees));
end;

function Economica:testWoodLicense()
	if self.woodLicense then
		self:changeNumTrees();
	else
		self.statistics.penaltyCutDownTrees = self.statistics.penaltyCutDownTrees + 1;
		g_currentMission:showBlinkingWarning(g_i18n:getText("noCutNotOwnedTrees")..self.currencySymbol, 3000);
		g_server:broadcastEvent(cutTreePenaltyEvent:new(true));
		g_currentMission:addSharedMoney(-20000, "other");
		g_currentMission:addMoneyChange(-20000, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("penalties"));
	end;
end;

function Economica:changeNumTrees()
	self.woodLicense.numTrees = self.woodLicense.numTrees - 1;
	g_server:broadcastEvent(EconomicaWoodEvent:new(false, self.woodLicense.timer, self.woodLicense.numTrees));
	if self.woodLicense.numTrees == 0 then
		self.woodLicense = nil;
	end;
end;

function Economica:saveWoodLicense(xmlFile)
	setXMLInt(xmlFile, "economica.woodLicense#timer", self.woodLicense.timer);
	setXMLInt(xmlFile, "economica.woodLicense#numTrees", self.woodLicense.numTrees);
end;
