--author: igor29381

function Economica:loadUpdateablesDefaultData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.updateables.updateable(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local name = getXMLString(xmlFile, key.."#name");
		local numUpdates = getXMLInt(xmlFile, key.."#numUpdates");
		local prices = getXMLString(xmlFile, key.."#prices");
		local i3dFilename = getXMLString(xmlFile, key.."#i3dFilename");
		if i3dFilename then i3dFilename = TrafficManager.curModDir..i3dFilename; end;
		local capacity = getXMLString(xmlFile, key.."#capacity");
		local productivity = getXMLString(xmlFile, key.."#productivity");
		local dayCosts = getXMLString(xmlFile, key.."#dayCosts");
		local hours = getXMLString(xmlFile, key.."#hours");
		local x, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#xz"));
		local updateable = {};
		updateable.x = x;
		updateable.z = z;
		local factory = UniversalFactory[name];
		updateable.isWarehouse = factory.isWarehouse;
		if not x and not z then
			local objectId = factory.nodeId;
			if objectId > 0 then
				local ox,_,oz = getWorldTranslation(objectId);
				local sx, sz = self:mapCoordsToScreen(ox, oz);
				updateable.x = sx;
				updateable.z = sz;
			end;
		end;
		updateable.numUpdates = numUpdates;
		updateable.currentValue = 1;
		updateable.updateMode = false;
		prices = Utils.splitString(" ", prices);
		for ii=1, #prices do prices[ii] = tonumber(prices[ii]); end;
		updateable.prices = prices;
		if i3dFilename then updateable.i3dFilename = i3dFilename; end;
		if capacity then
			updateable.capacity = {Utils.getVectorFromString(capacity)};
		end;
		if productivity then
			updateable.productivity = {Utils.getVectorFromString(productivity)};
		end;
		if dayCosts then
			updateable.dayCosts = {Utils.getVectorFromString(dayCosts)};
		end;
		if hours then
			updateable.hours = {Utils.getVectorFromString(hours)};
		end;
		if not self.updateables[name] then
			self.updateables[name] = {};
		end;
		table.insert(self.updateables[name], updateable);
		updateable.index = #self.updateables[name];
		self:updateObject(name, updateable.index, 1);
		i = i + 1;
	end;
end;

function Economica:loadUpdateablesSaveData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.updateables.updateable(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local name = getXMLString(xmlFile, key.."#name");
		if self.updateables[name] then
			local currentValue = Utils.getNoNil(getXMLInt(xmlFile, key.."#currentValue"), 1);
			local index = Utils.getNoNil(getXMLInt(xmlFile, key.."#index"), 1);
			local updateable = self.updateables[name][index];
			if updateable then
				updateable.currentValue = currentValue;
				if currentValue > 1 then
					self:updateObject(name, index, currentValue);
				end;
			end;
		end;
		i = i + 1;
	end;
end;

function Economica:testUpdating(name, index, currentValue)
	local updateable = self.updateables[name][index];
	local factory = UniversalFactory[name];
	if updateable then
		local price = updateable.prices[currentValue];
		if g_currentMission.missionStats.money < price then
			g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
			return;
		elseif factory.repairTimer > 0 then
			g_currentMission:showBlinkingWarning(g_i18n:getText("factoryIsClosed"), 3000);
			return;
		else
			if updateable.capacity then
				local level = 0;
				for _,fillType in pairs(factory.fillType) do
					level = level + fillType.level;
				end;
				if level > 1000 then
					g_currentMission:showBlinkingWarning(g_i18n:getText("unloadStorageFirst"), 3000);
					return;
				end;
			end;
			if g_server then
				self:updateObject(name, index, currentValue, true);
				g_currentMission:addSharedMoney(-price, "other");
				g_currentMission:addMoneyChange(-price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_constructionCost"));
			else
				g_client:getServerConnection():sendEvent(EconomicaUpdateEvent:new(name, index, currentValue));
			end;
		end;
		updateable.updateMode = false;
	end;
end;

function Economica:updateObject(name, index, currentValue, process)
	local updateable = self.updateables[name][index];
	local factory = UniversalFactory[name];
	if updateable and factory then
		updateable.currentValue = currentValue;
		if updateable.i3dFilename then
			self:updateI3d(name, index, currentValue);
		end;
		if updateable.capacity then
			self:updateCapacity(name, index, currentValue);
		end;
		if updateable.productivity then
			self:updateProductivity(name, index, currentValue);
		end;
		if updateable.dayCosts then
			self:updateDayCosts(name, index, currentValue);
		end;
		if process and updateable.hours then
			factory.isEnabled = false;
			factory.repairTimer = updateable.hours[currentValue];
		end;
		if g_server then
			g_server:broadcastEvent(EconomicaUpdateEvent:new(name, index, currentValue));
		end;
	end;
end;

function Economica:updateI3d(name, index, currentValue)
	local updateable = self.updateables[name][index];
	local factory = UniversalFactory[name];
	if factory.updateRootNode then
		if factory.nightLights then
			for i=1, #factory.nightLights do
				factory.nightLights[i]:delete();
			end;
		end;
		if factory.loadedGates then
			for i=1, #factory.loadedGates do
				factory.loadedGates[i]:delete();
			end;
		end;
		delete(factory.updateRootNode);
	end;
	local updateRoot = Utils.loadSharedI3DFile(updateable.i3dFilename);
	if getNumOfChildren(updateRoot) >= currentValue then
		factory.updateRootNode = getChildAt(updateRoot, currentValue-1);
		link(getRootNode(), factory.updateRootNode);
		local nightLights = getUserAttribute(factory.updateRootNode, "nightLights");
		if nightLights then
			factory.nightLights = {};
			nightLights = Utils.splitString(" ", nightLights);
			for s=1, #nightLights do
				local id = Utils.indexToObject(factory.updateRootNode, nightLights[s]);
				if id > 0 then
					local nightLight = Nightlight:new(id);
					g_currentMission:addNonUpdateable(nightLight);
					table.insert(factory.nightLights, nightLight);
				end;
			end;
		end;
		local gates = getUserAttribute(factory.updateRootNode, "gates");
		if gates then
			factory.loadedGates = {};
			gates = Utils.splitString(" ", gates);
			for s=1, #gates do
				local id = Utils.indexToObject(factory.updateRootNode, gates[s]);
				if id > 0 then
					setRigidBodyType(id, "Static");
					local gate = SlideGateTrigger:new(id);
					g_currentMission:addUpdateable(gate);
					table.insert(factory.loadedGates, gate);
				end;
			end;
		end;
		local static = getChild(factory.updateRootNode, "static");
		if static > 0 then
			setRigidBodyType(static, "Static");
		end;
	end;
	delete(updateRoot);
end;

function Economica:updateCapacity(name, index, currentValue)
	local updateable = self.updateables[name][index];
	local capacity = updateable.capacity[currentValue];
	local factory = UniversalFactory[name];
	for _,fillType in pairs(factory.fillType) do
		fillType.capacity = capacity;
	end;
	factory:heapsMoving();
end;

function Economica:updateProductivity(name, index, currentValue)
	local updateable = self.updateables[name][index];
	local productivity = updateable.productivity[currentValue];
	local factory = UniversalFactory[name];
	factory.jobLitersPerSecond = productivity;
end;

function Economica:updateDayCosts(name, index, currentValue)
	local updateable = self.updateables[name][index];
	local dayCosts = updateable.dayCosts[currentValue];
	local factory = UniversalFactory[name];
	factory.dayCosts = dayCosts;
end;

function Economica:saveUpdateables(xmlFile)
	local i=0;
	for name,block in pairs(self.updateables) do
		for num,updateable in pairs(block) do
			local updateableKey = string.format("economica.updateables.updateable(%d)", i);
			setXMLString(xmlFile, updateableKey.."#name", name);
			setXMLInt(xmlFile, updateableKey.."#currentValue", updateable.currentValue);
			setXMLInt(xmlFile, updateableKey.."#index", num);
			i = i + 1;
		end;
	end;
end;
