--author: igor29381

function Economica:loadRandomEventsDefaultData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.randomEvents.event(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		randomEvent = {};
		randomEvent.name = getXMLString(xmlFile, key.."#name");
		local messageText = getXMLString(xmlFile, key.."#messageText");
		if messageText then
			randomEvent.msgText = string.gsub(g_i18n:getText(messageText), "@", "\n");
		end;
		local msgStop = getXMLString(xmlFile, key.."#stopText");
		if msgStop then
			randomEvent.stopText = string.gsub(g_i18n:getText(msgStop), "@", "\n");
		end;
		if g_server then
			randomEvent.repeatEvent = Utils.getNoNil(getXMLBool(xmlFile, key.."#repeatEvent"), false);
			local interval = getXMLString(xmlFile, key.."#interval");
			if interval then
				randomEvent.intervals = {Utils.getVectorFromString(interval)};
				local duration = getXMLString(xmlFile, key.."#duration");
				randomEvent.durations = {Utils.getVectorFromString(duration)};
				randomEvent.interval = math.random(randomEvent.intervals[1], randomEvent.intervals[2]);
				if randomEvent.name == "factoryDamage" then
					randomEvent.interval = self:setInterval(randomEvent.interval, true);
				end;
				if randomEvent.name == "technologyViolation" or randomEvent.name == "sanitaryPenalty" then
					randomEvent.interval = 100000;
				end;
				if randomEvent.name == "fuelTheft" or randomEvent.name == "vehicleTheft" or randomEvent.name == "moneyTheft" then
					randomEvent.interval = self:setInterval(randomEvent.interval, false);
				end;
				randomEvent.duration = 0;
			end;
			randomEvent.active = false;
		end;
		table.insert(self.randomEvents, randomEvent);
		self.randomEventsByNames[randomEvent.name] = randomEvent;
		i = i + 1;
		self.randomEventsNameToInt[randomEvent.name] = i;
		self.randomEventsIntToName[i] = randomEvent.name;
	end;
end;

function Economica:loadRandomEventsSaveData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.randomEvents.event(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local name = getXMLString(xmlFile, key.."#name");
		local randomEvent = self.randomEventsByNames[name];
		if randomEvent.interval then
			randomEvent.interval = Utils.getNoNil(getXMLInt(xmlFile, key.."#interval"), 0);
			randomEvent.duration = Utils.getNoNil(getXMLInt(xmlFile, key.."#duration"), 0);
		end;
		randomEvent.active = Utils.getNoNil(getXMLBool(xmlFile, key.."#active"), false);
		i = i + 1;
	end;
	local REBase = self.RandomEventsBase;
	REBase.enableThunders = Utils.getNoNil(getXMLBool(xmlFile, "economica.randomEvents#enableThunder"), false);
	REBase.enableBigHail = Utils.getNoNil(getXMLBool(xmlFile, "economica.randomEvents#enableBigHail"), false);
	if REBase.enableThunders then
		REBase.lightningTimer = math.random(12, 30)*1000;
		if REBase.enableBigHail then
			if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and Economica.randomEventsByNames.bigHail then
				REBase:startBigHail();
			end;
		end;
	end;
	local activeRepairWork = Utils.getNoNil(getXMLInt(xmlFile, "economica.randomEvents#activeRepairWork"), 0);
	if activeRepairWork > 0 then
		REBase:setRepairWorkState(activeRepairWork, true);
	end;
	local repairWorkStates = getXMLString(xmlFile, "economica.randomEvents#repairWorkStates");
	if repairWorkStates then
		REBase:setRepairWorkActivatedStates(repairWorkStates);
	end;
	setXMLString(xmlFile, "economica.randomEvents#repairWorkStates", REBase:getRepairWorkString());
end;

function Economica:randomEventsHourChanged()
	for i=1, #self.randomEvents do
		local randomEvent = self.randomEvents[i];
		if randomEvent.interval then
			randomEvent.interval = math.max(randomEvent.interval - 1, 0);
			randomEvent.duration = math.max(randomEvent.duration - 1, 0);
		end;
	end;
end;

function Economica:updateRandomEvents(dt)
	for i=1, #self.randomEvents do
		local randomEvent = self.randomEvents[i];
		if randomEvent.interval and randomEvent.name ~= "bigHail" then
			if randomEvent.interval == 0 and not randomEvent.active then
				randomEvent.duration = math.random(randomEvent.durations[1], randomEvent.durations[2]);
				randomEvent.active = true;
				local text = randomEvent.msgText;
				if randomEvent.name == "railRoadDamage" then
					text = string.format(randomEvent.msgText, randomEvent.duration);
					g_server:broadcastEvent(RandomEvEvent:new(i, randomEvent.duration, 0, 0));
				end;
				if randomEvent.name == "shipDamage" then
					if TrafficManager.shipTraffic.shipOnSpline then
						randomEvent.interval = 3;
						randomEvent.duration = 0;
						randomEvent.active = false;
						break;
					end;
					text = string.format(randomEvent.msgText, randomEvent.duration);
					g_server:broadcastEvent(RandomEvEvent:new(i, randomEvent.duration, 0, 0));
				end;
				if randomEvent.name == "factoryDamage" then
					local ii=1;
					local factoryIsClosed = false;
					while true do
						local numShop = math.random(1, #self.breakables);
						local factory = self.breakables[numShop];
						if factory.repairTimer == 0 and factory.isEnabled then
							factory.isEnabled = false;
							factory.repairTimer = randomEvent.duration;
							g_server:broadcastEvent(UniFactoryEvent:new(false, factory.isOwned, factory.repairTimer, factory));
							text = string.format(randomEvent.msgText, factory.locationName, randomEvent.duration);
							g_server:broadcastEvent(RandomEvEvent:new(i, factory.index, randomEvent.duration, 0));
							factoryIsClosed = true;
							break;
						end;
						ii=ii+1;
						if ii>5 then break; end;
					end;
					if not factoryIsClosed then
						randomEvent.interval = 1;
						randomEvent.active = false;
						break;
					end;
				end;
				if randomEvent.name == "technologyViolation" or randomEvent.name == "sanitaryPenalty" then
					local ii=1;
					local factoryFound = false;
					while true do
						local numFactory = math.random(1, #UniversalFactory.Factories);
						local factory = UniversalFactory.Factories[numFactory];
						if factory.isOwned and factory.isEnabled and not factory.enableIfOwned then
							if randomEvent.name == "technologyViolation" then
								for num,fillType in pairs(factory.fillType) do
									if FillUtil.fillTypeIndexToDesc[num].showOnPriceTable and fillType.outputFillType then
										local percent = fillType.level/fillType.capacity;
										if percent > 0.75 then
											local level = math.floor(fillType.level*0.00066)*1000;
											fillType.level = fillType.level - level;
											text = string.format(randomEvent.msgText, factory.locationName, fillTypeName(num), level, g_i18n:getText("unit_liter"));
											g_server:broadcastEvent(RandomEvEvent:new(i, factory.index, num, level));
											factoryFound = true;
											break;
										end;
									end;
								end;
							elseif randomEvent.name == "sanitaryPenalty" then
								if g_currentMission.missionStats.money > 100000 then
									local money = 50000;
									text = string.format(randomEvent.msgText, factory.locationName, money, self.currencySymbol);
									g_server:broadcastEvent(RandomEvEvent:new(i, factory.index, 0, money));
									g_currentMission:addSharedMoney(-money, "other");
									g_currentMission:addMoneyChange(-money, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("penalties"));
									factoryFound = true;
								else
									break;
								end;
							end;
						end;
						if factoryFound then break; end;
						ii=ii+1;
						if ii >= #UniversalFactory.Factories then break; end;
					end;
					if not factoryFound then
						randomEvent.interval = 24;
						randomEvent.active = false;
						break;
					end;
				end;
				if randomEvent.name == "fuelTheft" or randomEvent.name == "vehicleTheft" then
					local vehicle = g_currentMission.nodeToVehicle[self.RandomEventsBase:getLostVehicle()];
					if vehicle then
						local storeItem = StoreItemsUtil.storeItemsByXMLFilename[string.lower(vehicle.configFileName)];
						local storeText = string.format("%s %s", storeItem.brand, storeItem.name);
						text = string.format(randomEvent.msgText, storeText);
						g_server:broadcastEvent(RandomEvEvent:new(i, 0, 0, storeItem.id));
						if randomEvent.name == "fuelTheft" then
							vehicle:setFuelFillLevel(0);
						elseif randomEvent.name == "vehicleTheft" then
							g_currentMission:removeVehicle(vehicle);
						end;
					else
						randomEvent.interval = 24;
						randomEvent.active = false;
						break;
					end;
				end;
				if randomEvent.name == "moneyTheft" then
					if g_currentMission.missionStats.money > 0 then
						local money = math.floor(g_currentMission.missionStats.money*0.00025)*1000;
						text = string.format(randomEvent.msgText, money, self.currencySymbol);
						g_server:broadcastEvent(RandomEvEvent:new(i, 0, 0, money));
						g_currentMission:addSharedMoney(-money, "other");
						g_currentMission:addMoneyChange(-money, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("theft"));
					else
						randomEvent.active = false;
						randomEvent.interval = self:setInterval(math.random(randomEvent.intervals[1], randomEvent.intervals[2]), false);
						break;
					end;
				end;
				if randomEvent.name == "repairWorks" then
					local base = self.RandomEventsBase;
					local newRepairWorks = base:getNewRepairWorks();
					if #newRepairWorks > 0 then
						local num = math.random(1, #newRepairWorks);
						num = newRepairWorks[num];
						text = string.format(base:setRepairWorkState(num, true), randomEvent.duration);
						g_server:broadcastEvent(RandomEvEvent:new(i, num, randomEvent.duration, 0));
					else
						randomEvent.duration = 0;
						randomEvent.interval = 1000000;
						break;
					end;
				end;
				if randomEvent.name == "trafficViolation" then
					if g_currentMission.missionStats.money > 50000 then
						local money = math.random(1, 3)*1000;
						text = string.format(randomEvent.msgText, money, self.currencySymbol);
						g_server:broadcastEvent(RandomEvEvent:new(i, 0, 0, money));
						g_currentMission:addSharedMoney(-money, "other");
						g_currentMission:addMoneyChange(-money, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("penalties"));
					else
						randomEvent.duration = 0;
						randomEvent.interval = 0;
						break;
					end;
				end;
				self:showRandomEventMessage(text);
				break;
			end;
			if randomEvent.duration == 0 and randomEvent.interval == 0 and randomEvent.active then
				local text = randomEvent.stopText;
				if randomEvent.repeatEvent then
					randomEvent.interval = math.random(randomEvent.intervals[1], randomEvent.intervals[2]);
					if randomEvent.name == "factoryDamage" or randomEvent.name == "technologyViolation" or randomEvent.name == "sanitaryPenalty" then
						randomEvent.interval = self:setInterval(randomEvent.interval, true);
					end;
					if randomEvent.name == "fuelTheft" or randomEvent.name == "vehicleTheft" then
						randomEvent.interval = self:setInterval(randomEvent.interval, false);
					end;
					if randomEvent.name == "railRoadDamage" or randomEvent.name == "shipDamage" then
						g_server:broadcastEvent(RandomEvEvent:new(i, 0, 0, 0));
					end;
					randomEvent.active = false;
				end;
				if randomEvent.name == "repairWorks" then
					local base = self.RandomEventsBase;
					local num = base:getActiveRepairWork();
					if num > 0 then
						text = base:setRepairWorkState(num, false);
						g_server:broadcastEvent(RandomEvEvent:new(i, num, 0, 0));
					end;
				end;
				if text then
					self:showRandomEventMessage(text);
					break;
				end;
			end;
		end;
	end;
end;

function Economica:showRandomEventMessage(text)
	self.message = {
	["timer"] = self.EMmessageDuration,
	["title"] = self.TITLE_RANDOMEVENT,
	["buttons"] = self.BUTTONS_OK,
	["text"] = text,
	["callbackOK"] = self.callbackCloseMessage};
	if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
	self:onStartMessage();
end;

function Economica:saveRandomEvents(xmlFile)
	for i=1, #self.randomEvents do
		local key = string.format("economica.randomEvents.event(%d)", i-1);
		local randomEvent = self.randomEvents[i];
		setXMLString(xmlFile, key.."#name", randomEvent.name);
		if randomEvent.interval then
			setXMLInt(xmlFile, key.."#interval", randomEvent.interval);
			if randomEvent.duration > 0 then
				setXMLInt(xmlFile, key.."#duration", randomEvent.duration);
			end;
		end;
		setXMLBool(xmlFile, key.."#active", randomEvent.active);
	end;
	local REBase = self.RandomEventsBase;
	if REBase then
		if REBase.bigHailTimer > 0 then
			setXMLBool(xmlFile, "economica.randomEvents#enableBigHail", true);
		end;
		setXMLInt(xmlFile, "economica.randomEvents#activeRepairWork", REBase:getActiveRepairWork());
		setXMLString(xmlFile, "economica.randomEvents#repairWorkStates", REBase:getRepairWorkString());
	end;
end;
