--author: igor29381

function Economica:loadMissionsDefaultData(xmlFile)
	self.missionIntervals = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.extraMission#interval"), "2 4"))};
	self.missionPriceMultipliers = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.extraMission#priceMultiplier"), "2 3"))};
	self.missionDurations = {};
	self.missionVolumes = {};
	local i = 0;
	while true do
		local key = string.format("economica.extraMission.place(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local name = getXMLString(xmlFile, key.."#name");
		if name then
			self.missionDurations[name] = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, key.."#duration"), "4 7"))};
			self.missionVolumes[name] = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, key.."#volume"), "5000 50000"))};
		end;
		i = i + 1;
	end;
end;

function Economica:loadMissionsSaveData(xmlFile)
	local key = "economica.extraMission";
	if hasXMLProperty(xmlFile, key) then
		local shopName = getXMLString(xmlFile, key.."#shopName");
		local fillType = getXMLString(xmlFile, key.."#fillType");
		fillType = FillUtil.fillTypeNameToInt[fillType];
		local fillTypeName = fillTypeName(fillType);
		local volume = getXMLFloat(xmlFile, key.."#volume");
		local price = getXMLFloat(xmlFile, key.."#price");
		local duration = getXMLFloat(xmlFile, key.."#duration");
		self:registerNewExtraMission(shopName, fillType, volume, price, duration, false);
		self:activateExtraMission(false);
	end;
end;

function Economica:setMissionInterval()
	return math.random(self.missionIntervals[1], self.missionIntervals[2]);
end;

function Economica:missionsHourChanged()
	if #self.extraMissions > 0 then
		local mission = self.extraMissions[1];
		if mission.active then
			local shop = UniversalFactory[mission.shopName];
			if shop.isEnabled then
				self.enableExtraMissions = true;
			end;
		end;
	end;
end;

function Economica:updateMissions(dt)
	if not self.showMessage and self.missionInterval == 0 and #self.extraMissions == 0 then
		local numShop, fillType = self:getLowLevel(true);
		if numShop and fillType then
			local shopName = self.shops[numShop].factoryName;
			if self.missionDurations[shopName] then
				local duration = math.random(self.missionDurations[shopName][1], self.missionDurations[shopName][2])*60;
				self:newExtraMission(shopName, fillType, duration);
			end;
		end;
		self.missionInterval = self:setMissionInterval();
	end;
	if #self.extraMissions > 0 then
		local extraMission = self.extraMissions[1];
		if extraMission.active then
			local factory = UniversalFactory[extraMission.shopName];
			local fillType = factory.fillType[extraMission.fillType];
			if fillType.extraMission then
				if not self.showMessage then
					if fillType.extraMissionLevel >= extraMission.volume then
						local price = extraMission.price;
						local completedMissions = 1;
						local prize = false;
						g_currentMission:addSharedMoney(price, "missionIncome");
						g_currentMission:addMoneyChange(price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_missionIncome"));
						if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and self.randomEventsByNames.EMPrize
						and not self.randomEventsByNames.EMPrize.active and self.statistics.completedMissions >= self.statistics.missionPrize then
							local randomEvent = self.randomEventsByNames.EMPrize;
							randomEvent.active = true;
							completedMissions = 5;
							prize = true;
						end;
						self:showExtraMissionMessage(price, false, prize);
						self.statistics.completedMissions = self.statistics.completedMissions + completedMissions;
						self:cancelExtraMission();
						g_server:broadcastEvent(EconomicaExtraMissionEvent:new("empty", 0, 0, price, 0, false, prize));
					end;
					if extraMission.duration == 0 then
						local percent = fillType.extraMissionLevel/extraMission.volume;
						local penalty = extraMission.price*percent - extraMission.price*(1 - percent);
						g_currentMission:addSharedMoney(penalty, "missionIncome");
						local text = g_i18n:getText("finance_missionIncome");
						if penalty < 0 then
							text = g_i18n:getText("penalties");
						end;
						g_currentMission:addMoneyChange(penalty, FSBaseMission.MONEY_TYPE_SINGLE, true, text);
						self:showExtraMissionMessage(penalty, true);
						self.statistics.completedMissions = self.statistics.completedMissions - 1;
						self:cancelExtraMission();
						g_server:broadcastEvent(EconomicaExtraMissionEvent:new("empty", 0, 0, penalty, 0, true));
					end;
				end;
			end;
		end;
	end;
end;

function Economica:newExtraMission(shopName, fillType, duration)
	local shop = UniversalFactory[shopName];
	if shop and not self.showMessage then
		local shopFillType = shop.fillType[fillType];
		local multiplier = math.random(self.missionPriceMultipliers[1]*10, self.missionPriceMultipliers[2]*10)/10;
		local volume = math.min(math.random(self.missionVolumes[shopName][1]/1000, self.missionVolumes[shopName][2]/1000)*1000, shopFillType.capacity - shopFillType.level);
		volume = volume*Utils.clamp(self.rating/100, 0.25, 1);
		if self.rating < 50 then
			duration = duration + ((50 - self.rating)/10)*60;
		end;
		local priceMultiplier = shop.fillType[fillType].priceMultiplier;
		local price = FillUtil.fillTypeIndexToDesc[fillType].pricePerLiter*priceMultiplier*multiplier*self.difficultyMultiplier*volume;
		self:registerNewExtraMission(shopName, fillType, volume, price, duration, true);
		g_server:broadcastEvent(EconomicaExtraMissionEvent:new(shopName, fillType, volume, price, duration, false));
	end;
	self.missionInterval = self:setMissionInterval();
end;

function Economica:registerNewExtraMission(shopName, fillType, volume, price, duration, showMessage)
	local mission = {};
	mission.shopName = shopName;
	mission.fillType = fillType;
	mission.fillTypeName = fillTypeName(fillType);
	mission.volume = volume;
	mission.price = price;
	mission.duration = duration;
	if g_server then
		mission.nextMinute = duration/60;
	end;
	mission.active = false;
	table.insert(self.extraMissions, mission);
	UniversalFactory[shopName].fillType[fillType].extraMission = true;
	if showMessage then
		local text = self.msgText[self.MSG_EXTRAMISSION];
		text = string.format(text, g_i18n:getText(shopName), mission.fillTypeName, math.floor(price), self.currencySymbol, volume, string.format("%s.", g_i18n:getText("unit_liter")), timeToString(duration));
		self.message = {
		["timer"] = self.EMmessageDuration,
		["title"] = self.TITLE_EXTRAMISSION,
		["text"] = text,
		["buttons"] = self.BUTTONS_OK_CANCEL,
		["callbackOK"] = self.missionCallbackOK,
		["callbackCancel"] = self.missionCallbackCancel};
		if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
		self:onStartMessage();
	end;
end;

function Economica.missionCallbackOK()
	if g_server ~= nil then
		Economica:activateExtraMission(true);
	else
		g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(true, false, 0, 0, 0, false));
	end;
end;

function Economica.missionCallbackCancel()
	if g_server ~= nil then
		Economica:cancelExtraMission();
		Economica:onCloseMessage();
	else
		g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(false, true, 0, 0, 0, false));
	end;
end;

function Economica:showExtraMissionMessage(price, penalty, prize)
	local title = self.TITLE_MISSION_SUCCESSFUL;
	local text = self.msgText[self.MSG_CASH];
	if prize and self.randomEventsByNames.EMPrize then
		text = string.format("%s\n%s", text, self.randomEventsByNames.EMPrize.msgText);
	end;
	if penalty then
		title = self.TITLE_MISSION_FAILED;
		text = self.msgText[self.MSG_PENALTY];
	end;
	self.message = {
	["timer"] = self.EMmessageDuration,
	["title"] = title,
	["buttons"] = self.BUTTONS_OK,
	["text"] = string.format(text, math.abs(price), self.currencySymbol),
	["callbackOK"] = self.callbackCloseMessage};
	if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
	self:onStartMessage();
end;

function Economica:activateExtraMission(newLevel)
	self.enableExtraMissions = true;
	local mission = self.extraMissions[1];
	if mission then
		mission.active = true;
		local shop = UniversalFactory[mission.shopName];
		if shop.mapHotspot then
			shop.mapHotspot:setBlinking(true);
		end;
		local fillType = shop.fillType[mission.fillType];
		fillType.extraMission = true;
		if newLevel then
			fillType.extraMissionLevel = 0;
		end;
		if g_server then
			g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(true, false, 0, 0, 0, false));
		end;
		if self.message.title and self.message.title == self.TITLE_EXTRAMISSION then
			self:onCloseMessage();
		end;
	end;
end;

function Economica:cancelExtraMission()
	self.enableExtraMissions = false;
	local mission = self.extraMissions[1];
	if mission then
		local shop = UniversalFactory[mission.shopName];
		if shop.mapHotspot then
			shop.mapHotspot:setBlinking(false);
		end;
		local fillType = shop.fillType[mission.fillType];
		fillType.extraMission = false;
		fillType.extraMissionLevel = 0;
		table.remove(self.extraMissions);
		if g_server then
			g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, true, 0, 0, 0, false));
		end;
		if self.message.title and self.message.title == self.TITLE_EXTRAMISSION then
			self:onCloseMessage();
		end;
	end;
end;

function Economica:saveMissions(xmlFile)
	if #self.extraMissions > 0 and self.extraMissions[1].active then
		local key = "economica.extraMission";
		local mission = Economica.extraMissions[1];
		setXMLString(xmlFile, key.."#shopName", mission.shopName);
		setXMLString(xmlFile, key.."#fillType", FillUtil.fillTypeIntToName[mission.fillType]);
		setXMLFloat(xmlFile, key.."#volume", mission.volume);
		setXMLFloat(xmlFile, key.."#price", mission.price);
		setXMLFloat(xmlFile, key.."#duration", mission.duration);
	end;
end;
