--author: igor29381

function Economica:loadGreatDemandsDefaultData(xmlFile)
	self.greatDemandIntervals = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.greatDemands#interval"), "3 30"))};
	self.greatDemandDuration = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.greatDemands#duration"), "4 7"))};
end;

function Economica:loadGreatDemandsSaveData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.greatDemand(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local shopName = getXMLString(xmlFile, key.."#shopName");
		local fillType = getXMLString(xmlFile, key.."#fillType");
		fillType = FillUtil.fillTypeNameToInt[fillType];
		local fillTypeName = fillTypeName(fillType);
		local highLevel = getXMLBool(xmlFile, key.."#highLevel");
		local multiplier = getXMLFloat(xmlFile, key.."#multiplier");
		local pricePerCube = getXMLFloat(xmlFile, key.."#pricePerCube");
		local duration = getXMLInt(xmlFile, key.."#duration");
		if duration > self.greatDemandDuration[2] then
			duration = math.floor(duration/3600);
		end;
		self:registerNewGreatDemand(shopName, fillType, highLevel, multiplier, pricePerCube, duration, false);
		i = i + 1;
	end;
end;

function Economica:setGreatDemandInterval()
	return math.random(self.greatDemandIntervals[1], self.greatDemandIntervals[2]);
end;

function Economica:greatDemandsHourChanged()
	if #self.greatDemands > 0 then
		for i=1, #self.greatDemands do
			local greatDemand = self.greatDemands[i];
			local factory = UniversalFactory[greatDemand.shopName];
			if factory.isEnabled then
				greatDemand.duration = math.max(greatDemand.duration - 1, 0);
				local fillType = factory.fillType[greatDemand.fillType];
				fillType.greatDemandDuration = greatDemand.duration;
			end;
		end;
	end;
end;

function Economica:updateGreatDemands(dt)
	if not self.showMessage and self.greatDemandInterval == 0 then
		self.greatDemandInterval = self:setGreatDemandInterval();
		local numShop, fillType;
		local highLevel = math.random(1, 2) > 1;
		if not self.acceptedFillTypes[FillUtil.FILLTYPE_CEMENT] and not self.acceptedFillTypes[FillUtil.FILLTYPE_HOPS] then
			highLevel = false;
		end;
		if highLevel then
			numShop, fillType = self:getHighLevel();
		else
			numShop, fillType = self:getLowLevel(true);
		end;
		if numShop and fillType then
			local shop = self.shops[numShop];
			if shop then
				local shopName = shop.factoryName;
				local multiplier = math.random(3, 5)/10;
				if highLevel then
					multiplier = 1 - multiplier;
				else
					multiplier = 1 + multiplier;
				end;
				local duration = math.random(self.greatDemandDuration[1], self.greatDemandDuration[2]);
				local priceMultiplier = shop.fillType[fillType].priceMultiplier;
				local pricePerCube = FillUtil.fillTypeIndexToDesc[fillType].pricePerLiter*priceMultiplier*multiplier*self.difficultyMultiplier*1000;
				self:registerNewGreatDemand(shopName, fillType, highLevel, multiplier, pricePerCube, duration, true);
				g_server:broadcastEvent(EconomicaGreatDemandEvent:new(shopName, fillType, highLevel, multiplier, pricePerCube, duration, 0));
			end;
		end;
	end;
	if #self.greatDemands > 0 then
		for i=1, #self.greatDemands do
			local greatDemand = self.greatDemands[i];
			if not self.showMessage and greatDemand.duration == 0 then
				local fillType = UniversalFactory[greatDemand.shopName].fillType[greatDemand.fillType];
				greatDemand.pricePerCube = FillUtil.fillTypeIndexToDesc[greatDemand.fillType].pricePerLiter*fillType.priceMultiplier*self.difficultyMultiplier*1000;
				self:showGreatDemandMessage(i, self.MSG_PRICEBACK);
				g_server:broadcastEvent(EconomicaGreatDemandEvent:new("empty", 0, false, 0, greatDemand.pricePerCube, 0, i));
				self:removeGreatDemand(i);
			end;
		end;
	end;
end;

function Economica:registerNewGreatDemand(shopName, fillType, highLevel, multiplier, pricePerCube, duration, showMessage)
	local gd = {};
	gd.shopName = shopName;
	gd.fillType = fillType;
	gd.fillTypeName = fillTypeName(fillType);
	gd.highLevel = highLevel;
	local action = self.MSG_PRICEUP;
	if highLevel then action = self.MSG_PRICEDOWN; end;
	gd.multiplier = multiplier;
	gd.pricePerCube = pricePerCube;
	gd.duration = duration;
	local FT = UniversalFactory[shopName].fillType[fillType];
	FT.greatDemandDuration = duration;
	FT.priceDelta = multiplier;
	table.insert(self.greatDemands, gd);
	if showMessage then
		self:showGreatDemandMessage(#self.greatDemands, action);
	end;
end;

function Economica:showGreatDemandMessage(numGreatDemand, action)
	local greatDemand = self.greatDemands[numGreatDemand];
	if greatDemand then
		local text = self.msgText[action];
		text = string.format(text, g_i18n:getText(greatDemand.shopName), greatDemand.fillTypeName, math.floor(greatDemand.pricePerCube), self.currencySymbol, math.ceil(greatDemand.duration));
		self.message = {
		["timer"] = self.GDmessageDuration,
		["title"] = self.TITLE_GREATDEMAND,
		["buttons"] = self.BUTTONS_OK,
		["text"] = text,
		["callbackOK"] = self.callbackCloseMessage};
		if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
		self:onStartMessage();
	end;
end;

function Economica:removeGreatDemand(numGreatDemand)
	local greatDemand = self.greatDemands[numGreatDemand];
	local FT = UniversalFactory[greatDemand.shopName].fillType[greatDemand.fillType];
	FT.greatDemandDuration = nil;
	FT.priceDelta = 1;
	table.remove(self.greatDemands, numGreatDemand);
end;

function Economica:saveGreatDemands(xmlFile)
	for i=1, #self.greatDemands do
		local unit = self.greatDemands[i];
		local key = string.format("economica.greatDemand(%d)", i-1);
		setXMLString(xmlFile, key.."#shopName", unit.shopName);
		setXMLString(xmlFile, key.."#fillType", FillUtil.fillTypeIntToName[unit.fillType]);
		setXMLBool(xmlFile, key.."#highLevel", unit.highLevel);
		setXMLFloat(xmlFile, key.."#multiplier", unit.multiplier);
		setXMLFloat(xmlFile, key.."#pricePerCube", unit.pricePerCube);
		setXMLInt(xmlFile, key.."#duration", unit.duration);
	end;
end;
