--author: igor29381

EconomicaGreatDemandEvent = {};
EconomicaGreatDemandEvent_mt = Class(EconomicaGreatDemandEvent, Event);
InitEventClass(EconomicaGreatDemandEvent, "EconomicaGreatDemandEvent");

function EconomicaGreatDemandEvent:emptyNew()
	local self = Event:new(EconomicaGreatDemandEvent_mt);
    return self;
end;

function EconomicaGreatDemandEvent:new(shopName, fillType, highLevel, multiplier, pricePerCube, duration, numGreatDemand)
	local self = EconomicaGreatDemandEvent:emptyNew();
	self.shopName = shopName;
	self.fillType = fillType;
	self.highLevel = highLevel;
	self.multiplier = multiplier;
	self.pricePerCube = pricePerCube;
	self.duration = duration;
	self.numGreatDemand = numGreatDemand;
	return self;
end;

function EconomicaGreatDemandEvent:readStream(streamId, connection)
	local shopName = streamReadString(streamId);
	local fillType = streamReadInt8(streamId);
	local highLevel = streamReadBool(streamId);
	local multiplier = streamReadFloat32(streamId);
	local pricePerCube = streamReadFloat32(streamId);
	local duration = streamReadInt8(streamId);
	local numGreatDemand = streamReadInt8(streamId);
	if shopName ~= "empty" then
		Economica:registerNewGreatDemand(shopName, fillType, highLevel, multiplier, pricePerCube, duration, true);
	else
		Economica.greatDemands[numGreatDemand].pricePerCube = pricePerCube;
		Economica:showGreatDemandMessage(numGreatDemand, Economica.MSG_PRICEBACK);
		Economica:removeGreatDemand(numGreatDemand);
	end;
end;

function EconomicaGreatDemandEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.shopName);
	streamWriteInt8(streamId, self.fillType);
	streamWriteBool(streamId, self.highLevel);
	streamWriteFloat32(streamId, self.multiplier);
	streamWriteFloat32(streamId, self.pricePerCube);
	streamWriteInt8(streamId, self.duration);
	streamWriteInt8(streamId, self.numGreatDemand);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaExtraMissionEvent = {};
EconomicaExtraMissionEvent_mt = Class(EconomicaExtraMissionEvent, Event);
InitEventClass(EconomicaExtraMissionEvent, "EconomicaExtraMissionEvent");

function EconomicaExtraMissionEvent:emptyNew()
	local self = Event:new(EconomicaExtraMissionEvent_mt);
    return self;
end;

function EconomicaExtraMissionEvent:new(shopName, fillType, volume, price, duration, penalty, prize)
	local self = EconomicaExtraMissionEvent:emptyNew();
	self.shopName = shopName;
	self.fillType = fillType;
	self.volume = volume;
	self.price = price;
	self.duration = duration;
	self.penalty = penalty;
	self.prize = Utils.getNoNil(prize, false);
	return self;
end;

function EconomicaExtraMissionEvent:readStream(streamId, connection)
	local shopName = streamReadString(streamId);
	local fillType = streamReadInt8(streamId);
	local volume = streamReadFloat32(streamId);
	local price = streamReadFloat32(streamId);
	local duration = streamReadFloat32(streamId);
	local penalty = streamReadBool(streamId);
	local prize = streamReadBool(streamId);
	if shopName ~= "empty" then
		Economica:registerNewExtraMission(shopName, fillType, volume, price, duration, true);
	else
		Economica:showExtraMissionMessage(price, penalty, prize);
		Economica:cancelExtraMission();
	end;
end;

function EconomicaExtraMissionEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.shopName);
	streamWriteInt8(streamId, self.fillType);
	streamWriteFloat32(streamId, self.volume);
	streamWriteFloat32(streamId, self.price);
	streamWriteFloat32(streamId, self.duration);
	streamWriteBool(streamId, self.penalty);
	streamWriteBool(streamId, self.prize);
end;
----------------------------------------------------------------------------------------------------------------

EconomicaContractEvent = {};
EconomicaContractEvent_mt = Class(EconomicaContractEvent, Event);
InitEventClass(EconomicaContractEvent, "EconomicaContractEvent");

function EconomicaContractEvent:emptyNew()
	local self = Event:new(EconomicaContractEvent_mt);
    return self;
end;

function EconomicaContractEvent:new(contractData, numContract, stop, penalty, outputPenalty, noPutToHistory)
	local self = EconomicaContractEvent:emptyNew();
	self.contractData = contractData;
	self.numContract = numContract;
	self.stop = stop;
	self.penalty = penalty;
	self.outputPenalty = outputPenalty;
	self.noPutToHistory = noPutToHistory;
	return self;
end;

function EconomicaContractEvent:readStream(streamId, connection)
	local contractData = {};
	contractData.numShop = streamReadInt8(streamId);
	contractData.fillType = streamReadInt8(streamId);
	contractData.multiplier = streamReadFloat32(streamId);
	contractData.pricePerCube = streamReadFloat32(streamId);
	contractData.volume = streamReadFloat32(streamId);
	contractData.duration = streamReadInt16(streamId);
	contractData.waitInterval = streamReadInt8(streamId);
	local numContract = streamReadInt8(streamId);
	local stop = streamReadBool(streamId);
	local penalty = streamReadFloat32(streamId);
	local outputPenalty = streamReadInt32(streamId);
	local noPutToHistory = streamReadBool(streamId);
	if contractData.numShop > 0 then
		Economica:registerNewContract(contractData, true);
	elseif outputPenalty > 0 then
		g_currentMission:showBlinkingWarning(string.format("%s %d%s", g_i18n:getText("contractOutputPenalty"), math.floor(outputPenalty), g_i18n.globalI18N:getCurrencySymbol(true)), 3000);
	else
		Economica:showContractMessage(numContract, stop, penalty, noPutToHistory);
	end;
end;

function EconomicaContractEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.contractData.numShop);
	streamWriteInt8(streamId, self.contractData.fillType);
	streamWriteFloat32(streamId, self.contractData.multiplier);
	streamWriteFloat32(streamId, self.contractData.pricePerCube);
	streamWriteFloat32(streamId, self.contractData.volume);
	streamWriteInt16(streamId, self.contractData.duration);
	streamWriteInt8(streamId, self.contractData.waitInterval);
	streamWriteInt8(streamId, self.numContract);
	streamWriteBool(streamId, self.stop);
	streamWriteFloat32(streamId, self.penalty);
	streamWriteInt32(streamId, self.outputPenalty);
	streamWriteBool(streamId, self.noPutToHistory);
end;

-------------------------------------------------------------------------------------------------

EconomicaMessageCallbackEvent = {};
EconomicaMessageCallbackEvent_mt = Class(EconomicaMessageCallbackEvent, Event);

InitEventClass(EconomicaMessageCallbackEvent, "EconomicaMessageCallbackEvent");

function EconomicaMessageCallbackEvent:emptyNew()
	local self = Event:new(EconomicaMessageCallbackEvent_mt);
    return self;
end;

function EconomicaMessageCallbackEvent:new(activateExtraMission, cancelExtraMission, numContractToActivate, putOffContract, numContractToCancel, closeMessage, showContract)
	local self = EconomicaMessageCallbackEvent:emptyNew();
	self.activateExtraMission = activateExtraMission;
	self.cancelExtraMission = cancelExtraMission;
	self.numContractToActivate = numContractToActivate;
	self.putOffContract = putOffContract;
	self.numContractToCancel = numContractToCancel;
	self.closeMessage = closeMessage;
	self.showContract = Utils.getNoNil(showContract, 0);
	return self;
end;

function EconomicaMessageCallbackEvent:readStream(streamId, connection)
	local activateExtraMission = streamReadBool(streamId);
	local cancelExtraMission = streamReadBool(streamId);
	local numContractToActivate = streamReadInt8(streamId);
	local numputOffContract = streamReadInt8(streamId);
	local numContractToCancel = streamReadInt8(streamId);
	local closeMessage = streamReadBool(streamId);
	local showContract = streamReadInt8(streamId);
	if activateExtraMission then
		Economica:activateExtraMission(true);
	end;
	if cancelExtraMission then
		Economica:cancelExtraMission();
	end;
	if numContractToActivate > 0 then
		Economica:activateContract(numContractToActivate, true);
	end;
	if numputOffContract > 0 then
		Economica:putOffContract(numputOffContract);
	end;
	if numContractToCancel > 0 then
		Economica:cancelContract(numContractToCancel, closeMessage);
	end;
	if showContract > 0 then
		Economica:showContractMessage(showContract, false, 0, true);
		if g_server then
			g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, 0, false, showContract));
		end;
	end;
end;

function EconomicaMessageCallbackEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.activateExtraMission);
	streamWriteBool(streamId, self.cancelExtraMission);
	streamWriteInt8(streamId, self.numContractToActivate);
	streamWriteInt8(streamId, self.putOffContract);
	streamWriteInt8(streamId, self.numContractToCancel);
	streamWriteBool(streamId, self.closeMessage);
	streamWriteInt8(streamId, self.showContract);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaBuyableEvent = {};
EconomicaBuyableEvent_mt = Class(EconomicaBuyableEvent, Event);
InitEventClass(EconomicaBuyableEvent, "EconomicaBuyableEvent");

function EconomicaBuyableEvent:emptyNew()
	local self = Event:new(EconomicaBuyableEvent_mt);
    return self;
end;

function EconomicaBuyableEvent:new(name, fieldNumber, isOwned)
	local self = EconomicaBuyableEvent:emptyNew();
	self.name = name;
	self.fieldNumber = fieldNumber;
	self.isOwned = isOwned;
	return self;
end;

function EconomicaBuyableEvent:readStream(streamId, connection)
	local name = streamReadString(streamId);
	local fieldNumber = streamReadInt8(streamId);
	local isOwned = streamReadBool(streamId);
	if name ~= "empty" then
		if UniversalFactory[name] then self:buyFactory(name); end;
		if Garage.main.garages[name] then Garage.main.garages[name].isOwned = isOwned; end;
	elseif fieldNumber > 0 then
		local fieldDef = g_currentMission.fieldDefinitionBase.fieldDefs[fieldNumber];
		fieldDef.ownedByPlayer = isOwned;
		local baseColor = {1, 1, 1, 1};
		if isOwned then
			baseColor = {0.25, 1, 0.25, 1};
		end;
		fieldDef.fieldMapHotspot.baseColor = baseColor;
	end;
end;

function EconomicaBuyableEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.name);
	streamWriteInt8(streamId, self.fieldNumber);
	streamWriteBool(streamId, self.isOwned);
end;

function EconomicaBuyableEvent:buyFactory(name)
	local factory = UniversalFactory[name];
	if g_server and factory.rentCosts > 0 then
		g_currentMission:addSharedMoney(-factory.rentCosts, "other");
		g_currentMission:addMoneyChange(-factory.rentCosts, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("rent"));
		factory.rentCosts = 0;
	end;
	if factory.isFactory and not factory.enableIfOwned then
		for _,fillType in pairs(factory.fillType) do
			fillType.priceDelta = 1;
			fillType.level = Utils.getNoNil(fillType.rentLevel, 0);
			fillType.extraMission = false;
			fillType.extraMissionLevel = 0;
			fillType.contract = false;
			fillType.contractLevel = 0;
			fillType.rent = false;
			fillType.rentLevel = 0;
		end;
		factory:heapsMoving();
		factory.enableUpdateClients = true;
		for i=1, #factory.jobStreams do
			local jobStream = factory.jobStreams[i];
			jobStream.rentTimer = 0;
		end;
		for i=1, #Economica.greatDemands do
			if name == Economica.greatDemands[i].shopName then
				Economica:removeGreatDemand(i);
			end;
		end;
		if #Economica.extraMissions > 0 then
			if name == Economica.extraMissions[1].shopName then
				Economica:cancelExtraMission();
			end;
		end;
		for i=1, #Economica.contracts do
			if name == UniversalFactory.all[Economica.contracts[i].numShop].factoryName then
				Economica:cancelContract(i);
			end;
		end;
	elseif factory.isWarehouse then
		for _,fillType in pairs(factory.fillType) do
			fillType.level = Utils.getNoNil(fillType.rentLevel, 0);
			fillType.rentLevel = 0;
		end;
		factory:heapsMoving();
		factory.enableUpdateClients = true;
	end;
end;
----------------------------------------------------------------------------------------------------------------

EconomicaBuyCallbackEvent = {};
EconomicaBuyCallbackEvent_mt = Class(EconomicaBuyCallbackEvent, Event);
InitEventClass(EconomicaBuyCallbackEvent, "EconomicaBuyCallbackEvent");

function EconomicaBuyCallbackEvent:emptyNew()
	local self = Event:new(EconomicaBuyCallbackEvent_mt);
    return self;
end;

function EconomicaBuyCallbackEvent:new(name, buing, selling, request, numCoins, needAnswer)
	local self = EconomicaBuyCallbackEvent:emptyNew();
	self.name = name;
	self.buing = buing;
	self.selling = selling;
	self.request = request;
	self.numCoins = numCoins;
	self.needAnswer = needAnswer;
	return self;
end;

function EconomicaBuyCallbackEvent:readStream(streamId, connection)
	local name = streamReadString(streamId);
	local buing = streamReadBool(streamId);
	local selling = streamReadBool(streamId);
	local request = streamReadBool(streamId);
	local numCoins = streamReadInt8(streamId);
	local needAnswer = streamReadBool(streamId);
	if name then
		local buyable = Economica.buyables[name];
		if buyable then
			if buing then
				if buyable.numCoins > 0 then
					Economica.statistics.coinDeals = Economica.statistics.coinDeals + 1;
					Economica.statistics.ownedGoldCoins = Economica.statistics.ownedGoldCoins - buyable.numCoins;
					buyable.numCoins = 0;
				end;
				Economica:buyObject(name);
			end;
			if selling then Economica:sellObject(name); end;
			buyable.numCoins = numCoins;
			buyable.hasMessage = false;
			if not needAnswer then
				buyable.needAnswer = false;
			end;
			if request then
				Economica:priceRequestServer(name);
			end;
			if numCoins < 0 then
				Economica:badDeal(name);
			end;
			if not buing and not selling and not request then
				g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name, false));
			end;
		end;
	end;

end;

function EconomicaBuyCallbackEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.name);
	streamWriteBool(streamId, self.buing);
	streamWriteBool(streamId, self.selling);
	streamWriteBool(streamId, self.request);
	streamWriteInt8(streamId, self.numCoins);
	streamWriteBool(streamId, self.needAnswer);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaBuyableStateEvent = {};
EconomicaBuyableStateEvent_mt = Class(EconomicaBuyableStateEvent, Event);
InitEventClass(EconomicaBuyableStateEvent, "EconomicaBuyableStateEvent");

function EconomicaBuyableStateEvent:emptyNew()
	local self = Event:new(EconomicaBuyableStateEvent_mt);
    return self;
end;

function EconomicaBuyableStateEvent:new(name)
	local self = EconomicaBuyableStateEvent:emptyNew();
	self.name = name;
	return self;
end;

function EconomicaBuyableStateEvent:readStream(streamId, connection)
	local name = streamReadString(streamId);
	local buyable = Economica.buyables[name];
	if buyable then
		buyable.request = streamReadBool(streamId);
		buyable.ownerAgree = streamReadBool(streamId);
		buyable.ownerWantPrice = streamReadInt32(streamId);
		buyable.numCoins = streamReadInt8(streamId);
		buyable.isOwned = streamReadBool(streamId);
		buyable.hasMessage = streamReadBool(streamId);
		buyable.needAnswer = streamReadBool(streamId);
	end;
	if buyable.needAnswer and g_currentMission.isMasterUser then
		Economica:showRequestResult(name);
	end;
end;

function EconomicaBuyableStateEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.name);
	local buyable = Economica.buyables[self.name];
	if buyable then
		streamWriteBool(streamId, buyable.request);
		streamWriteBool(streamId, buyable.ownerAgree);
		streamWriteInt32(streamId, math.floor(buyable.ownerWantPrice));
		streamWriteInt8(streamId, buyable.numCoins);
		streamWriteBool(streamId, buyable.isOwned);
		streamWriteBool(streamId, buyable.hasMessage);
		streamWriteBool(streamId, buyable.needAnswer);
	end;
end;

----------------------------------------------------------------------------------------------------------------

EconomicaLowPriceSellEvent = {};
EconomicaLowPriceSellEvent_mt = Class(EconomicaLowPriceSellEvent, Event);
InitEventClass(EconomicaLowPriceSellEvent, "EconomicaLowPriceSellEvent");

function EconomicaLowPriceSellEvent:emptyNew()
	local self = Event:new(EconomicaLowPriceSellEvent_mt);
    return self;
end;

function EconomicaLowPriceSellEvent:new(name, price)
	local self = EconomicaLowPriceSellEvent:emptyNew();
	self.name = name;
	self.price = price;
	return self;
end;

function EconomicaLowPriceSellEvent:readStream(streamId, connection)
	local name = streamReadString(streamId);
	local price = streamReadInt32(streamId);
	if name ~= "" then
		if g_currentMission.isMasterUser then
			Economica:showLowPriceSellMessage(name, price);
		end;
		local buyable = Economica.buyables[name];
		if price > 0 then
			buyable.ownerWantPrice = price;
		else
			buyable.ownerWantPrice = buyable.price;
		end;
	end;
end;

function EconomicaLowPriceSellEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.name);
	streamWriteInt32(streamId, self.price);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaRatingEvent = {};
EconomicaRatingEvent_mt = Class(EconomicaRatingEvent, Event);
InitEventClass(EconomicaRatingEvent, "EconomicaRatingEvent");

function EconomicaRatingEvent:emptyNew()
	local self = Event:new(EconomicaRatingEvent_mt);
    return self;
end;

function EconomicaRatingEvent:new(rating, statistics)
	local self = EconomicaRatingEvent:emptyNew();
	self.rating = rating;
	self.statistics = statistics;
	return self;
end;

function EconomicaRatingEvent:readStream(streamId, connection)
	local rating = streamReadInt32(streamId);
	if g_server then
		Economica:updateRating();
	elseif rating > 0 then
		Economica.statistics.completedMissions = streamReadInt32(streamId);
		Economica.statistics.completedContracts = streamReadInt32(streamId);
		Economica.statistics.purchasedLicenses = streamReadInt32(streamId);
		Economica.statistics.ownedObjects = streamReadInt16(streamId);
		Economica.statistics.penaltyCutDownTrees = streamReadInt32(streamId);
		Economica.statistics.railroadPenalty = streamReadInt32(streamId);
		Economica.statistics.ownedGoldCoins = streamReadInt16(streamId);
		Economica.statistics.coinDeals = streamReadInt16(streamId);
		for name,_ in pairs(Economica.animalNames) do
			Economica.statistics.animalRating[name] = streamReadInt32(streamId);
		end;
		Economica.statistics.hectaresRating = streamReadInt32(streamId);
		Economica.statistics.playTimeRating = streamReadInt32(streamId);
		g_currentMission.missionInfo.threshedHectares = streamReadInt32(streamId);
		g_currentMission.missionInfo.playTime = streamReadInt32(streamId);
		Economica.rating = rating;
	end;
end;

function EconomicaRatingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.rating);
	if self.rating > 0 then
		streamWriteInt32(streamId, self.statistics.completedMissions);
		streamWriteInt32(streamId, self.statistics.completedContracts);
		streamWriteInt32(streamId, self.statistics.purchasedLicenses);
		streamWriteInt16(streamId, self.statistics.ownedObjects);
		streamWriteInt32(streamId, self.statistics.penaltyCutDownTrees);
		streamWriteInt32(streamId, self.statistics.railroadPenalty);
		streamWriteInt16(streamId, self.statistics.ownedGoldCoins);
		streamWriteInt16(streamId, self.statistics.coinDeals);
		for name,_ in pairs(Economica.animalNames) do
			streamWriteInt32(streamId, self.statistics.animalRating[name]);
		end;
		streamWriteInt32(streamId, self.statistics.hectaresRating);
		streamWriteInt32(streamId, self.statistics.playTimeRating);
		streamWriteInt32(streamId, math.floor(g_currentMission.missionInfo.threshedHectares));
		streamWriteInt32(streamId, math.floor(g_currentMission.missionInfo.playTime));
	end;
end;

----------------------------------------------------------------------------------------------------------------

EconomicaUpdateEvent = {};
EconomicaUpdateEvent_mt = Class(EconomicaUpdateEvent, Event);
InitEventClass(EconomicaUpdateEvent, "EconomicaUpdateEvent");

function EconomicaUpdateEvent:emptyNew()
	local self = Event:new(EconomicaUpdateEvent_mt);
    return self;
end;

function EconomicaUpdateEvent:new(name, index, currentValue)
	local self = EconomicaUpdateEvent:emptyNew();
	self.name = name;
	self.index = index;
	self.currentValue = currentValue;
	return self;
end;

function EconomicaUpdateEvent:readStream(streamId, connection)
	local name = streamReadString(streamId);
	local index = streamReadInt8(streamId);
	local currentValue = streamReadInt8(streamId);
	if name and index and currentValue then
		if g_server then
			local updateable = Economica.updateables[name][index];
			if updateable then
				local price = updateable.prices[currentValue];
				g_currentMission:addSharedMoney(-price, "other");
				Economica:updateObject(name, index, currentValue, true);
			end;
		else
			Economica:updateObject(name, index, currentValue, true);
		end;
	end;
end;

function EconomicaUpdateEvent:writeStream(streamId, connection)
	streamWriteString(streamId, self.name);
	streamWriteInt8(streamId, self.index);
	streamWriteInt8(streamId, self.currentValue);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaWoodEvent = {};
EconomicaWoodEvent_mt = Class(EconomicaWoodEvent, Event);
InitEventClass(EconomicaWoodEvent, "EconomicaWoodEvent");

function EconomicaWoodEvent:emptyNew()
	local self = Event:new(EconomicaWoodEvent_mt);
    return self;
end;

function EconomicaWoodEvent:new(newLicense, timer, numTrees)
	local self = EconomicaWoodEvent:emptyNew();
	self.newLicense = newLicense;
	self.timer = timer;
	self.numTrees = numTrees;
	return self;
end;

function EconomicaWoodEvent:readStream(streamId, connection)
	local newLicense = streamReadBool(streamId);
	local timer = streamReadInt8(streamId);
	local numTrees = streamReadInt8(streamId);
	if g_server then
		if newLicense then Economica:buyServerWoodLicense(); end;
	else
		if newLicense then
			Economica.woodLicense = {["timer"]=25, ["numTrees"]=numTrees};
		elseif timer > 0 then
			if numTrees == 0 then
				Economica.woodLicense = nil;
			else
				Economica.woodLicense.timer = timer;
				Economica.woodLicense.numTrees = numTrees;
			end;
		end;
	end;
end;

function EconomicaWoodEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.newLicense);
	streamWriteInt8(streamId, self.timer);
	streamWriteInt8(streamId, self.numTrees);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaGarbageEvent = {};
EconomicaGarbageEvent_mt = Class(EconomicaGarbageEvent, Event);
InitEventClass(EconomicaGarbageEvent, "EconomicaGarbageEvent");

function EconomicaGarbageEvent:emptyNew()
	local self = Event:new(EconomicaGarbageEvent_mt);
    return self;
end;

function EconomicaGarbageEvent:new(num)
	local self = EconomicaGarbageEvent:emptyNew();
	self.num = num;
	return self;
end;

function EconomicaGarbageEvent:readStream(streamId, connection)
	local num = streamReadInt8(streamId);
	if g_server then
		Economica.base:removeGarbage(num);
	else
		Economica.base:deleteGarbage(Economica.base.garbage[num].id);
		Economica.base.garbageStates[num] = 0;
	end;
end;

function EconomicaGarbageEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.num);
end;

----------------------------------------------------------------------------------------------------------------

EconomicaGoldCoinEvent = {};
EconomicaGoldCoinEvent_mt = Class(EconomicaGoldCoinEvent, Event);
InitEventClass(EconomicaGoldCoinEvent, "EconomicaGoldCoinEvent");

function EconomicaGoldCoinEvent:emptyNew()
	local self = Event:new(EconomicaGoldCoinEvent_mt);
    return self;
end;

function EconomicaGoldCoinEvent:new(num, num2, notFoundGoldCoins)
	local self = EconomicaGoldCoinEvent:emptyNew();
	self.num = num;
	self.num2 = num2;
	self.notFoundGoldCoins = notFoundGoldCoins;
	return self;
end;

function EconomicaGoldCoinEvent:readStream(streamId, connection)
	local num = streamReadInt16(streamId);
	local num2 = streamReadInt16(streamId);
	local notFoundGoldCoins = streamReadInt16(streamId);
	if g_server then
		Economica.base:changeGoldCoinState(num);
	else
		Economica.base:deleteGoldCoin(num2);
		Economica.base.notFoundGoldCoins = notFoundGoldCoins;
	end;
end;

function EconomicaGoldCoinEvent:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.num);
	streamWriteInt16(streamId, self.num2);
	streamWriteInt16(streamId, self.notFoundGoldCoins);
end;
