--author: igor29381

Economica = {};
Economica.shops = {};

Economica.TITLE_GREATDEMAND = 1;
Economica.TITLE_EXTRAMISSION = 2;
Economica.TITLE_CONTRACT = 3;
Economica.TITLE_MISSION_SUCCESSFUL = 4;
Economica.TITLE_MISSION_FAILED = 5;
Economica.TITLE_STOPCONTRACT = 6;
Economica.TITLE_REALTOR_AGENCY = 7;
Economica.TITLE_CONSTRUCTOR_AGENCY = 8;
Economica.TITLE_WOODLICENSING_AGENCY = 9;
Economica.TITLE_AIRSPRAYER = 10;
Economica.TITLE_RANDOMEVENT = 11;

Economica.BUTTONS_OK = 1;
Economica.BUTTONS_OK_CANCEL = 2;
Economica.BUTTONS_OK_CANCEL_PUT_OFF = 3;
Economica.BUTTONS_PREV_CANCEL_NEXT = 4;

Economica.MSG_PRICEUP = 1;
Economica.MSG_PRICEDOWN = 2;
Economica.MSG_PRICEBACK = 3;
Economica.MSG_EXTRAMISSION = 4;
Economica.MSG_CASH = 5;
Economica.MSG_PENALTY = 6;
Economica.MSG_NEWCONTRACT = 7;
Economica.MSG_STOPCONTRACT = 8;
Economica.MSG_WAITPRICE = 9;
Economica.MSG_OWNERWANT = 10;
Economica.MSG_OWNERDONOTWANT = 11;
Economica.MSG_LOWPRICE = 12;
Economica.MSG_LOWPRICEFIN = 13;
Economica.MSG_MAYBECOINS = 14;
Economica.MSG_MORERATING = 15;
Economica.MSG_WOODLICENSE = 16;
Economica.MSG_AIRSPRAYER = 17;
Economica.MSG_CONFIRMAIRSPRAYER = 18;

source(g_currentModDirectory.."maps/scripts/Economica/Buyables.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/Contracts.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/Events.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/GreatDemands.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/Missions.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/RandomEvents.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/Updateables.lua", "Perestroyka");
source(g_currentModDirectory.."maps/scripts/Economica/WoodLicense.lua", "Perestroyka");

function Economica:loadMap(name)
	self.statistics = {};
	self.animalNames = {["cow"] = g_i18n:getText("statistic_cowOwned"),
						["sheep"] = g_i18n:getText("statistic_sheepOwned"),
						["pig"] = g_i18n:getText("statistic_pigOwned")};
						--["chicken"] = g_i18n:getText("statistic_chickenOwned")};
	self.statistics.animalRating = {};
	for name,_ in pairs(self.animalNames) do
		self.statistics.animalRating[name] = 0;
	end;
	self.greatDemands = {};
	self.extraMissions = {};
	self.contracts = {};
	self.emptyContractData = {["numShop"]=0,["fillType"]=0,["multiplier"]=0,["volume"]=0,["duration"]=0,["waitInterval"]=0,["pricePerCube"]=0};
	self.buyables = {};
	self.updateables = {};
	self.randomEvents = {};
	self.randomEventsByNames = {};
	self.randomEventsNameToInt = {};
	self.randomEventsIntToName = {};
	self.messageHud = createImageOverlay(TrafficManager.curModDir.."maps/scripts/huds/messageHud.dds");
	self.mapHud = createImageOverlay(TrafficManager.curModDir.."maps/pda_map_H.dds");
	local soundPreview = TrafficManager.curModDir.."maps/sounds/preview.wav";
	if fileExists(soundPreview) then
		self.previewSound = createSample("Preview");
		loadSample(self.previewSound, soundPreview, false);
	end;
	local goldCoinPickupSound = TrafficManager.curModDir.."maps/sounds/goldCoinPickupSound.wav";
	if fileExists(goldCoinPickupSound) then
		Economica.goldCoinPickupSound = createSample("goldCoinPickupSound");
		loadSample(Economica.goldCoinPickupSound, goldCoinPickupSound, false);
	end;
	self.difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
	self.currencySymbol = g_i18n.globalI18N:getCurrencySymbol(true);
	self.msgText = {};
	self.msgText[self.MSG_PRICEUP] = string.gsub(g_i18n:getText("priceUp"), "@", "\n");
	self.msgText[self.MSG_PRICEDOWN] = string.gsub(g_i18n:getText("priceDown"), "@", "\n");
	self.msgText[self.MSG_PRICEBACK] = string.gsub(g_i18n:getText("priceBack"), "@", "\n");
	self.msgText[self.MSG_EXTRAMISSION] = string.gsub(g_i18n:getText("extraMissionText"), "@", "\n");
	self.msgText[self.MSG_CASH] = g_i18n:getText("cash");
	self.msgText[self.MSG_PENALTY] = g_i18n:getText("penalty");
	self.msgText[self.MSG_NEWCONTRACT] = string.gsub(g_i18n:getText("concludeContract"), "@", "\n");
	self.msgText[self.MSG_STOPCONTRACT] = g_i18n:getText("breaksContract");
	self.msgText[self.MSG_WAITPRICE] = g_i18n:getText("waitPrice");
	self.msgText[self.MSG_OWNERWANT] = string.gsub(g_i18n:getText("ownerWant"), "@", "\n");
	self.msgText[self.MSG_OWNERDONOTWANT] = string.gsub(g_i18n:getText("ownerDoNotWant"), "@", "\n");
	self.msgText[self.MSG_LOWPRICE] = string.gsub(g_i18n:getText("lowPrice"), "@", "\n");
	self.msgText[self.MSG_LOWPRICEFIN] = g_i18n:getText("lowPricefinished");
	self.msgText[self.MSG_MAYBECOINS] = string.gsub(g_i18n:getText("mayBeCoins"), "@", "\n");
	self.msgText[self.MSG_MORERATING] = string.format("%s \n %s", g_i18n:getText("blockedDeal"), g_i18n:getText("needMoreRating"));
	self.msgText[self.MSG_WOODLICENSE] = string.gsub(g_i18n:getText("woodLicense"), "@", "\n");
	self.msgText[self.MSG_AIRSPRAYER] = string.format(g_i18n:getText("flight"), 1000, self.currencySymbol);
	self.msgText[self.MSG_CONFIRMAIRSPRAYER] = g_i18n:getText("confirmAirSprayer");
	self.messageHistory = {};
	if self.fieldConfigurationMap == nil then
        self.fieldConfigurationMap = createBitVectorMap("fieldConfigurationMap");
		loadBitVectorMapFromFile(self.fieldConfigurationMap, TrafficManager.curModDir.."maps/map01/fieldConfigurationMap.grle", 2);
        self.fieldConfigurationMapWidth, self.fieldConfigurationMapHeight = getBitVectorMapSize(self.fieldConfigurationMap);
    end
	g_currentMission.environment:addHourChangeListener(self);
	local xmlPath = TrafficManager.curModDir.."maps/scripts/Economica/Economica.xml";
	if fileExists(xmlPath) then
		local xmlFile = loadXMLFile("Economica", xmlPath);
		self.GDmessageDuration = Utils.getNoNil(getXMLInt(xmlFile, "economica.greatDemands#messageDuration"), 20);
		self.EMmessageDuration = Utils.getNoNil(getXMLInt(xmlFile, "economica.extraMission#messageDuration"), 20);
		self.ConMessageDuration = Utils.getNoNil(getXMLInt(xmlFile, "economica.contract#messageDuration"), 20);
		self.buyMessageDuration = Utils.getNoNil(getXMLInt(xmlFile, "economica.buyables#messageDuration"), 20);
		self.autoOutputPrice = Utils.getNoNil(getXMLFloat(xmlFile, "economica.pricePerCube#autoOutput"), 50)*0.001;
		self.rentPrice = Utils.getNoNil(getXMLFloat(xmlFile, "economica.pricePerCube#rent"), 10)/1440*0.001;
		if g_server then
			self:loadContractsDefaultData(xmlFile);
			self:loadMissionsDefaultData(xmlFile);
			self:loadGreatDemandsDefaultData(xmlFile);
			if hasXMLProperty(xmlFile, "economica.fillLevelCurves") then
				self.fillLevelCurves = {};
				local i = 0;
				while true do
					local key = string.format("economica.fillLevelCurves.curve(%d)", i);
					if not hasXMLProperty(xmlFile, key) then break; end;
					local value = getXMLString(xmlFile, key.."#value");
					value = {Utils.getVectorFromString(value)};
					table.insert(self.fillLevelCurves, value);
					i = i + 1;
				end;
			end;
			if hasXMLProperty(xmlFile, "economica.rentCoeffs") then
				self.rentCoeffs = {};
				local i = 0;
				while true do
					local key = string.format("economica.rentCoeffs.coeff(%d)", i);
					if not hasXMLProperty(xmlFile, key) then break; end;
					local fillTypes = getXMLString(xmlFile, key.."#fillTypes");
					local value = getXMLFloat(xmlFile, key.."#value");
					fillTypes = Utils.splitString(" ", fillTypes);
					for f=1, #fillTypes do
						local fillType = fillTypes[f];
						fillType = FillUtil.fillTypeNameToInt[fillType];
						if fillType then
							self.rentCoeffs[fillType] = value;
						end;
					end;
					i = i + 1;
				end;
			end;
		end;
		self:loadBuyablesDefaultData(xmlFile);
		self:loadUpdateablesDefaultData(xmlFile);
		self:loadRandomEventsDefaultData(xmlFile);
		self:loadWoodLicenseDefaultData(xmlFile);
		delete(xmlFile);
	end;
	self.titles = {"greatDemand", "extraMission", "contract", "mission_successful", "mission_failed",
	"stopContract", "realtorAgency", "constructorAgency", "woodlicensingAgency", "hirePlane", "randomEvent"};
	self.enableAgency = false;
	self.enableExtraMissions = false;
	self.active = false;
	self.activate = false;
	self.activated = false;
	self.callMode = false;
	self.UFHUDactive = false;
	self.hudsState = {};
	self.message = {};
	self.action = "";
	self.showMessage = false;
	self.transparentText = 1;
	self.updateMode = false;
	self.lowPriceActivated = false;
	self.mPos={0,0,0,0};
	self.statistics.completedMissions = 0;
	self.statistics.completedContracts = 0;
	self.statistics.contractPrize = math.random(4, 7);
	self.statistics.missionPrize = math.random(4, 7);
	self.statistics.purchasedLicenses = 0;
	self.statistics.ownedObjects = 0;
	self.statistics.penaltyCutDownTrees = 0;
	self.statistics.railroadPenalty = 0;
	self.statistics.ownedGoldCoins = 0;
	self.statistics.coinDeals = 0;
	self.rating = 0;
	self.airSprayerHour = 0;
	g_currentMission.environment:addMinuteChangeListener(self);
	if g_server then
		self.lowPriceSellObjectName = "";
		local xmlPath = "EconomicaSaves.xml";
		if g_currentMission.missionInfo.savegameDirectory then
			xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/EconomicaSaves.xml";
		end;
		if fileExists(xmlPath) then
			local xmlFile = loadXMLFile("EconomicaSaves", xmlPath);
			self:loadContractsSaveData(xmlFile);
			self:loadMissionsSaveData(xmlFile);
			self:loadGreatDemandsSaveData(xmlFile);
			self:loadBuyablesSaveData(xmlFile);
			self:loadUpdateablesSaveData(xmlFile);
			self:loadRandomEventsSaveData(xmlFile);
			self:loadWoodLicenseSaveData(xmlFile);
			local i = 0;
			while true do
				local key = string.format("economica.messages.message(%d)", i);
				if not hasXMLProperty(xmlFile, key) then break; end;
				local message = {};
				message.title = getXMLInt(xmlFile, key.."#title");
				message.day = getXMLInt(xmlFile, key.."#day");
				message.time = getXMLString(xmlFile, key.."#time");
				message.text = getXMLString(xmlFile, key.."#text");
				table.insert(self.messageHistory, message);
				i = i + 1;
			end;
			self.greatDemandInterval = math.min(Utils.getNoNil(getXMLInt(xmlFile, "economica.intervals#greatDemand"), self.greatDemandIntervals[2]), self.greatDemandIntervals[2]);
			self.missionInterval = math.min(Utils.getNoNil(getXMLInt(xmlFile, "economica.intervals#extraMission"), self.missionIntervals[2]), self.missionIntervals[2]);
			self.contractInterval = math.min(Utils.getNoNil(getXMLInt(xmlFile, "economica.intervals#contract"), self.contractIntervals[2]), self.contractIntervals[2]);
			self.lowPriceSellInterval = math.min(Utils.getNoNil(getXMLInt(xmlFile, "economica.intervals#lowPriceSell"), self.lowPriceSellIntervals[2]), self.lowPriceSellIntervals[2]);
			self.airSprayerHour = Utils.getNoNil(getXMLInt(xmlFile, "economica.intervals#airSprayerHour"), 0);
			self.statistics.completedMissions = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#completedMissions"), 0);
			self.statistics.completedContracts = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#completedContracts"), 0);
			local contractPrize = getXMLInt(xmlFile, "economica.statistics#contractPrize");
			if contractPrize then
				self.statistics.contractPrize = contractPrize;
			else
				self.statistics.contractPrize = self.statistics.contractPrize + self.statistics.completedContracts;
			end;
			local missionPrize = getXMLInt(xmlFile, "economica.statistics#missionPrize");
			if missionPrize then
				self.statistics.missionPrize = missionPrize;
			else
				self.statistics.missionPrize = self.statistics.missionPrize + self.statistics.completedMissions;
			end;
			self.statistics.purchasedLicenses = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#purchasedLicenses"), 0);
			self.statistics.penaltyCutDownTrees = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#penaltyCutDownTrees"), 0);
			self.statistics.railroadPenalty = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#railroadPenalty"), 0);
			self.statistics.ownedGoldCoins = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#ownedGoldCoins"), 0);
			self.statistics.coinDeals = Utils.getNoNil(getXMLInt(xmlFile, "economica.statistics#coinDeals"), 0);
			delete(xmlFile);
		else
			self.greatDemandInterval = self:setGreatDemandInterval();
			self.missionInterval = self:setMissionInterval();
			self.contractInterval = self:setContractInterval();
			self.lowPriceSellInterval = self:setLowPriceSellInterval();
		end;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] then
			local ownedFactories = 0;
			for i=1, #UniversalFactory.Factories do
				local factory = UniversalFactory.Factories[i];
				if factory.foodFactory and factory.isOwned then
					ownedFactories = ownedFactories + 1;
				end;
			end;
			if ownedFactories >= 2 then
				local randomEvent = self.randomEventsByNames.technologyViolation;
				if randomEvent and randomEvent.interval > 10000 then
					randomEvent.interval = self:setInterval(math.random(randomEvent.intervals[1], randomEvent.intervals[2]), true);
				end;
				randomEvent = self.randomEventsByNames.sanitaryPenalty;
				if randomEvent and randomEvent.interval > 10000 then
					randomEvent.interval = self:setInterval(math.random(randomEvent.intervals[1], randomEvent.intervals[2]), true);
				end;
			end;
		end;
	end;
	print("Economica loaded");
end;

function Economica:deleteMap()
	if g_currentMission.environment then
		g_currentMission.environment:removeHourChangeListener(self);
		g_currentMission.environment:removeMinuteChangeListener(self);
	end;
	self.woodLicense = nil;
    if self.fieldConfigurationMap ~= nil then
        delete(self.fieldConfigurationMap);
        self.fieldConfigurationMap = nil;
    end
end;

function Economica:mouseEvent(posX, posY, isDown, isUp, button)
	if self.active or self.showMessage then
		if isDown and button == 1 then
			self.mPos[3] = posX;
			self.mPos[4] = posY;
		end;
		self.mPos[1] = posX;
		self.mPos[2] = posY;
	end;
end;

function Economica:keyEvent(unicode, sym, modifier, isDown)
end;

function Economica:mapCoordsToScreen(x, z)
	if x ~= nil and z ~= nil then
		x = 0.5 + x/4096;
		z =-(z/4096 - 0.5);
		return x, z;
	end;
	return 0, 0;
end;

function Economica:getOwnedTerritory(x,z)
    if self.fieldConfigurationMap ~= nil then
        local gridX,gridZ = g_currentMission:convertWorldToFieldOwnershipPosition(x,z);
        return g_currentMission:getIsFieldOwnedAtWorldPos(x,z) and getBitVectorMapPoint(self.fieldConfigurationMap, gridX, gridZ, 0, 1) == 0;
    end
    return false;
end;

function Economica:setInterval(interval, day)
	local delta = 0;
	local days = math.floor(interval/24);
	if day then
		delta = math.random(8, 16);
	else
		delta = math.random(0, 4);
	end;
	return days*24 + delta;
end;

function Economica:setRains()
	if g_server then
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and Economica.randomEventsByNames.bigHail and Economica.randomEventsByNames.bigHail.interval > 0 then
			local env = g_currentMission.environment;
			for i=1, #env.rains do
				local rain = env.rains[i];
				if rain.rainTypeId == "hail" then
					rain.rainTypeId = "rain";
				end;
			end;
		end;
	end;
end;

function Economica:updateShops()
	self.shops = {};
	self.breakables = {};
	self.shopNamesToInt = {};
	for i=1, #UniversalFactory.all do
		local factory = UniversalFactory.all[i];
		factory:setOutputFillTypes();
		if not factory.isWarehouse and not factory.enableIfOwned and not factory.husbandry then
			if not factory.isOwned then
				table.insert(self.shops, factory);
				self.shopNamesToInt[factory.factoryName] = #self.shops;
			end;
			table.insert(self.breakables, factory);
		end;
	end;
	if g_server then
		self.acceptedFillTypes = {};
		for i=1, 51 do
			self.acceptedFillTypes[i] = true;
		end;
		self.acceptedFillTypes[FillUtil.FILLTYPE_RYE] = true;
		self.acceptedFillTypes[FillUtil.FILLTYPE_ONION] = true;
		self.acceptedFillTypes[FillUtil.FILLTYPE_CARROT] = true;
		for i=1, #UniversalFactory.Factories do
			local factory = UniversalFactory.Factories[i];
			if factory.isOwned then
				for n,_ in pairs(factory.fillType) do
					self.acceptedFillTypes[n] = true;
				end;
			end;
		end;
		self.numNotBought = 0;
		for _,buyable in pairs(self.buyables) do
			if not buyable.isOwned then self.numNotBought = self.numNotBought + 1; end;
		end;
	end;
end;

function Economica:setRandomCurve()
	for i=1, #UniversalFactory.all do
		local factory = UniversalFactory.all[i];
		if not factory.isOwned and not factory.isWarehouse and not factory.transportStation and not factory.enableIfOwned then
			for _,ft in pairs(factory.fillType) do
				ft.curve = math.random(1, #self.fillLevelCurves);
				ft.minuteToChange = math.random(1, 20);
			end;
		end;
	end;
end;

function Economica:getLowLevel(transportStation)
	local numShop, fillTypeIndex;
	local fillTypes = {};
	local shopNumbers = {};
	for i=1, #self.shops do
		local shop = self.shops[i];
		if shop.isEnabled then
			local enable = true;
			if shop.transportStation then enable = transportStation; end;
			if enable then
				for num,fillType in pairs(shop.fillType) do
					if (FillUtil.fillTypeIndexToDesc[num].showOnPriceTable or num == FillUtil.FILLTYPE_MILK) and self.acceptedFillTypes[num]
					and fillType.inputFillType and fillType.priceDelta == 1 and not fillType.extraMission and not fillType.contract
					and not fillType.autoInput and not fillType.rent then
						local percent = fillType.level/fillType.capacity;
						if fillType.level/fillType.capacity <= 0.2 then
							table.insert(fillTypes, num);
							table.insert(shopNumbers, i);
						end;
					end;
				end;
			end;
		end;
	end;
	if #fillTypes > 0 and #shopNumbers > 0 then
		local index = math.random(1, #fillTypes);
		fillTypeIndex = fillTypes[index];
		numShop = shopNumbers[index];
	end;
	return numShop, fillTypeIndex;
end;

function Economica:getHighLevel()
	local numShop, fillTypeIndex;
	local fillTypes = {};
	local shopNumbers = {};
	for i=1, #self.shops do
		local shop = self.shops[i];
		if shop.isEnabled then
			local enable = true;
			for num,fillType in pairs(shop.fillType) do
				if FillUtil.fillTypeIndexToDesc[num].showOnPriceTable and self.acceptedFillTypes[num]
				and fillType.outputFillType and fillType.priceDelta == 1 and not fillType.extraMission and not fillType.contract
				and not fillType.autoInput and not fillType.rent then
					local percent = fillType.level/fillType.capacity;
					if fillType.level/fillType.capacity >= 0.8 then
						table.insert(fillTypes, num);
						table.insert(shopNumbers, i);
					end;
				end;
			end;
		end;
	end;
	if #fillTypes > 0 and #shopNumbers > 0 then
		local index = math.random(1, #fillTypes);
		fillTypeIndex = fillTypes[index];
		numShop = shopNumbers[index];
	end;
	return numShop, fillTypeIndex;
end;

function Economica:changeHudStates(state)
	if state then
		g_currentMission.renderTime = self.hudsState[1];
		g_gameSettings:setValue("showHelpMenu", self.hudsState[2]);
		g_currentMission.showHudEnv  = self.hudsState[3];
		g_currentMission.showWeatherForecast = self.hudsState[4];
		g_currentMission.showVehicleInfo = self.hudsState[5];
		g_currentMission.showVehicleSchema = self.hudsState[6];
	else
		self.hudsState[1] = g_currentMission.renderTime;
		self.hudsState[2] = g_gameSettings:getValue("showHelpMenu");
		self.hudsState[3] = g_currentMission.showHudEnv;
		self.hudsState[4] = g_currentMission.showWeatherForecast;
		self.hudsState[5] = g_currentMission.showVehicleInfo;
		self.hudsState[6] = g_currentMission.showVehicleSchema;
		g_currentMission.renderTime = false;
		g_gameSettings:setValue("showHelpMenu", false);
		g_currentMission.showHudEnv  = false;
		g_currentMission.showWeatherForecast = false;
		g_currentMission.showVehicleInfo = false;
		g_currentMission.showVehicleSchema = false;
	end;
end;

function Economica:hourChanged()
	Economica.enableAgency = g_currentMission.environment.currentHour >= 8 and g_currentMission.environment.currentHour < 18;
	if not Economica.enableAgency then
		if Economica.active then
			Economica:onCloseMap();
		end;
		if Economica.showMessage and Economica.message.title == Economica.TITLE_WOODLICENSING_AGENCY then
			Economica:onCloseMessage();
		end;
	end;
	if g_server then
		Economica:updateRating();
		self.greatDemandInterval = math.max(self.greatDemandInterval - 1, 0);
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] then
			self.missionInterval = math.max(self.missionInterval - 1, 0);
		end;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_CONTRACTS] then
			self.contractInterval = math.max(self.contractInterval - 1, 0);
		end;
		self.lowPriceSellInterval = math.max(self.lowPriceSellInterval - 1, 0);
	end;
	if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_CONTRACTS] then
		self:contractsHourChanged();
	end;
	self.enableExtraMissions = false;
	if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] then
		self:missionsHourChanged();
	end;
	self:greatDemandsHourChanged();
	if self.woodLicense then
		self:woodLicenseHourChanged();
	end;
	if g_server then
		if self.airSprayerHour > 0 then
			self.airSprayerHour = math.max(self.airSprayerHour - 1, 0);
			if self.airSprayerHour == 0 then
				local airSprayer = TrafficManager.AirSprayer;
				if airSprayer:getIsActivatable() then
					local numField = math.random(1, #g_currentMission.fieldDefinitionBase.unownedFields);
					numField = g_currentMission.fieldDefinitionBase.unownedFields[numField].fieldNumber;
					if airSprayer.splines[numField] then
						airSprayer.currentSpline = numField;
						airSprayer.currentChemical = 1;
						g_server:broadcastEvent(AirSprayerEvent:new(numField, 1, airSprayer));
						AirSprayerFlightEvent:startSprayer(0, false, airSprayer, true);
					end;
				end;
			end;
		end;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] then
			self:randomEventsHourChanged();
		end;
	end;
end;

function Economica:minuteChanged()
	if g_server and UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] and self.enableExtraMissions and self.extraMissions[1] then
		self.base:raiseDirtyFlags(self.base.economicaDirtyFlag);
	end;
end;

function Economica:update(dt)
	local timeScale = g_currentMission.missionInfo.timeScale;
	if self.activate and not self.active and not self.showMessage then
		self.active = true;
		self.activate = false;
		self.activated = true;
		self:changeHudStates(false);
		InputBinding.setShowMouseCursor(true);
		g_currentMission.player.lockedInput = true;
		if UniversalFactoryHUD.active then
			self.UFHUDactive = true;
			UniversalFactoryHUD.active = false;
		else
			self.UFHUDactive = false;
		end;
	end;

	if g_server then
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and not self.showMessage then
			self:updateRandomEvents(dt);
		end;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_CONTRACTS] then
			self:updateContracts(dt);
		end;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] then
			self:updateMissions(dt);
		end;
		self:updateGreatDemands(dt);
		if self.enableAgency then
			self:updateBuyables(dt, timeScale);
		end;
	end;
	if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEXTRAMISSION] and self.enableExtraMissions and self.extraMissions[1] then
		local mission = self.extraMissions[1];
		mission.duration = math.max(mission.duration - dt*0.001, 0);
	end;
	if self.showMessage then
		self.message.timer = math.max(self.message.timer - dt*0.001, 0);
		if self.message.timer == 0 then
			if g_server then
				if self.message.contract and self.contracts[self.message.contract] and not self.contracts[self.message.contract].active then
					self:putOffContract(self.message.contract);
				end;
				if self.message.name then
					local buyable = self.buyables[self.message.name];
					if buyable and buyable.needAnswer then
						buyable.hasMessage = true;
						g_server:broadcastEvent(EconomicaBuyableStateEvent:new(self.message.name));
					end;
				end;
				if self.message.title == self.TITLE_EXTRAMISSION and self.message.callbackCancel then
					self.message.callbackCancel();
				end;
			end;
			self:onCloseMessage();
		end;
		if self.message.name and self.message.request then
			local buyable = self.buyables[self.message.name];
			if buyable and not buyable.needAnswer then
				self:onCloseMessage();
			end;
		end;
	end;
end;

function Economica:showAirSprayerMessage(price, confirm)
	if not self.showMessage then
		local msgText = self.msgText[self.MSG_CONFIRMAIRSPRAYER];
		local callbackOK = Economica.confirmAirSprayer;
		local callbackCancel = Economica.callbackCloseMessage;
		if not confirm then
			msgText = self.msgText[self.MSG_AIRSPRAYER];
			callbackOK = Economica.airSprayerFlight;
			callbackCancel = Economica.airSprayerNoFlight;
		end;
		self.message = {
		["timer"] = self.buyMessageDuration,
		["title"] = self.TITLE_AIRSPRAYER,
		["buttons"] = self.BUTTONS_OK_CANCEL,
		["text"] = msgText,
		["name"] = price,
		["callbackOK"] = callbackOK,
		["callbackCancel"] = callbackCancel};
		self:onStartMessage(true);
	end;
end;

function Economica.confirmAirSprayer(price)
	Economica:onCloseMessage();
	if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FLIGHTDIALOG] then
		Economica:showAirSprayerMessage(price, false);
	else
		Economica.airSprayerNoFlight(price);
	end;
end;

function Economica.airSprayerFlight(price)
	local airSprayer = TrafficManager.AirSprayer;
	airSprayer.camera:onActivate();
	g_currentMission.hasSpecialCamera = true;
	if g_server then
		AirSprayerFlightEvent:startSprayer(price, true, airSprayer);
	else
		g_client:getServerConnection():sendEvent(AirSprayerFlightEvent:new(price, true, airSprayer));
	end;
	Economica:onCloseMessage();
end;

function Economica.airSprayerNoFlight(price)
	local airSprayer = TrafficManager.AirSprayer;
	if g_server then
		AirSprayerFlightEvent:startSprayer(price, false, airSprayer);
	else
		g_client:getServerConnection():sendEvent(AirSprayerFlightEvent:new(price, false, airSprayer));
	end;
	Economica:onCloseMessage();
end;

function Economica:draw()
	if self.showMessage then
		local message = self.message;
		setTextColor(1, 1, 1, 1);
		setTextBold(true);
		local fontSize = UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE]+0.001;--0.016;
		local fontScale = 1-(UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE]-0.015)*40;
		if g_screenWidth/g_screenHeight < 1.5 then
			fontSize = UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE]-0.001;--0.014;
			fontScale = fontScale - 0.15;
		end;
		if message.title == self.TITLE_WOODLICENSING_AGENCY then
			setTextWidthScale(fontScale);
		end;
		setTextAlignment(RenderText.ALIGN_CENTER);
		renderOverlay(self.messageHud, 0.3, 0.4, 0.4, 0.2);
		renderText(0.5, 0.58, fontSize+0.005, g_i18n:getText(self.titles[message.title]));
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_LEFT);
		if message.historyText then
			setTextAlignment(RenderText.ALIGN_CENTER);
			setTextColor(1, 1, 0, 1);
			renderText(0.5, 0.56, fontSize, message.historyText);
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextColor(1, 1, 1, 1);
		end;
		renderText(0.31, 0.54, fontSize, message.text);
		setTextWidthScale(1);
		setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
		if message.buttons == 1 then
			if inRange(self.mPos[1], self.mPos[2], 0.3, 0.4, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.7, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.3, 0.4, 0.4, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.3, 0.4, 0.4, 0.04) then
				message.callbackOK(message.name);
			end;
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.5, 0.41, 0.02, g_i18n:getText("button_ok"));
		elseif message.buttons == 2 then
			if inRange(self.mPos[1], self.mPos[2], 0.3, 0.2, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.7, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.3, 0.4, 0.2, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.3, 0.2, 0.4, 0.04) then
				message.callbackOK(message.name);
			end;
			if inRange(self.mPos[1], self.mPos[2], 0.5, 0.2, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.7, 0.3, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.5, 0.4, 0.2, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.5, 0.2, 0.4, 0.04) then
				message.callbackCancel(message.name);
			end;
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.4, 0.41, 0.02, g_i18n:getText("button_ok"));
			renderText(0.6, 0.41, 0.02, g_i18n:getText("button_cancel"));
		elseif message.buttons == 3 then
			if inRange(self.mPos[1], self.mPos[2], 0.3, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.7, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.3, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.3, 0.133, 0.4, 0.04) then
				if g_server ~= nil then
					self:activateContract(message.contract, true);
				else
					g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(false, false, message.contract, 0, 0, false));
				end;
			end;
			if inRange(self.mPos[1], self.mPos[2], 0.433, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.3, 0.7, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.433, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.433, 0.133, 0.4, 0.04) then
				if g_server ~= nil then
					self:putOffContract(message.contract);
				else
					g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(false, false, 0, message.contract, 0, false));
				end;
			end;
			if inRange(self.mPos[1], self.mPos[2], 0.566, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.7, 0.3, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.566, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.566, 0.133, 0.4, 0.04) then
				if g_server ~= nil then
					self:cancelContract(message.contract, true);
					g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, message.contract, true));
				else
					g_client:getServerConnection():sendEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, message.contract, true));
				end;
			end;
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.3665, 0.41, 0.02, g_i18n:getText("button_ok"));
			renderText(0.5, 0.41, 0.02, g_i18n:getText("put_off"));
			renderText(0.6325, 0.41, 0.02, g_i18n:getText("button_cancel"));
		elseif message.buttons == 4 then
			if inRange(self.mPos[1], self.mPos[2], 0.3, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.7, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.3, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.3, 0.133, 0.4, 0.04) then
				message.callbackPrev(message.msgNum);
			end;
			if inRange(self.mPos[1], self.mPos[2], 0.433, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.7, 0.3, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.433, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.433, 0.133, 0.4, 0.04) then
				message.callbackCancel();
			end;
			if inRange(self.mPos[1], self.mPos[2], 0.566, 0.133, 0.4, 0.04) then
				setOverlayColor(UniversalFactoryHUD.greyButton, 0.3, 0.7, 0.3, 0.5);
			end;
			renderOverlay(UniversalFactoryHUD.greyButton, 0.566, 0.4, 0.133, 0.04);
			setOverlayColor(UniversalFactoryHUD.greyButton, 0.5, 0.5, 0.5, 0.5);
			if inRange(self.mPos[3], self.mPos[4], 0.566, 0.133, 0.4, 0.04) then
				message.callbackNext(message.msgNum);
			end;
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.3665, 0.41, 0.02, "<<");
			renderText(0.5, 0.41, 0.02, g_i18n:getText("button_cancel"));
			renderText(0.6325, 0.41, 0.02, ">>");
		end;
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_LEFT);
	elseif self.active then
		setTextColor(1, 1, 1, 1);
		setTextBold(false);
		setTextAlignment(RenderText.ALIGN_CENTER);
		local fontSize = UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE];--0.015;
		local fontScale = 1-(UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE]-0.015)*40;
		if g_screenWidth/g_screenHeight < 1.5 then
			fontSize = UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE]-0.002;--0.014;
			fontScale = fontScale - 0.15;
		end;
		renderOverlay(self.mapHud, 0, 0, 1, 1);
		if self.action == "realtor" then
			local transparentText = false;
			for name,buyable in pairs(self.buyables) do
				local currentTransparentText = self.transparentText;
				local enableInfo = true;
				local hasMessage = false;
				if buyable.hasMessage and (g_server or g_currentMission.isMasterUser) then
					hasMessage = true;
				end;
				if not hasMessage and not buyable.ownerAgree and not buyable.request then
					currentTransparentText = 0.1;
					enableInfo = false;
				end;
				if enableInfo and inRange(self.mPos[1], self.mPos[2], buyable.x-0.025, 0.05, buyable.z, 0.02) then
					setTextColor(1, 1, 0, 1);
					if buyable.request then
						renderText(buyable.x, buyable.z-0.015, fontSize, g_i18n:getText("overcharge"));
					elseif hasMessage then
						renderText(buyable.x, buyable.z-0.015, fontSize, g_i18n:getText("readMessage"));
					else
						local positionY = 0.03;
						local priceText = string.format("%s: %d%s", g_i18n:getText("ui_nominalValue"), tostring(buyable.price), self.currencySymbol);
						if buyable.ownerWantPrice < buyable.price then
							priceText = priceText..string.format(" %s %d%s", g_i18n:getText("ownerSells"), tostring(buyable.ownerWantPrice), self.currencySymbol);
						end;
						if buyable.isOwned then
							priceText = string.format(g_i18n:getText("YouWantToSellThat"), buyable.sellPrice, self.currencySymbol);
							setTextColor(1, 0, 0, 1);
						end;
						renderText(buyable.x, buyable.z-0.015, fontSize, priceText);
						if buyable.rating > 0 and not buyable.isOwned then
							local rating = buyable.rating;
							if buyable.ownerWantPrice < buyable.price then rating = math.max(rating - 10, 0); end;
							renderText(buyable.x, buyable.z-0.03, fontSize, string.format(g_i18n:getText("needMoreRating"), rating));
							positionY = 0.045;
						end;
						if buyable.fieldArea then
							renderText(buyable.x, buyable.z-positionY, fontSize, buyable.fieldArea);
						end;
					end;
					transparentText = true;
					self.transparentText = 0.1;
					currentTransparentText = 1;
				end;
				setTextColor(1, 1, 1, currentTransparentText);
				if buyable.ownerWantPrice < buyable.price then
					setTextColor(1, 0, 0, currentTransparentText);
				end;
				if buyable.isOwned then
					setTextColor(0, 1, 0, currentTransparentText);
				end;
				if hasMessage then
					setTextColor(0, 1, 1, currentTransparentText);
				end;
				renderText(buyable.x, buyable.z, fontSize, buyable.name);
				setTextColor(1, 1, 1, 1);
				local callMode = self.callMode;
				if not callMode then
					if not g_server then
						if not g_currentMission.isMasterUser then
							callMode = true;
						end;
					end;
				end;
				if inRange(self.mPos[3], self.mPos[4], buyable.x-0.025, 0.05, buyable.z, 0.02) then
					if hasMessage then
						if g_server then
							buyable.hasMessage = false;
							g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
						else
							g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, buyable.numCoins, true));
						end;
						self:showRequestResult(name);
						self:onCloseMap();
					elseif buyable.ownerAgree and not buyable.request and not callMode then
						if buyable.isOwned then
							if g_server then
								self:sellObject(name);
							else
								g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, true, false, 0, false));
							end;
						else
							if buyable.ownerWantPrice < buyable.price then
								if self.rating >= buyable.rating - 10 then
									if g_server then
										self:buyObject(name);
									else
										g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, true, false, false, 0, false));
									end;
								else
									self:needMoreRating(name);
								end;
							else
								if self.rating >= buyable.rating then
									self:priceRequest(name);
								else
									self:needMoreRating(name);
								end;
							end;
						end;
						self:onCloseMap();
					end;
				end;
			end;
			if not transparentText and self.transparentText == 0.1 then
				self.transparentText = 1;
			end;
			setTextAlignment(RenderText.ALIGN_RIGHT);
			local positionY = 0.035;
			renderText(0.55, positionY, fontSize, g_i18n:getText("ui_total")..":"); renderText(0.65, positionY, fontSize, tostring(self.rating));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, g_i18n:getText("railroadPenalty"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.railroadPenalty));
			local penaltyText = "";
			if self.statistics.railroadPenalty > 0 then penaltyText = "-"; end;
			renderText(0.65, positionY, fontSize, string.format("%s%d", penaltyText, self.statistics.railroadPenalty));
			positionY = positionY + 0.015;
			if self.statistics.penaltyCutDownTrees > 0 then penaltyText = "-"; else penaltyText = ""; end;
			renderText(0.55, positionY, fontSize, g_i18n:getText("penaltyCutDownTrees"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.penaltyCutDownTrees));
			renderText(0.65, positionY, fontSize, string.format("%s%d", penaltyText, self.statistics.penaltyCutDownTrees));
			positionY = positionY + 0.015;
			if self.statistics.coinDeals > 0 then penaltyText = "-"; else penaltyText = ""; end;
			renderText(0.55, positionY, fontSize, g_i18n:getText("coinDeals"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.coinDeals));
			renderText(0.65, positionY, fontSize, string.format("%s%d", penaltyText, self.statistics.coinDeals));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, string.format("%s, %s:", g_i18n:getText("statistic_playTime"), g_i18n:getText("shortHour")));
			renderText(0.6, positionY, fontSize, tostring(math.floor(g_currentMission.missionInfo.playTime/60)));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.playTimeRating));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, g_i18n:getText("ownedObjects"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.ownedObjects));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.ownedObjects));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, string.format("%s, %s:", g_i18n:getText("statistic_hectaresThreshed"), g_i18n:getText("unit_areaShort")));
			renderText(0.6, positionY, fontSize, tostring(math.floor(g_currentMission.missionInfo.threshedHectares)));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.hectaresRating));
			positionY = positionY + 0.015;
			for name,animalRating in pairs(self.statistics.animalRating) do
				renderText(0.55, positionY, fontSize, self.animalNames[name]..":");
				renderText(0.6, positionY, fontSize, tostring(g_currentMission.husbandries[name].totalNumAnimals));
				renderText(0.65, positionY, fontSize, tostring(animalRating));
				positionY = positionY + 0.015;
			end;
			renderText(0.55, positionY, fontSize, g_i18n:getText("purchasedLicenses"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.purchasedLicenses));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.purchasedLicenses*2));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, g_i18n:getText("completedContracts"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.completedContracts));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.completedContracts*3));
			positionY = positionY + 0.015;
			renderText(0.55, positionY, fontSize, g_i18n:getText("completedMissions"));
			renderText(0.6, positionY, fontSize, tostring(self.statistics.completedMissions));
			renderText(0.65, positionY, fontSize, tostring(self.statistics.completedMissions));
			positionY = positionY + 0.015;
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(0.5, positionY, fontSize, g_i18n:getText("ratingCalculation"));
			renderText(0.6, positionY, fontSize, g_i18n:getText("Amount"));
			renderText(0.65, positionY, fontSize, g_i18n:getText("rating"));
			renderText(0.75, 0.2, fontSize, string.format("%s %d", g_i18n:getText("ownedGoldCoins"), self.statistics.ownedGoldCoins));
		elseif self.action == "constructor" then
			local transparentText = false;
			for name,block in pairs(self.updateables) do
				local factory = UniversalFactory[name];
				if factory.isOwned then

					for index=1, #block do
						local currentTransparentText = self.transparentText;
						local updateable = block[index];
						local currentValue = updateable.currentValue;
						local posY = updateable.z-0.015;

						if inRange(self.mPos[1], self.mPos[2], updateable.x-0.025, 0.05, updateable.z, 0.02) or updateable.updateMode then
							setTextColor(1, 1, 1, 1);
							if updateable.capacity and updateable.capacity[currentValue + 1] then
								if inRange(self.mPos[1], self.mPos[2], updateable.x-0.025, 0.05, posY, 0.015) then
									setTextColor(1, 1, 0, 1);
								end;
								renderText(updateable.x, posY, fontSize, string.format(g_i18n:getText("updateCapacity"), tostring(updateable.capacity[currentValue + 1]))..tostring(updateable.prices[currentValue + 1])..self.currencySymbol);
								if inRange(self.mPos[3], self.mPos[4], updateable.x-0.025, 0.05, posY, 0.015) then
									self:testUpdating(name, index, currentValue+1);
									self:onCloseMap();
								end;
								posY = posY-0.015;
							end;
							if updateable.productivity and updateable.productivity[currentValue + 1] then
								if inRange(self.mPos[1], self.mPos[2], updateable.x-0.025, 0.05, posY, 0.015) then
									setTextColor(1, 1, 0, 1);
								end;
								renderText(updateable.x, posY, fontSize, string.format(g_i18n:getText("updateProductivity"), tostring(updateable.productivity[currentValue + 1]*60*60))..tostring(updateable.prices[currentValue + 1])..self.currencySymbol);
								if inRange(self.mPos[3], self.mPos[4], updateable.x-0.025, 0.05, posY, 0.015) then
									self:testUpdating(name, index, currentValue+1);
									self:onCloseMap();
								end;
								posY = posY-0.015;
							end;
							if updateable.dayCosts and updateable.dayCosts[currentValue + 1] then
								renderText(updateable.x, posY, fontSize, g_i18n:getText("maintainingCosts")..tostring(updateable.dayCosts[currentValue + 1])..self.currencySymbol);
								posY = posY-0.015;
							end;
							transparentText = true;
							self.transparentText = 0.1;
							currentTransparentText = 1;
						end;
						setTextColor(1, 1, 1, currentTransparentText);
						if index == 1 then
							renderText(updateable.x, updateable.z, fontSize, g_i18n:getText(name));
						end;
						if inRange(self.mPos[3], self.mPos[4], updateable.x-0.025, 0.05, updateable.z, 0.025) then
							updateable.updateMode = not updateable.updateMode;
							self.mPos={0,0,0,0};
						end;
					end;
				end;
			end;
			if not transparentText and self.transparentText == 0.1 then
				self.transparentText = 1;
			end;
		end;
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextWidthScale(1);
		setTextColor(1, 1, 1, 1);
	end;
end;

function Economica:updateRating()
	local rating = 0;
	rating = rating + self.statistics.completedMissions;
	rating = rating + self.statistics.completedContracts*3;
	rating = rating + self.statistics.purchasedLicenses*2;
	local animalRating = {};
	local animals = {"cow", "pig", "sheep"};
	for i=1, #animals do
		local numAnimals = g_currentMission.husbandries[animals[i]].totalNumAnimals;
		local ii = 1;
		local aRating = 0;
		while true do
			if i*10*2^(ii-1) <= numAnimals then
				aRating = ii;
				ii = ii + 1;
			else
				break;
			end;
		end;
		rating = rating + aRating;
		animalRating[animals[i]] = aRating;
	end;
	self.statistics.animalRating = animalRating;
	local ii = 1;
	local hectares = g_currentMission.missionInfo.threshedHectares;
	self.statistics.hectaresRating = 0;
	while true do
		if 5*2^(ii-1) <= hectares then
			self.statistics.hectaresRating = ii;
			ii = ii + 1;
		else
			break;
		end;
	end;
	rating = rating + self.statistics.hectaresRating;
	ii = 1;
	local playTime = math.floor(g_currentMission.missionInfo.playTime/60);
	self.statistics.playTimeRating = math.floor(playTime/20);
	local ownedObjects = 0;
	for _,buyable in pairs(self.buyables) do
		if buyable.isOwned then
			ownedObjects = ownedObjects + 1;
		end;
	end;
	for _,fieldDef in pairs(g_currentMission.fieldDefinitionBase.fieldDefs) do
		if fieldDef.ownedByPlayer then
			ownedObjects = ownedObjects + 1;
		end;
	end;
	self.statistics.ownedObjects = ownedObjects;
	rating = rating + self.statistics.ownedObjects;
	rating = rating + self.statistics.playTimeRating;
	rating = rating - self.statistics.coinDeals;
	rating = rating - self.statistics.penaltyCutDownTrees;
	rating = rating - self.statistics.railroadPenalty;
	if rating == nil then
		print("Error: rating = nil");
		return;
	end;
	self.rating = rating;
	self.autoOutputPricePerCube = self.autoOutputPrice*(1+rating*0.01);
	g_server:broadcastEvent(EconomicaRatingEvent:new(self.rating, self.statistics));
end;

function Economica:showMessageFromHistory(msgNum)
	local message = self.messageHistory[msgNum];
	self.message = {
	["timer"] = self.buyMessageDuration,
	["title"] = message.title,
	["buttons"] = self.BUTTONS_PREV_CANCEL_NEXT,
	["msgNum"] = msgNum,
	["historyText"] = string.format("%s: %d/%d %s: %d %s: %s", g_i18n:getText("Message"), msgNum, #self.messageHistory, g_i18n:getText("dayNum"), message.day, g_i18n:getText("Time"), message.time),
	["text"] = message.text,
	["callbackPrev"] = self.callbackPreviousMessage,
	["callbackNext"] = self.callbackNextMessage,
	["callbackCancel"] = self.callbackCloseMessage};
	self:onStartMessage(true);
end;

function Economica.callbackPreviousMessage(msgNum)
	if #Economica.messageHistory > 1 then
		if msgNum == 1 then
			msgNum = #Economica.messageHistory;
		elseif msgNum > 1 then
			msgNum = msgNum - 1;
		end;
		Economica:onCloseMessage();
		Economica:showMessageFromHistory(msgNum);
	end;
end;

function Economica.callbackNextMessage(msgNum)
	if #Economica.messageHistory > 1 then
		if msgNum >= #Economica.messageHistory then
			msgNum = 1;
		else
			msgNum = msgNum + 1;
		end;
		Economica:onCloseMessage();
		Economica:showMessageFromHistory(msgNum);
	end;
end;

function Economica:onStartMessage(noPutToHistory)
	if not self.showMessage then
		self.mPos={0,0,0,0};
		if self.activated then
			self.active = false;
			self:changeHudStates(true);
			if self.UFHUDactive and not UniversalFactoryHUD.active then
				UniversalFactoryHUD.active = true;
			end;
		end;
		if not noPutToHistory then
			if #self.messageHistory == 20 then
				table.remove(self.messageHistory, 1);
			end;
			local message = {
			["title"] = self.message.title,
			["day"] = g_currentMission.environment.currentDay,
			["time"] = timeToString(g_currentMission.environment.dayTime/1000),
			["text"] = self.message.text};
			table.insert(self.messageHistory, message);
		end;
		self.showMessage = true;
	end;
end;

function Economica:onCloseMessage()
	if g_server then
		self.active = self.activated;
		if self.active then self:changeHudStates(false); end;
	end;
	if self.activated then
		self.active = false;
		self:changeHudStates(true);
	else
		self:onCloseManipulation();
	end;
	self.message = {};
	self.showMessage = false;
end;

function Economica.callbackCloseMessage()
	Economica:onCloseMessage();
end;

function Economica:onCloseMap()
	self.active = false;
	self.activated = false;
	self.action = "";
	self:changeHudStates(true);
	self:onCloseManipulation();
	self.callMode = false;
	if self.UFHUDactive then
		UniversalFactoryHUD.active = true;
		self.UFHUDactive = false;
	end;
end;

function Economica:onCloseManipulation()
	self.mPos={0,0,0,0};
	unlockCameras();
end;

function Economica:save()
	local key = "economica";
	local path = ('%ssavegame%d/'):format(tostring(getUserProfileAppPath()), g_currentMission.missionInfo.savegameIndex);
	local xmlFile = createXMLFile("EconomicaSaves", path .. "/EconomicaSaves.xml", key);
	self:saveContracts(xmlFile);
	self:saveMissions(xmlFile);
	self:saveGreatDemands(xmlFile);
	self:saveBuyables(xmlFile);
	self:saveUpdateables(xmlFile);
	self:saveRandomEvents(xmlFile);
	if self.woodLicense then
		self:saveWoodLicense(xmlFile);
	end;
	local garbageString = tableToString(self.base.garbageStates);
	setXMLString(xmlFile, "economica.garbage#states", garbageString);
	local goldCoinString = tableToString(self.base.goldCoinStates);
	setXMLString(xmlFile, "economica.goldCoins#states", goldCoinString);
	setXMLInt(xmlFile, "economica.intervals#greatDemand", self.greatDemandInterval);
	setXMLInt(xmlFile, "economica.intervals#extraMission", self.missionInterval);
	setXMLInt(xmlFile, "economica.intervals#contract", self.contractInterval);
	setXMLInt(xmlFile, "economica.intervals#lowPriceSell", self.lowPriceSellInterval);
	setXMLInt(xmlFile, "economica.intervals#airSprayerHour", self.airSprayerHour);
	setXMLInt(xmlFile, "economica.statistics#completedMissions", self.statistics.completedMissions);
	setXMLInt(xmlFile, "economica.statistics#completedContracts", self.statistics.completedContracts);
	setXMLInt(xmlFile, "economica.statistics#missionPrize", self.statistics.missionPrize);
	setXMLInt(xmlFile, "economica.statistics#contractPrize", self.statistics.contractPrize);
	setXMLInt(xmlFile, "economica.statistics#purchasedLicenses", self.statistics.purchasedLicenses);
	setXMLInt(xmlFile, "economica.statistics#penaltyCutDownTrees", self.statistics.penaltyCutDownTrees);
	setXMLInt(xmlFile, "economica.statistics#railroadPenalty", self.statistics.railroadPenalty);
	setXMLInt(xmlFile, "economica.statistics#ownedGoldCoins", self.statistics.ownedGoldCoins);
	setXMLInt(xmlFile, "economica.statistics#coinDeals", self.statistics.coinDeals);
	for i=1, #self.messageHistory do
		local messageKey = string.format("economica.messages.message(%d)", i-1);
		local message = self.messageHistory[i];
		setXMLInt(xmlFile, messageKey.."#title", message.title);
		setXMLInt(xmlFile, messageKey.."#day", message.day);
		setXMLString(xmlFile, messageKey.."#time", message.time);
		setXMLString(xmlFile, messageKey.."#text", message.text);
	end;
	saveXMLFile(xmlFile);
	delete(xmlFile);
end;
