--author: igor29381

EconomicBase = {};
EconomicBase_mt = Class(EconomicBase, Object);

function EconomicBase.onCreate(id)
    local object = EconomicBase:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:addOnCreateLoadedObject(object);
    object:load(id);
	object:register(true);
end

function EconomicBase:new(isServer, isClient, customMt)
    if customMt == nil then
        customMt = EconomicBase_mt;
    end
    local self = Object:new(isServer, isClient, customMt);
	self.economicaDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function EconomicBase:load(id)
	self.triggers = {};
	local triggersRootNode = getChild(id, "triggers");
	if triggersRootNode > 0 then
		for i=1, getNumOfChildren(triggersRootNode) do
			local child = getChildAt(triggersRootNode, i-1);
			local trigger = EconomicsTrigger:new(child);
			g_currentMission:addNonUpdateable(trigger);
			table.insert(self.triggers, trigger);
		end;
	end;
	self.notFoundGoldCoins = 0;
	self.goldCoinStates = {};
	self.garbageStates = {};
	if self.isServer then
		local xmlPath = "EconomicaSaves.xml";
		if g_currentMission.missionInfo.savegameDirectory then
			xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/EconomicaSaves.xml";
		end;
		if fileExists(xmlPath) then
			local xmlFile = loadXMLFile("EconomicaSaves", xmlPath);
			local garbageStates = getXMLString(xmlFile, "economica.garbage#states");
			if garbageStates then
				self.garbageStates = Utils.splitString(" ", garbageStates);
				for i=1, #self.garbageStates do self.garbageStates[i] = tonumber(self.garbageStates[i]); end;
			end;
			local goldCoinStates = getXMLString(xmlFile, "economica.goldCoins#states");
			if goldCoinStates then
				self.goldCoinStates = Utils.splitString(" ", goldCoinStates);
				for i=1, #self.goldCoinStates do self.goldCoinStates[i] = tonumber(self.goldCoinStates[i]); end;
			end;
			delete(xmlFile);
		end;
	end;
	self.goldCoins = {};
	local goldRootNode = getChild(id, "collectableGoldCoins");
	if goldRootNode > 0 then
		for i=1, getNumOfChildren(goldRootNode) do
			local child = getChildAt(goldRootNode, i-1);
			local triggerId = getChildAt(child, 0);
			local trigger = EconomyGoldCoinTrigger:new(triggerId);
			g_currentMission:addNonUpdateable(trigger);
			trigger.number = i;
			trigger.parentId = child;
			table.insert(self.goldCoins, trigger);
		end;
		for i=1, #self.goldCoins do
			if self.goldCoinStates[i] == nil then
				self.goldCoinStates[i] = 1;
				self.notFoundGoldCoins = self.notFoundGoldCoins + 1;
			elseif self.goldCoinStates[i] == 1 then
				self.notFoundGoldCoins = self.notFoundGoldCoins + 1;
			elseif self.goldCoinStates[i] == 0 then
				self:deleteGoldCoin(i);
			end;
		end;
	end;
	local garbageRootNode = getChild(id, "garbage");
	self.garbage = {};
	if garbageRootNode > 0 then
		for i=1, getNumOfChildren(garbageRootNode) do
			local garbage = {};
			garbage.id = getChildAt(garbageRootNode, i-1);
			garbage.price = Utils.getNoNil(getUserAttribute(garbage.id, "price"), 15000);
			local text = getUserAttribute(garbage.id, "text");
			if text then
				text = g_i18n:getText(text);
				garbage.text = Utils.splitString("@", text);
			end;
			if self.isServer then
				if self.garbageStates[i] == nil then
					self.garbageStates[i] = 1;
				elseif self.garbageStates[i] == 0 then
					self:deleteGarbage(garbage.id);
				end;
			end;
			table.insert(self.garbage, garbage);
		end;
	end;
	Economica.base = self;
	print("EconomicBase loaded");
	return true;
end;

function EconomicBase:delete()
	EconomicBase:superClass().delete(self);
end;

function EconomicBase:deleteGarbage(id)
	local numOfChildren = getNumOfChildren(id);
	if numOfChildren > 0 then
		for i=1, numOfChildren do
			delete(getChildAt(id, numOfChildren-i));
		end;
	end;
end;

function EconomicBase:removeGarbage(num)
	local garbage = self.garbage[num];
	self:deleteGarbage(garbage.id);
	self.garbageStates[num] = 0;
	g_server:broadcastEvent(EconomicaGarbageEvent:new(num));
	g_currentMission:addSharedMoney(-garbage.price, "other");
	g_currentMission:addMoneyChange(-garbage.price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_wagePayment"));
end;

function EconomicBase:changeGoldCoinState(num)
	if #self.goldCoins > 0 then
		local goldCoin = self.goldCoins[num];
		if goldCoin and goldCoin.isEnabled then
			self.notFoundGoldCoins = self.notFoundGoldCoins - 1;
			Economica.statistics.ownedGoldCoins = Economica.statistics.ownedGoldCoins + 1;
			self:deleteGoldCoin(num);
			g_server:broadcastEvent(EconomicaGoldCoinEvent:new(0, num, self.notFoundGoldCoins));
		end;
	end;
end;

function EconomicBase:deleteGoldCoin(num)
	local goldCoin = self.goldCoins[num];
	if goldCoin then
		setVisibility(goldCoin.parentId, false);
		goldCoin.isEnabled = false;
	end;
	self.goldCoinStates[num] = 0;
end;

function EconomicBase:readStream(streamId, connection)
	EconomicBase:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		if #self.garbage > 0 then
			for i=1, #self.garbage do
				local garbageState = streamReadInt8(streamId);
				self.garbageStates[i] = garbageState;
				if garbageState == 0 then
					self:deleteGarbage(self.garbage[i].id);
				end;
			end;
		end;
		if #self.goldCoins > 0 then
			for i=1, #self.goldCoinStates do
				self.goldCoinStates[i] = streamReadInt8(streamId);
				if self.goldCoinStates[i] == 0 then
					self:deleteGoldCoin(i);
				end;
			end;
		end;
		self.notFoundGoldCoins = streamReadInt16(streamId);
		local numGreatDemands = streamReadInt8(streamId);
		for i=1, numGreatDemands do
			local shopName = streamReadString(streamId);
			local fillType = streamReadInt8(streamId);
			local highLevel = streamReadBool(streamId);
			local multiplier = streamReadFloat32(streamId);
			local pricePerCube = streamReadFloat32(streamId);
			local duration = streamReadInt8(streamId);
			Economica:registerNewGreatDemand(shopName, fillType, highLevel, multiplier, pricePerCube, duration, false);
		end;
		local extraMission = streamReadBool(streamId);
		if extraMission then
			local shopName = streamReadString(streamId);
			local fillType = streamReadInt8(streamId);
			local volume = streamReadFloat32(streamId);
			local price = streamReadFloat32(streamId);
			local duration = streamReadFloat32(streamId);
			local active = streamReadBool(streamId);
			Economica:registerNewExtraMission(shopName, fillType, volume, price, duration, false);
			if active then
				Economica:activateExtraMission(false);
			end;
		end;
		local numContracts = streamReadInt8(streamId);
		for i=1, numContracts do
			local contractData = {};
			contractData.numShop = streamReadInt8(streamId);
			contractData.fillType = streamReadInt8(streamId);
			contractData.multiplier = streamReadFloat32(streamId);
			contractData.pricePerCube = streamReadFloat32(streamId);
			contractData.volume = streamReadFloat32(streamId);
			contractData.duration = streamReadInt16(streamId);
			contractData.waitInterval = streamReadInt8(streamId);
			local endHour = streamReadInt32(streamId);
			local active = streamReadBool(streamId);
			local postponed = streamReadBool(streamId);
			Economica:registerNewContract(contractData, false);
			Economica.contracts[i].endHour = endHour;
			if active then
				Economica:activateContract(i, false);
			end;
			if postponed then
				Economica:putOffContract(i);
			end;
		end;
		for name,buyable in pairs(Economica.buyables) do
			buyable.isOwned = streamReadBool(streamId);
			if not buyable.isOwned then
				buyable.request = streamReadBool(streamId);
				buyable.ownerAgree = streamReadBool(streamId);
				buyable.hasMessage = streamReadBool(streamId);
				buyable.ownerWantPrice = streamReadInt32(streamId);
				buyable.numCoins = streamReadInt8(streamId);
			end;
			if buyable.garage then
				Economica:changeGarageOwner(name, buyable.isOwned);
			end;
		end;
		local sellObjectName = streamReadString(streamId);
		local sellObjectPrice = streamReadInt32(streamId);
		if sellObjectName ~= "" and sellObjectPrice > 0 then
			local buyable = Economica.buyables[sellObjectName];
			if buyable then
				buyable.ownerWantPrice = sellObjectPrice;
			end;
		end;
		for name,updateable in pairs(Economica.updateables) do
			for i=1, #updateable do
				local currentValue = streamReadInt8(streamId);
				if currentValue > 1 then
					Economica:updateObject(name, i, currentValue);
				end;
			end;
		end;
		local woodLicenseTimer = streamReadInt8(streamId);
		local woodLicenseNumTrees = streamReadInt8(streamId);
		if woodLicenseTimer > 0 and woodLicenseNumTrees > 0 then
			Economica.woodLicense = {["timer"]=woodLicenseTimer, ["numTrees"]=woodLicenseNumTrees};
		end;
		for i=1, #UniversalFactoryHUD.settings do
			if not UniversalFactoryHUD.clientSettings[i] then
				local state = streamReadBool(streamId);
				UniversalFactoryHUD.settings[i] = state;
			end;
		end;
		for _,fieldDef in pairs(g_currentMission.fieldDefinitionBase.fieldDefs) do
			fieldDef.npcIndex = streamReadInt8(streamId);
		end;
	end;
end;

function EconomicBase:writeStream(streamId, connection)
	EconomicBase:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		if #self.garbage > 0 then
			for i=1, #self.garbage do
				streamWriteInt8(streamId, self.garbageStates[i]);
			end;
		end;
		if #self.goldCoins > 0 then
			for i=1, #self.goldCoinStates do
				streamWriteInt8(streamId, self.goldCoinStates[i]);
			end;
		end;
		streamWriteInt16(streamId, self.notFoundGoldCoins);
		local numGreatDemands = #Economica.greatDemands;
		streamWriteInt8(streamId, numGreatDemands);
		for i=1, numGreatDemands do
			local greatDemand = Economica.greatDemands[i];
			streamWriteString(streamId, greatDemand.shopName);
			streamWriteInt8(streamId, greatDemand.fillType);
			streamWriteBool(streamId, greatDemand.highLevel);
			streamWriteFloat32(streamId, greatDemand.multiplier);
			streamWriteFloat32(streamId, greatDemand.pricePerCube);
			streamWriteInt8(streamId, greatDemand.duration);
		end;
		local extraMission = #Economica.extraMissions > 0;
		streamWriteBool(streamId, extraMission);
		if extraMission then
			local mission = Economica.extraMissions[1];
			streamWriteString(streamId, mission.shopName);
			streamWriteInt8(streamId, mission.fillType);
			streamWriteFloat32(streamId, mission.volume);
			streamWriteFloat32(streamId, mission.price);
			streamWriteFloat32(streamId, mission.duration);
			streamWriteBool(streamId, mission.active);
		end;
		local numContracts = #Economica.contracts;
		streamWriteInt8(streamId, numContracts);
		for i=1, numContracts do
			local contract = Economica.contracts[i];
			streamWriteInt8(streamId, contract.numShop);
			streamWriteInt8(streamId, contract.fillType);
			streamWriteFloat32(streamId, contract.multiplier);
			streamWriteFloat32(streamId, contract.pricePerCube);
			streamWriteFloat32(streamId, contract.volume);
			streamWriteInt16(streamId, contract.duration);
			streamWriteInt8(streamId, contract.waitInterval);
			streamWriteInt32(streamId, contract.endHour);
			streamWriteBool(streamId, contract.active);
			streamWriteBool(streamId, contract.postponed);
		end;
		for _,buyable in pairs(Economica.buyables) do
			streamWriteBool(streamId, buyable.isOwned);
			if not buyable.isOwned then
				streamWriteBool(streamId, buyable.request);
				streamWriteBool(streamId, buyable.ownerAgree);
				streamWriteBool(streamId, buyable.hasMessage);
				streamWriteInt32(streamId, math.floor(buyable.ownerWantPrice));
				streamWriteInt8(streamId, buyable.numCoins);
			end;
		end;
		local sellObjectPrice = 0;
		streamWriteString(streamId, Economica.lowPriceSellObjectName);
		if Economica.lowPriceSellObjectName ~= "" then
			local buyable = Economica.buyables[Economica.lowPriceSellObjectName];
			if buyable then
				sellObjectPrice = buyable.ownerWantPrice;
			end;
		end;
		streamWriteInt32(streamId, sellObjectPrice);
		for name,updateable in pairs(Economica.updateables) do
			for i=1, #updateable do
				streamWriteInt8(streamId, updateable[i].currentValue);
			end;
		end;
		local woodLicenseTimer = 0;
		local woodLicenseNumTrees = 0;
		if Economica.woodLicense then
			woodLicenseTimer = Economica.woodLicense.timer;
			woodLicenseNumTrees = Economica.woodLicense.numTrees;
		end;
		streamWriteInt8(streamId, woodLicenseTimer);
		streamWriteInt8(streamId, woodLicenseNumTrees);
		for i=1, #UniversalFactoryHUD.settings do
			if not UniversalFactoryHUD.clientSettings[i] then
				streamWriteBool(streamId, UniversalFactoryHUD.settings[i]);
			end;
		end;
		for _,fieldDef in pairs(g_currentMission.fieldDefinitionBase.fieldDefs) do
			streamWriteInt8(streamId, fieldDef.npcIndex);
		end;
	end;
end;

function EconomicBase:readUpdateStream(streamId, timestamp, connection)
	EconomicBase:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		if Economica.extraMissions[1] then
			Economica.extraMissions[1].duration = streamReadInt32(streamId)/100;
		end;
	end;
end;

function EconomicBase:writeUpdateStream(streamId, connection, dirtyMask)
	EconomicBase:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		if Economica.extraMissions[1] then
			streamWriteInt32(streamId, math.floor(Economica.extraMissions[1].duration*100));
		end;
	end;
end;

function EconomicBase:update(dt)
end;

g_onCreateUtil.addOnCreateFunction("EconomicBase", EconomicBase.onCreate);

----------------------------------------

EconomicsTrigger = {};

local EconomicsTrigger_mt = Class(EconomicsTrigger);

function EconomicsTrigger.onCreate(id)
    g_currentMission:addNonUpdateable(EconomicsTrigger:new(id));
end;

function EconomicsTrigger:new(nodeId)
	local self = {};
	setmetatable(self, EconomicsTrigger_mt);
	self.triggerId = nodeId;
	addTrigger(self.triggerId, "triggerCallback", self);
	self.action = getUserAttribute(self.triggerId, "action");
    return self;
end;

function EconomicsTrigger:delete()
    removeTrigger(self.triggerId);
end;

function EconomicsTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if otherId == g_currentMission.player.rootNode then
		if onEnter then
			if g_currentMission.environment.currentHour >= 8 and g_currentMission.environment.currentHour < 18 then
				if self.action == "woodLicense" then
					if not Economica.showMessage and not Economica.woodLicense then
						Economica:showWoodLicensingMessage();
					end;
				else
					Economica.activate = true;
					Economica.action = self.action;
					if self.action == "realtor" then
						if g_server then
							Economica:updateRating();
						else
							g_client:getServerConnection():sendEvent(EconomicaRatingEvent:new(0, 0));
						end;
					end;
				end;
			end;
		elseif onLeave then
			Economica.activated = false;
			if Economica.active then
				Economica:onCloseMap();
			elseif Economica.showMessage and Economica.message.title == Economica.TITLE_WOODLICENSING_AGENCY then
				Economica:onCloseMessage();
			end;
		end;
	end;
end;

----------------------------------------

EconomyGoldCoinTrigger = {};

local EconomyGoldCoinTrigger_mt = Class(EconomyGoldCoinTrigger);

function EconomyGoldCoinTrigger.onCreate(id)
    g_currentMission:addNonUpdateable(EconomyGoldCoinTrigger:new(id));
end;

function EconomyGoldCoinTrigger:new(nodeId)
	local self = {};
	setmetatable(self, EconomyGoldCoinTrigger_mt);
	self.triggerId = nodeId;
	addTrigger(self.triggerId, "triggerCallback", self);
	self.isEnabled = true;
    return self;
end;

function EconomyGoldCoinTrigger:delete()
    removeTrigger(self.triggerId);
end;

function EconomyGoldCoinTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	if self.isEnabled and onEnter and otherId == g_currentMission.player.rootNode then
		g_currentMission:showBlinkingWarning(string.format("%s %s %d", g_i18n:getText("yourFirstGoldCoinTitle"), g_i18n:getText("numGoldCoins"), Economica.base.notFoundGoldCoins-1), 3000);
		playSample(Economica.goldCoinPickupSound, 1, 1, 0);
		if g_server then
			Economica.base:changeGoldCoinState(self.number);
		else
			g_client:getServerConnection():sendEvent(EconomicaGoldCoinEvent:new(self.number, 0, 0));
		end;
	end;
end;
