--author: igor29381

function Economica:loadContractsDefaultData(xmlFile)
	self.contractIntervals = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.contract#interval"), "50 80"))};
	self.waitInterval = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.contract#waitingInterval"), "2 4"))};
	self.contractDuration = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.contract#duration"), "40 70"))};
	self.contractVolume = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.contract#volume"), "50000 150000"))};
end;

function Economica:loadContractsSaveData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.contract(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local contractData = {};
		local shopName = getXMLString(xmlFile, key.."#shopName");
		contractData.numShop = UniversalFactory[shopName].index;
		local fillType = getXMLString(xmlFile, key.."#fillType");
		contractData.fillType = FillUtil.fillTypeNameToInt[fillType];
		contractData.multiplier = getXMLFloat(xmlFile, key.."#multiplier");
		contractData.pricePerCube = getXMLFloat(xmlFile, key.."#pricePerCube");
		contractData.volume = getXMLFloat(xmlFile, key.."#volume");
		contractData.duration = math.min(getXMLInt(xmlFile, key.."#duration"), self.contractDuration[2]*2);
		contractData.waitInterval = math.min(getXMLInt(xmlFile, key.."#waitInterval"), self.waitInterval[2]);
		local outputInterval = getXMLInt(xmlFile, key.."#outputInterval");
		local endHour = Utils.getNoNil(getXMLInt(xmlFile, key.."#endHour"), 0);
		local postponed = getXMLBool(xmlFile, key.."#postponed");
		local active = getXMLBool(xmlFile, key.."#active");
		self:registerNewContract(contractData, false);
		i = i + 1;
		if postponed then
			self:putOffContract(i);
		end;
		if active then
			self:activateContract(i, false);
		end;
		self.contracts[i].endHour = endHour;
		self.contracts[i].outputInterval = outputInterval;
		self.contracts[i].outputIntervalBase = outputInterval;
	end;
end;

function Economica:setContractInterval()
	return math.random(self.contractIntervals[1], self.contractIntervals[2]);
end;

function Economica:contractsHourChanged()
	for i=1, #self.contracts do
		local contract = self.contracts[i];
		if contract then
			local shop = UniversalFactory.all[contract.numShop];
			if contract.active then
				local currentHour = (g_currentMission.environment.currentDay-1)*24 + g_currentMission.environment.currentHour;
				if contract.endHour == 0 then
					local durationDelta = 0;
					if shop.workingDuration then
						durationDelta = math.ceil(contract.duration/24)*(24-shop.workingDuration);
					end;
					contract.endHour = currentHour + contract.duration + durationDelta;
				end;
				contract.duration = math.max(contract.endHour - currentHour, 0);
				if shop.isEnabled then
					if g_server then
						local fillType = shop.fillType[contract.fillType];
						local percent = fillType.level/fillType.capacity;
						if percent > 0.33 then
							contract.outputInterval = 0;
						else
							contract.outputInterval = math.max(contract.outputInterval - 1, 0);
						end;
					end;
				end;
			elseif contract.postponed then
				contract.waitInterval = math.max(contract.waitInterval - 1, 0);
				if g_server and contract.waitInterval == 0 then
					self:cancelContract(i, false);
					g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, i, false));
				end;
			end;
		end;
	end;
end;

function Economica:updateContracts(dt)
	if not self.showMessage and self.contractInterval == 0 then
		self.contractInterval = self:setContractInterval();
		if #self.contracts < 3 then
			local numShop, fillType = self:getLowLevel(false);
			if numShop and fillType then
				local shop = self.shops[numShop];
				if shop then
					local shopFillType = shop.fillType[fillType];
					local contractData = {};
					contractData.numShop = shop.index;
					contractData.fillType = fillType;
					contractData.multiplier = 1 + math.random(3, 5)*0.1;
					local capacityMultiplier = math.random(20, 33)*0.1;
					local duration = math.max(math.ceil(math.random(self.contractDuration[1], self.contractDuration[2])*math.max(2-self.rating*0.02, 0)), self.contractDuration[1]);
					local durationDelta = 6-math.random(1, 11);
					if shop.workingDuration then
						durationDelta = durationDelta + math.ceil(duration/24)*(24-shop.workingDuration);
					end;
					contractData.volume = math.min(math.random(self.contractVolume[1], self.contractVolume[2])*math.max(self.rating*0.015, 0.25)*1000, shopFillType.capacity*capacityMultiplier);
					contractData.duration = duration + durationDelta;
					contractData.waitInterval = math.random(self.waitInterval[1], self.waitInterval[2]);
					local priceMultiplier = shop.fillType[fillType].priceMultiplier;
					contractData.pricePerCube = FillUtil.fillTypeIndexToDesc[fillType].pricePerLiter*priceMultiplier*contractData.multiplier*self.difficultyMultiplier*1000;
					self:registerNewContract(contractData, true);
					g_server:broadcastEvent(EconomicaContractEvent:new(contractData, 0, false, 0, 0, false));
				end;
			end;
		end;
	end;
	if #self.contracts > 0 then
		for i=1, #self.contracts do
			local contract = self.contracts[i];
			if contract and contract.active then
				local factory = UniversalFactory.all[contract.numShop];
				local fillType = factory.fillType[contract.fillType];
				if not self.showMessage then
					if not self.active and contract.outputInterval == 0 then
						local percent = math.max(fillType.level/fillType.capacity, 0.25);
						local outputVolume = contract.volume*percent/5;
						contract.outputInterval = contract.outputIntervalBase;
						if fillType.contractLevel < contract.volume and fillType.level < outputVolume then
							local delta = outputVolume - fillType.level;
							local penalty = FillUtil.fillTypeIndexToDesc[contract.fillType].pricePerLiter*fillType.priceMultiplier*contract.multiplier*self.difficultyMultiplier*delta;
							g_currentMission:showBlinkingWarning(string.format("%s %d%s", g_i18n:getText("contractOutputPenalty"), math.floor(penalty), g_i18n.globalI18N:getCurrencySymbol(true)), 3000);
							g_currentMission:addSharedMoney(-penalty, "other");
							g_currentMission:addMoneyChange(-penalty, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("penalties"));
							g_server:broadcastEvent(EconomicaContractEvent:new(self.emptyContractData, 0, false, 0, math.floor(penalty), false));
						end;
						fillType.level = math.max(fillType.level - outputVolume, 0);
					end;
					if contract.duration == 0 then
						local penalty = 0;
						if contract.volume > fillType.contractLevel then
							penalty = ((contract.volume - fillType.contractLevel)/1000) * contract.pricePerCube;
							self.statistics.completedContracts = self.statistics.completedContracts - 1;
							g_currentMission:addSharedMoney(-penalty, "other");
							g_currentMission:addMoneyChange(-penalty, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("penalties"));
						end;
						g_server:broadcastEvent(EconomicaContractEvent:new(self.emptyContractData, i, true, penalty, 0, false));
						self:showContractMessage(i, true, penalty);
					end;
					if fillType.contractLevel >= contract.volume then
						self.statistics.completedContracts = self.statistics.completedContracts + 1;
						local prize = false;
						if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_RANDOMEVENTS] and self.randomEventsByNames.contractPrize
						and not self.randomEventsByNames.contractPrize.active and self.statistics.completedContracts >= self.statistics.contractPrize
						and not self.woodLicense then
							self.woodLicense = {["timer"]=25, ["numTrees"]=self.woodLicenseNumTrees};
							g_server:broadcastEvent(EconomicaWoodEvent:new(true, 0, self.woodLicenseNumTrees));
							local randomEvent = self.randomEventsByNames.contractPrize;
							randomEvent.active = true;
							self:showRandomEventMessage(randomEvent.msgText);
							g_server:broadcastEvent(RandomEvEvent:new(self.randomEventsNameToInt.contractPrize, 0, 0, 0));
							self:cancelContract(i, false);
							g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, 0, 0, i, false));
							prize = true;
						else
							g_server:broadcastEvent(EconomicaContractEvent:new(self.emptyContractData, i, true, 0, 0, false));
							self:showContractMessage(i, true, 0);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function Economica:registerNewContract(contractData, showMessage)
	local contract = contractData;
	contract.shopName = UniversalFactory.all[contractData.numShop].locationName;
	contract.fillTypeName = fillTypeName(contractData.fillType);
	contract.outputInterval = math.max(math.floor(contractData.duration/10), 5);
	contract.outputIntervalBase = contract.outputInterval;
	if g_currentMission.environment then
		contract.endHour = (g_currentMission.environment.currentDay-1)*24 + g_currentMission.environment.currentHour + contract.duration;
	end;
	contract.active = false;
	contract.postponed = false;
	table.insert(self.contracts, contract);
	UniversalFactory.all[contractData.numShop].fillType[contractData.fillType].contract = true;
	if showMessage then
		self:showContractMessage(#self.contracts, false, 0);
	end;
end;

function Economica:showContractMessage(numContract, stop, penalty, noPutToHistory)
	local contract = self.contracts[numContract];
	if contract then
		local timer = self.ConMessageDuration;
		local title = self.TITLE_CONTRACT;
		local buttons = self.BUTTONS_OK_CANCEL_PUT_OFF;
		local text = "";
		if stop then
			timer = 10;
			title = self.TITLE_STOPCONTRACT;
			buttons = self.BUTTONS_OK;
			text = string.format(self.msgText[self.MSG_STOPCONTRACT], contract.fillTypeName);
			if penalty and penalty > 0 then
				text = text.."\n"..string.format(self.msgText[self.MSG_PENALTY], math.abs(penalty), g_i18n.globalI18N:getCurrencySymbol(true));
			end;
		else
			text = string.format(self.msgText[self.MSG_NEWCONTRACT], contract.shopName, contract.fillTypeName, contract.volume, string.format("%s.", g_i18n:getText("unit_liter")), contract.pricePerCube, g_i18n.globalI18N:getCurrencySymbol(true), math.ceil(contract.duration));
		end;
		self.message = {
		["timer"] = timer,
		["title"] = title,
		["buttons"] = buttons,
		["contract"] = numContract,
		["text"] = text,
		["callbackOK"] = self.callbackCloseMessage};
		self:onStartMessage(noPutToHistory);
		if self.previewSound and not noPutToHistory then playSample(self.previewSound, 1, 1, 0); end;
		contract.postponed = false;
		if stop then
			self:cancelContract(numContract, false);
		end;
	end;
end;

function Economica:activateContract(numContract, newLevel)
	local contract = self.contracts[numContract];
	if contract then
		contract.active = true;
		contract.hudText = string.format("%s: %s", contract.shopName, contract.fillTypeName);
		local fillType = UniversalFactory.all[contract.numShop].fillType[contract.fillType];
		fillType.priceDelta = contract.multiplier;
		fillType.contract = true;
		if newLevel then
			fillType.contractLevel = 0;
		end;
		if g_server then
			g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, numContract, 0, 0, false));
		end;
	end;
	if self.message.contract then
		self:onCloseMessage();
	end;
end;

function Economica:putOffContract(numContract)
	local contract = self.contracts[numContract];
	if contract then
		contract.postponed = true;
		contract.hudText = string.format("%s: %s %d", contract.shopName, contract.fillTypeName, contract.volume);
		if g_server then
			g_server:broadcastEvent(EconomicaMessageCallbackEvent:new(false, false, 0, numContract, 0, false));
		end;
	end;
	if self.message.contract then
		self:onCloseMessage();
	end;
end;

function Economica:cancelContract(numContract, closeMessage)
	local contract = self.contracts[numContract];
	if contract then
		local fillType = UniversalFactory.all[contract.numShop].fillType[contract.fillType];
		fillType.priceDelta = 1;
		fillType.contract = false;
		fillType.contractLevel = 0;
		table.remove(self.contracts, numContract);
		if closeMessage and self.message.contract then
			self:onCloseMessage();
		end;
	end;
end;

function Economica:saveContracts(xmlFile)
	for i=1, #self.contracts do
		local contract = self.contracts[i];
		if contract.active or contract.postponed then
			local key = string.format("economica.contract(%d)", i-1);
			setXMLString(xmlFile, key.."#shopName", UniversalFactory.all[contract.numShop].factoryName);
			setXMLString(xmlFile, key.."#fillType", FillUtil.fillTypeIntToName[contract.fillType]);
			setXMLFloat(xmlFile, key.."#multiplier", contract.multiplier);
			setXMLFloat(xmlFile, key.."#pricePerCube", contract.pricePerCube);
			setXMLFloat(xmlFile, key.."#volume", contract.volume);
			setXMLInt(xmlFile, key.."#duration", contract.duration);
			setXMLInt(xmlFile, key.."#waitInterval", contract.waitInterval);
			setXMLInt(xmlFile, key.."#outputInterval", contract.outputIntervalBase);
			setXMLInt(xmlFile, key.."#endHour", contract.endHour);
			setXMLBool(xmlFile, key.."#postponed", contract.postponed);
			setXMLBool(xmlFile, key.."#active", contract.active);
		end;
	end;
end;
