--author: igor29381

function Economica:loadBuyablesDefaultData(xmlFile)
	if g_server then
		self.lowPriceSellIntervals = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.buyables#lowPriceSellInterval"), "150 250"))};
		self.lowPriceSellDurations = {Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, "economica.buyables#lowPriceSellDuration"), "10 20"))};
	end;
	local i = 0;
	while true do
		local key = string.format("economica.buyables.buyable(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local buyable = {};
		local name = getXMLString(xmlFile, key.."#name");
		buyable.name = g_i18n:getText(name);
		local neighbourName = getXMLString(xmlFile, key.."#neighbourName");
		if neighbourName then
			buyable.neighbourName = neighbourName;
		end;
		buyable.price = getXMLFloat(xmlFile, key.."#price");
		local objectId = 0;
		buyable.UniFactory = Utils.getNoNil(getXMLBool(xmlFile, key.."#UniFactory"), false);
		if buyable.UniFactory then
			objectId = UniversalFactory[name].nodeId;
		end;
		buyable.garage = Utils.getNoNil(getXMLBool(xmlFile, key.."#garage"), false);
		if buyable.garage then
			self:changeGarageOwner(name, false);
			objectId = Garage.main.garages[name].nodeId;
		end;
		local x, z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#xz"));
		buyable.x = x;
		buyable.z = z;
		if not x and not z then
			local x,_,z = getWorldTranslation(objectId);
			local sx, sz = self:mapCoordsToScreen(x, z);
			buyable.x = sx;
			buyable.z = sz;
		end;
		buyable.rating = getXMLInt(xmlFile, key.."#rating");
		buyable.ownerWantPrice = buyable.price;
		buyable.sellPrice = buyable.price*0.75;
		buyable.waitInterval = 0;
		buyable.request = false;
		buyable.ownerAgree = true;
		buyable.numCoins = 0;
		buyable.isOwned = false;
		buyable.hasMessage = false;
		buyable.needAnswer = false;
		self.buyables[name] = buyable;
		if g_server then
			if buyable.UniFactory then
				self:changeFactoryOwner(name, false);
			end;
		end;
		i = i + 1;
	end;
	--[[for _,fieldDef in pairs(g_currentMission.fieldDefinitionBase.fieldDefs) do
		local x,_,z = getWorldTranslation(fieldDef.fieldMapIndicator);
		local sx, sy = Economica:mapCoordsToScreen(x, z);
		local name = fieldDef.fieldName;
		if name == "" then name = tostring(fieldDef.fieldNumber); end;
		local buyable = {};
		buyable.name = g_i18n:getText("ui_fieldNo")..tostring(fieldDef.fieldNumber);
		buyable.field = fieldDef.fieldNumber;
		buyable.x = sx;
		buyable.z = sy-0.01;
		buyable.fieldArea = string.format("%s: %s %s", g_i18n:getText("ui_fieldArea"), string.sub(tostring(fieldDef.fieldArea),1,4), g_i18n:getText("unit_areaShort"));
		local rating = 0;
		if fieldDef.fieldArea > 30 then
			rating = 100;
		elseif fieldDef.fieldArea > 10 then
			rating = 40;
		end;
		buyable.rating = rating;
		buyable.price = fieldDef.fieldPrice;
		buyable.ownerWantPrice = buyable.price;
		buyable.sellPrice = buyable.price*0.75;
		buyable.waitInterval = 0;
		buyable.request = false;
		buyable.ownerAgree = true;
		buyable.numCoins = 0;
		buyable.isOwned = fieldDef.ownedByPlayer;
		buyable.hasMessage = false;
		buyable.needAnswer = false;
		self.buyables[name] = buyable;
	end;]]
end;

function Economica:loadBuyablesSaveData(xmlFile)
	local i = 0;
	while true do
		local key = string.format("economica.buyables.buyable(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		local name = getXMLString(xmlFile, key.."#name");
		if self.buyables[name] then
			local buyable = self.buyables[name];
			local isOwned = getXMLBool(xmlFile, key.."#isOwned");
			buyable.isOwned = isOwned;
			if buyable.UniFactory then
				self:changeFactoryOwner(name, isOwned);
			end;
			if buyable.garage then
				self:changeGarageOwner(name, isOwned);
			end;
			if not buyable.isOwned then
				buyable.ownerAgree = getXMLBool(xmlFile, key.."#ownerAgree");
				buyable.request = getXMLBool(xmlFile, key.."#request");
				buyable.waitInterval = Utils.getNoNil(getXMLFloat(xmlFile, key.."#waitInterval"), 0);
				buyable.ownerWantPrice = Utils.getNoNil(getXMLFloat(xmlFile, key.."#ownerWantPrice"), buyable.price);
				buyable.numCoins = Utils.getNoNil(getXMLInt(xmlFile, key.."#numCoins"), 0);
				buyable.hasMessage = Utils.getNoNil(getXMLBool(xmlFile, key.."#hasMessage"), false);
			end;
		end;
		i = i + 1;
	end;
	local lowPriceSellObjectName = getXMLString(xmlFile, "economica.buyables#lowPriceSellObjectName");
	if lowPriceSellObjectName then
		self.lowPriceSellObjectName = lowPriceSellObjectName;
		self.lowPriceActivated = true;
		self.lowPriceSellDuration = Utils.getNoNil(getXMLFloat(xmlFile, "economica.buyables#lowPriceSellDuration"), 0);
	end;
end;

function Economica:setLowPriceSellInterval()
	return math.random(self.lowPriceSellIntervals[1], self.lowPriceSellIntervals[2]);
end;

function Economica:updateBuyables(dt, timeScale)
	for name,buyable in pairs(self.buyables) do
		if buyable.waitInterval > 0 then
			buyable.waitInterval = math.max(buyable.waitInterval - dt*0.001*timeScale, 0);
		elseif not self.showMessage and buyable.request then
			self:showRequestResult(name);
			buyable.request = false;
			g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			if not buyable.ownerAgree then
				buyable.waitInterval = math.random(35, 55)*60*60;
			end;
		elseif not buyable.ownerAgree and not buyable.request then
			buyable.ownerAgree = true;
			g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
		end;
	end;
	if self.numNotBought > 0 then
		if not self.showMessage and self.lowPriceSellInterval == 0 then
			if not self.lowPriceActivated then
				local notBought = {};
				for name,buyable in pairs(self.buyables) do
					if not buyable.isOwned and buyable.ownerAgree and not buyable.request then table.insert(notBought, name); end;
				end;
				self.numNotBought = #notBought;
				if self.numNotBought > 0 then
					self.lowPriceSellObjectName = notBought[math.random(1, #notBought)];
					local buyable = self.buyables[self.lowPriceSellObjectName];
					local price = (buyable.price*0.001 - math.random(0, buyable.price*0.00025))*1000;
					buyable.ownerWantPrice = price;
					self.lowPriceSellDuration = math.random(self.lowPriceSellDurations[1], self.lowPriceSellDurations[2])*60*60;
					g_server:broadcastEvent(EconomicaLowPriceSellEvent:new(self.lowPriceSellObjectName, math.floor(price)));
					self:showLowPriceSellMessage(self.lowPriceSellObjectName, price);
					self.lowPriceActivated = true;
				end;
			end;
			self.lowPriceSellDuration = math.max(self.lowPriceSellDuration - dt*0.001*timeScale, 0);
			if self.lowPriceSellDuration == 0 then
				local buyable = self.buyables[self.lowPriceSellObjectName];
				buyable.ownerWantPrice = buyable.price;
				g_server:broadcastEvent(EconomicaLowPriceSellEvent:new(self.lowPriceSellObjectName, 0));
				self:showLowPriceSellMessage(self.lowPriceSellObjectName, 0);
				self.lowPriceActivated = false;
				self.lowPriceSellObjectName = "";
				self.lowPriceSellInterval = self:setLowPriceSellInterval();
			end;
		end;
	end;
end;

function Economica:showLowPriceSellMessage(name, price)
	local buyable = self.buyables[name];
	if buyable then
		local text = string.format(self.msgText[self.MSG_LOWPRICEFIN], buyable.name);
		if price > 0 then
			text = string.format(self.msgText[self.MSG_LOWPRICE], buyable.name, price, g_i18n.globalI18N:getCurrencySymbol(true))
		end;
		self.message = {
		["timer"] = self.buyMessageDuration,
		["title"] = self.TITLE_REALTOR_AGENCY,
		["buttons"] = self.BUTTONS_OK,
		["text"] = text,
		["callbackOK"] = self.callbackCloseMessage};
		if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
		self:onStartMessage();
	end;
end;

function Economica.realtorBuyObject(name)
	if g_server then
		Economica:buyObject(name);
	else
		g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, true, false, false, 0, false));
		Economica:onCloseMessage();
	end;
	Economica:onCloseMessage();
end;

function Economica:needMoreRating(name)
	local buyable = self.buyables[name];
	local rating = buyable.rating;
	if buyable.ownerWantPrice < buyable.price then rating = rating - 10; end;
	self.message = {
	["timer"] = self.buyMessageDuration,
	["title"] = self.TITLE_REALTOR_AGENCY,
	["buttons"] = self.BUTTONS_OK,
	["text"] = string.format(self.msgText[self.MSG_MORERATING], rating),
	["name"] = name,
	["callbackOK"] = self.realtorCancel};
	self:onStartMessage(true);
end;

function Economica.coinDealBuyObject(name)
	local buyable = Economica.buyables[name];
	if g_currentMission.missionStats.money < buyable.ownerWantPrice then
		g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
		Economica:onCloseMessage();
	elseif not buyable.isOwned and buyable.numCoins > 0 then
		if Economica.statistics.ownedGoldCoins >= buyable.numCoins then
			if g_server then
				Economica.statistics.coinDeals = Economica.statistics.coinDeals + 1;
				Economica.statistics.ownedGoldCoins = Economica.statistics.ownedGoldCoins - buyable.numCoins;
				buyable.numCoins = 0;
				Economica:buyObject(name);
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, true, false, false, 0, false));
				Economica:onCloseMessage();
			end;
		else
			g_currentMission:showBlinkingWarning(g_i18n:getText("notEnoughCoinsForDeal"), 3000);
			if g_server then
				buyable.numCoins = 0;
				g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, 0, false));
				Economica:onCloseMessage();
			end;
		end;
	end;
	Economica:onCloseMessage();
end;

function Economica.coinDealRequest(name)
	Economica:onCloseMessage();
	local buyable = Economica.buyables[name];
	if buyable.numCoins > 0 then
		if Economica.statistics.ownedGoldCoins >= buyable.numCoins then
			if g_server then
				Economica:priceRequestServer(name);
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, true, buyable.numCoins, false));
			end;
			Economica.message = {
			["timer"] = Economica.buyMessageDuration,
			["title"] = Economica.TITLE_REALTOR_AGENCY,
			["buttons"] = Economica.BUTTONS_OK,
			["text"] = Economica.msgText[Economica.MSG_WAITPRICE],
			["name"] = name,
			["callbackOK"] = Economica.callbackCloseMessage};
			Economica:onStartMessage(true);
		else
			g_currentMission:showBlinkingWarning(g_i18n:getText("notEnoughCoinsForDeal"), 3000);
			if g_server then
				buyable.numCoins = 0;
				g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, 0, false));
			end;
		end;
	end;
end;

function Economica.coinDealAbort(name)
	if g_server then
		Economica:badDeal(name);
		g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
	else
		g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, -1, false));
	end;
	Economica:onCloseMessage();
end;

function Economica:badDeal(name)
	local buyable = Economica.buyables[name];
	if not buyable.isOwned and buyable.ownerAgree then
		buyable.waitInterval = math.random(10, 17)*60*60;
		buyable.request = false;
		buyable.ownerAgree = false;
		buyable.ownerWantPrice = buyable.price;
		buyable.numCoins = 0;
		buyable.needAnswer = false;
	end;
end;

function Economica.realtorCancel(name)
	Economica:onCloseMessage();
	Economica:onBuyingCancel(name);
end;

function Economica:onBuyingCancel(name)
	local buyable = self.buyables[name];
	if not buyable.isOwned then
		local numCoins = math.random(5, 10);
		if self.rating < buyable.rating then
			numCoins = math.ceil((buyable.rating - self.rating)/3);
		end;
		if self.statistics.ownedGoldCoins > 0 and (buyable.ownerWantPrice - buyable.price > buyable.price*0.25
		or not buyable.ownerAgree or self.rating < buyable.rating) then
			if g_server then
				buyable.numCoins = numCoins;
				g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, numCoins, false));
			end;
			local callbackOK = self.coinDealRequest;
			if buyable.ownerWantPrice < buyable.price then
				callbackOK = self.coinDealBuyObject;
			end;
			self.message = {
			["timer"] = self.buyMessageDuration,
			["title"] = self.TITLE_REALTOR_AGENCY,
			["buttons"] = self.BUTTONS_OK_CANCEL,
			["text"] = string.format(self.msgText[self.MSG_MAYBECOINS], numCoins, buyable.name),
			["name"] = name,
			["callbackOK"] = callbackOK,
			["callbackCancel"] = self.coinDealCancel};
			self:onStartMessage();
		else
			if g_server then
				self:badDeal(name);
				g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, -1, false));
			end;
			self:onCloseMessage();
		end;
	end;
end;

function Economica.coinDealCancel(name)
	local buyable = Economica.buyables[name];
	if buyable and not buyable.isOwned then
		if g_server then
			buyable.numCoins = 0;
			g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
		else
			g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, false, 0, false));
		end;
	end;
	Economica:onCloseMessage();
end;

function Economica:priceRequest(name)
	local buyable = self.buyables[name];
	if buyable then
		if g_currentMission.missionStats.money < buyable.price then
			g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
		else
			if g_server then
				self:priceRequestServer(name);
			else
				g_client:getServerConnection():sendEvent(EconomicaBuyCallbackEvent:new(name, false, false, true, 0, false));
			end;
			self.message = {
			["timer"] = self.buyMessageDuration,
			["title"] = self.TITLE_REALTOR_AGENCY,
			["buttons"] = self.BUTTONS_OK,
			["text"] = self.msgText[self.MSG_WAITPRICE],
			["callbackOK"] = self.callbackCloseMessage};
			self:onStartMessage(true);
		end;
	end;
end;

function Economica:priceRequestServer(name)
	local buyable = self.buyables[name];
	if buyable then
		if buyable.numCoins > 0 then
			buyable.waitInterval = math.random(15, 30)*60;
			buyable.request = true;
			buyable.ownerAgree = true;
			if buyable.ownerWantPrice >= buyable.price then
				buyable.ownerWantPrice = (buyable.price + math.random(0, buyable.price*0.00025)*1000);
			end;
		else
			buyable.waitInterval = (math.random(10, 50)/10)*60*60;
			buyable.request = true;
			local ownerAgree = math.random(1, math.max(3, self.rating/5));
			buyable.ownerAgree = ownerAgree > 1;
			if buyable.ownerAgree then
				buyable.ownerWantPrice = (buyable.price + math.random(0, buyable.price/2000)*1000);
			end;
		end;
		g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
	end;
end;

function Economica:showRequestResult(name)
	local buyable = self.buyables[name];
	if buyable then
		buyable.needAnswer = true;
		local text = "";
		local buttons = self.BUTTONS_OK;
		local callbackOK = self.realtorCancel;
		local callbackCancel = self.realtorCancel;
		if buyable.ownerAgree then
			text = string.format(self.msgText[self.MSG_OWNERWANT], buyable.name, buyable.ownerWantPrice, g_i18n.globalI18N:getCurrencySymbol(true));
			buttons = self.BUTTONS_OK_CANCEL;
			callbackOK = self.realtorBuyObject;
		else
			text = string.format(self.msgText[self.MSG_OWNERDONOTWANT], buyable.name);
		end;
		if buyable.numCoins > 0 then
			callbackOK = self.coinDealBuyObject;
			callbackCancel = self.coinDealAbort;
		end;
		self.message = {
		["timer"] = self.buyMessageDuration,
		["title"] = self.TITLE_REALTOR_AGENCY,
		["buttons"] = buttons,
		["text"] = text,
		["name"] = name,
		["request"] = true,
		["callbackOK"] = callbackOK,
		["callbackCancel"] = callbackCancel};
		if self.previewSound then playSample(self.previewSound, 1, 1, 0); end;
		self:onStartMessage();
	end;
end;

function Economica:buyObject(name)
	local buyable = self.buyables[name];
	if not buyable.isOwned then
		local price = buyable.ownerWantPrice;
		if g_currentMission.missionStats.money < price then
			g_currentMission:showBlinkingWarning(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"), 3000);
		else
			if buyable.field then
				fieldDef = g_currentMission.fieldDefinitionBase.fieldDefs[buyable.field];
				g_currentMission.fieldDefinitionBase:setFieldOwnedByPlayer(fieldDef, true);
				g_server:broadcastEvent(EconomicaBuyableEvent:new("empty", buyable.field, true));
			else
				if buyable.UniFactory then
					self:changeFactoryOwner(name, true);
					g_server:broadcastEvent(EconomicaBuyableEvent:new(name, 0, true));
					EconomicaBuyableEvent:buyFactory(name);
					if buyable.neighbourName then
						if UniversalFactory[buyable.neighbourName] then
							EconomicaBuyableEvent:buyFactory(buyable.neighbourName);
						end;
					end;
					self:updateShops();
					local factory = UniversalFactory[name];
					factory:raiseDirtyFlags(factory.UniversalFactoryDirtyFlag);
				end;
				if buyable.garage then
					self:changeGarageOwner(name, true);
					g_server:broadcastEvent(EconomicaBuyableEvent:new(name, 0, true));
					if buyable.neighbourName then
						self:changeGarageOwner(buyable.neighbourName, true);
						g_server:broadcastEvent(EconomicaBuyableEvent:new(buyable.neighbourName, 0, true));
					end;
				end;
			end;
			if buyable.field or buyable.UniFactory then
				self.statistics.ownedObjects = self.statistics.ownedObjects + 1;
			end;
			buyable.isOwned = true;
			buyable.ownerWantPrice = buyable.price;
			buyable.needAnswer = false;
			g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
			if self.lowPriceActivated and self.lowPriceSellInterval == 0 and self.lowPriceSellObjectName == name then
				self.lowPriceSellObjectName = "";
				self.lowPriceActivated = false;
				self.lowPriceSellInterval = self:setLowPriceSellInterval();
			end;
			g_currentMission:addSharedMoney(-price, "other");
			g_currentMission:addMoneyChange(-price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("buyingProperty"));
		end;
	end;
	if self.message.title and self.message.title == self.TITLE_REALTOR_AGENCY then
		self:onCloseMessage();
	end;
end;

function Economica:changeFactoryOwner(name, isOwned)
	local buyable = self.buyables[name];
	local factory = UniversalFactory[name];
	factory.isOwned = isOwned;
	factory:setRentTriggerVisibility(not isOwned);
	factory:setRentFillTypes(not isOwned);
	if not isOwned then
		for i=1, #factory.jobStreams do
			local jobStream = factory.jobStreams[i];
			if jobStream.rentTimer > 0 then
				factory:setRentState(i, true);
			end;
		end;
	end;
	if factory.enableIfOwned and factory.repairTimer == 0 then
		factory.isEnabled = isOwned;
	end;
	if buyable.neighbourName then
		if UniversalFactory[buyable.neighbourName] then
			local neighbourFactory = UniversalFactory[buyable.neighbourName];
			neighbourFactory.isOwned = isOwned;
			neighbourFactory:setRentFillTypes(not isOwned);
			if neighbourFactory.enableIfOwned then
				neighbourFactory.isEnabled = isOwned;
			end;
			g_server:broadcastEvent(UniFactoryEvent:new(neighbourFactory.isEnabled, neighbourFactory.isOwned, neighbourFactory.repairTimer, neighbourFactory));
		elseif Garage.main.garages[buyable.neighbourName] then
			self:changeGarageOwner(buyable.neighbourName, isOwned);
			g_server:broadcastEvent(EconomicaBuyableEvent:new(buyable.neighbourName, 0, isOwned));
		end;
	end;
	g_server:broadcastEvent(UniFactoryEvent:new(factory.isEnabled, factory.isOwned, factory.repairTimer, factory));
end;

function Economica:changeGarageOwner(name, isOwned)
	Garage.main.garages[name].isOwned = isOwned;
end;

function Economica:sellObject(name)
	local buyable = self.buyables[name];
	local price = buyable.sellPrice;
	if buyable.field then
		fieldDef = g_currentMission.fieldDefinitionBase.fieldDefs[buyable.field];
		g_currentMission.fieldDefinitionBase:setFieldOwnedByPlayer(fieldDef, false);
		g_server:broadcastEvent(EconomicaBuyableEvent:new("empty", buyable.field, false));
	else
		if buyable.UniFactory then
			self:changeFactoryOwner(name, false);
			local factory = UniversalFactory[name];
			for _,fillType in pairs(factory.fillType) do
				fillType.rentLevel = fillType.level;
				fillType.level = 0;
				if factory.isWarehouse then
					fillType.rent = true;
				end;
			end;
		end;
		if buyable.garage then
			self:changeGarageOwner(name, false);
			g_server:broadcastEvent(EconomicaBuyableEvent:new(name, 0, false));
			if buyable.neighbourName then
				Garage.main.garages[buyable.neighbourName].isOwned = false;
				self:changeGarageOwner(buyable.neighbourName, false);
				g_server:broadcastEvent(EconomicaBuyableEvent:new(buyable.neighbourName, 0, false));
			end;
		end;
	end;
	if buyable.field or buyable.UniFactory then
		self.statistics.ownedObjects = self.statistics.ownedObjects - 1;
	end;
	buyable.isOwned = false;
	g_server:broadcastEvent(EconomicaBuyableStateEvent:new(name));
	g_currentMission:addSharedMoney(price, "other");
	g_currentMission:addMoneyChange(price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("sellingProperty"));
	self:updateShops();
	if self.message.name then
		self:onCloseMessage();
	end;
end;

function Economica:saveBuyables(xmlFile)
	local i=0;
	for name,buyable in pairs(self.buyables) do
		local buyableKey = string.format("economica.buyables.buyable(%d)", i);
		setXMLString(xmlFile, buyableKey.."#name", name);
		setXMLBool(xmlFile, buyableKey.."#isOwned", buyable.isOwned);
		if not buyable.isOwned then
			setXMLBool(xmlFile, buyableKey.."#ownerAgree", buyable.ownerAgree);
			setXMLBool(xmlFile, buyableKey.."#request", buyable.request);
			if buyable.waitInterval > 0 then
				setXMLFloat(xmlFile, buyableKey.."#waitInterval", buyable.waitInterval);
			end;
			if buyable.ownerWantPrice ~= buyable.price then
				setXMLFloat(xmlFile, buyableKey.."#ownerWantPrice", buyable.ownerWantPrice);
			end;
			if buyable.numCoins > 0 then
				setXMLInt(xmlFile, buyableKey.."#numCoins", buyable.numCoins);
			end;
			if buyable.hasMessage then
				setXMLBool(xmlFile, buyableKey.."#hasMessage", true);
			end;
		end;
		i = i + 1;
	end;
	if self.lowPriceSellObjectName ~= "" then
		setXMLString(xmlFile, "economica.buyables#lowPriceSellObjectName", self.lowPriceSellObjectName);
		setXMLFloat(xmlFile, "economica.buyables#lowPriceSellDuration", self.lowPriceSellDuration);
	end;
end;
