--author: igor29381

DirtyTrigger = {};
DirtyTrigger.carWash = {};
DirtyTrigger_mt = Class(DirtyTrigger, Object);

function DirtyTrigger.onCreate(id)
    local object = DirtyTrigger:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end;
end;

function DirtyTrigger:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = DirtyTrigger_mt
    end;
    local self = Object:new(isServer, isClient, DirtyTrigger_mt);
    registerObjectClassName(self, "DirtyTrigger");
	self.washingDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function DirtyTrigger:load(id)
	self.isRoof = Utils.getNoNil(getUserAttribute(id, "isRoof"), false);
	self.waterPlane = Utils.getNoNil(getUserAttribute(id, "waterPlane"), false);
	self.carWash = Utils.getNoNil(getUserAttribute(id, "carWash"), false);
	self.trigger = id;
	addTrigger(self.trigger, "triggerCallback", self);
	if self.isRoof then
		self.vehicles = {};
	elseif self.carWash then
		self.isOwned = true;
		self.price = Utils.getNoNil(getUserAttribute(id, "price"), 0);
		self.pricePerSecond = Utils.getNoNil(getUserAttribute(id, "pricePerSecond"), 1);
		if self.price > 0 then
			self.isOwned = false;
		end;
		DirtyTrigger.carWash[id] = self;
	end;
	self.isEnabled = true;
    return true;
end;

function DirtyTrigger:loadWashers(id)
	local waterStreams = getUserAttribute(id, "waterStreams");
	if waterStreams then
		waterStreams = Utils.indexToObject(id, waterStreams);
		if waterStreams then
			self.waterStreams = waterStreams;
			local numSpawns = getNumOfChildren(waterStreams);
			if numSpawns > 0 then
				local kaercherRoot = Utils.loadSharedI3DFile(TrafficManager.curModDir.."maps/particleSystems/kaercherHDS918-4M.i3d");
				if kaercherRoot then
					local water = getChildAt(kaercherRoot, 0);
					local material = MaterialUtil.getMaterial(FillUtil.FILLTYPE_WATER, "WASHER", 1);
					link(self.waterStreams, water);
					delete(kaercherRoot);
					self.wps = {};
					for i=1, numSpawns do
						local spawn = getChildAt(waterStreams, i-1);
						local x,y,z = getTranslation(spawn);
						local rx,ry,rz = getRotation(spawn);
						local waterStream = clone(water, true);
						if material then
							setMaterial(waterStream, material, 0);
						end
						setTranslation(waterStream, x,y,z);
						setRotation(waterStream, rx,ry,rz);
						local psData = {};
						psData.psFile = "maps/particleSystems/kaercherHDS918-4MParticles.i3d";
						psData.posX, psData.posY, psData.posZ = x, y, z;
						psData.rotX, psData.rotY, psData.rotZ = rx, ry, rz;
						psData.worldSpace = false;
						self.wps[i] = {};
						Utils.loadParticleSystemFromData(psData, self.wps[i], nil, false, nil, g_currentMission.baseDirectory, self.waterStreams);
					end;
					delete(water);
				end;
			end;
			local sound = createAudioSource("WaterSound", "data/placeables/highPressureWasher/kaercher/kaercherHDS918-4M_run.wav", 30, 15, 1, 0);
			link(self.waterStreams, sound);
			setVisibility(self.waterStreams, false);
			self.timer = 0;
		end;
	end;
end;

function DirtyTrigger:delete()
	if self.trigger then removeTrigger(self.trigger); end;
	if self.wps then
		for _,ps in pairs(self.wps) do
			Utils.deleteParticleSystem(ps);
		end;
	end;
	DirtyTrigger:superClass().delete(self);
end;

function DirtyTrigger:readUpdateStream(streamId, timestamp, connection)
	DirtyTrigger:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		self.washing = streamReadBool(streamId);
		if self.waterStreams then
			setVisibility(self.waterStreams, self.washing);
			for _,ps in pairs(self.wps) do
				ParticleUtil.setEmittingState(ps, self.washing);
			end;
		end;
	end;
end;

function DirtyTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	DirtyTrigger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.washing);
	end;
end;

function DirtyTrigger:update(dt)
	if g_currentMission.player and g_currentMission.player.isEntered and not g_gui:getIsGuiVisible() then
		local xt, yt, zt = getTranslation(g_currentMission.player.rootNode);
		if yt - g_currentMission.waterY <= -0.6 then
			setTranslation(g_currentMission.player.rootNode, xt, yt+0.01, zt);
		end;
	end;
end;

function DirtyTrigger:updateTick()
end;

function DirtyTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled and self.isServer then
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle then
			if onEnter then
				if self.isRoof then vehicle.underRoof = true; end;
				if self.waterPlane then
					if vehicle:getIsActive() then
						vehicle.isBroken = true;
						g_currentMission:onSunkVehicle(vehicle);
						if vehicle.isEntered then
							if vehicle:getIsActiveForSound() then
								local volume = math.min(1, vehicle:getLastSpeed()/30);
								if vehicle.sampleWaterSplash ~= nil then
									SoundUtil.playSample(vehicle.sampleWaterSplash, 1, 0, volume);
								else
									SoundUtil.playSample(g_currentMission.sampleWaterSplash, 1, 0, volume);
								end;
							end;
							g_currentMission:onLeaveVehicle();
						end;
					end;
					vehicle.showWaterWarning = deltaWater < 2;
				end;
				if self.carWash then
					vehicle.carWashTrigger = self;
				end;
			elseif onLeave then
				if self.isRoof then vehicle.underRoof = false; end;
				if self.carWash then
					vehicle.carWashTrigger = nil;

					if self.waterStreams then
						setVisibility(self.waterStreams, false);
						for _,ps in pairs(self.wps) do
							ParticleUtil.setEmittingState(ps, false);
						end;
					end;
					self.timer = 0;
					self.washing = false;
					self:raiseDirtyFlags(self.washingDirtyFlag);
				end;
			end;
		end;
	end;
end;
g_onCreateUtil.addOnCreateFunction("DirtyTrigger", DirtyTrigger.onCreate);
