--author: vampire_007

Crane = {};

Crane_mt = Class(Crane, Object);
InitObjectClass(Crane, "Crane");

function Crane.onCreate(id)
	local object = Crane:new(g_server ~= nil, g_client ~= nil)
	g_currentMission:addOnCreateLoadedObject(object);
	object:load(id);
	object:register(true);
end;

function Crane:new(isServer, isClient, customMt)
	if customMt == nil then customMt = Crane_mt; end;
	return Object:new(isServer, isClient, customMt);
end;

function Crane:load(id)
	self.rotationState = 0;
	local top = getChild(id, "CraneTop");
	if top > 0 then
		self.rootID = id;
		self.top = top;
		local _, ry, _ = getRotation(self.top);
		ry = ry - math.rad(180);
		self.initialAngle = ry;
		local rotAngle = Utils.getNoNil(getUserAttribute(id, "rotationAngle"), 180);
		self.direction = (rotAngle > 0 and 1 or rotAngle < 0 and -1 or 0);
		self.rotationAngle = ry + math.rad(rotAngle);
		self.rotationSpeed = math.abs(Utils.getNoNil(getUserAttribute(id, "rotationSpeed"), 0.0001));

		self.topSound = getChild(id, "rotationSound");
		if self.topSound > 0 then setVisibility(self.topSound, false); else self.topSound = nil; end;

		self.waitTime = 30000;
		self.currentWait = 0;
		self.currentAngle = ry;
		g_currentMission.environment:addMinuteChangeListener(self);
	end;
end;

function Crane:delete()
	if g_currentMission.environment ~= nil then
		g_currentMission.environment:removeMinuteChangeListener(self);
	end;
	Crane:superClass().delete(self);
end;

function Crane:readStream(streamId, connection)
end;

function Crane:writeStream(streamId, connection)
end;

function Crane:readUpdateStream(streamId, timestamp, connection)
end;

function Crane:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Crane:minuteChanged()
	if self.currentWait == 0 and self.rotationState == 0 and g_currentMission.environment.currentMinute % 10 == 0 then
		self.rotationState = 1;
	end;
end;

function Crane:update(dt)
	if self.currentWait == 0 then
		if self.rotationState ~= 0 then
			if self.topSound and not getVisibility(self.topSound) then
				setVisibility(self.topSound, true);
			end;
			local deltaAngle = self.rotationSpeed * dt * self.direction * self.rotationState;
			local delta_sign = (deltaAngle > 0 and 1 or deltaAngle < 0 and -1 or 0);
			self.currentAngle = self.currentAngle + deltaAngle;
			if self.rotationState == 1 and delta_sign * (self.currentAngle - self.rotationAngle) > 0 then
				self.rotationState = -1;
				self.currentWait = self.waitTime;
				if self.topSound then setVisibility(self.topSound, false); end;
			elseif self.rotationState == -1 and delta_sign * (self.currentAngle - self.initialAngle) >= 0 then
				self.currentAngle = self.initialAngle;
				self.rotationState = 0;
				self.currentWait = self.waitTime;
				if self.topSound then setVisibility(self.topSound, false); end;
			end;
			setRotation(self.top, 0, self.currentAngle, 0);
		end;
	else
		self.currentWait = self.currentWait - dt;
		if self.currentWait < 0 then
			self.currentWait = 0;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("Crane", Crane.onCreate);
