--authors: igor29381, Giants (some changed functions)

ChangedFunctions = {};
OriginalFunctions = {};
BaseMission.loadMapOriginal = BaseMission.loadMap;
Mission00.loadMission00FinishedOriginal = Mission00.loadMission00Finished;
IngameMap.newOriginal = IngameMap.new;

source(g_currentModDirectory.."maps/scripts/AnimalHusbandryChanges.lua", "Perestroyka");

function ChangedFunctions:load()
	OriginalFunctions.onClickResetVehicle = g_inGameMenu.mapSelectionReset.onClickCallback;
	g_inGameMenu.mapSelectionReset.onClickCallback = ChangedFunctions.onClickResetVehicle;
	OriginalFunctions.onYesNoReset = InGameMenu.onYesNoReset;
	InGameMenu.onYesNoReset = ChangedFunctions.onYesNoReset;
	OriginalFunctions.onVehicleReset = InGameMenu.onVehicleReset;
	InGameMenu.onVehicleReset = ChangedFunctions.onVehicleReset;
	g_inGameMenu.mapSelectionReset.text = g_i18n:getText("resetBase");
	OriginalFunctions.getDriveGroundParticleSystemsScale = Vehicle.getDriveGroundParticleSystemsScale;
	Vehicle.getDriveGroundParticleSystemsScale = ChangedFunctions.getDriveGroundParticleSystemsScale;
	OriginalFunctions.updateWheelsGraphics = WheelsUtil.updateWheelsGraphics;
	WheelsUtil.updateWheelsGraphics = ChangedFunctions.updateWheelsGraphics;
	SpecializationUtil.registerSpecialization('terrainControl', 'terrainControl', TrafficManager.curModDir..'maps/scripts/terrainControl.lua');
	SpecializationUtil.registerSpecialization('unloadingSpec', 'UnloadingSpec', TrafficManager.curModDir..'maps/scripts/UnloadingSpec.lua');
	for k,v in pairs(VehicleTypeUtil.vehicleTypes) do
		if v ~= nil then
			table.insert(v.specializations, SpecializationUtil.getSpecialization("terrainControl"));
			if SpecializationUtil.hasSpecialization(SowingMachine, v.specializations) or
			SpecializationUtil.hasSpecialization(Sprayer, v.specializations) then
				table.insert(v.specializations, SpecializationUtil.getSpecialization("unloadingSpec"));
			end;
		end;
	end;
	FSBaseMission.drawVehicleHud = Utils.appendedFunction(FSBaseMission.drawVehicleHud, ChangedFunctions.drawVehicleHud);
	OriginalFunctions.woodHarvesterCutTree = WoodHarvester.cutTree;
	WoodHarvester.cutTree = ChangedFunctions.cutTree;
	OriginalFunctions.chainsawUtilCutSplitShape = ChainsawUtil.cutSplitShape;
	ChainsawUtil.cutSplitShape = ChangedFunctions.cutSplitShape;
	OriginalFunctions.origStumpCutterUpdateTick = StumpCutter.updateTick;
	StumpCutter.updateTick = ChangedFunctions.StumpCutterUpdateTick;
	for _,entry in pairs(getfenv(0)) do
		if type(entry) == "table" and entry.courseplay then
			OriginalFunctions.courseplay = entry.courseplay;
			break;
		end;
	end;
	OriginalFunctions.processFruitPreparerAreas = FruitPreparer.processFruitPreparerAreas;
	FruitPreparer.processFruitPreparerAreas = ChangedFunctions.processFruitPreparerAreas;
	OriginalFunctions.processPloughAreas = Plough.processPloughAreas;
	Plough.processPloughAreas = ChangedFunctions.processPloughAreas;
	OriginalFunctions.updateCultivatorArea = Utils.updateCultivatorArea;
	local function updateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle)
		Utils.destroyStrawDensity(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		return OriginalFunctions.updateCultivatorArea(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, forced, commonForced, angle);
	end;
	Utils.updateCultivatorArea = updateCultivatorArea;
	OriginalFunctions.updateDirectSowingArea = Utils.updateDirectSowingArea;
	local function updateDirectSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, plantValue)
		Utils.destroyStrawDensity(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		return OriginalFunctions.updateDirectSowingArea(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ, angle, plantValue);
	end;
	Utils.updateDirectSowingArea = updateDirectSowingArea;
	OriginalFunctions.washableUpdateTick = Washable.updateTick;
	Washable.updateTick = ChangedFunctions.washableUpdateTick;
	OriginalFunctions.manageGreatDemands = EconomyManager.manageGreatDemands;
	EconomyManager.manageGreatDemands = function() end;
	AttacherJoints.registerJointType("FillingStation");
	AttacherJoints.registerJointType("unloadingPipe");
	FieldJob.CATEGROY_FIELDSIZE_SMALL = 3;
	FieldJob.CATEGROY_FIELDSIZE_MEDIUM = 3;
	local overlay = g_currentMission.hudTipperOverlay;
	g_currentMission.hudLoadOverlay = Overlay:new("hudLoadOverlay", TrafficManager.curModDir..'maps/models/texturen/greenArrow.dds', overlay.x, overlay.y, overlay.width, overlay.height);
	print('map "Perestroyka');
end;

function IngameMap:new()
	table.insert(g_gameplayHints.new, {g_i18n:getText("briefingText1"), g_i18n:getText("briefingText2"), g_i18n:getText("briefingText3")});
	g_mpLoadingScreen.currentGameplayHintGroup = #g_gameplayHints.new;
	g_mpLoadingScreen:setGameplayHint(g_mpLoadingScreen.currentGameplayHintGroup, 1);
	local ingameMap = IngameMap:newOriginal();
	ingameMap.defaultHotspotWidth, ingameMap.defaultHotspotHeight = getNormalizedScreenValues(10,10);
	return ingameMap;
end;

function BaseMission:loadMap(filename, addPhysics, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments)
	FruitRegister:load();
	TrafficManager:loadData();
	ChangedFunctions:load();
	addModEventListener(UniversalFactoryHUD);
	addModEventListener(Economica);
	self:loadMapOriginal(filename, addPhysics, asyncCallbackFunction, asyncCallbackObject, asyncCallbackArguments);
end;

function Mission00:loadMission00Finished(node, arguments)
	self:loadMission00FinishedOriginal(node, arguments);
	local densities = {	"dirty", "dirty_sand", "dirty_gravel", "lightStraw", "darkStraw", "maizeStraw",
						"sunflowerStraw", "townDecoGrass", "bushes", "Schilf", "Unkraut"};
	for i=1, #densities do
		local key = string.format("%sDensityId", densities[i]);
		if not terrainControl[key] then
			terrainControl[key] = Utils.getNoNil(getChild(g_currentMission.terrainRootNode, densities[i]), 0);
		end;
	end;
	terrainControl.fruitTypes = {FruitUtil.FRUITTYPE_WHEAT,
								FruitUtil.FRUITTYPE_BARLEY,
								FruitUtil.FRUITTYPE_RAPE,
								FruitUtil.FRUITTYPE_SUNFLOWER,
								FruitUtil.FRUITTYPE_SOYBEAN,
								FruitUtil.FRUITTYPE_RYE,
								FruitUtil.FRUITTYPE_MAIZE,
								FruitUtil.FRUITTYPE_GRASS,
								FruitUtil.FRUITTYPE_OILSEEDRADISH,
								FruitUtil.FRUITTYPE_POPLAR};
	terrainControl.saveDensities = {terrainControl.dirtyDensityId,
									terrainControl.lightStrawDensityId,
									terrainControl.townDecoGrassDensityId,
									terrainControl.bushesDensityId,
									terrainControl.SchilfDensityId,
									terrainControl.UnkrautDensityId};
	terrainControl.strawDensity = {	terrainControl.lightStrawDensityId, terrainControl.darkStrawDensityId,
									terrainControl.maizeStrawDensityId, terrainControl.sunflowerStrawDensityId};
	terrainControl.decoDensity = {	terrainControl.townDecoGrassDensityId, terrainControl.bushesDensityId,
									terrainControl.SchilfDensityId, terrainControl.UnkrautDensityId};
	local sentDensity = 		{	terrainControl.lightStrawDensityId, terrainControl.darkStrawDensityId,
									terrainControl.maizeStrawDensityId, terrainControl.sunflowerStrawDensityId,
									terrainControl.townDecoGrassDensityId, terrainControl.bushesDensityId,
									terrainControl.SchilfDensityId, terrainControl.UnkrautDensityId};
	for i=1, #sentDensity do
		addDensityMapSyncerDensityMap(g_currentMission.densityMapSyncer, sentDensity[i]);
	end;
	terrainControl.fruitTypesToStraw = {[FruitUtil.FRUITTYPE_WHEAT] = terrainControl.lightStrawDensityId,
										[FruitUtil.FRUITTYPE_BARLEY] = terrainControl.lightStrawDensityId,
										[FruitUtil.FRUITTYPE_RAPE] = terrainControl.lightStrawDensityId,
										[FruitUtil.FRUITTYPE_MAIZE] = terrainControl.maizeStrawDensityId,
										[FruitUtil.FRUITTYPE_SUNFLOWER] = terrainControl.sunflowerStrawDensityId,
										[FruitUtil.FRUITTYPE_RYE] = terrainControl.lightStrawDensityId,
										[FruitUtil.FRUITTYPE_SOYBEAN] = terrainControl.lightStrawDensityId,
										[FruitUtil.FRUITTYPE_OILSEEDRADISH] = terrainControl.darkStrawDensityId,
										[FruitUtil.FRUITTYPE_POPLAR] = terrainControl.maizeStrawDensityId};
	terrainControl.cutFruitsByWheels = true;
	if g_currentMission.driveControl and g_currentMission.driveControl.useModules then
		g_currentMission.driveControl.useModules.groundResponse = false;
		g_currentMission.driveControl.useModules.fruitDestruction = false;
	end;
	for id,carWash in pairs(DirtyTrigger.carWash) do
		carWash:loadWashers(id);
	end;
	FruitRegister:addMaterials();
	UniversalFactoryHUD.goodWeather = false;
	if g_currentMission.environment.isSunOn and g_currentMission.environment.currentRain == nil then
		UniversalFactoryHUD.goodWeather = true;
	end;
end;

function ChangedFunctions:onClickResetVehicle(element)
    if self.pagingElement:getCurrentPageId() == InGameMenu.PAGE_MAP_OVERVIEW then
        if not (g_currentMission.tourIconsBase ~= nil and g_currentMission.tourIconsBase.visible) and self.currentHotspot ~= nil then
            g_gui:showYesNoDialog({text=g_i18n:getText("resetVehicleText"), title=g_i18n:getText("resetBase"), callback=self.onYesNoReset, target=self});
        end;
    end;
end;

function ChangedFunctions:onYesNoReset(yes)
    if yes then
        if self.currentHotspot ~= nil then
            local vehicle = g_currentMission.nodeToVehicle[self.currentHotspot.objectId]
            if vehicle ~= nil then
                if not g_currentMission.controlPlayer and g_currentMission.controlledVehicle ~= nil and vehicle == g_currentMission.controlledVehicle then
                    g_currentMission:onLeaveVehicle();
                end
                local rootAttacherVehicle = vehicle:getRootAttacherVehicle();
                if not rootAttacherVehicle.aiIsStarted then
					local vx, _, vz = getWorldTranslation(vehicle.rootNode);
					local distance = Utils.vector2Length(181-vx, 23-vz);
					local mass = vehicle:getTotalMass();
					local brokenCoeff = 1;
					local text = g_i18n:getText("evacuator");
					if vehicle.isBroken then
						brokenCoeff = 2;
						text = g_i18n:getText("rescue_service");
					end;
					local distancePrice = 1500;
					if distance > 1000 then
						distancePrice = 1500+(distance-1000)*1.5;
					end;
					local price = (distancePrice + mass*300)*brokenCoeff;
					self.resetText = string.format("%s %d%s", text, price, g_i18n.globalI18N:getCurrencySymbol(true));
					if g_server then
						g_currentMission:addSharedMoney(-price, "vehicleRunningCost");
						g_currentMission:addMoneyChange(-price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_vehicleRunningCost"));
					else
						g_client:getServerConnection():sendEvent(VehicleResetPriceEvent:new(math.floor(-price)));
					end;
                    g_client:getServerConnection():sendEvent(ResetVehicleEvent:new(vehicle));
                    self:updateVehicleSelectionIcons();
                else
                    g_gui:showInfoDialog({text=g_i18n:getText("shop_messageReturnVehicleInUse"), callback=self.onInfoOkClick, target=self})
                end
            end
        end;
    end;
end;

function ChangedFunctions:onVehicleReset(state)
    if state == ResetVehicleEvent.STATE_SUCCESS then
		g_gui:showInfoDialog({text=self.resetText, dialogType=DialogElement.TYPE_INFO, callback=self.onInfoOkClick, target=self});
    elseif state == ResetVehicleEvent.STATE_FAILED then
        g_gui:showInfoDialog({text=g_i18n:getText("resetVehicleFailed"), callback=self.onInfoOkClick, target=self})
    elseif state == ResetVehicleEvent.STATE_IN_USE then
        g_gui:showInfoDialog({text=g_i18n:getText("shop_messageReturnVehicleInUse"), callback=self.onInfoOkClick, target=self})
    else
        g_gui:showInfoDialog({text=g_i18n:getText("shop_messageNoPermissionGeneral"), callback=self.onInfoOkClick, target=self})
    end;
end;

function ChangedFunctions:drawVehicleHud()
	if g_currentMission.controlledVehicle then
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_BIGFILLTYPEOVERLAY] then
			local fillLevelInformations = {};
			g_currentMission.controlledVehicle:getFillLevelInformation(fillLevelInformations);
			for i=1, #fillLevelInformations do
				local fillType = fillLevelInformations[i].fillType;
				if fillType ~= FillUtil.FILLTYPE_UNKNOWN then
					local icon = g_currentMission.fillTypeOverlays[fillType];
					local label = FillUtil.fillTypeIndexToDesc[fillType].nameI18N;
					if icon and label then
						icon:setColor(1, 1, 1, 1);
						renderOverlay(icon.overlayId, 0.975-i*0.084, 0.25, icon.width*3.5, icon.height*2.5);
						setTextAlignment(RenderText.ALIGN_LEFT);
						setTextColor(1, 1, 1, 1);
						setTextBold(false);
						renderText(0.975-i*0.084, 0.23, UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FONTSIZE], label);
					end;
				end;
			end;
		end;
	end;
end;

function FSBaseMission:drawHudIcon()
    local overlay = nil;
    if self.activeHudIconName == "tip" then
        overlay = self.hudTipperOverlay;
    elseif self.activeHudIconName == "attach" then
        overlay = self.hudAttachmentOverlay;
    elseif self.activeHudIconName == "refuel" then
        overlay = self.hudFuelOverlay;
    elseif self.activeHudIconName == "detachingNotAllowed" then
        overlay = self.hudDetachingNotAllowedOverlay;
	elseif self.activeHudIconName == "load" then
		overlay = self.hudLoadOverlay;
    end;
    if overlay ~= nil then
        overlay:setColor(nil,nil,nil,self.activeHudIconAlpha);
        overlay:render();
    end;
    self.activeHudIconName = "";
    self.activeHudIconPriority = 0;
    self.activeHudIconAlpha = 1;
end;

function ChangedFunctions:cutTree(length, noEventSend)
	WoodHarvesterCutTreeEvent.sendEvent(self, length, noEventSend);
	if self.isServer then
		if length == 0 then
			if self.attachedSplitShape ~= nil or self.curSplitShape ~= nil then
				self.cutTimer = 100;
				if self.cutAnimation.name ~= nil then
					self:setAnimationTime(self.cutAnimation.name, 0, true);
					self:playAnimation(self.cutAnimation.name, self.cutAnimation.speedScale, self:getAnimationTime(self.cutAnimation.name));
				end;
			end;
		elseif length > 0 and self.attachedSplitShape ~= nil then
			self.attachedSplitShapeTargetY = self.attachedSplitShapeLastCutY + length;
			self.delimbDistance = length;
			self:onDelimbTree(true);
			if g_server ~= nil then
				g_server:broadcastEvent(WoodHarvesterOnDelimbTreeEvent:new(self, true), nil, nil, self);
			end;
		end;
		if self.curSplitShape ~= nil and getRigidBodyType(self.curSplitShape) == "Static" then
			local x,_,z = getWorldTranslation(self.curSplitShape);
			if not Economica:getOwnedTerritory(x,z) then
				Economica:testWoodLicense();
			end;
		end;
	end;
end;

function ChainsawUtil:getSplitPhysics()
	local split0 = ChainsawUtil.curSplitShapes[1];
	local split1 = ChainsawUtil.curSplitShapes[2];
	local type0 = getRigidBodyType(split0.shape);
	local type1 = getRigidBodyType(split1.shape);
	local dynamicSplit = nil;
	local staticSplit = nil;
	if type0 == "Static" and type1 == "Dynamic" then
		staticSplit = split0;
		dynamicSplit = split1;
	elseif type1 == "Static" and type0 == "Dynamic" then
		staticSplit = split1;
		dynamicSplit = split0;
	end;
	if (type0 == "Static" and type1 == "Dynamic") or (type1 == "Static" and type0 == "Dynamic") then
		g_currentMission.missionStats:updateStats("cutTreeCount", 1);
		if splitTypeName ~= "" then
			g_currentMission.missionStats:updateTreeTypesCut(splitTypeName);
		end;
	end;
	if staticSplit then
		local x,_,z = getWorldTranslation(staticSplit.shape);
		local sizeX, _, _, _, _ = getSplitShapeStats(dynamicSplit.shape);
		local sizeXS, _, _, _, _ = getSplitShapeStats(staticSplit.shape);
		if sizeX/sizeXS > 3 and not Economica:getOwnedTerritory(x,z) then
			Economica:testWoodLicense();
		end;
	end;
	return dynamicSplit, staticSplit;
end;

function ChangedFunctions.cutSplitShape(shape, x,y,z, nx,ny,nz, yx,yy,yz, cutSizeY, cutSizeZ)
    local splitTypeName = "";
    local splitType = SplitUtil.splitTypes[getSplitType(shape)];
    if splitType ~= nil then
        splitTypeName = splitType.name;
    end;
	if math.abs(ny) < 0.96 then
		ChainsawUtil.curSplitShapes = {};
		splitShape(shape, x,y,z, nx,ny,nz, yx,yy,yz, cutSizeY, cutSizeZ, "ChainsawUtil.cutSplitShapeCallback", nil);
		if table.getn(ChainsawUtil.curSplitShapes) == 2 then
			ChainsawUtil:getSplitPhysics();
		end;
	else
		ChainsawUtil.curSplitShapes = {};
		splitShape(shape, x,y,z, nx,ny,nz, yx,yy,yz, cutSizeY, cutSizeZ, "ChainsawUtil.cutSplitShapeCallback", nil);
		if table.getn(ChainsawUtil.curSplitShapes) == 2 then
			local dynamicSplit, staticSplit = ChainsawUtil:getSplitPhysics();
			if dynamicSplit ~= nil then
				local distY = dynamicSplit.minY + (dynamicSplit.maxY-dynamicSplit.minY)*0.75; -- create hinge at 75% of the tree
				local distZ = (dynamicSplit.minZ+dynamicSplit.maxZ)*0.5;
				local zx,zy,zz = Utils.crossProduct(nx,ny,nz, yx,yy,yz);
				local angle = math.rad(40);
				local scale0 = math.sin(1.5707-angle);
				local scale1 = math.sin(angle);
				if dynamicSplit.isBelow then scale1 = -scale1; end;
				local nx2 = nx*scale0 + yx*scale1;
				local ny2 = ny*scale0 + yy*scale1;
				local nz2 = nz*scale0 + yz*scale1;
				local yx2,yy2,yz2 = Utils.crossProduct(zx,zy,zz, nx2,ny2,nz2);
				local cx = x + yx*distY - yx2*cutSizeY*0.1;
				local cy = y + yy*distY - yy2*cutSizeY*0.1;
				local cz = z + yz*distY - yz2*cutSizeY*0.1;
				splitShape(staticSplit.shape, cx,cy,cz, nx2,ny2,nz2, yx2,yy2,yz2, cutSizeY*1.1, cutSizeZ);
				local jx = x + yx*distY + zx*distZ;
				local jy = y + yy*distY + zy*distZ;
				local jz = z + yz*distY + zz*distZ;
				local constr = JointConstructor:new();
				constr:setActors(0, dynamicSplit.shape);
				constr:setJointWorldAxes(nx,ny,nz, nx,ny,nz);
				constr:setJointWorldNormals(yx,yy,yz, yx,yy,yz);
				constr:setJointWorldPositions(jx, jy, jz, jx, jy, jz);
				constr:setRotationLimit(0, 0, 0);
				constr:setTranslationLimit(0, false, 0, 0);
				constr:setEnableCollision(true);
				local jointIndex = constr:finalize();
				local ax,ay,az = Utils.crossProduct(0,0.8,0, yx,yy, yz);
				setAngularVelocity(dynamicSplit.shape, ax,ay,az);
				TreePlantUtil.addTreeCutJoint(g_currentMission.plantedTrees, jointIndex, dynamicSplit.shape, nx,ny,nz, math.rad(45), 2000);
                g_currentMission.missionStats:updateStats("cutTreeCount", 1);
                if splitTypeName ~= "" then
                    g_currentMission.missionStats:updateTreeTypesCut(splitTypeName);
                end;
			end;
		end;
	end;
end;

function ChangedFunctions:StumpCutterUpdateTick(dt)
    if self:getIsActive() then
        if self:getIsTurnedOn() then
            if self.stumpCutterCutNode ~= nil then
                self.curLenAbove = 0;
                local x,y,z = getWorldTranslation(self.stumpCutterCutNode);
                local nx,ny,nz = localDirectionToWorld(self.stumpCutterCutNode, 1,0,0);
                local yx,yy,yz = localDirectionToWorld(self.stumpCutterCutNode, 0,1,0);
                if self.curSplitShape ~= nil then
                    if testSplitShape(self.curSplitShape, x,y,z, nx,ny,nz, yx,yy,yz, self.stumpCutterCutSizeY, self.stumpCutterCutSizeZ) == nil then
                        self.curSplitShape = nil;
                    end
                end
                if self.curSplitShape == nil then
                    local shape, _, _, _, _ = findSplitShape(x,y,z, nx,ny,nz, yx,yy,yz, self.stumpCutterCutSizeY, self.stumpCutterCutSizeZ);
                    if shape ~= 0 then
                        self.curSplitShape = shape;
                    end
                end
                if self.stumpCutterParticleSystems ~= nil then
                    for _, ps in pairs(self.stumpCutterParticleSystems) do
                        ParticleUtil.setEmittingState(ps, self.curSplitShape ~= nil);
                    end;
                end;
                if self.curSplitShape ~= nil then
                    self.workFadeTime = math.min(self.maxWorkFadeTime, self.workFadeTime + dt);
                    if self.isServer then
                        self.resetCutTime = self.maxResetCutTime;
                        if self.nextCutTime > 0 then
                            self.nextCutTime = self.nextCutTime - dt;
                            if self.nextCutTime <= 0 then
                                -- cut
                                local lenBelow, lenAbove = getSplitShapePlaneExtents(self.curSplitShape, x,y,z, nx,ny,nz);
                                local lx,ly,lz = worldToLocal(self.curSplitShape, x,y,z);
                                if (lenBelow <= 0.4 or ly < 0.21) and lenAbove < 1 then -- only delete tree if lenAbove < 1 to avoid full tree deletion
                                    -- Delete full tree: Not much left below the cut or cutting near the ground
                                    self:crushSplitShape(self.curSplitShape);
                                    self.curSplitShape = nil;
                                elseif lenAbove >= 0.2 then
                                    -- Normal cut: Splitting 20cm below the top
									if getRigidBodyType(self.curSplitShape) == "Static" and lenAbove > 1 then
										local tx,_,tz = getWorldTranslation(self.curSplitShape);
										if not Economica:getOwnedTerritory(tx, tz) then
											Economica:testWoodLicense();
										end;
									end;
									self.nextCutTime = self.maxCutTime;
                                    local curSplitShape = self.curSplitShape;
                                    self.curSplitShape = nil;
                                    self.curLenAbove = lenAbove;
                                    splitShape(curSplitShape, x,y,z, nx,ny,nz, yx,yy,yz, self.stumpCutterCutSizeY, self.stumpCutterCutSizeZ, "stumpCutterSplitShapeCallback", self);
								else
                                    self.nextCutTime = self.maxCutTime;
                                end;
                            end;
                        end;
                    end;
                else
                    self.workFadeTime = math.max(0, self.workFadeTime - dt);
                    if self.isServer then
                        if self.resetCutTime > 0 then
                            self.resetCutTime = self.resetCutTime - dt;
                            if self.resetCutTime <= 0 then
                                self.nextCutTime = self.maxCutTime;
                            end;
                        end;
                    end
                end;
            end
            if self.isClient then
                if self:getIsActiveForSound() then
                    if not SoundUtil.isSamplePlaying(self.sampleStumpCutterStart, 1.8*dt) then
                        SoundUtil.playSample(self.sampleStumpCutterIdle, 0, 0, nil);
                        SoundUtil.playSample(self.sampleStumpCutterWork, 0, 0, nil);
                    end
                    local volume = self.sampleStumpCutterWork.volume * self.workFadeTime/self.maxWorkFadeTime;
                    SoundUtil.setSampleVolume(self.sampleStumpCutterWork, volume);
                end
            end;
        end
    end
end;

function ChangedFunctions.updateWheelsGraphics(self, dt)
	if self.isServer then
		self.hasWheelGroundContact = false;
	end;
	for i, wheel in pairs(self.wheels) do
		WheelsUtil.updateWheelSteeringAngle(self, wheel, dt);
		if self.isServer and self.isAddedToPhysics then
			WheelsUtil.updateWheelHasGroundContact(wheel);
			if wheel.hasGroundContact then
				self.hasWheelGroundContact = true;
			end;
			if wheel.updateWheel then
				local x,y,z, xDrive, suspensionLength = getWheelShapePosition(wheel.node, wheel.wheelShape);
				xDrive = xDrive + wheel.xDriveOffset
				WheelsUtil.updateWheelGraphics(self, wheel, x, y, z, xDrive, suspensionLength);
				--fill netinfo (on server)
				wheel.netInfo.x = x;
				wheel.netInfo.y = y;
				wheel.netInfo.z = z;
				wheel.netInfo.xDrive = xDrive;
				wheel.netInfo.suspensionLength = suspensionLength;
			else
				wheel.updateWheel = true;
			end;
		else
			-- client code
			local x, y, z = wheel.netInfo.x, wheel.netInfo.y, wheel.netInfo.z;
			if self:getLastSpeed(true) > 0 and wheel.tireType ~= 4 then
				if wheel.lastYnetInfo then
					if math.abs(math.abs(wheel.lastYnetInfo)-math.abs(y)) > 0.02 then
						if wheel.lastYnetInfo < y then
							y = wheel.lastYnetInfo+0.02;
						else
							y = wheel.lastYnetInfo-0.02;
						end;
					end;
				end;
				wheel.lastYnetInfo = y;
			end;
			local xDrive = wheel.netInfo.xDrive;
			local suspensionLength = wheel.netInfo.suspensionLength
			WheelsUtil.updateWheelGraphics(self, wheel, x, y, z, xDrive, suspensionLength);
		end;
	end;
end;

function SiloTrigger:load(id)
    self.rootNode = id;
    self.triggerIds = {};
    local triggerRoot = Utils.indexToObject(id, getUserAttribute(id, "triggerIndex"));
    if triggerRoot == nil then
        triggerRoot = id;
    end
    table.insert(self.triggerIds, triggerRoot);
    addTrigger(triggerRoot, "triggerCallback", self);
    for i=1, 3 do
        local child = getChildAt(triggerRoot, i-1);
        table.insert(self.triggerIds, child);
        addTrigger(child, "triggerCallback", self);
    end;
    self.fillVolumeDischargeInfos = {};
    self.fillVolumeDischargeInfos.name = "fillVolumeDischargeInfo";
    self.fillVolumeDischargeInfos.nodes = {};
    local node = Utils.indexToObject(id, getUserAttribute(id, "fillVolumeDischargeNode"));
    local width = Utils.getNoNil( getUserAttribute(id, "fillVolumeDischargeNodeWidth"), 0.5 );
    local length = Utils.getNoNil( getUserAttribute(id, "fillVolumeDischargeNodeLength"), 0.5 );
    table.insert(self.fillVolumeDischargeInfos.nodes, {node=node, width=width, length=length, priority=1});
    self.selectedFillType = nil;
    self.fillLitersPerSecond = Utils.getNoNil(tonumber(getUserAttribute(id, "fillLitersPerSecond")), 1500);
    self.stationName = g_i18n:getText(Utils.getNoNil(getUserAttribute(id, "stationName"), "station_farmSilo"));
    self.storageRadius = Utils.getNoNil(getUserAttribute(id, "storageRadius"), 50);
    self.isFarmSilo = Utils.getNoNil(getUserAttribute(id, "isFarmSilo"), false)
    if self.isFarmSilo then
        if g_currentMission.farmSiloTrigger == nil then
            g_currentMission.farmSiloTrigger = self
        end
    end
    self.isEnabled = true;
    self.siloTrailer = nil;
    self.siloTrailerSend = nil;
    self.isFilling = false;
    self.startFillText = g_i18n:getText("action_siloStartFilling");
    self.stopFillText = g_i18n:getText("action_siloStopFilling");
    self.activateText = self.startFillText;
    self.objectActivated = false;
    if self.isClient then
        local dropParticleSystem = Utils.indexToObject(id, getUserAttribute(id, "dropParticleSystemIndex"));
		if dropParticleSystem ~= nil then
            self.dropParticleSystems = {};
			for i=1, getNumOfChildren(dropParticleSystem) do
				local particleId = getChildAt(dropParticleSystem, i-1);
				local ps = {};
				ParticleUtil.loadParticleSystemFromNode(particleId, ps, false, false);
				table.insert(self.dropParticleSystems, ps);
			end;
        end;
        local lyingParticleSystem = Utils.indexToObject(id, getUserAttribute(id, "lyingParticleSystemIndex"));
        if lyingParticleSystem ~= nil then
			self.lyingParticleSystems = {};
			for i=1, getNumOfChildren(lyingParticleSystem) do
				local particleId = getChildAt(lyingParticleSystem, i-1);
				local ps = {};
				ParticleUtil.loadParticleSystemFromNode(particleId, ps, true, false);
				if ps.geometry then
					local lifespan = getParticleSystemLifespan(ps.geometry);
					addParticleSystemSimulationTime(ps.geometry, lifespan);
					ParticleUtil.setParticleSystemTimeScale(ps, 0);
					table.insert(self.lyingParticleSystems, ps);
				end;
			end;
        end;
        if self.dropParticleSystems == nil then
            local effectsNode = Utils.indexToObject(id, getUserAttribute(id, "effectsNode"));
            if effectsNode ~= nil then
                self.dropEffects = EffectManager:loadFromNode(effectsNode, self);
            end;
        end;
        local fillSoundFilename = getUserAttribute(id, "fillSoundFilename");
        if fillSoundFilename == nil then
            fillSoundFilename = "$data/maps/sounds/siloFillSound.wav";
        end;
        if fillSoundFilename ~= "" and fillSoundFilename ~= "none" then
            fillSoundFilename = Utils.getFilename(fillSoundFilename, g_currentMission.baseDirectory);
            self.siloFillSound = createAudioSource("siloFillSound", fillSoundFilename, 30, 10, 1, 0);
            link(id, self.siloFillSound);
            setVisibility(self.siloFillSound, false);
        end;
        self.scroller = Utils.indexToObject(id, getUserAttribute(id, "scrollerIndex"));
        if self.scroller ~= nil then
            self.scrollerShaderParameterName = Utils.getNoNil(getUserAttribute(self.scroller, "shaderParameterName"), "uvScrollSpeed");
            local scrollerScrollSpeed = getUserAttribute(self.scroller, "scrollSpeed");
            if scrollerScrollSpeed ~= nil then
                self.scrollerSpeedX, self.scrollerSpeedY = Utils.getVectorFromString(scrollerScrollSpeed);
            end
            self.scrollerSpeedX = Utils.getNoNil(self.scrollerSpeedX, 0);
            self.scrollerSpeedY = Utils.getNoNil(self.scrollerSpeedY, -0.75);
            setShaderParameter(self.scroller, self.scrollerShaderParameterName, 0, 0, 0, 0, false);
        end;
    end;
    return true;
end;

function Combine:updateTick(dt)
    if self.isServer then
        self.lastArea = self.lastCuttersArea;
        self.lastAreaZeroTime = self.lastAreaZeroTime + dt;
        if self.lastArea > 0 then
            self.lastAreaZeroTime = 0;
            self.lastAreaNonZeroTime = g_currentMission.time;
        end
        self.lastInputFruitType = self.lastCuttersInputFruitType;
        self.lastCuttersArea = 0;
        self.lastCuttersInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        self.lastCuttersFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
        if self.lastInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
            self.lastValidInputFruitType = self.lastInputFruitType;
        end
        if self:getIsActive() then
           self.strawBufferCheckTimer = (#self.strawBuffer+2)*self.strawBufferDuration
           if self.lastAreaZeroTime > 500 then
                if self.combineFillDisableTime == nil then
                    self.combineFillDisableTime = g_currentMission.time + self.combineFillToggleTime;
                end
            end
            if self.combineFillEnableTime ~= nil and self.combineFillEnableTime <= g_currentMission.time then
                self:setCombineIsFilling(true, false, false);
                self.combineFillEnableTime = nil;
            end
            if self.combineFillDisableTime ~= nil and self.combineFillDisableTime <= g_currentMission.time then
                self:setCombineIsFilling(false, false, false);
                self.combineFillDisableTime = nil;
            end
            if self:getIsTurnedOn() then
                g_currentMission.missionStats:updateStats("threshedTime", dt/(1000*60));
                g_currentMission.missionStats:updateStats("workedTime", dt/(1000*60));
            end
        else
            if self.strawBufferCheckTimer >= 0 then
                self.strawBufferCheckTimer = self.strawBufferCheckTimer - dt
            end
        end
        if self.strawBufferCheckTimer >= 0 then
            self.strawBufferFillIndexTimer = self.strawBufferFillIndexTimer - dt
            if self.strawBufferFillIndexTimer < 0 then
                self.strawBufferFillIndex = self.strawBufferFillIndex + 1
                if self.strawBufferFillIndex > #self.strawBuffer then
                    self.strawBufferFillIndex = 1
                end
                self.strawBufferFillIndexTimer = self.strawBufferDuration
                self.strawBufferDropIndex = self.strawBufferDropIndex + 1
                if self.strawBufferDropIndex > #self.strawBuffer then
                    self.strawBufferDropIndex = 1
                end
                self.strawBufferDropValue = self.strawBuffer[self.strawBufferDropIndex]
            end
            local isStrawEffectEnabled = false
            local isChopperEffectEnabled = false
            if self:getUnitLastValidFillType(self.overloading.fillUnitIndex) ~= FillUtil.FILLTYPE_UNKNOWN then
                local litersPerFrame = math.min(self.strawBufferDropValue * (dt/self.strawBufferDuration), self.strawBuffer[self.strawBufferDropIndex])
                if self.isStrawEnabled then
                    local literToDrop = litersPerFrame + self.strawToDrop
					local fruitDesc = FruitUtil.fruitIndexToDesc[FruitUtil.fillTypeToFruitType[self:getUnitLastValidFillType(self.overloading.fillUnitIndex)]];
                    if fruitDesc ~= nil and fruitDesc.windrowLiterPerSqm ~= nil then
                        local windrowFillType = FruitUtil.fruitTypeToWindrowFillType[fruitDesc.index];
                        if literToDrop > 0 and windrowFillType ~= nil then
                            isStrawEffectEnabled = litersPerFrame > 0
                            local typedWorkAreas = self:getTypedWorkAreas(WorkArea.AREATYPE_COMBINE);
                            local value = literToDrop/table.getn(typedWorkAreas);
                            for _, workArea in pairs(typedWorkAreas) do
                                local sx,sy,sz = getWorldTranslation(workArea.start);
                                local ex,ey,ez = getWorldTranslation(workArea.width);
                                local dropped, lineOffset = TipUtil.tipToGroundAroundLine(self, value, windrowFillType, sx,sy,sz, ex,ey,ez, 0, nil, self.combineLineOffset, false, nil, false);
                                self.combineLineOffset = lineOffset;
                                self.strawToDrop = value-dropped
                            end
                        end
                    end
                else
                    isChopperEffectEnabled = litersPerFrame > 0
                end
                self.strawBuffer[self.strawBufferDropIndex] = self.strawBuffer[self.strawBufferDropIndex] - litersPerFrame
            end
            local currentDropIndex = self.strawBufferDropIndex
            for i=1, 2 do
                currentDropIndex = currentDropIndex + 1
                if currentDropIndex > #self.strawBuffer then
                    currentDropIndex = 1
                end
                if self.strawBuffer[currentDropIndex] > 0 then
                    if self.chopperPSenabled and not self.isStrawEnabled and not isChopperEffectEnabled then
                        isChopperEffectEnabled = true
                    end
                    if self.strawPSenabled and self.isStrawEnabled and not isStrawEffectEnabled then
                        isStrawEffectEnabled = true
                    end
                end
            end
            self:setChopperPSEnabled(isChopperEffectEnabled, false, false);
            self:setStrawPSEnabled(isStrawEffectEnabled, false, false);
        end
        if self:getUnitCapacity(self.overloading.fillUnitIndex) <= 0 then
            local fillLevel = self:getUnitFillLevel(self.overloading.fillUnitIndex);
            self.lastLostFillLevel = fillLevel;
            if fillLevel > 0 then
                self:setUnitFillLevel(self.overloading.fillUnitIndex, 0, self:getUnitFillType(self.overloading.fillUnitIndex), false);
            end
        end
        if  self.combineIsFilling ~= self.sentCombineIsFilling or
            self.chopperPSenabled ~= self.sentChopperPSenabled or
            self.strawPSenabled ~= self.sentStrawPSenabled
        then
            self:raiseDirtyFlags(self.combineDirtyFlag);
            self.sentCombineIsFilling = self.combineIsFilling;
            self.sentChopperPSenabled = self.chopperPSenabled;
            self.sentStrawPSenabled = self.strawPSenabled;
        end
    end
end;

function Combine:onAttachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTER or object.attacherJoint.jointType == AttacherJoints.JOINTTYPE_CUTTERHARVESTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
		if self.strawArea then
			local width = 2.5;
			local storeItem = StoreItemsUtil.storeItemsByXMLFilename[string.lower(object.configFileName)];
			if storeItem and storeItem.specs and storeItem.specs.workingWidth then
				width = storeItem.specs.workingWidth*0.5;
			end;
			local _,_,z = getTranslation(self.strawArea.start);
			local _,_,z2 = getTranslation(self.strawArea.width);
			local _,_,z3 = getTranslation(self.strawArea.height);
			setTranslation(self.strawArea.start, width, 0, z);
			setTranslation(self.strawArea.width, -width, 0, z2);
			setTranslation(self.strawArea.height, width, 0, z3-width);
		end;
    end;
end;

--[[function Combine:setCombineIsFilling(combineIsFilling, fruitTypeChanged, isSynchronized)
	if self.combineIsFilling ~= combineIsFilling or fruitTypeChanged then
		self.combineIsFilling = combineIsFilling;
		if self.isServer and isSynchronized then
			self.sentCombineIsFilling = combineIsFilling;
		end;
		if self.currentCombineThreshingFillParticleSystem ~= nil then
			Utils.setEmittingState(self.currentCombineThreshingFillParticleSystem, false);
			self.currentCombineThreshingFillParticleSystem = nil;
		end;
		if self.fillEffect ~= nil and (not combineIsFilling or fruitTypeChanged) then
			EffectManager:stopEffect(self.fillEffect)
		end;
		if combineIsFilling then
			if self.combineThreshingFillParticleSystems[self.lastValidFillType] then
				self.currentCombineThreshingFillParticleSystem = self.combineThreshingFillParticleSystems[self.lastValidFillType];
			else
				local lastValidFruitType = FruitUtil.fillTypeToFruitType[self.lastValidFillType];
				self.currentCombineThreshingFillParticleSystem = self.combineThreshingFillParticleSystems[lastValidFruitType];
			end;
			Utils.setEmittingState(self.currentCombineThreshingFillParticleSystem, true);
			if self.fillEffect ~= nil then
				self.fillEffect:setFillType(self.lastValidFillType);
				EffectManager:startEffect(self.fillEffect)
			end;
		end;
	end;
end;]]

function FieldJob:init(fieldDef, jobType, sprayFactor, fieldSpraySet, fieldState, growthState, fieldPloughFactor)
    local fruitIndex = fieldDef.missionFruitType;
    if jobType == FieldJob.TYPE_SOWING then
        fruitIndex = g_currentMission.fieldJobManager.availableFruitTypeIndices[ math.random(1, g_currentMission.fieldJobManager.fruitTypesCount) ];
    end;
    self.fieldDef = fieldDef;
    self.fruitType = fruitIndex;
    self.fieldDef.missionFruitType = fruitIndex;
    self.jobType = jobType;
    self.sprayFactor = Utils.getNoNil(sprayFactor, 0);
    self.fieldSpraySet = fieldSpraySet;
    self.fieldState = fieldState;
    self.growthState = growthState;
    self.fieldPloughFactor = fieldPloughFactor;
    self.fieldJobVehiclesXOffset = self.fieldJobVehiclesXOffset * self.fieldDef.fieldJobVehicleSpawnDirection;
    local fruitDesc = FruitUtil.fruitIndexToDesc[self.fruitType];
    self.backUpValues.plantGrowthRateLocked = g_currentMission.plantGrowthRateIsLocked;
    self.backUpValues.plantGrowthRate = g_currentMission.missionInfo.plantGrowthRate;
    g_currentMission:setPlantGrowthRate(1, true);
    g_currentMission:setPlantGrowthRateLocked(true);
    self.backUpValues.timeScale = g_currentMission.missionInfo.timeScale;
    g_currentMission:setTimeScale(1, true);
    g_currentMission.disableAIVehicle = true;
    local fieldSizeCategory = FieldJob.CATEGROY_FIELDSIZE_SMALL;
    if fieldDef.fieldArea > FieldJob.FIELDSIZE_THRESHOLDS[FieldJob.CATEGROY_FIELDSIZE_MEDIUM] then
        fieldSizeCategory = FieldJob.CATEGROY_FIELDSIZE_MEDIUM;
        if fieldDef.fieldArea > FieldJob.FIELDSIZE_THRESHOLDS[FieldJob.CATEGROY_FIELDSIZE_LARGE] then
            fieldSizeCategory = FieldJob.CATEGROY_FIELDSIZE_LARGE;
        end;
    end;
    self:setUpVehicleList(fieldSizeCategory);
    if table.getn(self.fieldJobVehiclesToLoad) == 0 or self.lastFieldJobVehicleLoadedIndex == nil or self.fieldJobVehicleToLoadIndex == nil then
        self.reward = nil;
        self:finish(false);
        return false;
    else
        local f = 0.8;
        if g_currentMission.missionInfo.difficulty == 2 then
            f = 1.0;
        elseif g_currentMission.missionInfo.difficulty == 1 then
            f = 1.2;
        end;
		local ratingCoeff = math.max(1 - Economica.rating*0.01, 0.5);
        self.reward = 400 * (self.timeLeft/60000) * f;
		if UniversalFactoryHUD.settings[UniversalFactoryHUD.SET_FIELDJOBREWARD] then
			self.reward = self.reward*ratingCoeff;
		end;
        if jobType == FieldJob.TYPE_HARVESTING then
            local dayPlus, timePlus = g_currentMission.environment:getDayAndDayTime(g_currentMission.environment.dayTime+self.timeLeft, g_currentMission.environment.currentDay);
            local rainTypeId = g_currentMission.environment:getRainTypeIdInTimeRange(g_currentMission.environment.currentDay, g_currentMission.environment.dayTime, dayPlus, timePlus);
            if rainTypeId ~= nil then
                if not g_currentMission.environment.rainTypeIdToType[rainTypeId].isAtmosphericOnly then
                    self.reward = nil;
                    self:finish(false);
                    return false;
                end;
            end;
        end;
    end;
    return true;
end

function Motorized:load(savegame)
    self.getIsMotorStarted = Utils.overwrittenFunction(self.getIsMotorStarted, Motorized.getIsMotorStarted);
    self.getDeactivateOnLeave = Utils.overwrittenFunction(self.getDeactivateOnLeave, Motorized.getDeactivateOnLeave);
    self.getDeactivateLights = Utils.overwrittenFunction(self.getDeactivateLights, Motorized.getDeactivateLights);
    self.updateFuelUsage = Utils.overwrittenFunction(self.updateFuelUsage, Motorized.updateFuelUsage);
	self.startMotor = SpecializationUtil.callSpecializationsFunction("startMotor");
    self.stopMotor = SpecializationUtil.callSpecializationsFunction("stopMotor");
    self.setIsFuelFilling = SpecializationUtil.callSpecializationsFunction("setIsFuelFilling");
    self.setFuelFillLevel = SpecializationUtil.callSpecializationsFunction("setFuelFillLevel");
    self.addFuelFillTrigger = Motorized.addFuelFillTrigger;
    self.removeFuelFillTrigger = Motorized.removeFuelFillTrigger;
    self.motorizedNode = nil;
    for _, component in pairs(self.components) do
        if component.motorized then
            self.motorizedNode = component.node;
            break;
        end
    end
    Motorized.loadDifferentials(self, self.xmlFile, self.differentialIndex);
    Motorized.loadMotor(self, self.xmlFile, self.configurations["motor"]);
    Motorized.loadSounds(self, self.xmlFile, self.configurations["motor"]);
    self.motorizedFillActivatable = MotorizedRefuelActivatable:new(self);
    self.fuelFillTriggers = {};
    self.isFuelFilling = false;
    self.fuelFillLitersPerSecond = 10;
    self.fuelFillLevel = 0;
    self.lastFuelFillLevel = 0;
    self:setFuelFillLevel(self.fuelCapacity);
    self.sentFuelFillLevel = self.fuelFillLevel;
    self.stopMotorOnLeave = true;
    if self.isClient then
        self.exhaustParticleSystems = {};
        local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.exhaustParticleSystems#count"), 0);
        for i=1, exhaustParticleSystemCount do
            local namei = string.format("vehicle.exhaustParticleSystems.exhaustParticleSystem%d", i);
            local ps = {}
            ParticleUtil.loadParticleSystem(self.xmlFile, ps, namei, self.components, false, nil, self.baseDirectory)
            ps.minScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.exhaustParticleSystems#minScale"), 0.5);
            ps.maxScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.exhaustParticleSystems#maxScale"), 1);
            table.insert(self.exhaustParticleSystems, ps)
        end
        if #self.exhaustParticleSystems == 0 then
            self.exhaustParticleSystems = nil
        end
        local exhaustFlapIndex = getXMLString(self.xmlFile, "vehicle.exhaustFlap#index");
        if exhaustFlapIndex ~= nil then
            self.exhaustFlap = {};
            self.exhaustFlap.node = Utils.indexToObject(self.components, exhaustFlapIndex);
            self.exhaustFlap.maxRot = Utils.degToRad(Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.exhaustFlap#maxRot"),0));
        end
        self.exhaustEffects = {};
        Motorized.loadExhaustEffects(self, self.xmlFile, self.exhaustEffects);
        if table.getn(self.exhaustEffects) == 0 then
            self.exhaustEffects = nil;
        end
    end
    self.motorStartDuration = 0;
    if self.sampleMotorStart ~= nil then
        self.motorStartDuration = self.sampleMotorStart.duration;
    end
    self.motorStartDuration = Utils.getNoNil( Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.motorStartDuration"), self.motorStartDuration), 0);
    self.motorStartTime = 0;
    self.lastRoundPerMinute = 0;
    self.actualLoadPercentage = 0;
    self.maxDecelerationDuringBrake = 0;
    self.motorizedDirtyFlag = self:getNextDirtyFlag();
    self.isMotorStarted = false;
    self.motorStopTimerDuration = g_gameSettings:getValue("motorStopTimerDuration")
    self.motorStopTimer = self.motorStopTimerDuration
    self.fuelFillLevelHud = VehicleHudUtils.loadHud(self, self.xmlFile, "fuel");
    self.rpmHud = VehicleHudUtils.loadHud(self, self.xmlFile, "rpm");
    self.timeHud = VehicleHudUtils.loadHud(self, self.xmlFile, "time");
    if self.timeHud ~= nil then
        self.minuteChanged = Utils.appendedFunction(self.minuteChanged, Motorized.minuteChanged);
        g_currentMission.environment:addMinuteChangeListener(self);
        self:minuteChanged();
    end
    self.speedHud = VehicleHudUtils.loadHud(self, self.xmlFile, "speed");
    self.fuelUsageHud = VehicleHudUtils.loadHud(self, self.xmlFile, "fuelUsage");
    if savegame ~= nil then
        local fuelFillLevel = getXMLFloat(savegame.xmlFile, savegame.key.."#fuelFillLevel");
        if fuelFillLevel ~= nil then
            self:setFuelFillLevel(fuelFillLevel);
        end
    end
    self.motorTurnedOnRotationNodes = Utils.loadRotationNodes(self.xmlFile, {}, "vehicle.turnedOnRotationNodes.turnedOnRotationNode", "motor", self.components);
end;

function Motorized:setFuelFillLevel(newFillLevel)
    self.fuelFillLevel = math.max(math.min(newFillLevel, self.fuelCapacity), 0);
    if self.fuelFillLevelHud ~= nil and math.abs(self.lastFuelFillLevel-self.fuelFillLevel) > 0.1 then
        VehicleHudUtils.setHudValue(self, self.fuelFillLevelHud, self.fuelFillLevel, self.fuelCapacity);
        self.lastFuelFillLevel = self.fuelFillLevel;
    end;
    if self.fuelFillLevel == 0 then
		if self:getIsHired() then
			self:stopAIVehicle(AIVehicle.STOP_REASON_OUT_OF_FUEL);
		end;
		if self.isMotorStarted then
			self:stopMotor(true);
		end;
    end;
end;

function Motorized:onLeave()
    if self.isMotorStarted and self.stopMotorOnLeave and g_currentMission.missionInfo.automaticMotorStartEnabled then
        self:stopMotor(true);
    end;
    Motorized.onDeactivateSounds(self);
end;

function Utils.getFruitStates(fruitId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	local allowPreparing = false;
	local ret = 0;
	local ids = g_currentMission.fruits[fruitId];
	if ids == nil or ids.id == 0 then
		return false;
	end;
	local id = ids.id;
	local desc = FruitUtil.fruitIndexToDesc[fruitId];
	setDensityReturnValueShift(id, -1);
	if desc.minPreparingGrowthState >= 0 and desc.maxPreparingGrowthState >= 0 then
		setDensityCompareParams(id, "between", math.max(desc.minHarvestingGrowthState-8, 1), desc.maxHarvestingGrowthState);
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		ret = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
		setDensityCompareParams(id, "between", desc.minPreparingGrowthState+1, desc.maxPreparingGrowthState+1);
		allowPreparing = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels) > 0;
	else
		setDensityCompareParams(id, "between", desc.minHarvestingGrowthState-2, desc.maxHarvestingGrowthState+2);
		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
		ret = getDensityParallelogram(id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
	end;
	setDensityCompareParams(id, "greater", -1);
	setDensityReturnValueShift(id, 0);
	return ret > 0, allowPreparing;
end;

function Utils.updateHaulmArea(densityId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(nil, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	setDensityParallelogram(densityId, x, z, widthX, widthZ, heightX, heightZ, 0, 1, 1);
end;

function Utils.destroyNoFruitDensity(densityId, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
    local x, z, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(nil, startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
    setDensityParallelogram(densityId, x, z, widthX, widthZ, heightX, heightZ, 0, 1, 0);
end;

function Utils.destroyStrawDensity(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	for i=1, #terrainControl.strawDensity do
		Utils.destroyNoFruitDensity(terrainControl.strawDensity[i], startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	end;
end;

function Utils.destroyDecoDensity(startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ)
	for i=1, #terrainControl.decoDensity do
		Utils.destroyNoFruitDensity(terrainControl.decoDensity[i], startWorldX, startWorldZ, widthWorldX, widthWorldZ, heightWorldX, heightWorldZ);
	end;
end;

function ChangedFunctions:processFruitPreparerAreas(workAreas, numWorkAreas, fruitType)
    local fruitTypes = {self.fruitPreparer.originalFruitType, FruitUtil.FRUITTYPE_ONION, FruitUtil.FRUITTYPE_CARROT};
	local numAreasUsed = 0;
    for i=1, numWorkAreas do
        local x = workAreas[i].x;
        local z = workAreas[i].z;
        local x1 = workAreas[i].x1;
        local z1 = workAreas[i].z1;
        local x2 = workAreas[i].x2;
        local z2 = workAreas[i].z2;
        local areaChanged = 0;
        for ii=1, #fruitTypes do
			local fruitValue = Utils.getFruitArea(fruitTypes[ii], x, z, x1, z1, x2, z2, true, false);
			if fruitValue > 0 then
				fruitType = fruitTypes[ii];
				local desc = FruitUtil.fruitIndexToDesc[fruitType];
				if desc then
					self.fruitPreparer.fruitType = fruitType;
					self.aiRequiredFruitType = fruitType;
					self.aiRequiredMinGrowthState = desc.minPreparingGrowthState;
					self.aiRequiredMaxGrowthState = desc.maxPreparingGrowthState;
				end;
				break;
			end;
		end;
		if workAreas[i].hasSeparateDropArea then
            local dx = workAreas[i].dx;
            local dz = workAreas[i].dz;
            local dx1 = workAreas[i].dx1;
            local dz1 = workAreas[i].dz1;
            local dx2 = workAreas[i].dx2;
            local dz2 = workAreas[i].dz2;
            areaChanged = Utils.updateFruitPreparerArea(fruitType, x, z, x1, z1, x2, z2, dx, dz, dx1, dz1, dx2, dz2);
        else
            areaChanged = Utils.updateFruitPreparerArea(fruitType, x, z, x1, z1, x2, z2, x, z, x1, z1, x2, z2);
        end;
        if areaChanged > 0 then
            numAreasUsed = numAreasUsed + 1;
        end;
    end;
    return numAreasUsed;
end;

function FruitPreparer:postLoad()
	self.fruitPreparer.originalFruitType = self.fruitPreparer.fruitType;
end;

function ChangedFunctions:processPloughAreas(workAreas, limitToField, limitGrassDestructionToField, angle)
    local areaSum = 0;
    for _, area in pairs(workAreas) do
		if not limitToField then
			Utils.destroyDecoDensity(area[1], area[2], area[3], area[4], area[5], area[6]);
		end;
		Utils.destroyStrawDensity(area[1], area[2], area[3], area[4], area[5], area[6]);
		areaSum = areaSum + Utils.updatePloughArea(area[1], area[2], area[3], area[4], area[5], area[6], not limitToField, not limitGrassDestructionToField, angle);
	end;
    return areaSum;
end;

function ChangedFunctions:getDriveGroundParticleSystemsScale(particleSystem)
    local wheel = particleSystem.wheel;
    if wheel ~= nil then
        if (particleSystem.onlyActiveOnGroundContact and wheel.contact ~= Vehicle.WHEEL_GROUND_CONTACT) or wheel.inDirt then
            return 0;
        end;
        if not GroundSoundUtil.terrainAttributeEmitsParticles[wheel.lastTerrainAttribute] then
            return 0;
        end;
    end;
    local minSpeed = particleSystem.minSpeed;
    local direction = particleSystem.direction;
    if self.lastSpeedReal > minSpeed and (direction == 0 or (direction > 0) == (self.movingDirection > 0)) then
        local maxSpeed = particleSystem.maxSpeed;
        local alpha = math.min((self.lastSpeedReal - minSpeed) / (maxSpeed - minSpeed), 1);
        local scale = Utils.lerp(particleSystem.minScale, particleSystem.maxScale, alpha);
        return scale;
    end;
    return 0;
end;

function ChangedFunctions:washableUpdateTick(dt)
	if self.washableNodes ~= nil then
		if self.isServer then
			if not self.underRoof then
				if self.carWashTrigger then
					self.carWashTrigger.timer = self.carWashTrigger.timer + dt;
					if self.carWashTrigger.timer > 7000 then
						local amount = self:getDirtAmount();
						if amount > 0.01 then
							amount = math.max(self:getDirtAmount() - (dt/self.washDuration)*4, 0);
							self:setDirtAmount(amount);
							if not self.carWashTrigger.isOwned then
								local money = self.carWashTrigger.pricePerSecond*0.001*dt;
								g_currentMission:addSharedMoney(-money, "vehicleRunningCost");
							end;
							if not self.carWashTrigger.washing then
								if self.carWashTrigger.waterStreams then
									setVisibility(self.carWashTrigger.waterStreams, true);
									for _,ps in pairs(self.carWashTrigger.wps) do
										Utils.setEmittingState(ps, true);
									end;
								end;
								self.carWashTrigger.washing = true;
								self.carWashTrigger:raiseDirtyFlags(self.carWashTrigger.washingDirtyFlag);
							end;
						else
							if self.carWashTrigger.waterStreams then
								setVisibility(self.carWashTrigger.waterStreams, false);
								for _,ps in pairs(self.carWashTrigger.wps) do
									Utils.setEmittingState(ps, false);
								end;
							end;
							self.carWashTrigger.timer = 0;
							self.carWashTrigger.washing = false;
							self.carWashTrigger:raiseDirtyFlags(self.carWashTrigger.washingDirtyFlag);
							self.carWashTrigger = nil;
						end;
					end;
				elseif g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
					local amount = self:getDirtAmount();
					if amount > 0.5 then
						amount = self:getDirtAmount() - (dt/self.washDuration);
					end;
					self:setDirtAmount(amount);
				else
					if self:getIsActive() or self.isActive then
						self:setDirtAmount(self:getDirtAmount() + (dt * self.dirtDuration)*self:getDirtMultiplier()*Washable.getIntervalMultiplier());
					end;
				end;
			end;
		end;
	end;
end;

-------------------------------------------------------------------------------------------------
cutTreePenaltyEvent = {};
cutTreePenaltyEvent_mt = Class(cutTreePenaltyEvent, Event);

InitEventClass(cutTreePenaltyEvent, "cutTreePenaltyEvent");

function cutTreePenaltyEvent:emptyNew()
	local self = Event:new(cutTreePenaltyEvent_mt);
    return self;
end;

function cutTreePenaltyEvent:new(penalty)
	local self = cutTreePenaltyEvent:emptyNew();
	self.penalty = penalty;
	return self;
end;

function cutTreePenaltyEvent:readStream(streamId, connection)
	local penalty = streamReadBool(streamId);
	if penalty then
		g_currentMission:showBlinkingWarning(g_i18n:getText("noCutNotOwnedTrees")..g_i18n.globalI18N:getCurrencySymbol(true), 3000);
	end;
end;

function cutTreePenaltyEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.penalty);
end;

----------------------------------------------------------------------------------------------------------------

VehicleResetPriceEvent = {};
VehicleResetPriceEvent_mt = Class(VehicleResetPriceEvent, Event);
InitEventClass(VehicleResetPriceEvent, "VehicleResetPriceEvent");

function VehicleResetPriceEvent:emptyNew()
	local self = Event:new(VehicleResetPriceEvent_mt);
    return self;
end;

function VehicleResetPriceEvent:new(price)
	local self = VehicleResetPriceEvent:emptyNew();
	self.price = price;
	return self;
end;

function VehicleResetPriceEvent:readStream(streamId, connection)
	local price = streamReadInt32(streamId);
	g_currentMission:addSharedMoney(price, "vehicleRunningCost");
	g_currentMission:addMoneyChange(price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_vehicleRunningCost"));
end;

function VehicleResetPriceEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.price);
end;

----------------------------------------------------------------------------------------------------------------

UnloadingSpecEvent = {};
UnloadingSpecEvent_mt = Class(UnloadingSpecEvent, Event);

InitEventClass(UnloadingSpecEvent, "UnloadingSpecEvent");

function UnloadingSpecEvent:emptyNew()
	local self = Event:new(UnloadingSpecEvent_mt);
    return self;
end;

function UnloadingSpecEvent:new(enableDump, machine)
	local self = UnloadingSpecEvent:emptyNew();
	self.enableDump = enableDump;
	self.machine = machine;
	return self;
end;

function UnloadingSpecEvent:readStream(streamId, connection)
	local enableDump = streamReadBool(streamId);
	local id = streamReadInt32(streamId);
    local machine = networkGetObject(id);
	if machine then
		machine.enableDump = enableDump;
		if enableDump then
			g_currentMission:removeActivatableObject(machine.fillActivatable);
		end;
		if g_server then
			g_server:broadcastEvent(UnloadingSpecEvent:new(enableDump, machine));
		end;
	end;
end;

function UnloadingSpecEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.enableDump);
	streamWriteInt32(streamId, networkGetObjectId(self.machine));
end;
