--author: igor29381

Bagger = {};
BaggerObject = {};
local Bagger_mt = Class(Bagger, Object);

function Bagger.onCreate(id)
	local bagger = Bagger:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:addOnCreateLoadedObject(bagger);
	bagger:load(id);
	bagger:register(true);
end;

function Bagger:new(isServer, isClient, customMt)
	if customMt == nil then customMt = Bagger_mt; end;
	local self = Object:new(isServer, isClient, customMt);
	self.rootNode = 0;
	self.baggerDirtyFlag = self:getNextDirtyFlag();
	return self;
end;

function Bagger:load(id)
	self.rootNode = id;
	self.positions = {};
	self.level = 0;
	self.currentFillType = 0;
	local siloTrigger = getUserAttribute(id, "siloTrigger");
	if siloTrigger then
		local triggerFillTypes = {};
		local fillTypes = getUserAttribute(id, "fillTypes");
		local fillTypesPositions = getUserAttribute(id, "fillTypesPositions");
		if fillTypes and fillTypesPositions then
			fillTypes = Utils.splitString(" ", fillTypes);
			fillTypesPositions = Utils.splitString("and", fillTypesPositions);
			for i=1, #fillTypes do
				local index = FillUtil.fillTypeNameToInt[fillTypes[i]];
				local position = Utils.getRadiansFromString(fillTypesPositions[i], 2);
				if index and position then
					self.positions[index] = position;
					self.currentFillType = index;
					triggerFillTypes[index] = index;
				end;
			end;
		end;
		siloTrigger = Utils.indexToObject(id, siloTrigger);
		if siloTrigger > 0 then
			local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
			g_currentMission:removeSiloTrigger(trigger);
			trigger.parent = self;
			trigger.fillTypes = triggerFillTypes;
			g_currentMission:addOnCreateLoadedObject(trigger);
			trigger:load(siloTrigger);
			trigger:register(true);
			trigger.getIsActivatable = function(trigger)
				if not self.isEnabled or not trigger.isEnabled or self.moving then
					return false;
				end;
				if trigger.isFilling then
					if trigger.siloTrailer:getRootAttacherVehicle() == g_currentMission.controlledVehicle then
						return true;
					end;
				else
					if trigger.siloTrailer ~= nil then
						local trailer = trigger.siloTrailer;
						if trailer:getRootAttacherVehicle() ~= g_currentMission.controlledVehicle then
							return false;
						end;
						if trailer:getFillLevel() == 0 then
							return true;
						elseif trailer:getFillLevel() > 0 and trailer:getFillLevel() < trailer:getCapacity() then
							local fillTypes = trailer:getCurrentFillTypes();
							for _,fillType in pairs(fillTypes) do
								if self.positions[fillType] then
									return true;
								end;
							end;
						end;
					end;
				end;
				return false;
			end;
			trigger.onActivateObject = function(trigger)
				if trigger.siloTrailer and trigger.siloTrailer:getFillLevel() > 0 then
					if g_server then
						self:setCurrentFillType(0);
					else
						g_client:getServerConnection():sendEvent(BaggerEvent:new(0, self));
					end;
				elseif not UniversalFactoryHUD.siloTriggerMenu then
					UniversalFactoryHUD.currentSiloTrigger = trigger;
					UniversalFactoryHUD.siloTriggerMenu = true;
					UniversalFactoryHUD.baggerSiloTrigger = true;
					UniversalFactoryHUD.showCursor = true;
				end;
			end;
			trigger.drawActivate = function(trigger)
				g_currentMission:enableHudIcon("load", 4);
			end;
			trigger.delete = function(trigger)
				if trigger.dropEffects then
					EffectManager:deleteEffects(trigger.dropEffects);
				end;
				for i=1, table.getn(trigger.triggerIds) do
					removeTrigger(trigger.triggerIds[i]);
				end
				delete(trigger.rootNode);
				SiloTrigger:superClass().delete(trigger);
			end;
			trigger.setIsFilling = function(trigger, isFilling, fillType, noEventSend)
				SiloTriggerSetIsFillingEvent.sendEvent(trigger, isFilling, fillType, noEventSend);
				if isFilling then
					trigger:startFill(fillType);
					setTranslation(self.gate, self.gateEndPosition, 0, 0);
				else
					trigger:stopFill();
					setTranslation(self.gate, self.gateStartPosition, 0, 0);
					self.readyToMining = false;
					self:changeWorkState(false);
				end;
			end;
			trigger.getFillLevel = function(trigger, fillType)
				return 100000000;
			end;
			trigger.update = function(trigger, dt)
				if trigger.isServer then
					if trigger.siloTrailer == nil then
						trigger.isEnabled = self.isEnabled;
					end;
					local trailer = trigger.siloTrailer;
					if trigger.activeTriggers >= 4 and trailer ~= nil and g_currentMission.missionStats.money > 0 then
						if trigger.isFilling then
							trailer:resetFillLevelIfNeeded(trigger.selectedFillType);
							local fillLevel = trailer:getFillLevel(trigger.selectedFillType);
							if trailer:allowFillType(trigger.selectedFillType, false) then
								local deltaFillLevel = trigger.fillLitersPerSecond*0.001*dt;
								trailer:setFillLevel(fillLevel+deltaFillLevel, trigger.selectedFillType, false, trigger.fillVolumeDischargeInfos);
								local newFillLevel = trailer:getFillLevel(trigger.selectedFillType);
								if fillLevel ~= newFillLevel then
									local delta = newFillLevel-fillLevel;
									local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
									local money = FillUtil.fillTypeIndexToDesc[trigger.selectedFillType].pricePerLiter * difficultyMultiplier * delta;
									g_currentMission:addSharedMoney(-money, "other");
									g_currentMission:addMoneyChange(-money, self.moneyChangeId);
									self.lastMoneyChange = 30;
								else
									trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
								end;
							else
								trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
							end;
						end;
					elseif trigger.isFilling then
						trigger:setIsFilling(false, FillUtil.FILLTYPE_UNKNOWN);
					end;
					if trigger.siloTrailerSend ~= trigger.siloTrailer then
						trigger.siloTrailerSend = trigger.siloTrailer;
						trigger:raiseDirtyFlags(trigger.siloTriggerDirtyFlag);
					end;
				end;
			end;
			self.siloTrigger = trigger;
		end;
	end;
	local top = getChild(id, "top");
	if top > 0 then
		self.top = top;
		self.topSound = getChild(top, "topSound");
		if self.topSound > 0 then setVisibility(self.topSound, false); end;
		local particleNode = getChild(top, "ParticleSystem");
		if particleNode > 0 then
			self.particle = {};
			for i=1, getNumOfChildren(particleNode) do
				local particleId = getChildAt(particleNode, i-1);
				local ps = {};
				ParticleUtil.loadParticleSystemFromNode(particleId, ps, false, false);
				table.insert(self.particle, ps);
			end;
		end;
		local rotor = getChild(top, "rotor");
		if rotor > 0 then
			self.rotor = rotor;
			self.rotorSound = getChild(rotor, "rotorSound");
			self.rotorSample = getAudioSourceSample(self.rotorSound);
			if self.rotorSound > 0 then setVisibility(self.rotorSound, false); end;
		end;
		self.workSound = getChild(rotor, "workSound");
		if self.workSound > 0 then setVisibility(self.workSound, false); end;
		local gate = getUserAttribute(id, "gate");
		if gate then
			self.gate = Utils.indexToObject(id, gate);
			local x,_,_ = getTranslation(self.gate);
			self.gateStartPosition = x;
			self.gateEndPosition = Utils.getNoNil(getUserAttribute(self.gate, "gateEndPosition"), 1.05);
		end;
	end;
	self.rotorRotateSpeed = Utils.getNoNil(getUserAttribute(id, "rotorSpeed"), 0.001);
	self.rotorAcceleration = Utils.getNoNil(getUserAttribute(id, "rotorAcceleration"), 0.0001);
	self.topRotateSpeed = Utils.getNoNil(getUserAttribute(id, "topRotateSpeed"), 0.00003);
	self.topWorkingSpeed = Utils.getNoNil(getUserAttribute(id, "topWorkingSpeed"), 0.000005);
	local appearsOnPDA = Utils.getNoNil(getUserAttribute(id, "appearsOnPDA"), true);
	if appearsOnPDA then
		local x, _, z = getWorldTranslation(id);
		local visitPoint = getChild(id, "visitPoint");
		if visitPoint > 0 then
			x, _, z = getWorldTranslation(visitPoint);
		end;
		local width, height = getNormalizedScreenValues(10, 10);
		self.mapHotspot = g_currentMission.ingameMap:createMapHotspot("", g_i18n:getText("bagger"), TrafficManager.curModDir.."maps/scripts/huds/baggerHUD.png", nil, nil, x, z, width, height, false, false, true, nil, true);
	end;
	self.rotorRotSpeed = 0;
	self.topRotAngle = 0;
	self.direction = 1;
	self.level = 0;
	self.capacity = 0;
	self.readyToMining = false;
	self.moving = false;
	self.mining = false;
	self.moneyChangeId = getMoneyTypeId();
	self.lastMoneyChange = -1;
	if self.siloTrigger and self.top and self.rotor and self.gate then
		self.isEnabled = true;
	else
		print("Bagger: some components not found");
	end;
	Perestroyka.bagger = self;
	return true;
end;

function Bagger:delete()
	Bagger:superClass().delete(self);
end;

function Bagger:readStream(streamId, connection)
end;

function Bagger:writeStream(streamId, connection)
end;

function Bagger:readUpdateStream(streamId, timestamp, connection)
	Bagger:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		self.readyToMining = streamReadBool(streamId);
		if not self.readyToMining and self.mining then
			self:changeWorkState(false);
		end;
		self.direction = streamReadInt8(streamId);
	end;
end;

function Bagger:writeUpdateStream(streamId, connection, dirtyMask)
	Bagger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.readyToMining);
		streamWriteInt8(streamId, self.direction);
	end;
end;

function Bagger:setCurrentFillType(fillType)
	local trailer = self.siloTrigger.siloTrailer;
	if trailer then
		for i=1, #trailer.fillUnits do
			local fillUnit = trailer.fillUnits[i];
			self.capacity = fillUnit.capacity - fillUnit.fillLevel;
			if fillUnit.currentFillType ~= FillUtil.FILLTYPE_UNKNOWN and self.siloTrigger.fillTypes[fillUnit.currentFillType] then
				self.currentFillType = fillUnit.currentFillType;
				self:startWork();
				break;
			elseif fillType and self.siloTrigger.fillTypes[fillType] then
				self.currentFillType = fillType;
				self:startWork();
				break;
			end;
		end;
	end;
end;

function Bagger:startWork()
	self.moving = true;
	self.readyToMining = true;
	if self.isServer then
		self.level = 0;
		g_server:broadcastEvent(BaggerEvent:new(self.currentFillType, self));
	end;
end;

function Bagger:changeWorkState(state)
	for i=1, #self.particle do
		Utils.setEmittingState(self.particle[i], state);
	end;
	if self.workSound > 0 then setVisibility(self.workSound, state); end;
	self.mining = state;
	self.direction = 1;
end;

function Bagger:update(dt)
	if self.isEnabled then
		if self.rotorRotSpeed == 1 then
			if math.abs(self.topAngle) > math.abs(self.positions[self.currentFillType][1]) then
				if self.isServer then
					if self.level == 0 then
						self:changeWorkState(true);
					end;
					if self.mining then
						self.level = math.min(self.level + dt*1.5, self.capacity);
						if self.level >= math.min(7000, self.capacity) then
							self.siloTrigger:onFillTypeSelection(self.currentFillType);
						end;
						if self.capacity/self.level < 2 and self.direction == 1 then
							self.direction = -1;
							self:raiseDirtyFlags(self.baggerDirtyFlag);
						end;
						if self.level >= self.capacity then
							self.readyToMining = false;
							self:changeWorkState(false);
							self:raiseDirtyFlags(self.baggerDirtyFlag);
						end;
					end;
				elseif not self.mining then
					self:changeWorkState(true);
				end;
			elseif self.mining then
				self:changeWorkState(false);
			end;
		end;
		if self.moving then
			if self.readyToMining then
				self.rotorRotSpeed = math.min(self.rotorRotSpeed + dt*self.rotorAcceleration, 1);
				local rotorSpeed = self.rotorRotSpeed*dt*self.rotorRotateSpeed;
				if not getVisibility(self.rotorSound) then
					setVisibility(self.rotorSound, true);
					setVisibility(self.topSound, true);
				end;
				if self.rotorRotSpeed < 1 then
					setSamplePitch(self.rotorSample, self.rotorRotSpeed+0.5);
				end;
				local _,_,rz = getRotation(self.rotor);
				setRotation(self.rotor, 0,0,rz+rotorSpeed);
				local speed = self.topRotateSpeed;
				if self.mining then
					speed = self.topWorkingSpeed;
				end;
				self.topRotAngle = Utils.clamp(self.topRotAngle + dt*speed*self.direction, 0, 1);
				self.topAngle = self.topRotAngle*self.positions[self.currentFillType][2];
				if self.topRotAngle < 1 then
					setRotation(self.top, 0,self.topAngle,0);
					if not getVisibility(self.topSound) then
						setVisibility(self.topSound, true);
					end;
				elseif getVisibility(self.topSound) then
					setVisibility(self.topSound, false);
				end;
			else
				if self.rotorRotSpeed > 0 then
					self.rotorRotSpeed = math.max(self.rotorRotSpeed - dt*self.rotorAcceleration, 0);
					local rotorSpeed = self.rotorRotSpeed*dt*self.rotorRotateSpeed;
					setSamplePitch(self.rotorSample, self.rotorRotSpeed+0.5);
					local _,_,rz = getRotation(self.rotor);
					setRotation(self.rotor, 0,0,rz+rotorSpeed);
				elseif getVisibility(self.rotorSound) then
					setVisibility(self.rotorSound, false);
				end;
				if self.topRotAngle > 0 then
					self.topRotAngle = math.max(self.topRotAngle - dt*self.topRotateSpeed, 0);
					setRotation(self.top, 0,self.topRotAngle*self.positions[self.currentFillType][2],0);
					if not getVisibility(self.topSound) then
						setVisibility(self.topSound, true);
					end;
				elseif getVisibility(self.topSound) then
					setVisibility(self.topSound, false);
					self.moving = false;
				end;
			end;
		end;
		if self.lastMoneyChange > 0 then
			self.lastMoneyChange = self.lastMoneyChange - 1;
			if self.lastMoneyChange == 0 then
				g_currentMission:showMoneyChange(self.moneyChangeId, g_i18n:getText("resourceCosts"));
			end;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("Bagger", Bagger.onCreate);

BaggerEvent = {};
BaggerEvent_mt = Class(BaggerEvent, Event);

InitEventClass(BaggerEvent, "BaggerEvent");

function BaggerEvent:emptyNew()
	local self = Event:new(BaggerEvent_mt);
    return self;
end;

function BaggerEvent:new(fillType, object)
	local self = BaggerEvent:emptyNew();
	self.fillType = fillType;
	self.object = object;
	return self;
end;

function BaggerEvent:readStream(streamId, connection)
	local fillType = streamReadInt8(streamId);
    local bagger = networkGetObject(streamReadInt32(streamId));
	if bagger then
		bagger:setCurrentFillType(fillType);
	end;
end;

function BaggerEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.fillType);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;
