--author: igor29381

AirSprayer = {};
AirSprayer_mt = Class(AirSprayer, Object);

function AirSprayer.onCreate(id)
    local object = AirSprayer:new(g_server ~= nil, g_client ~= nil);
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object);
        object:register(true);
    else
        object:delete();
    end;
end;

function AirSprayer:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = AirSprayer_mt;
    end;
    local self = Object:new(isServer, isClient, AirSprayer_mt);
	self.AirSprayerDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function AirSprayer:load(id)
	self.isEnabled = false;
	local i3dFilename = getUserAttribute(id, "i3dFilename");
	if i3dFilename then i3dFilename = TrafficManager.curModDir..i3dFilename; end;
	if fileExists(i3dFilename) then
		local airplaneRoot = Utils.loadSharedI3DFile(i3dFilename);
		self.base = getChild(airplaneRoot, "base");
		self.airplane = getChild(self.base, "Antonov_An2");
		link(getRootNode(), self.base);
		delete(airplaneRoot);
		self.startPoint = Utils.getNoNil(getChild(id, "startPoint"), getRootNode());
		local x, y, z = getWorldTranslation(self.startPoint);
		setTranslation(self.base, x, y-0.12, z);
		local _, ry, _ = getRotation(self.startPoint);
		setRotation(self.base, math.rad(12), ry, 0);
		self.vintRot = getChild(self.airplane, "vintRot");
		self.vintStatic = getChild(self.airplane, "vintStatic");
		local wheels = getChild(self.airplane, "wheels");
		local numWheels = getNumOfChildren(wheels);
		if numWheels > 0 then
			self.wheels = {};
			for i=1, numWheels do
				local wheel = getChildAt(wheels, i-1);
				if wheel and wheel > 0 then
					table.insert(self.wheels, wheel);
				end;
			end;
		end;
		self.motorSound = getChild(self.airplane, "motorSound");
		setVisibility(self.motorSound, false);
		self.motorSample = getAudioSourceSample(self.motorSound);
		self.motorStartSound = getChild(self.airplane, "motorStartSound");
		setVisibility(self.motorStartSound, false);
		self.motorStopSound = getChild(self.airplane, "motorStopSound");
		setVisibility(self.motorStopSound, false);
		local xmlPath = g_currentMission.baseDirectory .. "maps/traffic/an2/camera.xml";
		if fileExists(xmlPath) then
			self.components = self.base;
			local xmlFile = loadXMLFile("camera", xmlPath);
			local camera = VehicleCamera:new(self);
			if camera:loadFromXML(xmlFile, "vehicle.camera") then
				self.camera = camera;
			end;
			local i = 0;
			self.particle = {};
			while true do
				local baseString = string.format("vehicle.particleSystems.particleSystem(%d)", i);
				if not hasXMLProperty(xmlFile, baseString) then break; end;
				local ps = {};
				ParticleUtil.loadParticleSystem(xmlFile, ps, baseString, self.base, false, nil, g_currentMission.baseDirectory);
				table.insert(self.particle, ps);
				i = i + 1;
			end;
			delete(xmlFile);
		end;
		self.cruiseSpeed = Utils.getNoNil(getUserAttribute(id, "speed"), 180);
		self.workSpeed = Utils.getNoNil(getUserAttribute(id, "workSpeed"), 140);
		local splinesRootNode = getChild(id, "splines");
		if splinesRootNode > 0 and getNumOfChildren(splinesRootNode) > 0 then
			self.splines = {};
			self.chemicals = {};
			for i=1, getNumOfChildren(splinesRootNode) do
				local spline = {};
				spline.nodeId = getChildAt(splinesRootNode, i-1);
				spline.length = getSplineLength(spline.nodeId);
				spline.chemicals = {};
				local name = Utils.getNoNil(getUserAttribute(spline.nodeId, "fields"), i);
				local names = Utils.splitString(" ", name);
				name = string.format("%s%s", g_i18n:getText("ui_fieldNo"), names[1]);
				local fieldDefs = g_currentMission.fieldDefinitionBase.fieldDefs;
				local volume = fieldDefs[tonumber(names[1])].fieldArea * 550;
				if #names > 1 then
					for ii=2, #names do
						name = string.format("%s, %s", name, names[ii]);
						volume = volume + fieldDefs[tonumber(names[ii])].fieldArea * 550;
					end;
				end;
				local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionInfo.difficulty), 1);
				local fuelPrice = FillUtil.fillTypeIndexToDesc[FillUtil.FILLTYPE_FUEL].pricePerLiter * spline.length*0.012 * difficultyMultiplier + 500;
				local fertilizerPrice = volume * difficultyMultiplier;
				for f=1, #Sprayer.sprayTypeIndexToDesc do
					local sprayType = Sprayer.sprayTypeIndexToDesc[f];
					local fillType = Sprayer.sprayTypeToFillType[f];
					local desc = FillUtil.fillTypeIndexToDesc[fillType];
					if fillType ~= FillUtil.FILLTYPE_MANURE and fillType ~= FillUtil.FILLTYPE_LIQUIDMANURE and fillType ~= FillUtil.FILLTYPE_DIGESTATE and fillType ~= FillUtil.FILLTYPE_FERTILIZER then
						local chemical = {};
						local price = desc.pricePerLiter;
						if fillType == FillUtil.FILLTYPE_LIQUIDFERTILIZER then
							price = desc.pricePerLiter*0.5;
						end;
						chemical.price = math.floor(fertilizerPrice*price + fuelPrice);
						chemical.text = string.format("%s - %d%s", name, chemical.price, g_i18n.globalI18N:getCurrencySymbol(true));
						table.insert(spline.chemicals, chemical);
						if i==1 then
							table.insert(self.chemicals, {["label"]=desc.nameI18N, ["fillType"]=fillType});
						end;
					end;
				end;
				local numMarkers = getNumOfChildren(spline.nodeId);
				if numMarkers > 0 then
					spline.markers = {};
					for m=1, numMarkers do
						local markerId = getChildAt(spline.nodeId, m-1);
						if markerId then
							local action = getUserAttribute(markerId, "action");
							if action then
								local x, _, z = getWorldTranslation(markerId);
								local marker = {["x"]=x, ["z"]=z, ["action"]=action};
								table.insert(spline.markers, marker);
							end;
						end;
					end;
					local startWorkArea = getChild(spline.nodeId, "startWorkArea");
					if startWorkArea > 0 then
						local x, _, z = getWorldTranslation(startWorkArea);
						spline.startWorkArea = {["x"]=x, ["z"]=z};
					end;
					local stopWorkArea = getChild(spline.nodeId, "stopWorkArea");
					if stopWorkArea > 0 then
						local x, _, z = getWorldTranslation(stopWorkArea);
						spline.stopWorkArea = {["x"]=x, ["z"]=z};
					end;
				end;
				table.insert(self.splines, spline);
			end;
			local triggerId = getUserAttribute(id, "trigger");
			if triggerId then
				self.triggerId = Utils.indexToObject(id, triggerId);
				if self.triggerId then
					addTrigger(self.triggerId, "triggerCallback", self);
					self.isEnabled = true;
				end;
			end;
		end;
	end;
	self.currentChemical = 1;
	self.airplaneIsStarted = false;
	self.startMode = false;
	self.stopMode = false;
	self.takeoff = true;
	self.workMode = false;
	self.isWorking = false;
	self.touchdown = false;
	self.unownedField = false;
	self.vintStaticRotation = 0;
	self.speed = 0;
	self.limitedSpeed = 0;
	self.currentSpline = 1;
	self.splinePosition = 0;
	self.controlSplinePosition = 0;
	self.takeoffTimer = 0;
	self.lastSP = 0;
	self.curMark = 1;
	self.deltaY = 0.12;
	self.deltaRY = 0;
	self.samplePitch = 0.5;
	self.activateText = g_i18n:getText("hirePlane");
	self.objectActivated = false;
	local xmlPath = "trafficSaves.xml";
	if g_currentMission.missionInfo.savegameDirectory then
		xmlPath = g_currentMission.missionInfo.savegameDirectory .. "/trafficSaves.xml";
	end;
	if fileExists(xmlPath) then
		local xmlFile = loadXMLFile("trafficSaves", xmlPath);
		self.airplaneIsStarted = getXMLBool(xmlFile, "traffic.airSprayer#airplaneIsStarted");
		self.startMode = getXMLBool(xmlFile, "traffic.airSprayer#startMode");
		self.stopMode = getXMLBool(xmlFile, "traffic.airSprayer#stopMode");
		self.takeoff = getXMLBool(xmlFile, "traffic.airSprayer#takeoff");
		self.workMode = getXMLBool(xmlFile, "traffic.airSprayer#workMode");
		self.touchdown = getXMLBool(xmlFile, "traffic.airSprayer#touchdown");
		self.unownedField = getXMLBool(xmlFile, "traffic.airSprayer#unownedField");
		self.currentSpline = getXMLInt(xmlFile, "traffic.airSprayer#currentSpline");
		self.curMark = getXMLInt(xmlFile, "traffic.airSprayer#currentMarker");
		self.splinePosition = getXMLFloat(xmlFile, "traffic.airSprayer#splinePosition");
		self:loadFinished();
		delete(xmlFile);
	end;
	TrafficManager.AirSprayer = self;
	print("AirSprayer loaded");
	return true;
end;

function AirSprayer:save(xmlFile)
	setXMLBool(xmlFile, "traffic.airSprayer#airplaneIsStarted", Utils.getNoNil(self.airplaneIsStarted, false));
	setXMLBool(xmlFile, "traffic.airSprayer#startMode", Utils.getNoNil(self.startMode, false));
	setXMLBool(xmlFile, "traffic.airSprayer#stopMode", Utils.getNoNil(self.stopMode, false));
	setXMLBool(xmlFile, "traffic.airSprayer#takeoff", Utils.getNoNil(self.takeoff, false));
	setXMLBool(xmlFile, "traffic.airSprayer#workMode", Utils.getNoNil(self.workMode, false));
	setXMLBool(xmlFile, "traffic.airSprayer#touchdown", Utils.getNoNil(self.touchdown, false));
	setXMLBool(xmlFile, "traffic.airSprayer#unownedField", Utils.getNoNil(self.unownedField, false));
	setXMLInt(xmlFile, "traffic.airSprayer#currentSpline", self.currentSpline);
	setXMLInt(xmlFile, "traffic.airSprayer#currentMarker", self.curMark);
	setXMLFloat(xmlFile, "traffic.airSprayer#splinePosition", self.splinePosition);
end;

function AirSprayer:delete()
	if self.base then
		delete(self.base);
	end;
	if self.triggerId then
		removeTrigger(self.triggerId);
	end;
	AirSprayer:superClass().delete(self);
end;

function AirSprayer:loadFinished()
	if self.airplaneIsStarted then
		self.limitedSpeed = 180;
		self.samplePitch = 1.1;
		setSamplePitch(self.motorSample, 1.1);
		setVisibility(self.vintRot, true);
		setVisibility(self.vintStatic, false);
		setVisibility(self.motorSound, true);
	end;
	if self.takeoff then
		self.samplePitch = 1.5;
		setSamplePitch(self.motorSample, 1.5);
		self.limitedSpeed = 140;
		self.takeoffTimer = 30000;
	end;
	if self.workMode then
		self.limitedSpeed = self.workSpeed;
	end;
	if self.touchdown then
		self.limitedSpeed = 30;
		self.samplePitch = 0.5;
	end;
end;

function AirSprayer:getIsAttachedVehicleNode(nodeId)
	if nodeId == self.airplane then
		return true;
	end;
	return false;
end;

function AirSprayer:getIsDynamicallyMountedNode(nodeId)
	if nodeId == self.airplane then
		return true;
	end;
	return false;
end;

function AirSprayer:readStream(streamId, connection)
	AirSprayer:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		self.startMode = streamReadBool(streamId);
		self.airplaneIsStarted = streamReadBool(streamId);
		self.takeoff = streamReadBool(streamId);
		self.workMode = streamReadBool(streamId);
		self.touchdown = streamReadBool(streamId);
		self.stopMode = streamReadBool(streamId);
		self.unownedField = streamReadBool(streamId);
		self.splinePosition = streamReadInt16(streamId)/1000;
		self.currentSpline = streamReadUIntN(streamId, 6);
		self.curMark = streamReadUIntN(streamId, 4);
		self:loadFinished();
	end;
end;

function AirSprayer:writeStream(streamId, connection)
	AirSprayer:superClass().writeStream(self, streamId);
	if  not connection:getIsServer() then
		streamWriteBool(streamId, Utils.getNoNil(self.startMode, false));
		streamWriteBool(streamId, Utils.getNoNil(self.airplaneIsStarted, false));
		streamWriteBool(streamId, Utils.getNoNil(self.takeoff, false));
		streamWriteBool(streamId, Utils.getNoNil(self.workMode, false));
		streamWriteBool(streamId, Utils.getNoNil(self.touchdown, false));
		streamWriteBool(streamId, Utils.getNoNil(self.stopMode, false));
		streamWriteBool(streamId, Utils.getNoNil(self.unownedField, false));
		streamWriteInt16(streamId, math.floor(self.splinePosition*1000));
		streamWriteUIntN(streamId, self.currentSpline, 6);
		streamWriteUIntN(streamId, self.curMark, 4);
	end;
end;

function AirSprayer:readUpdateStream(streamId, timestamp, connection)
	AirSprayer:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
		self.controlSplinePosition = streamReadInt32(streamId)/1000;
		local distance = (self.controlSplinePosition-self.splinePosition)*self.splines[self.currentSpline].length;
		self.limitedSpeed = Utils.clamp(self.limitedSpeed+distance/3, math.max(self.limitedSpeed-5, 0), self.limitedSpeed+10);
	end;
end;

function AirSprayer:writeUpdateStream(streamId, connection, dirtyMask)
	AirSprayer:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
		streamWriteInt32(streamId, math.floor(self.controlSplinePosition*1000));
	end;
end;

function AirSprayer:update(dt)
	if self.isEnabled then
		if self.camera.isActivated then
			self.camera:update(dt);
            if self.camera.allowTranslation then
                if InputBinding.isPressed(InputBinding.CAMERA_ZOOM_IN) then
                    if InputBinding.getInputTypeOfDigitalAction(InputBinding.CAMERA_ZOOM_IN) == InputBinding.INPUTTYPE_MOUSE_WHEEL then
                        self.camera:zoomSmoothly(-0.6);
                    else
                        self.camera:zoomSmoothly(-0.005*dt);
                    end;
                elseif InputBinding.isPressed(InputBinding.CAMERA_ZOOM_OUT) then
                    if InputBinding.getInputTypeOfDigitalAction(InputBinding.CAMERA_ZOOM_OUT) == InputBinding.INPUTTYPE_MOUSE_WHEEL then
                        self.camera:zoomSmoothly(0.6);
                    else
                        self.camera:zoomSmoothly(0.005*dt);
                    end;
                end;
            end;
		end;
		if self.airplaneIsStarted and self.currentSpline > 0 then
			local spline = self.splines[self.currentSpline];
			local x,y,z = getSplinePosition(spline.nodeId, self.splinePosition);
			local touchdownIsNear = false;
			if self.isServer then
				if self.controlSplinePosition + 0.01 < self.splinePosition then
					self.controlSplinePosition = self.splinePosition;
					self:raiseDirtyFlags(self.AirSprayerDirtyFlag);
				end;
			end;
			local timeScale = math.abs(self.speed/3.6) / spline.length;
			self.splinePosition = math.min(self.splinePosition + 0.001*dt*timeScale, 1);
			setTranslation(self.base, x, y - self.deltaY, z);
			if spline.markers then
				local marker = spline.markers[self.curMark];
				local markerDistance = Utils.vector2Length(x-marker.x, z-marker.z);
				if markerDistance < 2 then
					if marker.action == "takeoff" then
						self.takeoff = false;
						self.limitedSpeed = self.cruiseSpeed;
					end;
					if marker.action == "startWork" then
						self.workMode = true;
						self.limitedSpeed = self.workSpeed;
					end;
					if marker.action == "stopWork" then
						self.workMode = false;
						self:setEmittingState(false);
						if not self.unownedField and spline.startWorkArea and spline.stopWorkArea and not g_currentMission.fieldJobManager.currentFieldJob then
							local fillType = self.chemicals[self.currentChemical].fillType;
							Utils.updateSprayArea(spline.startWorkArea.x, spline.startWorkArea.z, spline.startWorkArea.x, spline.stopWorkArea.z, spline.stopWorkArea.x, spline.startWorkArea.z, nil, 1);
						end;
						self.limitedSpeed = self.cruiseSpeed;
					end;
					if marker.action == "touchdown" then
						self.touchdown = true;
						self.limitedSpeed = 30;
						self.samplePitch = 0.5;
					end;
					self.curMark = math.min(self.curMark + 1, #spline.markers);
				end;
				if marker.action == "touchdown" and not self.touchdown and markerDistance < 200 then
					touchdownIsNear = true;
				end;
			end;
			if self.takeoff or self.touchdown then
				local rx,ry,rz = getSplineOrientation(spline.nodeId, self.splinePosition, 0, -1, 0);
				local deltaRX = Utils.clamp(20 - self.speed/6, 0, 12);
				self.deltaY = deltaRX*0.01;
				if self.wheels then
					for _, wheel in pairs (self.wheels) do
						local wx, _, _ = getRotation(wheel);
						local delta = (self.splinePosition-self.lastSP)*spline.length;
						delta = math.atan(delta/0.5);
						setRotation(wheel, wx-delta, 0, 0);
					end;
					self.lastSP = self.splinePosition;
				end;
				if self.touchdown then
					local fx,_,fz = getSplinePosition(spline.nodeId, 1);
					local stopDistance = Utils.vector2Length(x-fx, z-fz);
					self.limitedSpeed = math.max(math.min(stopDistance/3, 30), 6);
					self.samplePitch = math.max(self.samplePitch - dt*0.005, 0.5);
					if self.splinePosition == 1 then
						self.limitedSpeed = 0;
						self.speed = 0;
						self.samplePitch = 1.5;
						self.deltaRY = self.deltaRY + 0.5;
						if self.deltaRY >= 180 then
							self.stopMode = true;
							self.vintStaticRotation = -4;
							self.airplaneIsStarted = false;
							self.touchdown = false;
							setVisibility(self.vintRot, false);
							setVisibility(self.vintStatic, true);
							setVisibility(self.motorStopSound, true);
							setVisibility(self.motorSound, false);
						end;
					end;
				end;
				setRotation(self.base, rx + math.rad(deltaRX), ry+math.rad(self.deltaRY), rz);
			else
				local fx,fy,fz = getSplinePosition(spline.nodeId, self.splinePosition + 20/spline.length);
				local lfx, lfy, _ = worldToLocal(self.base, fx, fy, fz);
				if self.workMode and spline.startWorkArea and spline.stopWorkArea then
					local startWorkArea = spline.startWorkArea;
					local stopWorkArea = spline.stopWorkArea;
					local isWorking = (fx > startWorkArea.x and fz > startWorkArea.z and fx < stopWorkArea.x and fz < stopWorkArea.z);
					if isWorking then
						local bits = getDensityAtWorldPos(g_currentMission.terrainDetailId, fx, 0, fz);
						isWorking = bits > 0;
					end;
					if isWorking and not self.isWorking then
						self:setEmittingState(true);
					elseif not isWorking and self.isWorking then
						self:setEmittingState(false);
					end;
				end;
				if self.takeoffTimer == 0 then
					if self.limitedSpeed >= self.cruiseSpeed - 5 and self.speed >= self.cruiseSpeed - 5 then
						self.samplePitch = math.max(self.samplePitch - 0.0002*dt, 1.1);
					else
						self.samplePitch = Utils.clamp(Utils.clamp(self.speed, 140, 180)/130 + lfy + math.abs(lfx), 0.5, 1.5);
					end;
				end;
				local rx,ry,rz = getSplineOrientation(spline.nodeId, self.splinePosition, 0, -1, 0);
				setRotation(self.base, rx,ry,rz);
				local _,_,arz = getRotation(self.airplane);
				if touchdownIsNear then
					arz = math.min(arz+0.00025*dt, 0);
					self.limitedSpeed = math.min(self.limitedSpeed - dt*0.015, 130);
				else
					if lfx > 0 then
						arz = math.max(arz-0.0001*dt, -math.rad(lfx*20), math.rad(-40));
					else
						arz = math.min(arz+0.0001*dt, -math.rad(lfx*20), math.rad(40));
					end;
				end;
				setRotation(self.airplane, 0, 0, arz);
			end;
			if self.speed < self.limitedSpeed then
				self.speed = math.min(self.speed + dt*0.012, self.limitedSpeed);
			else
				self.speed = math.max(self.speed - dt*0.012, self.limitedSpeed);
			end;
			local samplePitch = getSamplePitch(self.motorSample);
			if samplePitch < self.samplePitch then
				setSamplePitch(self.motorSample, math.min(samplePitch + 0.0002*dt, self.samplePitch));
			else
				setSamplePitch(self.motorSample, math.max(samplePitch - 0.0002*dt, self.samplePitch));
			end;
			local _,_,vrz = getRotation(self.vintRot);
			setRotation(self.vintRot, 0, 0, vrz - 0.05);
			if self.splinePosition >= 1 then
				self.touchdown = true;
			end;
		elseif self.startMode then
			if self.vintStaticRotation == 0 then
				setVisibility(self.motorStartSound, true);
				self.deltaRY = 0;
			end;
			if self.vintStaticRotation > -3 then
				self.vintStaticRotation = math.max(self.vintStaticRotation - dt*0.001, -3);
				local _,_,rz = getRotation(self.vintStatic);
				setRotation(self.vintStatic, 0, 0, rz + self.vintStaticRotation);
				if self.vintStaticRotation == -3 then
					setVisibility(self.vintRot, true);
					setVisibility(self.vintStatic, false);
					self.samplePitch = 0.5;
					setSamplePitch(self.motorSample, 0.5);
					setVisibility(self.motorSound, true);
				end;
			else
				self.vintStaticRotation = math.max(self.vintStaticRotation - dt*0.001, -8);
				local _,_,vrz = getRotation(self.vintRot);
				setRotation(self.vintRot, 0, 0, vrz - 0.05);
				if self.vintStaticRotation == -8 then
					self.startMode = false;
					self.touchdown = false;
					self.takeoff = true;
					self.takeoffTimer = 30000;
					self.airplaneIsStarted = true;
					self.limitedSpeed = 140;
					self.curMark = 1;
					self.splinePosition = 0;
					self.controlSplinePosition = 0;
					self.samplePitch = 1.5;
					setVisibility(self.motorStartSound, false);
				end;
			end;
		elseif self.stopMode then
			self.vintStaticRotation = math.min(self.vintStaticRotation + dt*0.001, 0);
			local _,_,rz = getRotation(self.vintStatic);
			setRotation(self.vintStatic, 0, 0, rz-self.vintStaticRotation);
			if self.vintStaticRotation == 0 then
				self.stopMode = false;
				setVisibility(self.motorStopSound, false);
				self.unownedField = false;
				if self.camera.isActivated then
					self.camera:onDeactivate();
					g_currentMission.hasSpecialCamera = false;
				end;
			end;
		end;
		if self.takeoffTimer > 0 then
			self.takeoffTimer = math.max(self.takeoffTimer - dt, 0);
		end;
	end;
end;

function AirSprayer:updateTick(dt)
end;

function AirSprayer:setEmittingState(state)
	if self.particle then
		for i=1, #self.particle do
			ParticleUtil.setEmittingState(self.particle[i], state);
		end;
	end;
	self.isWorking = state;
end;

function AirSprayer:getIsActivatable()
    if (not self.isServer and not g_currentMission.isMasterUser) or not self.isEnabled or self.airplaneIsStarted or self.startMode
	or UniversalFactoryHUD.siloTriggerMenu or Economica.showMessage or g_currentMission.fieldJobManager.currentFieldJob then
        return false;
    end;
    return true;
end;

function AirSprayer:drawActivate()
    return;
end;

function AirSprayer:onActivateObject()
	UniversalFactoryHUD.currentAirSprayer = self;
	if #self.chemicals == 1 then
		UniversalFactoryHUD.currentChemical = 1;
	end;
	UniversalFactoryHUD.siloTriggerMenu = true;
	UniversalFactoryHUD.showCursor = true;
	UniversalFactoryHUD.mPos={0,0,0,0};
end;

function AirSprayer:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled then
		if onEnter then
			g_currentMission:addActivatableObject(self);
		elseif onLeave then
			g_currentMission:removeActivatableObject(self);
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("AirSprayer", AirSprayer.onCreate);

AirSprayerEvent = {};
AirSprayerEvent_mt = Class(AirSprayerEvent, Event);

InitEventClass(AirSprayerEvent, "AirSprayerEvent");

function AirSprayerEvent:emptyNew()
	local self = Event:new(AirSprayerEvent_mt);
    return self;
end;

function AirSprayerEvent:new(currentSpline, currentChemical, object)
	local self = AirSprayerEvent:emptyNew();
	self.currentSpline = currentSpline;
	self.currentChemical = currentChemical;
	self.object = object;
	return self;
end;

function AirSprayerEvent:readStream(streamId, connection)
	local currentSpline = streamReadInt8(streamId);
	local currentChemical = streamReadInt8(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	if object ~= nil then
		object.currentSpline = currentSpline;
		object.currentChemical = currentChemical;
		if g_server then
			g_server:broadcastEvent(AirSprayerEvent:new(currentSpline, currentChemical, object));
		end;
	end;
end;

function AirSprayerEvent:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentSpline);
	streamWriteInt8(streamId, self.currentChemical);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

AirSprayerFlightEvent = {};
AirSprayerFlightEvent_mt = Class(AirSprayerFlightEvent, Event);

InitEventClass(AirSprayerFlightEvent, "AirSprayerFlightEvent");

function AirSprayerFlightEvent:emptyNew()
	local self = Event:new(AirSprayerFlightEvent_mt);
    return self;
end;

function AirSprayerFlightEvent:new(price, flight, object, unownedField)
	local self = AirSprayerFlightEvent:emptyNew();
	self.price = price;
	self.flight = flight;
	self.object = object;
	self.unownedField = Utils.getNoNil(unownedField, false);
	return self;
end;

function AirSprayerFlightEvent:startSprayer(price, flight, object, unownedField)
	if flight and not g_currentMission.hasSpecialCamera and g_currentMission.player.isControlled then
		local x,y,z = getWorldTranslation(g_currentMission.player.rootNode);
		local ax,ay,az = getWorldTranslation(object.base);
		local distance = Utils.vector3Length(x-ax, y-ay, z-az);
		if distance < 10 then
			object.camera:onActivate();
			g_currentMission.hasSpecialCamera = true;
		end;
	end;
	object.startMode = true;
	unownedField = Utils.getNoNil(unownedField, false);
	object.unownedField = unownedField;
	if g_server then
		if not unownedField then
			if flight then
				price = price + 1000;
			end;
			g_currentMission:addSharedMoney(-price, "other");
			g_currentMission:addMoneyChange(-price, FSBaseMission.MONEY_TYPE_SINGLE, true, g_i18n:getText("finance_wagePayment"));
		end;
		g_server:broadcastEvent(AirSprayerFlightEvent:new(price, flight, object, unownedField));
	end;
end;

function AirSprayerFlightEvent:readStream(streamId, connection)
	local flight = streamReadBool(streamId);
	local price = streamReadInt32(streamId);
	local id = streamReadInt32(streamId);
    local object = networkGetObject(id);
	local unownedField = streamReadBool(streamId);
	if object ~= nil then
		self:startSprayer(price, flight, object, unownedField);
	end;
end;

function AirSprayerFlightEvent:writeStream(streamId, connection)
	streamWriteBool(streamId, self.flight);
	streamWriteInt32(streamId, self.price);
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.unownedField);
end;
