--author: igor29381

AirPlaneTraffic = {};
AirPlaneTraffic_mt = Class(AirPlaneTraffic, Object);

function AirPlaneTraffic.onCreate(id)
    local object = AirPlaneTraffic:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end;
end;

function AirPlaneTraffic:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = AirPlaneTraffic_mt
    end;
    local self = Object:new(isServer, isClient, AirPlaneTraffic_mt);
    return self;
end;

function AirPlaneTraffic:load(id)
	self.splines = {};
	self.splinesRootNode = id;
	local numChildren = getNumOfChildren(self.splinesRootNode);
	if numChildren > 0 and TrafficManager.airplane then self.isEnabled = true; end;
	for i=1, numChildren do
		local childId = getChildAt(self.splinesRootNode, i-1);
		local spline = {};
		spline.id = childId;
		spline.length = getSplineLength(childId);
		table.insert(self.splines, spline);
	end;
	self.airplaneOnSpline = false;
	self.airplane = nil;
	self.airplaneLights = nil;
	self.spline = nil;
	self.timeScale = nil;
	self.splinePosition = 0;
	g_currentMission.environment:addWeatherChangeListener(self);
	g_currentMission.environment:addHourChangeListener(self);
    return true;
end;

function AirPlaneTraffic:delete()
	if g_currentMission.environment ~= nil then
		g_currentMission.environment:removeWeatherChangeListener(self);
		g_currentMission.environment:removeHourChangeListener(self);
	end;
	AirPlaneTraffic:superClass().delete(self);
end;

function AirPlaneTraffic:readStream(streamId, connection)
end;

function AirPlaneTraffic:writeStream(streamId, connection)
end;

function AirPlaneTraffic:update(dt)
	if self.isEnabled and self.airplaneOnSpline then
		if self.splinePosition < 1 then
			self.splinePosition = self.splinePosition + 0.001*dt*self.timeScale;
			local x,y,z = getSplinePosition(self.spline, self.splinePosition);
			local rx,ry,rz = getSplineOrientation(self.spline, self.splinePosition, 0, -1, 0);
			setTranslation(self.airplane, x, y, z);
			setRotation(self.airplane, rx,ry,rz);
		else
			self.airplaneOnSpline = false;
			setVisibility(self.airplane, false);
			setVisibility(self.airplaneLights, false);
			setTranslation(self.airplane, 0, 5000, 0);
			self.airplaneLights = nil;
			self.airplane = nil;
			self.spline = nil;
			self.timeScale = nil;
		end;
	end;
end;

function AirPlaneTraffic:weatherChanged()
	if g_currentMission and g_currentMission.environment and self.airplaneLights then
		setVisibility(self.airplaneLights, not g_currentMission.environment.isSunOn);
	end;
end;

function AirPlaneTraffic:hourChanged()
	if self.isEnabled and not self.airplaneOnSpline then
		for i=1, #TrafficManager.airplane do
			local airplane = TrafficManager.airplane[i];
			for a=1, #airplane.times do
				if airplane.times[a].hour == g_currentMission.environment.currentHour and g_currentMission.environment.isSunOn then
					self.airplaneOnSpline = true;
					self.airplane = airplane.Id;
					self.airplaneLights = getChildAt(self.airplane, 0);
					setVisibility(self.airplaneLights, not g_currentMission.environment.isSunOn);
					setVisibility(self.airplane, true);
					local index = airplane.times[a].splineIndex;
					self.spline = self.splines[index].id;
					self.timeScale = (airplane.speed/3.6) / self.splines[index].length;
					self.splinePosition = 0;
					break;
				end;
			end;
			if self.airplaneOnSpline then break; end;
		end;
	end;
end;

function AirPlaneTraffic:updateTick()
end;

g_onCreateUtil.addOnCreateFunction("AirPlaneTraffic", AirPlaneTraffic.onCreate);
